;-*- Mode: Common-lisp; Package: ydecl; Readtable: ytools; -*-
(in-package :ydecl)

(depends-on %module/ nisp)

(depends-on :at-run-time %wtools/ txtlisp litlisp)

(eval-when (:compile-toplevel :load-toplevel :execute :slurp-toplevel)
   (export '(HTML-txtlisp-mode html-litlisp)))

(end-header)

(defnisptype HTML-txtlisp-mode
    (Object (:include Txtlisp-mode)))

(defproc html-litlisp - (~ Pathname) (in-file)
   (litlisp in-file false ':html
	    (list   ;;;; (tuple 'output-mode ':tex)
		  (tuple 'hyperlinks-to-code-segs true))))

(defmethproc initialize - Void (html-tm - HTML-txtlisp-mode)
	     (slot-defaults html-tm
	        name ':html
		file-ext "html"))

(defmethproc txtlisp-files-init - Void (tm - HTML-txtlisp-mode
				        in-pn - Pathname
				        out-srm - (~ Stream))
   (cond (out-srm
       (out (:to out-srm)
	  "<!-- THIS FILE WAS AUTOMATICALLY PRODUCED by html-litlisp from --->"
	  :% "<!-- " 3 in-pn  " -->"
	  :% "<!-- *** DO NOT EDIT *** -->" :% :%))))

(!= (alref txtlisp-mode-creators* ':html)
    (\\ (vars)
       (decl ()
	  (make-inst HTML-txtlisp-mode :vars (vars->hash-table vars)))))

(defmethfunc seg-def-wrappers - (Multvals pre post
					- (Fun String ((Alt Symbol String)
						       (Alt Symbol String))))
			   (output-mode - HTML-txtlisp-mode file-seg - Boolean)
   (values (\\ - String (segname segref - (Alt Symbol String))
	      (out-to-string
		 :% "<pre><a name=\"cf_" (:a segname)
		          "\">&lt;&lt;<i>Define </i>" (:a segref) "</a>"
           ;;;;		 :%"</pre>"
		    (:q ((and (not file-seg)
			      (tv-val-if-bound hyperlinks-to-code-segs))
			  :%))))
	   (\\ - String (_ _ - (Alt Symbol String))
	      (out-to-string 
		 "&gt;&gt;</pre>"
;;;;		 "<tt>&gt;&gt;</tt>"
		 )))) 

;;; Not needed, because the default impl. does the same thing --
;;;;(defmethfunc embedded-code-wrappers - (Multvals pre post
;;;;						- (Fun String (String)))
;;;;			(output-mode - HTML-txtlisp-mode)
;;;;   (values (\\ - String (begin-string - String)
;;;;	      (out-to-string
;;;;		 (:a begin-string)))
;;;;	   (\\ - String (end-string - String)
;;;;	      (out-to-string (:a end-string)))))

(defmethfunc seg-ref-producer - (Fun String (Symbol))
	                      (output-mode - Txtlisp-mode)
   (let ((frag-ref-version (frag-ref-producer output-mode)))
      (\\ - String (name - Symbol)
	 (let ((n (seg-leading-blanks name)))
	    (out-to-string
	       (:q (n
		    (:q ((> n 0)
			 (:e (repeat :for ((_ = 1 :to n))
				(:o "&nbsp;")))))))
	       (:a (funcall frag-ref-version name n)))))))

;;;;		  "&lt;&lt;Insert: " name "&gt;&gt;")
;;;;		 (t "&lt;&lt;Insert: ??" name "??&gt;&gt;"))))))

(defmethfunc frag-ref-producer - (Fun String (Symbol Boolean))
	                    (output-mode - HTML-txtlisp-mode)
   (\\ - String (name - Symbol defined - Boolean)
      (out-to-string
	 (:e (:stream osrm)
	    (:o "&lt;&lt;<i>Insert:</i> "
		(:q ((tv-val-if-bound hyperlinks-to-code-segs)
		     "<a href=\"#cf_" (:a name) "\">"))
		(:e (flag-undefined-name name defined osrm))
		(:q ((tv-val-if-bound hyperlinks-to-code-segs)
		     "</a>"))
		"&gt;&gt;")))
      ))

(defmethfunc string-guarder - (Fun String (String)) (m - HTML-txtlisp-mode)
   (\\ - String (str - String)
      (with-output-to-string (out-str)
	 (repeat :for ((i = 0 :to (- (string-length str) 1)))
	    (let ((ch (elt str i)))
	       (out (:to out-str)
		  (:a (cond ((html-char-must-be-guarded ch)
			     (html-char-guard ch))
			    (t ch)))))))))

(defmethfunc char-guarder - (Fun (~ String) (Char))
	                  (m - HTML-txtlisp-mode)
   (\\ - (~ String) (ch - Char)
      (cond ((html-char-must-be-guarded ch)
	     (out-to-string (html-char-guard ch)))
	    (t false))))

(defmethfunc char-guard-require-tester - (Fun Boolean (Char))
			  (m - HTML-txtlisp-mode)
   #'html-char-must-be-guarded)

;;; If true, spaces come out as the virtually unreadable &nbsp; --
(specdecl (html-spaces-guard* false) - Boolean)

(defun html-char-must-be-guarded (ch)
   (or (member ch '(#\< #\> #\&)
	       :test #'char=)
       (and html-spaces-guard*
	    (char= ch '#\Space))))

(deffunc html-char-guard - String (ch - Char)
   (case ch
      ((#\<) "&lt;")
      ((#\>) "&gt;")
      ((#\&) "&amp;")
      ((#\Space) "&nbsp;")
      (t (string ch))))
