;-*- Mode: Common-lisp; Package: nisp; Readtable: ytools; -*-
(in-package :nisp)

(depends-on %module/ nisp)

(depends-on %wtools/ txtlisp)

(eval-when (:compile-toplevel :load-toplevel :execute :slurp-toplevel)
   (export '(Level-counter level-counter-add level-counter-advance
	     counter++
	     lref labels label-ref label-set)))

;;; Section-style-counter hack for use with file litlisp (but doesn't
;;;   depend on it).

;;; Actually, these are pretty primitive.  They need to look more like
;;; LaTeX counters; and they need to be able to come out as LaTeX counters 
;;; if the target file format is .tex .

;;; Formatting information for one level of Level-counter
(defnisptype Levcount-descrip
    (Structure init - Fixnum
	       ;; -- Where it starts (usually 1)
	       before after - (Fun String (Fixnum))
	       ;; -- Strings to go before and after number
	       ext-b ext-a - String
	       ;; -- External versions
       (:handler
	   (print-object (sl - Levcount-descrip srm - Stream)
	      (with sl
		 (out (:to srm) "<"
		      (:a !>ext-b) "*" !>init "*" (:a !>ext-a) ">")))))

  (:conser (init - Fixnum before after - Obj)
     (let-fun ()
	(multi-let (((b ext-b)
		     (funnify before))
		    ((a ext-a)
		     (funnify after)))
	   (make ^^ init b a ext-b ext-a))
      :where
         (:def funnify - (Mlv (Fun String (Fixnum)) String)
		  (e)
	    (cond ((not e)
		   (values (\\ (_) "") ""))
		  ((is-String e)
		   (values (\\ (_) e) e))
		  (t
		   (values e "..")))))))

;;; Counter for, e.g., sections and subsections
(defnisptype Level-counter
   (Structure parent - (~ (Lstructure () take-levels - Fixnum
				         p - Level-counter))
	      ;; -- The printed rep of this counter starts with the
	      ;; !_k first levels of !_p
	      curval - (Lst Fixnum)
	      ;; curval is current value, from outermost level to innermost
	      levels - (Lst Levcount-descrip)
      (:handler
          (print-object (lc - Level-counter srm - Stream)
	     (out (:to srm)
		"#<Level-counter "
  		(:e (let-fun ((ancs-print (c - Level-counter)
			 	(cond ((!_parent c)
				       (:o "["
					   (!_take-levels (!_parent c))
					   "]")
				       (ancs-print (!_p (!_parent c)))
				       (:o "/")))
				(:o (!_levels c)
				    1 (!_curval c))))
		       (ancs-print lc)))
		">"))))

  (:access curdepth - Fixnum :inline (lc - Level-counter)
      (length (!_curval lc)))

  (:access totdepth - Fixnum (lc - Level-counter)
     (let ((sum (be Fixnum (len (!_curval lc)))))
        (cond ((!_parent lc)
	       (be Fixnum (+ (min (!_take-levels (!_parent lc))
				  (!_totdepth (!_p (!_parent lc))))
			     sum)))
	      (t sum))))

  (:access string-val - String (lc - Level-counter num - Fixnum)
      (let-fun ((:def get-the-val - (Multvals v - String
					      levels-left - Fixnum)
		                  (c - Level-counter
				   n - Fixnum)
		    (cond ((=< n 0)
			   (values "" 0))
			  ((!_parent c)
			   (multi-let (((res left)
					(get-the-val
					   (!_p (!_parent c))
					   (min n (!_take-levels
						     (!_parent c))))))
			      (string-from-here c res left)))
			  (t
			   (string-from-here c "" n))))
			         
		(:def string-from-here - (Multvals v - String
						   levels-left - Fixnum)
		                  (c - Level-counter
				   sofar - String
				   n - Fixnum)
;;;;		   (trace-around string-from-here
;;;;		      (:> "(string-from-here: " sofar " + " n
;;;;			  1 c ")")
		   (repeat :for ((i = 0 :to (- n 1))
				 (v :in (!_curval c)) - Fixnum
				 (sl :in (!_levels c)) - Levcount-descrip
				 (res sofar) - String)
 		      (!= res (string-concat res
			         (funcall (!_before sl) v)
			         (out-to-string v)
			         (funcall (!_after sl) v)))
		   :result
		      (let ((excess-demand
			       (- n (!_curdepth c))))
			 (cond ((> excess-demand 0)
				(signal-problem string-val
				   "Want more levels ("
				   n ") than "
				   c " can provide"
				   (:proceed
				       "I'll fill them in with zeroes"))
				(values
				   (<< string-concat
				       (cons res
					     (<# (\\ (_) "*0")
						 (series excess-demand))))
				   0))
			       (t
				(values res (- (!_curdepth c)
					       i))))))
;;;;		      (:< (val l) "string-from-here: " val " [" l "]"))
		   ))
	       
	 (nth-value 0
	    (get-the-val lc
			 (cond ((< num 0)
				(!_totdepth lc))
			       (t num)))))))
		   
;;; E.g., (new-Level-counter (1) (1 ".") (0 "-" ">"))
;;; makes a three-deep counter with stringvals like 1, 2.1, and 1.3-0>
;;; Optional keyword arg :parent is a list of a number and another
;;; counter, from whose prefix this one inherits a prefix of the
;;; given length.
(defmacro new-Level-counter (&rest level-descrips)
   (multi-let (((level-descrips p-alist)
		(keyword-args-extract level-descrips '(:parent))))
      (let ((p (alref p-alist ':parent)))
	 `(make Level-counter
	     ,(cond (p `(tuple ,(car p) ,(cadr p)))
		    (t 'false))
	     !()  ; Start at depth 0
   ;;;;	  ,(cond ((null level-descrips) '!())
   ;;;;		 ((null (car level-descrips)) ''(0))
   ;;;;		 (t 
   ;;;;		  `'(,(- (car (car level-descrips))
   ;;;;			 1))))
	     (list ,@(<# (\\ (ld)
			    `(make Levcount-descrip
				   ,(cond ((> (length ld) 0) (car ld))
					  (t '1))
				   ,(cond ((> (length ld) 1) (cadr ld))
					  (t 'false))
				   ,(cond ((> (length ld) 2) (caddr ld))
					  (t 'false))))
			 level-descrips))))))

(defproc level-counter-down - Void (lc - Level-counter k - Fixnum)
   (let ((curdepth (!_curdepth lc)))
      (cond ((> (+ curdepth k)
		(len (!_levels lc)))
	     (signal-problem level-counter-down
		"Can't push " lc :% " down " k " levels")))
      (!= (!_curval lc)
	  (nconc *-*
		 (<# (\\ (ld - Levcount-descrip)
			(- (!_init ld) 1))
		     (take k
			   (nthcdr curdepth
				   (!_levels lc))))))))

;;;;(list (- (!_init (list-elt (!_levels lc)
;;;;						curdepth))
;;;;			      1))))))

(defproc level-counter-up - Void (lc - Level-counter k - Fixnum)
   (cond ((< (!_curdepth lc) k)
	  (signal-problem level-counter-up
		"Can't pop " lc :% " up " k " levels")))
   (!= (!_curval lc)
       (drop (- k) *-*)))

(defproc level-counter-add - Void (lc - Level-counter level incr - Fixnum)
   (cond ((and (>= level 0)
	       (< level (!_curdepth lc)))
	  (!= (car (nthcdr level (!_curval lc)))
	      (+ *-* incr)))
	 (t
	  (signal-problem level-counter-add
	     "Can't change level " level " of " lc))))

;;; After this operation, the !_curdepth of lc is = level + 1.
(defproc level-counter-advance - String (lc - Level-counter level - Fixnum)
   (cond ((and (>= level 0)
	       (< level (len (!_levels lc))))
	  (let ((curdepth (!_curdepth lc)))
	     (cond ((< level (- curdepth 1))
		    ;; Discard sub-sub-sections when advancing
		    ;; to next section
		    (level-counter-up lc (- curdepth 1 level)))
		   ((> level (- curdepth 1))
		    ;; Initialize sub-sub-sections
		    (level-counter-down lc (- level curdepth -1)))))
	  (level-counter-add lc level 1)
	  (!_string-val lc -1))
	 (t
	  (signal-problem level-counter-advance
	     "Can't advance level " level " of " lc))))

(defproc counter++ - String (ctr - Level-counter n - Fixnum)
   (let ((cnt (level-counter-advance ctr n)))
      (out (:to *standard-output*)
	   (:a cnt))
      cnt))

;;; LaTeX-style labels

(declare-txtlisp-vars
   labels - (Lst (Lrcd Symbol (~ String)))
   defined-labels - (Lst Symbol)
   lbl-file-loaded - Boolean
   vars-saved-in-lbl-file - (Lst Symbol))

(defmacro lref (lab) `(label-ref ',lab))

(deffunc label-ref - Void (lab - Symbol)
   (ensure-var-saved-in-lbl-file 'labels)
   (out (:a (or (alref (tv-val labels) lab
		       (progn
				(out (:to *error-output*)
				   "Undefined label: " lab :%)
				false))
		"???"))))

(defproc label-set - Void (lab - Symbol val - String)
   (cond ((not (tv-is-bound labels))
	  (!= (tv-val labels) !())))
   (ensure-var-saved-in-lbl-file 'labels)
   (!= (alref (tv-val labels) lab)
       val)
   (cond ((not (txtlisp-var-is-bound 'defined-labels))
	  (!= (tv-val defined-labels) !())))
   (cond ((memq lab (tv-val defined-labels))
	  (err-out "Label " lab " defined more than once"))
	 (t
	  (!= (tv-val defined-labels) (cons lab *-*)))))
			      
(defproc ensure-var-saved-in-lbl-file - Void (var - Symbol)
   (ensure-lbl-file *standard-input*)
   (cond ((not (memq var (tv-val vars-saved-in-lbl-file)))
	  (!= (tv-val vars-saved-in-lbl-file)
	      (cons var *-*)))))

(specdecl lbl-pathname* - Pathname)

(!= lbl-pathname* (make-pathname :type "lbl"))


(defproc ensure-lbl-file - Void (in-stream - Stream)
   (cond ((not (tv-is-bound lbl-file-loaded))
	  (let ((lbl-pn (merge-pathnames lbl-pathname* (pathname in-stream))))
	     (cond ((probe-file lbl-pn)
		    (load lbl-pn))
		   (t
		    (err-out
		       ".lbl file doesn't exist -- creating")))
	     (!= (tv-val vars-saved-in-lbl-file) !())
	     (after-file-transduction
	         (with-open-file (lbl-srm lbl-pn :direction ':output
				          :if-exists ':supersede)
		     (bind ((*print-length* false)
			    (*print-level* false))
			(repeat :for ((v :in (tv-val vars-saved-in-lbl-file)))
			   (out (:to lbl-srm)
			      `(!= (tv-val ,v) ',(txtlisp-var-val v))
			      :%)))))
	     (!= (tv-val lbl-file-loaded) true)))))
