;-*- Mode: Common-lisp; Package: nisp; Readtable: ytools; -*-
(in-package :nisp)
;;;$Id: litlisp-copy.lisp,v 1.7 2006/05/18 20:07:24 dvm Exp $

(depends-on %module/ ytools)

(depends-on %ytools/ ytcopy %ydecl/ ydcopy)

(specdecl (litlisp-levels* '("word" "tools")) - (Lst String))

(defparameter +litlisp-files+
    '("litlisp.lisp" "htmlisp.lisp" "texlisp.lisp" "txtlisp.lisp"
      "levcount.lisp" "litlisp-copy.lisp" "textutils.lisp"
      "litlisp-CHANGELOG" "litlisp.lsy"))

(defparameter +litlisp-home-dir+ "/Users/dvm/CVSified/word/tools/")

(defun litlisp-build-for-export (&key (cvs-export-dir
                                          "%wkg/CVStemp/word/tools/")
                                      (dest-dir
                                          "%wkg/temp/litlisp/")
                                      (source ':cvs))
                                      ;; -- or :directory
   (let ((expanded-dest-dir (->pathname dest-dir)))
      (err-out "Exporting Litlisp to " expanded-dest-dir)
      (ensure-directories-exist expanded-dest-dir)
      (ecase source
         (:cvs
          (let ((expanded-cvs-dir 
                   (->pathname cvs-export-dir)))
             (cvs-export expanded-cvs-dir
                         litlisp-levels*
                         :host cyndra-cvs-host*)
             (directory-empty expanded-dest-dir)
             (repeat :for ((fname :in +litlisp-files+))
                (dir-pns-file-copy
                   expanded-cvs-dir expanded-dest-dir fname))))
         (:directory
          (directory-empty expanded-dest-dir)
          (let ((source-dir
                   (parse-namestring +litlisp-home-dir+)))
             (repeat :for ((fname :in +litlisp-files+))
                (dir-pns-file-copy
                   source-dir expanded-dest-dir fname)))))
      (err-out "Creating compressed tar file")
      (create-tar-file expanded-dest-dir)
      (!= (port:default-directory)
          (->pathname tar-file-dir*))
      (err-out "Copying tar file to cyndra (may take a while)")
      (let ((tar-file-name (lastelt (Pathname-directory expanded-dest-dir))))
         (cond ((not (string= tar-file-name "litlisp"))
                (err-out "WARNING -- tar file name is "
                         (:a tar-file-name) ".tar, not litlisp.tar"
                         :% :%)))
         (let ((shell-cmd
                  (out (:to :string)
                     !"scp " (:a tar-file-name) ".tar.gz"
                     " dvm@cyndra.cs.yale.edu:ftparea/software/litlisp.tar.gz")))
            (err-out "Executing " shell-cmd)
            (excl:run-shell-command shell-cmd :show-window ':hide)))
      (err-out "Don't forget to edit webpage to reflect Litlisp "
               (:q ((boundp '+nisp-version+)
                    (:a +litlisp-version+) 1)
                   (t
                     "(version ???) "))
               "availability")
      '***))
   