;-*- Mode: Common-lisp; Package: ydecl; Readtable: ytools; -*-
(in-package :ydecl)
;;; $Id: texlisp.lisp,v 1.10 2005/08/31 14:10:34 dvm Exp $

(depends-on %module/ nisp)

(depends-on :at-run-time %wtools/ txtlisp litlisp)

(eval-when (:compile-toplevel :load-toplevel :execute :slurp-toplevel)
   (export '(Tex-txtlisp-mode tex-litlisp include tex-label-ref)))

(end-header)

(defnisptype Tex-txtlisp-mode
    (Object (:include Txtlisp-mode)))

(declare-txtlisp-vars
   tex-labels - (Lst (Lrcd Symbol (Lrcd String String)))
   ;; An obscure var for the obscure 'cope-with-alltt*' hack --
   neg-space-defined - Boolean)

(specdecl (cope-with-alltt* false) - Boolean)

(defproc tex-litlisp - (~ Pathname) (in-file)
   (litlisp in-file false ':tex
	    (nconc (cond (cope-with-alltt*
			  (list (tuple 'neg-space-defined false)))
			 (t !()))
		   (list   ;;;; (tuple 'output-mode ':tex)
			 (tuple 'pagerefs-to-code-segs true)
			 (tuple 'seg-vspace-adjust-defined false)))))

(defmethproc initialize - Void (tex-tm - Tex-txtlisp-mode)
	     (slot-defaults tex-tm
	        name ':tex
		file-ext "tex"))

(defmethproc txtlisp-files-init - Void (tex-tm - Tex-txtlisp-mode
				      in-pn - Pathname
				      out-srm
				        - (~ Stream))
   (try-load-aux-file in-pn)
   (cond (out-srm
	  (out (:to out-srm)
	     "%%% THIS FILE WAS AUTOMATICALLY PRODUCED by tex-litlisp from"
	     :% "%%%  " in-pn
	     :% "%%% *** DO NOT EDIT *** %%%" :% :%))))

;;;; (specdecl (tex-txtlisp-mode* (make-inst Tex-txtlisp-mode))
;;;; 	  - Tex-txtlisp-mode)

(!= (alref txtlisp-mode-creators* ':tex)
    (\\ (vars)
       (decl ()
	  (make-inst Tex-txtlisp-mode :vars (vars->hash-table vars)))))

(defconstant +tex-label-marker+ "\\newlabel{")

(defconstant +tex-label-marker-length+ (string-length +tex-label-marker+))

(specdecl +tex-label-marker+ - String
	  +tex-label-marker-length+ - Fixnum)

;;; Read in labels and store in txtlisp var 'tex-labels'.
(defproc try-load-aux-file - Void (in-pn - Pathname)
   (let ((aux-pn (merge-pathnames (make-Pathname :type "aux")
				  in-pn)))
      (cond ((probe-file aux-pn)
	     (with-open-file (aux-srm aux-pn :direction ':input)
	        (repeat :for ((line = (in (:from aux-srm) :linestring)
				    :then :again)
			      - Obj
			      :collector
			         labels - (Lrcd Symbol (Lrcd String String)))
		 :until (eq line eof*)
		 :within
		   (decl (line - String)
		      (let ((m (mismatch +tex-label-marker+ line)))
			 (cond ((= m +tex-label-marker-length+)
				(let ((substrings
					 (string-split line '("{"  "}{{"  "}{" "}}"))))
				   (cond ((null substrings)
					  (err-out "Failed to parse aux-file line: "
						   :% (:a line) :%))
					 (t
					  (:continue
					   :collect
					     (tuple (intern (first substrings))
						    (tuple (second substrings)
							   (third substrings)))))))))))
		 :result
		    (!= (tv-val tex-labels)
			labels))))
	    (t
	     (err-out "No .aux file for " in-pn :%)
	     (!= (tv-val tex-labels)
		 !())
;;;;	     (breakpoint try-load-aux-file
;;;;		"auxpn = " aux-pn)
	     ))))

(deffunc tex-label-ref - String (label - Symbol page - Boolean)
   (let ((labels (tv-val tex-labels)))
      (let ((e (alref labels label false)))
	 (cond (e
		(cond (page (second e)) (t (first e))))
	       (t
;;;;		(dbg-save label page)
;;;;		(breakpoint tex-label-ref
;;;;		   "Undefined label: " label)
		(out-to-string "??" label "??"))))))

(defun include (filename &optional out-file)
   (decl (filename - String out-file - Obj)
      (let ()
	 (multi-let (((in-pn out-pn)
		      (transduced-files-parse filename out-file
					      ".txl"
					      (!_file-ext txtlisp-control*)
					      true)))
	    ;; This will typically produce a .tex file from a .txl file, but
	    ;; any other files being produced (e.g., code files in litlisp)
	    ;; will be produced as before.--
	    (with-open-file (in-srm in-pn :direction ':input)
	       (cond ((is Pathname out-pn)
		      (with-open-file (out-srm out-pn
				         :direction ':output :if-exists ':supersede)
			 (txtlisp-transduce in-srm out-srm true)))
		     (t
		      (decl (out-pn - (~ Stream))
			 (txtlisp-transduce in-srm out-pn true)))))
	    ;; Now put this in the original file --
	    (cond ((and (eq (!_name txtlisp-control*) ':tex)
			(is Pathname out-pn))
		   (out "\\include{"
			(namestring out-pn)
			"}" :%))
		  ((is Pathname out-pn)
		   (err-out "Encountered in mode other than :tex -- "
			    `(include ',filename ',out-file))
		   (out :% "[[ No way to include " out-pn "]]" :%))
		  (t
		   (signal-problem include
		      "No way to include " out-pn)))))))

(specdecl (tex-seg-bracket-size* "footnotesize")
	  - String
	  (tex-code-begin*
	      "\\begin{small}\\begin{tt}\\begin{tabbing}") ;;;;\\\\
	  (tex-code-end*
	       "\\end{tabbing}\\end{tt}\\end{small}")

	  (alltt-tex-code-begin* "\\begin{small}\\begin{alltt}") 
	  (alltt-tex-code-end* (out (:to :string)
				  "\\end{alltt}\\end{small}")) 
	  - String
	  (seg-around-space* 9)
	  (seg-vspace-adjust* 9) - Integer)

(defmethfunc seg-def-wrappers - (Multvals pre post
					- (Fun String ((Alt Symbol String)
						       (Alt Symbol String))))
			   (output-mode - Tex-txtlisp-mode file-seg - Boolean)
   (values (\\ - String (segname segref - (Alt Symbol String))
	      (out-to-string
	             :% "\\noindent\\begin{" (:a tex-seg-bracket-size*) "}"
		     "\\texttt{<<\\textit{Define} " (:a segref) "}"
		     (:q ((and (not file-seg)
			       (tv-val-if-bound pagerefs-to-code-segs))
			  "\\label{cf/"
			  (:a segname)
			  "}"))
		     "\\end{"
			  (:a tex-seg-bracket-size*) "}"))
	   (\\ - String (_ _ - (Alt Symbol String))
	      (out-to-string "{\\" (:a tex-seg-bracket-size*) "\\texttt{>>}} \\medskip"
			     ))))

(defmethfunc embedded-code-wrappers - (Multvals pre post
						- (Fun String (String)))
			(output-mode - Tex-txtlisp-mode)
   (values (\\ - String (begin-string - String)
	      (out-to-string
		     (:q ((and cope-with-alltt*
			       (not (tv-val neg-space-defined)))
			  "\\newlength{\\lll}\\setlength{\\lll}{-1.5\\baselineskip}"
			  (:e (!= (tv-val neg-space-defined) true))))
		     (:q ((not cope-with-alltt*)
			  "\\vspace{" seg-around-space* "pt}"))
		     (:q ((not (tv-val seg-vspace-adjust-defined))
			  "\\newlength{\\segadjust}\\setlength{\\segadjust}{"
			  (:a seg-vspace-adjust*) "pt}"
			  (:e (!= (tv-val seg-vspace-adjust-defined) true))))
		     (:a begin-string)
		     "\\vspace{-\\segadjust}"
		     (:q (cope-with-alltt* (:a alltt-tex-code-begin*))
			 (t (:a tex-code-begin*)))))
	   (\\ - String (end-string - String)
	      (out-to-string (:a end-string)
			     (:q (cope-with-alltt*
				  (:a alltt-tex-code-end*)
				  "\\vspace{\\lll}\\hspace{\\textwidth}")
				 (t
				  (:a tex-code-end*)
				  "\\vspace{" seg-around-space* "pt}"))
;;;;			     "\\vspace{-\\segadjust}"
			     ))))

(defmethfunc seg-ref-producer - (Fun String (Symbol))
	                    (output-mode - Tex-txtlisp-mode)
   (let ((frag-ref-version (frag-ref-producer output-mode)))
      (\\ - String (name - Symbol)
	 (let ((n (seg-leading-blanks name)))
	    (out-to-string
	       (:q ((and n (> n 0)) "\\verb+" (:_ n) "+"))
	       (:a (funcall frag-ref-version name n)))))))

(defmethfunc frag-ref-producer - (Fun String (Symbol Boolean))
	                    (output-mode - Tex-txtlisp-mode)
   (\\ - String (name - Symbol defined - Boolean)
;;;;      (trace-around text-f-ref-produce (:if source-file*)
;;;;	 (:> "(text-f-ref-produce: " name ")")
      (out-to-string
	 (:e (:stream osrm)
	    (:o "\\begin{" (:a tex-seg-bracket-size*) "}\\texttt{<<}\\textit{Insert:} "
		(:e (flag-undefined-name name defined osrm))
		(:q ((tv-val-if-bound pagerefs-to-code-segs)
		     " (p.~"
		     (:a (tex-label-ref
			    (intern (string-concat "cf/" (symbol-name name)))
			    true))
		     ")"))
		"\\texttt{>>}\\end{" (:a tex-seg-bracket-size*) "}")))
;;;;	 (:< (val) "text-f-ref-produce: " val))
      ))

;;; Verbatimizing a string; wrap in "\verb+...+".
;;; 's' better not have any '+' characters!
(defmethfunc string-guarder - (Fun String (String)) (m - Tex-txtlisp-mode)
                                            ;;;; (deffunc cg - Obj (s - String)
   (\\ (s - String)
;;;;      (trace-around string-guard
;;;;	 (:> "(string-guard: " s")")
      (let ((slen (string-length s)))
	 (cond ((and (= slen 1) (char= (elt s 0) #\Space))
		;; There shouldn't be any need to verbatimize a single space;
		;; we're in \tt mode, so it will be a fixed-width space
		;; without verbatimizing.
		" ")
	       (t
		(repeat :for ((i = 0 :to (- slen 1)))
		   ;; If you don't find any problem characters, return
		   ;; original string
		   :result s
		   :within
		      (let ((ch (string-elt s i)))
			 (:continue
			  :until (or (tex-char-must-be-guarded ch)
				     (and (not cope-with-alltt*)
					  (char= ch #\Newline)))))
		   ;; Go back and rebuild it
		   :result
		      (let ((new-string
			       (make-string-array
				  (ceiling (* 1.25 (string-dim s))))))
			 (repeat :for ((i = 0))
			    ;; We know it's nonempty, so no need to
			    ;; check for termination at this point
			    :within
			    (let ((ch (string-elt s i)))
			       ;;;; (out 1 i ch)
			       (:continue
				  (cond ((tex-char-must-be-guarded ch)
					 (string-push-to-string
					    "\\verb+" new-string)
					 (repeat
					    (vector-push-extend ch new-string)
					    (!= i (+ i 1))
					  :until (= i slen)
					    (!= ch (string-elt s i))
					    ;;;; (out i ch)
					  :while (tex-char-must-be-guarded ch))
					 (vector-push-extend #\+ new-string)))
				:until (= i slen)
				  (cond ((and (not cope-with-alltt*)
					      (char= ch #\Newline))
					 (string-push-to-string "\\\\" new-string)))
				  (vector-push-extend ch new-string)
				  (!= i (+ i 1))
				:until (= i slen)))
			  :result new-string))
		   :where
		      (:def string-push-to-string - Void
			                        (source buffer - String)
			 (repeat :for ((j = 0
					  :to (- (string-length source) 1)))
			    (vector-push-extend
			        (string-elt source j)
				buffer)))))))
;;;;	 (:< (val &rest _) "string-guard: " val))
      ))

(defmethfunc char-guarder - (Fun (~ String) (Char))
	                  (m - Tex-txtlisp-mode)
   (\\ - (~ String) (ch - Char)
      (cond ((tex-char-must-be-guarded ch)
	     (out-to-string "\\verb+" (:a ch) "+"))
	    ((and (not cope-with-alltt*)
		  (char= ch #\Newline))
	     (out-to-string "\\\\" :%))
	    (t false))))

(defmethfunc char-guard-require-tester - (Fun Boolean (Char))
			  (m - Tex-txtlisp-mode)
   #'tex-char-must-be-guarded)

(defun tex-char-must-be-guarded (ch)
   (member ch (cond (cope-with-alltt* '(#\\ #\{ #\} #\Tab))
		    (t '(#\Tab #\Space
			 #\# #\$ #\% #\& #\~ #\_ #\^ #\\ #\{ #\})))
	   :test #'char=))

(defmethfunc code-seg-ellipsis - String (m - Tex-txtlisp-mode)
    "\\ldots ")
