;-*- Mode: Common-lisp; Package: nisp; Readtable: ytools; -*-
(in-package :nisp)
;;;$Id: textutils.lisp,v 1.9 2005/08/02 12:39:06 dvm Exp $

(depends-on %module/ nisp)

(eval-when (:compile-toplevel :load-toplevel :execute :slurp-toplevel)
   (export '(transduced-files-parse filespec->pathname with-open-file-or-stream
	     dev-null*)))

;;; When transducing one file to another, adopt the convention that
;;; output = false means "Use same name as input, except for type."
;;;        = :skip means "Don't output at all."
;;;        = :stdout means "Use *standard-output*"

;;; Returns < input-file, output-file >
;;; If allow-skip is true, second value returned can be false.
(deffunc transduced-files-parse - (Multvals in-file - Pathname
					    out-file - (Alt Pathname
							    Stream
							    (Const nil)))
			 (in-file out-file - Sexp
			  in-type out-type - (~ String)
			  allow-skip - Boolean)
   (let ((in-pn (filespec->pathname in-file)))
      (cond ((not (pathname-type in-pn))
	     (cond (in-type
		    (!= in-pn (merge-pathnames (make-Pathname :type in-type)
					       in-pn)))))
	    ((and out-type (string= (pathname-type in-pn) out-type))
	     (signal-problem transduced-files-parse
		"Input file " in-pn " to has output type " out-type
		:% ">> May be overwritten"
		(:continue "I'll take that chance"))))
      (let ((out-pn
	      (cond ((eq out-file ':skip)
		     (cond ((not allow-skip)
			    (signal-problem transduced-files-parse
			       "':skip' used as output file designator"
			       " in illegal context"
			       :% " (Input file = " in-pn ")")))
		     false)
		    ((eq out-file ':stdout)
		     *standard-output*)
		    ((or (not out-file)
			 (equal out-file "")
			 (eq out-file ':usual))
		     (cond (out-type
			    (merge-pathnames (make-Pathname :type out-type) in-pn))
			   (t
			    (signal-problem transduced-files-parse
			       "No way to create usual output pathname for input "
			       in-pn " and output file extension " out-type))))
		    (t
		     (let ((out-pn (filespec->pathname out-file)))
			(cond ((and out-type
				    (not (pathname-type out-pn)))
			       (merge-pathnames (make-Pathname :type out-type)
						out-pn))
			      (t
			       out-pn)))))))
	  (cond ((equal in-pn out-pn)
		 (signal-problem transduced-files-parse
		    "Transducing to itself: " in-pn))
		(t
		 (values in-pn out-pn))))))

(specdecl (dev-null* (make-broadcast-stream)) - Stream)

(defmacro with-open-file-or-stream (srm-var out-dest^ &body b)
   (let ((fcn-name (gen-var 'produce-output))
	 (dest-var (gen-var 'out-dest)))
      `(let ((,dest-var ,out-dest^) - (~ (Alt Stream Pathname)))
	  (let-fun ((:def ,fcn-name (,srm-var - Stream)
		       ,@b))
	     (cond (,dest-var
		    (cond ((is Pathname ,dest-var)
			   (with-open-file (,srm-var ,dest-var
						  :direction ':output
						  :if-exists ':supersede)
				 (,fcn-name ,srm-var)))
			  (t
			   (decl (,dest-var - Stream)
			      (,fcn-name ,dest-var)))))
		   (t
		    (,fcn-name dev-null*)))))))

(deffunc filespec->pathname - Pathname (filespec - Obj)
   (cond ((is-String filespec)
	  (->pathname filespec))
	 ((is-Pair filespec)
	  (let ((pnl (filespecs->pathnames filespec)))
	     (cond ((null pnl)
		    (signal-problem filespec->pathname
		       "Filespec denotes no pathname: " filespec))
		   (t
		    (cond ((not (null (cdr pnl)))
			   (signal-problem filespec->pathname
			      "Filespecs denote too many pathnames: "
			      filespec :% " -> " pnl
			      (:proceed "I'll take the first"))))
		    (car pnl)))))
	 (t
	  (signal-problem filespec->pathname
	     "Indecipherable file name " filespec))))

(eval-when (:compile-toplevel :load-toplevel :slurp-toplevel :execute)
   (shadowing-import 'yt::string-subseq))

(defun string-subseq (s i j)
   (subseq (the string s) i j))

