;-*- Mode: Common-lisp; Package: nisp; Readtable: ytools; -*-
(in-package :nisp)
;;; $Id: txtlisp.lisp,v 1.38 2005/09/12 13:41:15 dvm Exp $

#-:pre-chunk
(depends-on %module/ nisp-all-at-run-time)

;;;;(depends-on :at-compile-time %ydecl/ objtype objdcl)

#+:pre-chunk
(depends-on :at-run-time %ydecl/ intypes)

(depends-on :at-run-time 
	    %wtools/ textutils %hacks/ stringmatch)

(eval-when (:compile-toplevel :load-toplevel :execute :slurp-toplevel)
   (export '(txtlisp \. txtlisp-control*
	     declare-txtlisp-vars
	     tv-val tv-is-bound tv-val-if-bound
	     txtlisp-var-val txtlisp-var-is-bound
	     bind-vars-txtlisp-transduce oo & <> |,| nn
	     txtlisp-out-file* txtlisp-in-file*
	     note-txtlisp-aux-form)))

#|
 This is a file transducer that acts as a preprocessor for TeX,
 allowing Lisp commands that build TeX inputs (or any other textual format).

    (txtlisp <filename> <outspec> <mode-spec> <var bindings>) 

 takes a file (by default ending in ".txl"), and produces a text file
 (typically, a LateX file) with all Lisp parts transduced, and
 non-Lisp parts passed through.  If <outspec> is ':skip', production
 of output file is skipped; file is transduced purely for Lisp side
 effects.  The <mode-spec> specifies the output type, such as :tex or
 :html.  The role of <var bindings> is explained below.

 A Lisp segment begins with "~~", or with "\n." (that is, a line that starts 
 with a single period ".").
 It ends with '.' occurring as an atom (typed as '%.', as explained below).
 Lisp reading conventions are in effect in a Lisp segment, except
 that % becomes the Lisp escape char, and
 \ is just passed through to TeX.  (See below.)
 No extra spaces are inserted before or after a Lisp segment, so you
 have to be careful to put them in.  (If you want a space after %., you 
 should write "%. \ " if the output is LaTeX, &nbsp; if the output is
 HTML, etc.) [For HTML output, switching the escape chars makes little
 sense, but is harmless.  Perhaps the whole thing should
 be more flexible.]

 In Lisp mode, any string is PRINC'ed as part of the output.  
 A number causes that many spaces to be put in the .tex file.
 The atom & causes  & to be put in the .tex file
 The atom \\ causes \\-newline to be put in the .tex file.
 The atom :% causes a newline to be put in the .tex file
 The atom % causes \% to be put in the .tex file.
 (The atoms :% and %  must be
     typed :%% and %% in the .txl file to get through).
 Any other symbol is evaluated and the result PRINC'ed.
 Any other form is evaluated and the result is discarded.  >>During
   the evaluation of this form, standard input is the stream for file the
   form occurs in, starting just after the form,
   and standard-output is the file being built.<<

 Useful functions & macros:
 The function (oo -args-) treats the value of each arg as a tree of atoms, 
 which are then output as if they had appeared at the top level.
 The macro (|,| [$] e) evaluates e and turns it into a fixed-point number with
 commas interspersed.  If the $ is present, put a $ sign before it.
 If e is floating-point, generate exactly two decimal places.
 The function (nn k e) returns a list of k copies of e.
 Macro (<> f l): Expands to (<# (\\ (x) `(,@f x)) l).  
 Macro (& -args-): Each arg evaluates to a list of strings.  Intersperse
 each element of each list with copies of " & ", and put them between
 the lists, too.  E.g., (:& '("a" "b") (nn 2 "foo"))
 = ("a" " & " "b" " & " "foo" " & " "foo"). [Again, this is too
 LaTeX-centric; for HTML one might want ("a" </td><td> "b" ...).]

 At the top level, any legal OUT subform is treated as if
 it occurred inside (OUT ...).  
 Useful new out-operators: 
 (:|,| [$] e): equivalent to (:a (|,| [$] e)) 

 During the running of a txtlisp file, pieces of Lisp code can consult
 _txtlisp variables_, which are kept track of in a table associated with
 each file.  These are initialized by the third argument to 'txtlisp', which
 is an association list of variables and values.

The macro (tv-val V) gets the value of txtlisp variable V (which is
unevaluated).  It's settable, of course.  The function
txtlisp-var-is-bound checks if the variable is bound.  The macro
(tv-is-bound V) is usually more convenient.  (tv-val V) can be set
even if V is unbound.  Another macro (tv-val-if-bound V [D]) gets the
value of V, or the value of D if V is unbound; D defaults to 'false.

For a smooth interface with Nisp, the macro 'declare-txtlisp-vars' can
be used to declare variables' types.  It has the same syntax as
'specdecl', but you can't include initial values.  These are provided
on a per-file basis, either in the call to 'txtlisp' or in the file
itself.
|#

(specdecl (txl-readtable*
	      (let ((new (copy-readtable yt::ytools-readtable*)))
		 ;; It's more convenient to let #\\ be just the TeX 
		 ;; escape char, not the Lisp one
		 (set-syntax-from-char #\% #\\ new)
		 (set-syntax-from-char #\\ #\a new)
		 new))
          ytools-read-table*
	  - Obj
	  (txtlisp-dbg* false) - Boolean)

;;; With these conventions, TEXLISP mode just passes \ through, and converts
;;; %%   to % (the TeX comment character)
;;; %.   to the character '.' (which is parsed as the symbol |.| and ends TEXLISP mode)
;;; %,   to the character ','
;;;  etc.
;;; To get a percent into the file, you have to type \%% . The backslash
;;; is to keep it from being a TeX comment.  
;;; However, if the symbol "%" occurs at top level (i.e., as an atom,
;;; typed %%) it will be put out as an escaped percent.


;;;; (specdecl txtlisp-vars* - (Lst (Lrcd Symbol Obj))
;;;; 	  txtlisp-var-decls* - (Lst (Lrcd Symbol Type)))

(specdecl txtlisp-var-decls*   ;;; (make-hash-table :test #'eq :size 100)
	  - (Htb Type))

(eval-when (:slurp-toplevel :load-toplevel)
   (cond ((not (boundp 'txtlisp-var-decls*))
	  (!= txtlisp-var-decls*
	      (make-hash-table :test #'eq :size 100)))))

(specdecl *package* *readtable*)

(defnisptype Txtlisp-mode
       (Object name - Symbol file-ext - (~ String) vars - (Htb Obj)
	  (:handler
	      (print-object (tm - Txtlisp-mode srm - Stream)
		 (out (:to srm) "#<Txtlisp-mode " (!_name tm) ">")))))

(specdecl txtlisp-control* - Txtlisp-mode)

(defopproc txtlisp-files-init - Void (tm - Txtlisp-mode
				      in-pn - Pathname
				      out-srm - (~ Stream))
                                     (declare (ignore in-pn out-srm))
   nil)

(defmethproc initialize - Void (tm - Txtlisp-mode)
   (!= (!_vars tm) (make-hash-table :test #'eq :size 100)))

(defmethproc initialize :after - Void (tm - Txtlisp-mode)
   (cond ((not (and (slot-boundp tm 'name)
		    (slot-boundp tm 'file-ext)))
	  (signal-problem Txtlisp-mode-initialize
	     "Txtlisp-mode lacks name and/or file-ext"))))

(defnisptype Txt-txtlisp-mode
   (Object (:include Txtlisp-mode)))

(defmethproc initialize - Void (txt-tm - Txt-txtlisp-mode)
	     (slot-defaults txt-tm
	        name ':txt
		file-ext "txt"))

(defnisptype Skip-txtlisp-mode
   (Object (:include Txtlisp-mode)))

(defmethproc initialize - Void (skip-tm - Skip-txtlisp-mode)
   (slot-defaults skip-tm
      name ':skip
      file-ext ':skip))

(defnisptype Unknown-txtlisp-mode
   (Object (:include Txtlisp-mode)))

(defmethproc initialize - Void (txt-tm - Unknown-txtlisp-mode)
	     (slot-defaults txt-tm
	        name ':unknown
		file-ext false))

(specdecl (txtlisp-mode-creators* !())
	  - (Lst (Lrcd Symbol (Fun Txtlisp-mode (Obj)))))
;;;    -- Creates mode given vars as hash table or alist.

;;;;	  (txt-txtlisp-mode*
;;;;	     (make-inst Txt-txtlisp-mode))
;;;;	  (skip-txtlisp-mode*
;;;;	     (make-inst Skip-txtlisp-mode))
;;;;	  (unknown-txtlisp-mode*
;;;;	     (make-inst Unknown-txtlisp-mode)))

(!= (alref txtlisp-mode-creators* ':txt)
    (\\ (vars)
       (decl ()
	  (make-inst Txt-txtlisp-mode :vars (vars->hash-table vars)))))

(!= (alref txtlisp-mode-creators* ':skip)
    (\\ (vars)
       (decl ()
	  (make-inst Skip-txtlisp-mode :vars (vars->hash-table vars)))))

(specdecl (unknown-mode-creator* 
	     (\\ (vars)
		(decl ()
		   (make-inst Unknown-txtlisp-mode :vars (vars->hash-table vars)))))
	  - (Fun Txtlisp-mode (Obj)))

(!= (alref txtlisp-mode-creators* ':unknown)
    unknown-mode-creator*)

;;;; (!= (alref txtlisp-modes* ':txt) txt-txtlisp-mode*)
;;;; (!= (alref txtlisp-modes* ':skip) skip-txtlisp-mode*)
;;;; (!= (alref txtlisp-modes* ':unknown) unknown-txtlisp-mode*)

(specdecl txtlisp-aux-forms* - (Lst Sexp))

;;; The 'vars' arg is application-dependent vars, their initial values, 
;;;  and optional designators of their types.
(defproc txtlisp - (Alt Pathname Stream (Const nil))
                   (in-file out-file - Obj
		    mode-desig - Obj
		    vars - (Lst (Lrcd Symbol Obj)))
   (bind ((txtlisp-control*
	     (decipher-mode-from-desig mode-desig vars))
	  - Txtlisp-mode
	  ;; Turn off annoying warnings generated by 'fload's
	  ;; in files being transduced --
	  (warn-about-postponed-file-chunks* false)
	  - Boolean)
      (multi-let (((in-pn out-pn)
		   (transduced-files-parse
		      in-file out-file
		      "txl" (!_file-ext txtlisp-control*)
		      (eq (!_name txtlisp-control*) ':skip))))
	 (let ((aux-pn (merge-pathnames
			  (make-pathname :type "lux")
			  in-pn)))
	    (cond ((and out-pn
			(eq (!_name txtlisp-control*) ':skip))
		   (signal-problem txtlisp
		      "Can't specify output destination (" out-pn ")"
		      :% " with output mode :skip" 
		      (:proceed "I will suppress output"))
		   (!= out-pn false)))
;;;;	    (!= (alref txtlisp-vars* 'output-mode) output-mode)
	    (dbg-out txtlisp-dbg*
	       :% "Transducing [mode " (!_name txtlisp-control*) "]"
	       :% 4 in-pn
	       :% "--> " out-pn :%)
;;;;	    (breakpoint txtlisp
;;;;	       "Files initialized")
	    (with-open-file (in-stream in-pn :direction ':input)
	       (bind ((*package* *package*)
		      (*readtable* *readtable*)
		      (txtlisp-aux-forms* !())
		      (txtlisp-in-file* in-pn)
		      (txtlisp-out-file* out-pn)
;;;;		      (txtlisp-out-type* (Pathname-type out-pn))
		      )
		  (with-post-file-transduction-hooks
		     (cond ((probe-file aux-pn)
			    (handler-case (load aux-pn)
			       (error (e)
				  (err-out
				     "Error reading .lux file: " e))))
			   (t (out (:to *error-output*)
				 "File " aux-pn
				 " does not exist -- creating" :%)))
		     (cond (out-pn
			    (cond ((is Pathname out-pn)
				   (with-open-file (out-stream out-pn
						       :direction ':output
						    :if-exists ':supersede)
				      (txtlisp-files-init
				          txtlisp-control* in-pn
					  out-stream)
				      (txtlisp-transduce
					 in-stream out-stream false)))
				  (t
				   (decl (out-pn - Stream)
				      (txtlisp-files-init
				          txtlisp-control* in-pn
					  out-pn)
				      (txtlisp-transduce
					 in-stream out-pn false)))))
			   (t
			    (txtlisp-files-init txtlisp-control* in-pn false)
			    (txtlisp-transduce in-stream false false)))
;;;;		     (err-out "txtlisp-aux-forms*:" :% txtlisp-aux-forms*)
		     (with-open-file (aux-stream aux-pn
					 :direction ':output
					 :if-exists ':supersede)
			(bind ((*print-level* false)
			       (*print-length* false)
			       (*print-readably* true))
			   (repeat :for ((form :in (reverse txtlisp-aux-forms*)))
			      (out (:to aux-stream) form :%)))
			out-pn))))))))

(defproc note-txtlisp-aux-form - Void (form - Sexp)
   (on-list form txtlisp-aux-forms*))

(deffunc disj-comma-string - String (l - (Lst Obj)) 
   (out-to-string
      (:q ((not (null (tail l)))
	   ", "
	   (:q ((not (null (tail (tail l)))) "or "))))))

;;; Superseded by 'transduced-files-parse' --
#|
(specdecl tex-pathname* txl-pathname* -  Pathname)

(!= tex-pathname* (make-pathname :type "tex"))
(!= txl-pathname* (make-pathname :type "txl"))


(deffunc txl-files-parse - (Multvals in-pn - Pathname
				     out-pn - (~ Pathname))
	                (in-file out-file)
   (let ((in-pn (filespec->pathname in-file)) - Pathname
	 (out-pn (and out-file
		      (not (eq out-file ':skip))
		      (filespec->pathname out-file)))
	 - (~ Pathname))
      (cond ((not (pathname-type in-pn))
	     (!= in-pn (merge-pathnames txl-pathname* in-pn)))
	    ((string= (pathname-type in-pn) "tex")
	     (signal-problem txl-files-parse
		"Input file " in-pn " to texlisp has type '.tex'."
		:% ">> May be overwritten"
		(:continue "I'll use the given pathname"))))
      (cond ((not (eq out-file ':skip))
	     (cond ((not out-pn)
		    (!= out-pn
			(merge-pathnames tex-pathname* in-pn)))
		   ((not (pathname-type out-pn))
		    (!= out-pn
			(merge-pathnames tex-pathname* out-pn))))))
      (values in-pn out-pn)))
|#



(defmacro bind-vars-txtlisp-transduce (mode-desig^ vars^ prelude^ in-stream^ out-stream^)
   (let ((vars-var (gen-var 'vars)))
      `(let ((,vars-var ,vars^))
	  (bind ((txtlisp-control*
		    (decipher-mode-from-desig ,mode-desig^ ,vars^))
		 - Txtlisp-mode)
;;;;		(txtlisp-vars* ,vars-var)
		(*package* *package*)
		(*readtable* *readtable*)
		(txtlisp-in-file* false)
		(txtlisp-out-file* false))
	     (with-post-file-transduction-hooks
		,@prelude^
		(txtlisp-transduce ,in-stream^ ,out-stream^ false)))))

(defproc decipher-mode-from-desig - Txtlisp-mode
	                     (mode-desig - Obj
			      vars - (Lst (Lrcd Symbol Obj)))
   (cond ((is Txtlisp-mode mode-desig)
	  (!= (!_vars mode-desig)
	      (vars->hash-table vars))
	  mode-desig)
	 (t
	  (funcall
	     (cond ((is Symbol mode-desig)
		    (decl (mode-desig - (~ Symbol))
		       (repeat :for (x - (~ (Fun Txtlisp-mode (Obj))))
			  (!= x (alref txtlisp-mode-creators* mode-desig) )
			:until x
			:result x
			  (!= mode-desig
			      (signal-problem txtlisp
				  "Unfamiliar txtlisp mode " mode-desig
				  (:prompt-for "a symbol, one of "
					       (<# car txtlisp-mode-creators*)
					       " or nil for :unknown mode"
					       nil)))
			:while mode-desig
			:result unknown-mode-creator*)))
		   (t
		    (be (Fun Txtlisp-mode (Obj))
			mode-desig)))
	     vars))))


(defproc txtlisp-transduce - Void (in-stream - Stream
				   text-stream - (~ Stream)
				   ignore-lisp - Boolean)
	    (repeat :for (ch - Char ch2 - (~ Char)
			  escape (stop-early false) - Boolean
			  (out-stream (or text-stream (make-broadcast-stream)))
			  - Stream
			  (i = 1) - Integer
			  (chars !()) - (Lst Char)
			  lisp-escape-string end-string - String)
;;;;	       (err-out "chars = " (:a (coerce (reverse chars) 'string)))
	       (!= ch (in (:from in-stream) :char))
	     :until (eq ch eof*)
	     :result
	       (dbg-out txtlisp-dbg*
		  "Done with file in segment beginning"
		  :% "  [[[" (:a (start-string)) "]]]")
	       (count-char ch)
	       (!= escape false)
	       (cond ((char= ch #\Newline)
		      (!= ch2 (in (:from in-stream) :peek))
		      (!= escape (and (not (eq ch2 eof*))
				      (char= ch2 #\.))))
		     ((char= ch #\~)
		      (!= ch2 (in (:from in-stream) :peek))
		      (!= escape (and (not (eq ch2 eof*))
				      (char= ch2 #\~))))
		     (t
		      (!= ch2 false)))
	       (cond (escape
		      (count-char ch2)
		      (!= lisp-escape-string
			  (cond ((char= ch2 #\~) "~~")
				(t (coerce '(#\Newline #\.) 'string))))
		      ;; Flush ch2 -- 
		      (read-char in-stream)
		      (!= ch2 (in (:from in-stream) :peek))
		      (cond ((and (not (eq ch2 eof*))
				  (or (char= ch2 #\))
				      (char= ch2 #\|)))
			     ;; Stop before end of file reached.
			     (repeat (read-char in-stream)
				(cond (txtlisp-dbg*
				       (!= end-string
 					   (string-concat
					      lisp-escape-string
					      (string ch2)))))
				(!= ch2 (in (:from in-stream) :peek))
			      :while (and (not (eq ch2 eof*)) (char= ch2 #\))))
			     ;;;;(read-char in-stream)
			     (!= stop-early true))
			    (t
			     (dbg-out txtlisp-dbg*
				"Lisp segment beginning \"" (:a lisp-escape-string) "\""
				:% " in segment beginning "
				:% "  [[[" (:a (start-string)) "]]]")
			     (out-indent *error-output* 3
				(lisp-transduce in-stream out-stream
						ignore-lisp)))))
		     ((char= ch #\Tab)
		      ;; tab expansion
		      (out (:to out-stream) 8))
		     (t
;;;;		      (out (:to *error-output*)
;;;;			   "'" (:a ch))
		      (out (:to out-stream) 
			   (:a ch))))
	     :until stop-early
	     :result (dbg-out txtlisp-dbg*
			      (:i< 3)
			      "Segment ends; began with"
			      :% " [[[" (:a (start-string)) "]]]"
			      :% "ends with [[[" (:a end-string) "]]]")
	     :where

	       ;; Keep track of chars at beginning of lisp segment.
	       (:def count-char - Void (ch - Char)
		  (!= i (+ i 1))
		  (cond ((=< i 40)
			 (!= chars (cons ch *-*)))))

	       (:def start-string - String ()
		   (coerce (reverse chars) 'string))))

		       
(specdecl *load-verbose* *compile-verbose* - Boolean)

(defproc lisp-transduce - Void (in-stream out-stream - Stream
				ignore-forms - Boolean)
   (bind ((*readtable* txl-readtable*)
	  ;; Avoid cluttering up .tex file
          (*load-verbose* false)   
          (*compile-verbose*)
	  (*standard-input* in-stream)
	  (*standard-output* out-stream))
      (repeat :for (r (first-form false))
	 (!= r (read-preserving-whitespace in-stream))
;;;;	       (dbg-out txtlisp-dbg*
;;;;		  "Read:" r)
       :until (or (eq r eof*) (eq r '\.))
	 (cond ((not first-form)
		(!= first-form r)))
;;;;	 (out (:to *query-io*) r :%)
	 (cond ((not ignore-forms)
		(lisp-form-transduce r)))
       :result (cond ((eq r eof*)
		      (err-out "End of file reached during Lisp segment"
			       (:q (first-form
				    " beginning with " :% first-form))))
		     (t
		      (dbg-out txtlisp-dbg*
			  "Lisp segment ends with \".\"")
		      (repeat :for (ch)
			 (!= ch (in (:from in-stream) :peek))
		       ; Flush spaces and tabs, but not newlines, after %.
		       :while (memq ch '(#\Space #\Tab))
		         ;;;;(out (:to *error-output*) "?" ch)
			 (in (:from in-stream) :char)
		       :result false))))))

;;; When Lisp forms are transduced, *standard-output* is the text file (if any).

(defproc lisp-form-transduce - Void (r - Sexp)
   (dbg-out txtlisp-dbg*
      "Transducing form " r)
   (cond ((is String r)
	  (out (:a r)))
	 ((is Integer r)
	  (out (:_ r)))
	 ((memq r '(\\\\ % & :%))
	  (atom-transduce r))
	 ((is Symbol r)
	  (out (:a (eval r))))
	 ((atom r)
	  (atom-transduce r))
	 ((yt::get-out-operator r)
	  (eval `(out ,r)))
	 (t
	  (eval r))))

(defproc atom-transduce - Void (r - Obj)
   (selq r
      (\\\\
       (out " \\\\" :%))
      (%
       (out "\\%"))
      (&
       (out "&"))
      (:%
       (out :%))
      (t (out r))))

; Recursively transduce
(defproc oo - Void (&rest l)
   (repeat :for ((x :in l))
      (cond ((is String x)
	     (out (:a x)))
            ((atom x)
             (atom-transduce x))
	    ((consp x)
             (<< oo x)))))
            
(defmacro & (&rest l)
   `(progn
       ,@(&-sep (<# (\\ (x) `(&-sep ,x)) l))))

(defproc &-sep - (Lst Obj) (l - (Lst Obj))
   (<! \. (\\ (tl)
	     `(,(car tl)
	       ,@(include-if (not (null (cdr tl)))
                    '" & ")))
       l))

(defmacro <> (formstart x^)
   `(<# (\\ (e) (,@formstart e))
	,x^))

(yt::define-out-operator (:|,| cmd _)
  `(out (:a (|,| ,@(cdr cmd)))))

;;; Superseded by version in textutils.lisp (not clear if they're exactly equivalent)
#|
(defun filespec->pathname (fs) 
   (let ((pnl (filespecs->pathnames (cond ((consp fs) fs) (t (list fs))))))
      (cond ((= (len pnl) 1)
	     (head pnl))
	    ((null pnl)
	     (signal-problem filespec->pathname
		"Filespecs " fs " denotes no pathnames"))
	    (t
	     (signal-problem filespec->pathname
		"Filespec " fs
		:% " does not denote single pathname, but: "
		:% pnl
	        (:proceed "I'll take the first"))
	     (head pnl)))))
|#

(defmacro |,| (&rest l) 
   (cond ((eq (car l) '$)
          `(c-ify ,(cadr l) true false))
         ((equal (car l) '($))
          `(c-ify ,(cadr l) true true))
         ((eql (car l) '())
          `(c-ify ,(cadr l) false true))
         (t
          `(c-ify ,(car l) false false))))

(deffunc c-ify - String (n - Number dollars parens - Boolean)
   (cond ((< n 0)
          (let ((nc (c-ify (- n) false false)))
             (cond (dollars
                    (!= nc (string-concat "\\$" nc))))
	     (cond (parens
		    (string-concat "(" nc ")"))
		   (t (string-concat "-" nc)))))
         (t
          (let ((ns (num-commify n)))
             (cond (dollars
                    (string-concat "\\$" ns))
                   (t ns))))))

(defun num-commify (n)
   (labels ((add-commas (s)
	       (let ((l (length s)))
		  (cond ((< l 4) s)
			(t
			 (let ((s1 (subseq s 0 (- l 3)))
			       (s2 (subseq s (- l 3) l)))
			    (concatenate 'string
					 (add-commas s1) "," s2)))))))
      (cond ((floatp n)
	     (let ((str (format nil "~,2F" n)))
		(let ((l (length str)))
		   (string-concat (add-commas (subseq str 0 (- l 3)))
				  (subseq str (- l 3) l)))))
	    (t
	     (let ((str (format nil "~S" n)))
		(add-commas str))))))

(defun nn (k x)
   (<# (\\ (i) (ignore i)
	  x)
       (series k)))

(specdecl (txtlisp-var-unbound* (printable-as-string "Unbound txtlisp var")))
	  
(deffunc txtlisp-var-is-bound - Boolean (name - Symbol)
   (not (eq (href (!_vars txtlisp-control*)
		  name
		  txtlisp-var-unbound*)
	    txtlisp-var-unbound*)))

;;;;   (not (not (assq name txtlisp-vars*))))

(deffunc txtlisp-var-val (name - Symbol)
  (href (!_vars txtlisp-control*)
	name
	(signal-problem txtlisp-var-val
		  "Unbound txtlisp var " name)))

;;;  First arg always evaluated, second only if unbound
(defmacro txtlisp-var-val-if-bound (name^ default^)
   `(href (!_vars txtlisp-control*)
	  ,name^
	  ,default^))

(defproc txtlisp-var-val-set (name - Symbol val - Obj)
  (!= (href (!_vars txtlisp-control*) name)
      val))

(defsetf txtlisp-var-val txtlisp-var-val-set)

;;; Variables are bound wrt a particular file, but their type declarations
;;; are global.

;;;;(specdecl (txtlisp-var-decls* !()) - (Lst (Lrcd Symbol Type)))

(defmacro declare-txtlisp-vars (&rest decls)
   (let ((vtl (bvars-vartypes nil decls nil)))
      `(needed-by-macros
	       ,@(<# (\\ (vt)
		       (decl (vt - Vartype)
			   (let ((var (!_var vt)) - Symbol
				 (typ (!_typ vt)) - (~ Type))
			      `(!= (href txtlisp-var-decls* ',var 'Obj)
				   ,(cond (typ (type-loader (!_desig typ) false))
					  (t ''Obj))))))
		    vtl))))

(datafun decl-compl tv-val
   (defun :^ (exp dest-type)
      (let ((ty (href txtlisp-var-decls* (cadr exp)
		      (signal-problem tv-val-decl-compl
				"Undeclared txtlisp variable " (cadr exp)))))
	 (type-trans
	     `(txtlisp-var-val ',(cadr exp))
	     ty
	     dest-type))))

(defmacro set-tv-val (v ^val)
   `(txtlisp-var-val-set ',v ,^val))

;;;(defsetf tv-val set-tv-val)

(define-setf-expander tv-val (var-name)
   (let ((storevar (gensym))
	 (vars-var (gen-var 'vartab)))
      (values `(,vars-var)
	      `((!_vars txtlisp-control*))
	      `(,storevar)
	      `(!= (href ,vars-var ',var-name)
		   ,storevar)
	      `(href ,vars-var ',var-name))))

;;;;       (values `(,entryvar)  ;; temp vars
;;;; 	      `((assq ',var-name (!_vars txtlisp-control*)))  ;; temp forms
;;;; 	      `(,storevar)  
;;;; 	      `(cond (,entryvar
;;;; 		      (!= (cadr ,entryvar) ,storevar))
;;;; 		     (t
;;;; 		      (!= (!_vars txtlisp-control*)
;;;; 			  (cons (tuple ',var-name ,storevar)
;;;; 				*-*))))
;;;; 	      `(tv-val ,var-name))))

(defmacro tv-val (v) `(decl () (tv-val ,v)))

(defmacro tv-is-bound (v) `(txtlisp-var-is-bound ',v))

(defmacro tv-val-if-bound (v &key ((:else else^) 'false))
   `(txtlisp-var-val-if-bound ',v ,else^))

;;;;    `(cond ((txtlisp-var-is-bound ',v)
;;;; 	   (tv-val ,v))
;;;; 	  (t ,else^)))

;;;; (declare-txtlisp-vars
;;;;    output-mode - Txtlisp-mode)

;;; Hack to put spaces in Lisp sections, usually at end.
(defconstant \ " ")

(deffunc vars->hash-table - (Htb Obj) (vars - (Alt (Htb Obj)
						   (Lst (Lrcd Symbol Obj))))
   (cond ((hash-table-p vars)
	  (be (Htb Obj) vars))
	 (t
	  (decl (vars - (Lst (Lrcd Symbol Obj)))
	     (let ((table (make-hash-table :test #'eq :size (len vars))))
		(repeat :for ((e :in vars))
		   (!= (href table (first e))
		       (second e)))
		table)))))

