;-*- Mode: Common-lisp; Package: opt; Readtable: nisp; -*-
(in-package :opt)

SUPERSEDED by opt/action.lisp and other files

; Parser of actions and expansions.

def-body-to-method needs to be completely revised.

(depends-on nils)

(depends-on at-run-time opt/ more-syntax syntax basics types
			types/ typecheck flagsource)

;;; 'defs' each start with :action, :durative, or :process
(defun causations-parse (defs dom)
   (let ((env (domain-place-env dom))
	 (pre-scope-time scope-time*))
      (multi-let (((fundef-recs trailing-ifes)
		   (fundefs-types cause-defs !() false void-type*
				  step-type-wrapper env)))
	 (let ((fun-bdgs (recursive-funtypes-vartypes fundef-recs)))
	    (multi-let (((low-bdgs-lists low-restypes undo-stack)
			 (fundefs-body-envs fundef-recs !())))
	       (repeat :for ((fdr :in fundef-recs)
			     (res-type :in low-restypes)
			     (surface-def :in cause-defs)
			     (low-restype :in low-restypes)
			     (ustack !())
			     :collectors lists-of-alists-of-fields
					 low-envs
					 flagged-versions)
		  (collecting-defective-exps
		      (def-list)
		      (let ((low-env (env-bindings-append
					true (append low-bdgs fun-bdgs)
					env)))
			 (multi-let (((field-alist def-flg meth-varbdgs lower-env
				       bad-keyword-flg ill-formed-vars
				       ustack-1)
				      (funcall
				          (causation-def-fields-handler
				             (car surface-def))
					  fdr ustack
					  (context-expstack-push
					     (Fundef-rec-defn fdr)
					     (Fundef-rec-defn-pos fdr)
					     (opt-syn-context
						`(,cause-type ,@(Fundef-rec-defn fdr))
						!()))
					  low-env))))
			    (one-collect list-of-alists-of-fields field-alist)
			    (one-collect low-envs lower-env)
			    (one-collect flagged-versions def-flg))
		      (:if-aborted
		         :restart-report (lambda (srm)
					    (out (:to srm)
					       "I will skip checking "
					       (car surface-def)
					       1 (Fundef-rec-name fdr)))
			 (one-collect list-of-alists-of-fields !())
			 (one-collect low-envs lower-env)
			 (one-collect flagged-versions
				      (flagexp surface-def def-list))))
		:result
		  ;; Now eliminate tvars from low types, argtypes first
	          (let ((rem-tvar-lists 
			   (repeat :for ((fdr :in fundef-recs)
					 (low-env :in low-envs))
			    :collect (elim-tvars true fdr low-env))))
		     ;; ... Now the restypes
		     (!= rem-tvar-lists
			 (repeat :for ((fdr :in fundef-recs)
				       (low-env :in low-envs)
				       (rtl :in rem-tvar-lists))
			  :collect (unionq 
				      (elim-tvars false fdr low-env)
				      rtl)))
		     (repeat :for ((fdr :in fundef-recs)
				  (low-bdgs :in low-bdg-lists)
				  (low-env :in low-envs)
				  (rem-tvars :in rem-tvar-lists))
			(elim-unks fdr low-bdgs low-env rem-tvars))
		     (repeat :for ((fdr :in fundef-recs)
				   (surf :in surface-defs))
		      :collect (funcall (causation-def-definer
					   (car surf))
					fdr surf)))))))))

(defvar causation-def-field-handlers* !())

(datafun attach-datafun field-definer
   (defun :^ (sym _ fun-name)
      (!= (alref causation-def-field-handlers* sym)
	  (symbol->fun fun-name))))

(defun causation-def-fields-handler (def-flag)
   (alref causation-def-field-handlers* def-flag
	  (signal-problem causation-def-fields-handler
	     "Don't know how to handle causation type " def-flag)))

(datafun field-definer :action
   (defun :^ (fdr undo-stack context env)
      (let ((step-type
	       (cond ((memq ':expansion (Fundef-rec-defn fdr))
		      (make-Hop-type ty))
		     (t
		      (make-Skip-type ty))))
	    (ustack undo-stack)
	    field
	    (precond 'true) (effect 'true) (maintain 'true)
	    (expansion false))
	 (!= field (memq ':precondition (Fundef-rec-defn fdr)))
	 (cond (field
		(!= < precond ustack >
		    (term-check (cadr field) prop-type* ustack context env))))
	 (!= field (memq ':effect (Fundef-rec-defn fdr)))
	 (cond (field
		(!= < effect ustack >
		    (let ((step-type
			     (Fundef-rec-low-restype fundef-rec)))
		       (effect-parse
			  eff step-type prop-type*
			  ustack context
			  (env-bindings-append
			     true
			     (val-slot-vartypes
				val-slots step-type rtype env)
			     env))))))
	 (!= field (memq ':maintain (Fundef-rec-defn fdr)))
	 (cond (field
		(!= < maintain ustack >
		    (term-check (cadr field) prop-type* ustack
				env))))
		     
	 (!= field (memq ':expansion (Fundef-rec-defn fdr)))
	 (cond (field
		(!= 

		     (values fundef-recs
			     list-of-alists-of-fields
			     flagged-versions
			     trailing-ifes))

     (multi-let (((fundef-recs field-alist-list surface-forms)
		  (causations-parse 
		     act-defs ':action
		     (\\ (ty fdr)
			(cond ))
		     (list (tuple ':precondition
				  (\\ (prec _ _ undo-stack context env)
				     (term-check
					 prec prop-type* undo-stack
					 context env)))
			   (tuple ':effect
				  (\\ (eff fundef-rec val-slots undo-stack context env)
))
			   (tuple ':maintain
				  (\\ (maint _ _ undo-stack context env)
				     (term-check maint prop-type*
						 undo-stack context env)))
			   (tuple ':expansion
				  (\\ (exp _ _ undo-stack context env)
				     (cond ((eq exp ':methods)
					    (values exp undo-stack))
					   (t
					    (term-check exp action-type*
							undo-stack context env)))))
		     !() dom))))
	(let ((mrg (own-rule-group dom)))
	   (repeat :for ((fdr :in fundef-recs)
			 (form :in surface-forms)
			 (field-alist :in field-alist-list))
	      (let ((fbdg (place-domain-bdg fctn dom)))
		 (let ((fctn (flag-if-inconsistently-declared
			        (Fundef-rec-name fdr)
				fbdg
				(Fundef-rec-funtype fdr)
				(domain-place-env dom))))
		    (cond ((is-Symbol fctn)
			   (let ((defn (make-Action-defn
					  :function fctn
					  :term (fundef-rec-term fdr)
					  :varbdgs
					  :condition
					     (alref field-alist ':condition 'true)
					  :effect
					     (alref field-alist ':effect 'true)
					  :maintain
					     (alref field-alist ':maintain 'true)
					  :value (maybe-type-slot-fun
						    false (Fundef-rec-low-restype fdr)
						    'r ':type !() env???)
					  :has-methods (not (not (alref field-alist
									':expansion
									false)))
					  :only-in-expansions
					     (not (not (alref field-alist
							      ':only-in-expansions
							      false))))))
			      (bind-causation-function
			          fbdg fctn
				  (Fundef-rec-funtype fdr)
				  defn)
			      (let ((exp (alref field-alist ':expansion false)))
				 (cond ((and exp (not (eq exp ':methods)))
					(add-to-rule-group
					   (def-body-to-method
					      fctn fctn
					     (action-function-term fctn qvarbdgs)
					     qvarbdgs meth-varbdgs
					     false false expansion)
					   mrg))))))
			  (t
			   ;; Careful: destructively altering surface form to
			   ;; indicate problem.
			   ;; It's of form (:"action" (name ...) ...)
			   (!= (car (cadr surface-form)) fctn))))))
	   `(:actions ,@surface-forms))))

;;; 'cause-type' is :action, :process, or :durative.
;;; 'step-type-wrapper' is corresponding Skip, Slide, or Hop type builder.
;;; Returns < fundef-recs, list-of-alists-of-fields, surface-forms >
(defun causations-parse (cause-defs 
			 keyword-checkers required-keywords dom)
			     :collect lists-of-alists-of-fields
			              low-envs
				      flagged-versions)
			    (!= ustack ustack-1)
			    (one-collect low-envs lower-env)
			    (one-collect list-of-alists-of-fields
					 field-alist)
			    (one-collect flagged-versions
			       `(,@cause-type
				 (,fctn ,@(... all-params-in-external-form  ...))
				 - ,(fundef-rec-low-res-desig fdr)
				 ,@(cond ((null meth-varbdgs) '())
					 (t `(:vars
					      ,(vars-source-maybe-flag
						  meth-varbdgs
						  ill-formed-vars))))
				 ,@(repeat :for ((keyword-te :in field-alist))
				    :collect `(,(car keyword-te)
					       ,(flagsource
						   (cadr keyword-te))))
				 ,@bad-keyword-flg))))
		      (:if-aborted
		         (:restart-report
			     (lambda (srm)
			        "I will give up on checking "
				cause-type 1 (Fundef-rec-name fdr)))))
			
		:result



    :where

      (:def elim-tvars (arg-vs-res fdr low-env)
	    (cond ((Fundef-rec-is-high fdr)
		   (multi-let (((low-funtype-fewer-tvars _ ustack)
				(tvar-elim
				   (Fundef-rec-res-funtype fdr)
				   true
				   (cond (arg-vs-res
					  (list ':maximize false))
					 (t
					  (list false ':minimize)))
				   pre-scope-time undo-stack low-env)))
		      (!= undo-stack ustack)
		      (!= (Fundef-rec-res-funtype fdr)
			  low-funtype-fewer-tvars)
		      '()))
		   
		  (t
		   (multi-let (((low-funtype-fewer-tvars rem-tvars ustack)
				(tvar-elim
				   (Fundef-rec-funtype fdr)
				   true
				   (cond (arg-vs-res
					  (list false
						':max-if-constrained))
					 (t
					  (list ':min-if-constrained
						false)))
				   pre-scope-time undo-stack low-env)))
		      (!= undo-stack ustack)
		      (!= (Fundef-rec-funtype fdr)
			  low-funtype-fewer-tvars)
		      rem-tvars))))

      (:def elim-unks (fdr low-bdgs low-env rem-tvars)
	 (let ((new-high-params '()))
	    (cond ((Fundef-rec-is-high fdr)
		   (let ((unk-ids 
			    (<# (\\ (vt)
				   (unknown-type-id (Vartype-val vt)))
				low-bdgs)))
		      (let ((low-funtype
			       (unk-elim (Fundef-rec-res-funtype fdr)
					 unk-ids pre-scope-time fun-vartypes)))
			 (!= (Fundef-rec-funtype fdr)
			     (make-funtype
				1 low-funtype
				(type-find-feature
			           *-* 'argtype fun-vartypes)
				(args->spec (list low-funtype))
				(funtype-extract-arglist *-* fun-vartypes)
				false fun-vartypes)))))
		  (t
		   ;; Replace tvars with unks,
		   (repeat :for ((tv :in rem-tvars)
				 (new-unk false)
				 (unks '()))
		      (let ((tvbdg (tvar-type-bdg tv)))
			 (cond ((not (Typebdg-val tvbdg))
				(!= new-unk true)
				(let ((np 
					 (make-param-type
					    (build-symbol
					       Y- (++ new-high-param-no*))
					    type-type*)))
				   (!= new-high-params
				       (cons np *-*))
				   (let ((unk (nisptype::unknown-type-for-param
						 np type-type* false false)))
				      (!= unks
					  (cons unk *-*))
				      (!=? (Typebdg-val tvbdg)
					   unk
					   undo-stack))))))
		    :result (cond (new-unk
				   (fundef-rec-funtype-raise
				      fdr unks low-env))))))))

      (:def fundef-rec-funtype-raise (fdr unks low-env)
	 ;; Convert to high
	 (let ((arglist
		  (new-Arglistspec
		     (<# (\\ (u)
			    (new-Argspec
			       (param-type-varname
				  (type-feature u 'param))
			       ':required
			       type-type*))
			 unks))))
	    (let ((low-funtype
		     (unk-elim (Fundef-rec-funtype fdr)
			       (<# unknown-type-id unks)
			       pre-scope-time low-env)))
	       (!= (Fundef-rec-res-funtype fdr) low-funtype)
	       (!= (Fundef-rec-funtype fdr)
		   (make-funtype
		      1 low-funtype
		      (arglistspec-argtype arglist env)
		      (args->spec low-funtype)
		      arglist false fun-vartypes)))))))))))

(defun condition-or-vacuous (precond)
   (cond (precond (cadr precond))
	 (t
	  vacuously-true-boolapp*)))

(defun flag-if-inconsistently-declared (fbdg funtype env)
		   (cond ((and (not (Domain-bdg-unbound fbdg))
			       (not (types-equal (Domain-bdg-type fbdg)
						 funtype
						 env env)))
			  (setf (Domain-bdg-val fbdg) nil)
			  (flagexp "Symbol already defined "
				   (Vartype-var fbdg)))
			 (t (Vartype-var fbdg))))

(defun flag-expansion-problems (e dom)
   (cond ((not (eq e ':methods))
	  (!= e (flagsource e))))
   (cond ((domain-declares-requirement dom ':action-expansions)
	  e)
	 (t
	  (flag-if-ill-formed
	     e (list (simple-ill-formed-exp
			!"Action expansion illegal for ~
			  domain not declaring :action-expansions"
			false))))))

(defun methods-parse (methods dom rg)
   (cond ((null methods) '())
         (t
	  (multiple-value-bind (methods flg)
			       (list-smooth methods #'consp)
	      (let ((flg-al '()))
 		 (dolist (a methods)
		    (multiple-value-bind (flg-a defn)
					 (method-parse a dom)
		       (cond (defn 
			      (let ((fval (find-domain-bdg-val
					       (Method-defn-function defn)
					       dom)))
				 (cond ((is-Action-defn fval)
					(cond (rg
                                               (add-to-rule-group defn rg))))
				       (t
					(setq flg-a
					      (format-flg flg-a
						  "Method definition for ~
						  non-action-function ~
						  (value ~s)"
						  fval)))))))
		       (push flg-a flg-al)))
		 (let ((r `(,@(reverse flg-al)
			    ,@flg)))
		    (cond ((domain-declares-requirement
			      dom ':action-expansions)
			   r)
			  (t
			   (cons (new-Flagged-subexpression
				    false
				    (list (simple-ill-formed-exp
					     !"Methods are illegal for ~
                                               domains not declaring ~
                                               requirement :action-expansions"
					     false)))
				 r)))))))))

; Returns flagged method-body + defined method
(defun method-parse (method-body dom)
   (multiple-value-bind (fctn items bad-keyword-flg)
			(extract-params-etc
			   method-body 
			   '(:vars :precondition
			     :maintain :effect :expansion :name)
			   '(:expansion))
      (cond (fctn
	     (let ((env (empty-vartypes dom))
		   (params (get-field-or-empty ':parameters items))
		   (params-defl '()))
		(multi-let (((alspec freevars _ synerrs)
			     (params-parse
			        params true univ-type* false false env)))
		   (!= params-defl
		       (nconc *-* (synerrs-defective-exps synerrs)))
		   (let ((fbdg (var-lookup fctn env)))
		      (cond ((or (not fbdg)
				 (Domain-bdg-unbound fbdg))
			     (setq fctn
			           (flagexp "Method for undefined action"
					    fctn)))
			    (t
			     (!= params-defl
				 (nconc *-*
					(check-method-type
					   alspec freevars
					   fbdg  ;;(Domain-bdg-val fbdg)
					   env))))))
		   (let ((param-varbdgs (arglistspec->vartypes alspec)))
		      (!= env
			  (env-bindings-append true param-varbdgs *-*))
		      (multi-let (((meth-varbdgs ill-formed-vars
				    expansion precond maint _ _ _)
				   (action-def-body-check
				      items false '()
				      (opt-syn-context method-body '())
				      env)))
			 (let ((name (get-field-or-empty ':name items))
			       (actual-expansion
				  (cond ((and expansion
					      (cadr expansion)
					      (not (eq (cadr expansion)
						       ':methods)))
					 (cadr expansion))
					(t false))))
			    (values
			       `(:method ,fctn
				 ,@(cond (name
					  (cond ((symbolp name) `(,name))
						(t `(,(flagexp
							 "Illegal method name"
							 name)))))
					 (t '()))
				 :parameters ,(flag-if-ill-formed
					        (arglistspec-typed-arglist
						   alspec '())
						params-defl)
				 ,@(cond ((null meth-varbdgs) '())
					 (t `(:vars
					      ,(vars-source-maybe-flag
						  meth-varbdgs
						  ill-formed-vars))))
				 ,@(maybe-include-field precond)
				 ,@(maybe-include-field maint)
				 ,(cond (actual-expansion
					 `(:expansion
					   ,(flagsource actual-expansion)))
					(t
					 (flagexp ":expansion missing"
						  '(:expansion))))
				 ;;,@(maybe-include-field expansion)
				 ,@bad-keyword-flg)
			       (cond ((and actual-expansion (symbolp fctn))
				      (def-body-to-method
					name fctn
					(action-function-term fctn env)
					param-varbdgs meth-varbdgs
;;;;					(qvarbdgs-constraints
;;;;					   param-varbdgs env)
;;;;					(qvarbdgs-constraints
;;;;					   meth-varbdgs env)
					precond maint expansion))
				     (t nil)))))))))
            (t
             (values
	        `(:method ,(flagexp "Illegal action function"
			       (car method-body))
			  ,@(cdr method-body))
                nil)))))

;;; Returns < function, items, junk >
;;; items is an alist of fields.
(defun extract-params-etc (body keywords required)
   (multi-let (((fctn level val-type-desig params remaining-stuff)
		(extract-fun-header body)))
      (multi-let (((items bad-flg)
		   (keyword-list-smooth
                      remaining-stuff keywords required)))
	 (cond ((> level 0)
		(!= bad-flg
		    (cons (simple-ill-formed-exp
			     "No high-level functions allowed: "
			     fctn)
			  *-*))))
	 (values fctn
		 (cons (tuple ':parameters params)
		       (cons (tuple ':value val-type-desig)
			     items))
		 bad-flg))))

(defun vars-source-maybe-flag (bdgs ill-forms)
   (let ((l (var-bindings-sexp bdgs)))
      (cond ((null ill-forms) l)
	    (t (new-Flagged-subexpression l ill-forms)))))

(defun check-method-type (alspec _ fbdg env)
   (let ((ftype (Domain-bdg-type fbdg)))
      (cond ((and (is-funtype ftype)
		  (is-Skip-type (nisptype::fun-result-type ftype env)))
	     (cond ((try-accept (arglistspec-argtype alspec env)	
		 (type-feature ftype 'nisptype::argtype env)
			 !() env env !())
		    ;; Method types are not subtypes of their corresponding
		    ;; actions' types!
		    !())
		   (t
		    (list (flagexp "Mismatch with original action argtypes"
				   alspec)))))
	    (t
	     (list (flagexp "Method for non-Action "
			    (Domain-bdg-sym fbdg)))))))

(defun def-body-to-method (name fctn term acons mcons precond maint expansion)
   (cond ((not expansion)
	  (note-defective-exp
	     ((_) "Method " (:q (name name 1)) "with no expansion for " term)
	     :target name
	     :place def-body-to-method :fatal)))
   (make-Method-defn
         :name name
         :function fctn
	 :term term
	 :varbdgs (append acons mcons)
	 :precond (and precond (cadr precond))
	 :maint (and maint (cadr maint))
	 :effect false
	 :expansion (cadr expansion)))

(defun fundef-rec-terem (fdr)
   `(,(Fundef-rec-name fdr)
     ,@(<# (\\ (sym) (make-Qvar sym !()))
	   (arglistspec-arglist (Fundef-rec-low-result fdr)))))

;;; 'keyword-checkers' is alist of pairs (keyword checker-fcn)
;;; where 'checker-fcn' is used to check the term associated with
;;; the keyword; 'checker-fcn' is a function of the term, its associated
;;; Fundef-rec, the slots derived from the :value field, if any, the
;;; undo-stack, the context, and the environment.
;;; Returns < alist-of-fields, missing-keyword-flg, ill-formed-vars-flg,
;;;           vartypes-from-:var, env-with-:vars, undo-stack >
;;; where for each keyword there is an entry (keyword typed-exp) in alist-of-fields,
;;; such that typed-exp is either false (if entry for keyword absent), or
;;; the typed-exp produced from checking that entry.
;;; e.g., (:precondition #{Typed-exp-for-precond})
(defun causation-def-body-check (funrec keyword-checkers required
				 undo-stack context env)
   (multilet (((items missing-keywords-flg)
	       (keyword-list-smooth (Fundef-rec-defn funrec) keyword required)))

(defun causation-fields-check (funrec 

     (multi-let (((_ meth-varbdgs env ill-formed-vars)
		  (vars-extract-bdgs items env))
		 (step-type (Fundef-rec-low-restype funrec)))
	(multi-let (((val-slots _ undo-stack-1)
		     (Type-slotfns (maybe-type-slot-fun
				      false step-type 'r ':type undo-stack env)))
		    (body-context (opt-syn-context
				     (Fundef-rec-defn funrec)
				     !())))
	   (!= env (env-bindings-append true meth-varbdgs *-*))
	   (repeat :for ((kc :in keyword-checkers)
			 (ustack undo-stack-1)
			 item field-te
			 :collector alist-of-fields)
	      (!= item (assq (car kc) items))
	      (cond (item
		     (!= < field-te ustack >
			 (funcall (cadr kc) (cadr item) funrec val-slots ustack 
				  (context-expstack-push
				     (cadr item) (car item)
				     body-context)
				  env)))
		    (t
		     (!= field-te false)))
	    :collect (tuple (car kc) field-te)
	    :result (values alist-of-fields
			    meth-varbdgs env
			    missing-keywords-flg
			    ill-formed-vars
			    ustack))))))

;;;;(defun act-val-analyze (funrec type-maker)
;;;;   (let ((res-type (Fundef-rec-low-restype funrec)))
;;;;      (values (funcall type-maker res-type)
;;;;	      (Type-slotfns res-type))))
;;;;

(defun val-slot-vartypes (val-slots step-type val-type env)
   (let ((step-val-te
	    (simple-app-typed-exp
	       (simple-var-typed-exp 
		  'step-value env)
	       (list (make-inst Var-typed-exp
			:var 'this-step
			:qvar false
			:source 'this-step
			:type val-type
			:env env 
			:binder false
			:argspec (list (new-Vartype 'this-step val-type false))
			:check-time-callable false))
	       (list step-type)
	       univ-type* env))) 
      (<! (\\ (s)
	     (let ((slname (Slot-name s))
		   (sltype (Slot-type s)))
		(cond ((and sltype
			    (not (eq slname 'conser)))
		       (list 
			  (new-Vartype
			     slname sltype
			     (make-Prechecked
				(let ((sf-te (make-slot-fcn-te
						s sltype env)))
				   (make-inst Slot-acc-typed-exp
				      :slotname slname
				      :type-invert (Slot-invert s)
				      :fcn sf-te
				      :args (list step-val-te)
				      :arg-positions '(1)
				      :arg-targ-types step-type
				      :hidden false
				      :type sltype
				      :source `(!_ ,slname this-step)
				      :env env
				      :totbugs 0
				      :subexps (list sf-te step-val-te)))))))
		   (t !()))))
	  val-slots)))

;;;;(defun build-low-app (spec args f-type f-env fte undo-stack context mvartypes)
;;;;   (multiple-value-let (tel prefs arg-targs _ pathology undo-stack)
;;;;		       (args-check args spec
;;;;				   undo-stack context mvartypes)
;;;;      (let ((r-type
;;;;	       (type-must-find-feature
;;;;		   f-type 'resulttype f-env)))
;;;;	 (values (build-res-typed-exp
;;;;		    0 fte tel prefs arg-targs pathology
;;;;		    mvartypes r-type)
;;;;		 undo-stack))))
;;;;

;;; Returns < constraining, new-bindings-from-vars-field, augmented-env, 
;;;           error-flags >
;;; 'constraining' has the same meaning as for the value of 'qvar-list-parse'
(defun vars-extract-bdgs (def-items env)
  (let ((vars-field (get-field-or-empty ':vars def-items))
	(dom (find-domain-in-vartypes env)))
     (multi-let (((constraining varbdgs ill-formed-vars)
		  (qvar-list-parse vars-field env)))
	(cond ((and vars-field
		    (not (or (domain-declares-requirement
				dom ':existential-preconditions)
			     (domain-declares-requirement
				dom ':conditional-effects))))
	       (!= ill-formed-vars
		   (cons (simple-ill-formed-exp
			    !"Illegal for domain not declaring requirements ~
			    :existential-preconditions and ~
			    :conditional-effects"
			    false)
			 *-*))))
	(values constraining
		varbdgs
		(env-bindings-append true varbdgs env)
		ill-formed-vars))))

(defun bind-causation-function (fbdg fctn funtype defn)
   (cond (fbdg
	  (setf (Domain-bdg-type fbdg) funtype)
	  (setf (Domain-bdg-val fbdg)
		(make-Causation-function
		   :name fctn
		   :type funtype
		   :defn defn)))))

(defun build-field (field undo-stack context parser)
   (cond (field
	  (multi-let (((parsed-field new-undo-stack)
		       (funcall parser
			  (cadr field)
			  undo-stack
			  (context-expstack-push
			     (cadr field) (car field) context))))
	     (values (tuple (car field)
			    parsed-field)
		     new-undo-stack)))
	 (t
	  (values false undo-stack))))

;;; Returns 0, 1, or 100.
;;; 0 means no slots; 1 means 1 required slot; 100 covers all other
;;; cases.      
(defun arglistspec-size (alspec)
   (cond ((is-Arglistspec alspec)
	  (let ((tot (len (Arglistspec-argspecs alspec)))
		(nreq (len (Arglistspec-required alspec))))
	     (cond ((= nreq tot)
		    (cond ((< nreq 2) nreq)
			  (t 100)))
		   (t 100))))
	 (t
	  (signal-problem arglistspec-size
	     "Fumbled tup elt-types: " alspec))))

;; This is too simple; overlooks rebinding of the names.  See notes.txt
;; for the right thing.
(defun replace-value-vars (eff val-slots)
   (cond ((is-Qvar eff)
	  (cond ((is-Symbol (Qvar-sym eff))
		 (let ((a (find (Qvar-sym eff)
				val-slots
				:key #'Slot-name
				:test #'eq)))
		    (cond (a
			   `(!_ ,(Qvar-sym eff) (step-value this-step)))
			  (t eff))))
		(t
		 (out (:to (errout)) "Qvar with non-symbol: " eff :%)
		 eff)))
	 ((atom eff)
	  (cond ((is-Symbol eff)
		 (let ((a (find eff val-slots
				    :key #'Slot-name :test #'eq)))
		    (cond (a
			   `(!_ ,eff (step-value this-step)))
			  (t eff))))
		(t eff)))
	 (t
	  (<# (\\ (y) (replace-value-vars y val-slots))
	      eff))))

;;; This works only in contexts where a non-symbol is accepted.
(defun action-term-check (action-spec undo-stack context qvarbdgs)
   (cond ((consp action-spec)
          (multiple-value-bind (action-spec flg-junk)
                               (list-smooth action-spec
                                            #'any)
	     (multi-let (((ate undo-stack-1)
			  (clean-action-term-check
                             action-spec undo-stack context qvarbdgs)))
		(values
		   (note-bugs ate flg-junk)
		   undo-stack-1))))
	 (t
	  (values
	     (ill-formed-typed-exp action-spec action-type* qvarbdgs)
	     undo-stack))))

(defun clean-action-term-check (action-spec undo-stack context qvarbdgs)
   (term-check action-spec action-type* undo-stack context qvarbdgs))

(def-opt-form-handler effect term-checker (effterm target-type undo-stack
					   context mvartypes)
   (cond ((= (len effterm) 2)
	  (effect-parse (cadr effterm) void-type* target-type
			undo-stack context mvartypes))
	 (t
	  (values
	     (ill-formed-typed-exp effterm target-type mvartypes)
	     undo-stack))))

(defun effect-parse (e step-type target-type undo-stack context mvartypes)
   (term-check
      e target-type undo-stack
      (cons-Syn-context (tuple 'action-context 'effect)
			context)
      (make-Env true
		(cons (new-Vartype 'this-step step-type false)
		      (Env-vartypes mvartypes)))))

(def-class Action-binder-typed-exp (:options (:include Typed-exp))
   bindings  ;; vartypes
   body   ;; may be false
   (:handler
      (initialize :before (bte)
	 (slot-defaults bindings '())
	 (!= (slot subexps)
	     (list-if-not-false
		(Action-binder-typed-exp-body bte))))))

(def-meth show-header ((qte Action-binder-typed-exp))
  (out (:a (string-capitalize (Typed-exp-flag qte))) 1 
       (Action-binder-typed-exp-bindings qte)))

(def-meth flagsource ((abte Action-binder-typed-exp))
   (expect-slots (suchthat)
      `(,(nisptype::arglistspec-typed-arglist
	    (new-Arglistspec
	       (<# vartype->argspec
		   (Action-binder-typed-exp-bindings abte)))
	    '())
	,(flagsource (slot suchthat))
	,@(include-if (Action-binder-typed-exp-body abte)
	     (flagsource (Action-binder-typed-exp-body abte))))))

(def-meth show ((qte Action-binder-typed-exp))
   (out (:e (show (Action-binder-typed-exp-body qte)))
	:%))

(def-class Forsome-typed-exp (:options (:include Action-binder-typed-exp))
   suchthat
   (:handler
      (initialize :before ((tc Forsome-typed-exp))
	 (slot-defaults flag 'forsome))
      (initialize :after ((tc Forsome-typed-exp))
	 (!= (Forsome-typed-exp-subexps tc)
	     (cons (Forsome-typed-exp-suchthat tc) *-*)))))

(def-meth show ((fste Forsome-typed-exp))
   (out (:e (show (Forsome-typed-exp-suchthat fste)))
	:%))

(def-meth flagsource ((fste Forsome-typed-exp))
   `(forsome
     ,@(call-next-method fste)))

(def-opt-form-handler when term-checker
		      (exp target-type undo-stack context env)
   (match-cond exp
      ?( (when ?precond ?eff)
	(let ((eff-con (syn-context-lookup context 'action-context)))
	(multi-let (((pcte undo-stack-1)
		     (term-check
			precond prop-type* undo-stack
			(context-push-and-cons
			    precond 1
			    'action-context 'condition
			    (context-polarity-flip context))
			env)))
	   (multi-let (((whente undo-stack-2)
			(if-check-after-ante 'when pcte eff 'true target-type
					     undo-stack-1 context env)))
	      (cond ((foxlong-time-earlier
		        (earliest-foxlong-time
			   (If-typed-exp-iftrue whente))
			(latest-foxlong-time pcte))
		     (note-bugs whente
			(list (simple-ill-formed-exp
			         !"'when' antecedent refers to time after ~
                                   consequent"
				 exp)))))
	      (cond ((or (not eff-con)
			 (not (eq (cadr eff-con) 'effect)))
		       (note-bugs whente
			  (list (simple-ill-formed-exp
				   "'when' allowed only in action effect: "
				   exp)))))
	      (values whente undo-stack-2)))))
      (t
       (values
	  (ill-formed-typed-exp exp target-type env)
	  undo-stack))))

(defun latest-foxlong-time (te)
   (cond ((is-Durham-timed-typed-exp te)
	  (match-cond (Durham-timed-typed-exp-time-spec te)
	     ?( (at ?which)
	       which)
	     (t 
	      'end)))
	 ((eq (Typed-exp-type te) prop-type*)
	  (repeat :for ((sub :in (Typed-exp-subexps te))
			(latest 'start))
	     (let ((subtime (latest-foxlong-time sub)))
	        (cond ((foxlong-time-earlier latest subtime)
		       (!= latest subtime))))
	   :result latest))
	 (t false)))

(defun earliest-foxlong-time (te)
   (cond ((is-Durham-timed-typed-exp te)
	  (match-cond (Durham-timed-typed-exp-time-spec te)
	     ?( (at ?which)
	       which)
	     (t 
	      'start)))
	 ((eq (Typed-exp-type te) prop-type*)
	  (repeat :for ((sub :in (Typed-exp-subexps te))
			(earliest 'stop))
	     (let ((subtime (earliest-foxlong-time sub)))
	        (cond ((foxlong-time-earlier subtime earliest)
		       (!= earliest subtime))))
	   :result earliest))
	 (t false)))
	     
(defun foxlong-time-earlier (flt1 flt2)
   (memq flt2 (cdr (memq flt1 '(start mid stop)))))

(def-opt-form-handler forsome term-checker
                      (forsome-spec target-type undo-stack context qvarbdgs)
   (match-cond forsome-spec
      ?( (forsome ?vars ?suchthat ?act)
	(forsome-check vars suchthat act target-type
		       undo-stack context qvarbdgs))
      ?( (forsome ?vars ?act)
	(forsome-check vars false act target-type
		       undo-stack context qvarbdgs))
      (t
       (values
	  (ill-formed-typed-exp forsome-spec target-type qvarbdgs)
	  undo-stack))))

(defun forsome-check (vars suchthat act target-type
		      undo-stack context orig-qvarbdgs)
   (multi-let (((_ new-qvarbdgs defective-exps)
		(qvar-list-parse vars orig-qvarbdgs)))
      (!= context (context-expstack-push 'forsome 0 context))
      (let ((qvarbdgs (append new-qvarbdgs orig-qvarbdgs)))
	 (multi-let (((ste undo-stack-1)
		      (cond (suchthat
			     (!= context (context-expstack-advance *-*))
			     (term-check suchthat prop-type*
					 undo-stack context qvarbdgs))
			    (t
			     (values
				(build-Var-typed-exp 'true false
						     prop-type* qvarbdgs)
				undo-stack)))))
	    (!= context (context-expstack-advance *-*))
	    (multi-let (((ate undo-stack-2)
			 (term-check act target-type
				     undo-stack-1 context qvarbdgs)))
	       (values
		  (note-bugs
		     (make-inst Forsome-typed-exp
			:suchthat ste
			:body ate
			:bindings new-qvarbdgs
			:env orig-qvarbdgs
			:source `(forsome ,(var-bindings-sexp
					      new-qvarbdgs)
				    ,(Typed-exp-source ste)
				    ,(Typed-exp-source ate)))
		     defective-exps)
		  undo-stack-2))))))

(def-class Foreach-typed-exp (:options (:include Action-binder-typed-exp))
   suchthat
   (:handler
      (initialize :before ((tc Foreach-typed-exp))
	 (slot-defaults flag 'foreach))
      (initialize :after ((tc Foreach-typed-exp))
	 (!= (Foreach-typed-exp-subexps tc)
	     (cons (Foreach-typed-exp-suchthat tc) *-*)))))

(def-meth show ((fste Foreach-typed-exp))
   (out (:e (show (Foreach-typed-exp-suchthat fste)))
	:%))

(def-meth flagsource ((fste Foreach-typed-exp))
   `(forsome
     ,@(call-next-method fste)))

(def-opt-form-handler foreach term-checker
                      (foreach target-type undo-stack context qvarbdgs)
   (match-cond foreach
      ?( (foreach ?vars ?suchthat ?act)
	(multi-let (((_ new-qvarbdgs defective-exps)
		     (qvar-list-parse vars qvarbdgs)))
	   (!= qvarbdgs (append new-qvarbdgs *-*))
	   (multi-let (((gte undo-stack-1)
			(formula-typecheck suchthat
					   undo-stack qvarbdgs false)))
	      (multi-let (((ate undo-stack-2)
			   (action-term-check act
					      undo-stack-1 context qvarbdgs)))
		 (values
		    (note-bugs
	               (make-inst Foreach-typed-exp
			  :source foreach
			  :bindings new-qvarbdgs
			  :suchthat gte
			  :body ate)
		       defective-exps)
		    undo-stack-2)))))
      (t
       (ill-formed-typed-exp foreach target-type qvarbdgs))))

(def-class Link-typed-exp (:options (:include Typed-exp))
  act
  linkrels  ; (Lst (Tup Symbol Vartype))
   (:handler
      (initialize :before ((tc Link-typed-exp))
	 (slot-defaults flag 'link
			subexps (list (Link-typed-exp-act tc)))))
)

(def-meth show-header ((lte Link-typed-exp))
   (out "Link"))
   
(def-meth show ((lte Link-typed-exp))
   (out (:e (show (Link-typed-exp-act lte)))
	(:e (repeat :for ((rel :in linkrels))
	      (:o (car rel) 1 (Vartype-var (cadr rel)))))))  

(def-meth flagsource ((lte Link-typed-exp))
  `(link ,(flagsource lte)
	 ,@(<! (\\ (rel)
		  (list (car rel)
			(Vartype-var (cadr rel))))
	       linkrels)))

(def-opt-form-handler link term-checker
         (linkterm target-type undo-stack con vartypes)
   (function-unless-require :action-expansions
	      linkterm target-type undo-stack con vartypes
      (repeat :for ((l (cdr linkterm))
		    (offset 1)
		    (act-offset false)
		    act
		    :collector rel-triples)
       :until (null l)
       :result (cond (act-offset
		      (check-it))
		     (t
		      (values
			 (ill-formed-typed-exp linkterm target-type vartypes)
			 undo-stack)))
	 (cond ((is-Keyword (car l))
		(cond ((null (cdr l))
		       (note-defective-exp
			   ((_) "Extra item at end of keyword list " linkterm)
			 :place link-opt-form-handler
			 (:continue "I will ignore it"))
		       (!= l !()))
		      (t
		       (one-collect rel-triples (tuple (car l) (cadr l) offset))
		       (!= l (cddr l))
		       (!= offset (+ *-* 2)))))
	       (t
		(cond (act-offset
		       (note-defective-exp
			  ((_) "Action specified twice in " linkterm)
			  :place link-opt-form-handler
			  (:continue "I will ignore all but the first")))
		      (t
		       (!= act (car l))
		       (!= act-offset offset)))
		(!= offset (+ *-* 1))
		(!= l (cdr l))))
       :where

 (check-it ()
    (let ((existing-link-vartypes
	     (repeat :for ((rel :in (Collector-elements rel-triples))
			   keyword linkname keyword-okay
			   :collectors link-vartypes)
	      :result link-vartypes
		(!= keyword (car rel))
		(!= keyword-okay (memq keyword
				    '(:output :input :then :wait
				      :begin-then :wait-end :span)))
		(!= linkname (cadr rel))
		(cond ((and keyword-okay
			    (is-Symbol linkname))
		       (one-collect
			  link-vartypes
			  (let ((vt (var-lookup linkname vartypes)))
			    (cond (vt
				   (cond ((is-link-type (Vartype-type vt))
					  vt)
					 (t
					  (note-defective-exp
					     ((_) linkname
						  " is not the name of a link")
					     :fatal))))
				  (t
				   (note-defective-exp
				      ((_) "Unbound link name " linkname)
				      :fatal))))))
		      (t
		       (cond ((not (is-Symbol linkname))
			      (note-defective-exp
			         ((_) "Nonatomic link name: " linkname)
				 :place link-opt-form-handler
				 :fatal)))
		       (cond ((not keyword-okay)
			      (note-defective-exp ((_) "Illegal keyword in 'link' list: "
						       keyword)
				 :place link-opt-form-handler
				 :fatal))))))))
       (put-it-together (extra-vartypes existing-link-vartypes)
			(check-outputs existing-link-vartypes))))

 (extra-vartypes (existing-link-vartypes)
    (repeat :for ((rel-trip :in rel-triples)
		  (vt :in existing-link-vartypes)
		  :collectors input-vartypes)
     :when (eq (car rel-trip) ':input)
     :collect (new-Vartype (Vartype-var vt)
			   (type-find-feature
			      (Vartype-type vt)
			      'val-type
			      vartypes)
			   false)))

 (check-outputs (existing-vartypes)
       (repeat :for ((trip :in rel-triples)
		     (vt :in existing-vartypes)
		     (ustack undo-stack)
		     (ok true))
	:result ustack
	  (cond ((eq (car trip) ':output)
		 (!= < ok ustack >
		     (accept-as-equal true
				      (Vartype-type vt)
				      target-type
				      ustack
				      global-opt-env*
				      global-opt-env*
				      !()))
		 (cond ((not ok)
			(note-defective-exp
			   ((lt) "Output link " (Vartype-var vt)
				 " incompatible with target-type "
				 :% 1 target-type " in " :%
				 lt)
			   :target linkterm)))))))

 (put-it-together (input-vartypes undo-stack)
    (multi-let (((ate undo-stack-1)
		 (term-check act target-type undo-stack
			     (context-expstack-push
				linkterm act-offset con)
			     (env-bindings-append
				true input-vartypes vartypes))))
       (values
	  (make-inst Link-typed-exp
	     :act ate
	     :linkrels (<! (\\ (trip) (list (car trip) (cadr trip)))
			   rel-triples)
	     :type (Typed-exp-type ate)
	     :env input-vartypes
	     :source `(link ,(Typed-exp-source ate)
			 ,@(<! (\\ (rel vt)
				  (list (car rel)
					(Vartype-var vt)))
			       rel-triples
			       input-vartypes))
	     :subexps (list ate))
	  undo-stack-1))))))

(def-class With-links-typed-exp (:options (:include Binder-typed-exp))
   constraints
   arglistspec
  ;; (Lst (Tup which - (Con :postcondition :maintain)
   ;;           link - Vartype
   ;;           prop - Typed-exp))
   (:handler
       (initialize :before ((wlte With-links-typed-exp))
	  (slot-defaults flag 'with-links)))
)

(def-meth show-header ((wlte With-links-typed-exp))
   (out "With-links " (arglistspec-typed-arglist
		         (With-links-typed-exp-arglistspec wlte)
			 !())))

(def-meth show ((wlte With-links-typed-exp))
   (out (:i> 3)
	(:e (show (With-links-typed-exp-body wlte)))
	(:i< 3)
	(:e (repeat :for ((con :in (With-links-typed-exp-constraints wlte)))
	      (:o (car con) 1 (Vartype-var (cadr con)) :%
		  (:i> 3)
		  (:e (show (caddr con)))
		  :%)))))

(def-meth flagsource ((wlte With-links-typed-exp))
   `(with-links ,(var-bindings-flagsource
		   (With-links-typed-exp-bindings wlte))
       ,(flagsource (With-links-typed-exp-body wlte))
       ,@(<! (\\ (con)
		(list (car con)
		      (Vartype-var (cadr con))
		      (flagsource (caddr con))))
	     (With-links-typed-exp-constraints wlte))))

(def-opt-form-handler with-links term-checker
               (wlterm target-type undo-stack con mvartypes)
   (letrec ()
      (match-cond wlterm
	 ?( (with-links ?bdgs ?act ?constraints)
	   (check-it bdgs act constraints))
	 (t
	  (note-defective-exp ((wlterm) "Ill-formed: " wlterm)
	     :target wlterm
	     :place with-links-term-checker)))

      :where

 (check-it (bdgs act constraints)
    (multi-let (((alspec new-varbdgs)
		 (with-link-bdgs-parse bdgs mvartypes)))
       (let ((augenv (env-bindings-append
		        true new-varbdgs mvartypes)))
	  (multi-let (((ate undo-stack-1)
		       (term-check act target-type undo-stack
				   (context-expstack-push
				      wlterm 2 con)
				   augenv)))
	     (repeat :for ((con :in constraints)
			   (ustack undo-stack-1)
			   prop-te
			   (pos = 4 :by 2)
			   :collectors res)
	      :nconc 
		(match-cond con
		   ?( (?(\| :postcondition :maintain)
		       ?(+ ?linkname is-Symbol)
		       ?proposition)
		     (let ((vt (var-lookup linkname augenv)))
		        (cond ((and vt (is-link-type (Vartype-type vt)))
			       (!= < prop-te ustack >
				   (term-check
				      proposition
				      prop-type*
				      ustack
				      (context-expstack-push
					 wlterm pos con)
				      augenv))
			       (list (tuple (car con) vt prop-te)))
			      (t
			       (note-defective-exp
				   ((_) "Non-linkname " linkname)
				   :target wlterm
				   :place with-links-opt-term-handler
				   (:continue
				      "I'll ignore this constraint"))
			       !()))))
		   (t
		    (note-defective-exp
		        ((_) "Ill-formed constraint " con)
			:target wlterm
			:place with-links-opt-term-handler
			(:continue "I'll ignore this constraint"))
		    !()))
	      :result (put-it-together res)
	      :where

 (put-it-together (processed-constraints)
    (make-inst With-links-typed-exp
       :constraints processed-constraints
       :arglistspec alspec
       :body ate
       :bindings new-varbdgs
            ;;(vars-source-maybe-flag new-varbdgs ill-formed-vars)
       :type (Typed-exp-type ate)
       :subexps (cons ate (<# caddr processed-constraints))
       :env mvartypes
       :source `(with-links ,@(arglistspec-typed-arglist alspec '())
		   ,(Typed-exp-source ate)
		   ,@(<! (\\ (pc)
			    (list (car pc)
				  (Vartype-var (cadr pc))
				  (Typed-exp-source (caddr pc))))
			 processed-constraints)))))))))))

(defvar empty-val-type* (compile-time-designated-type (Val) opt))

(defun with-link-bdgs-parse (link-decls env)
   (multi-let (((orig-alspec _ _ synerrs)
		(params-parse link-decls true
			      empty-val-type* false false env)))
      (let ((link-alspec
	       (new-Arglistspec
		  (<# (\\ (as)
			 (make-Argspec
			    (Argspec-name as)
			    (Argspec-mode as)
			    (nisptype::Argspec-position as)
			    (make-link-type (Argspec-type as) env)
			    false
			    (<# list-copy (nisptype::Argspec-props as))))
		      (Arglistspec-argspecs orig-alspec)))))
	 (repeat :for ((err :in synerrs))
	    (defective-exp-notify
	       (make-Defective-exp
		  :has-target false
		  :target false
		  :observation (\\ (_ srm)
				  (synerr-out err srm))
		  :signaler (\\ (this-exp)
			       (signal-problem :place with-link-bdgs-parse
				  "Syntactic error in 'with-links'["
				  " vars list: " this-exp
				  (:continue "I'll ignore it"))))
	       true))
	 (values orig-alspec
		 (arglistspec->vartypes link-alspec)
))))

;; ff is either false or of the form (:fieldname typed-exp).
(defun maybe-include-field (ff)
   (cond (ff
;;;;	  (dbg-save :run-loud ff)
;;;;	  (breakpoint maybe-include-field
;;;;	     "About to include " ff)
	  `(,(car ff) ,(flagsource (cadr ff))))
	 (t '())))

(defun qvarbdgs-constraints (qvarbdgs env)
   (mapcan #'(lambda (v)
	        (let ((type (Vartype-type v)))
		   (let ((p (type-predify
				   type
			           (make-Qvar (Vartype-var v) '())
				   env)))
		     (cond ((matchq (is Obj ?_) p)
			    '())
			   (t
			    (list p))))))
	   qvarbdgs))

; Change type into predicate
(defun type-predify (n x vartypes)
   (multiple-value-let (fcn found)
		       (type-find-feature n 'predifier vartypes)
      (cond (found
	     (funcall fcn n x vartypes))
	    ((eq n univ-type*)
	     `(is Obj ,x))
	    ((is-Symbol (Type-desig n))
	     `(is ,(Type-desig n) ,x))
	    (t
	     `(is Obj ,x)))))

(defun context-push-and-cons (exp k prop val context)
   (cons-Syn-context (tuple prop val)
		     (context-expstack-push exp k context)))

