;-*- Mode: Common-lisp; Package: lisplang; Readtable: ytools; -*-
(in-package :lisplang)
;;; $Id: builtin.lisp,v 1.9 2005/07/05 13:35:53 dvm Exp $

(depends-on %module/ ytools nity %ytools/ nilscompat)

(depends-on :at-compile-time %nity/ deftyp desig altformer feature
	                           funacceptors funformers tloader)

(depends-on :at-run-time %nity/ trecycle tuptypes funtypes dottypes contype)

(end-header :continue-slurping)

(eval-when (:compile-toplevel :load-toplevel :execute :slurp-toplevel)
   (export '(Number Float Rational Integer Ratio Char Symbol String
	     Sexp Opaque
	     opaque-type* boolean-type*  
	     num-type* float-type* rational-type* int-type* ratio-type*
	     symbol-type* string-type* char-type* obj-list-type*)))

(in-type-system universal)

(def-type Number (Clump :subtype Obj
		     (is is-Number)
		     (= =)
		     (:feature cltype :value 'number)
		     (:feature initexp 0)))

(def-type Float (Clump :subtype Number
		   (is is-Float)
		   (:feature cltype :value 'single-float)
		   (:feature initexp 0.0)))

(def-type Rational (Clump :subtype Number
		       (is is-Rational)
		       (:feature cltype :value 'rational)
		       (:feature initexp 0)))

(def-type Integer (Clump :subtype Rational
		     (is is-Integer)
		     (:feature cltype :value 'integer)
		     (:feature initexp 0)))

(def-type Ratio (Clump :subtype Rational
		   (is is-Ratio)
		   (:feature cltype :value 'ratio)
		   (:feature initexp 0)))

(def-type Char (Clump :subtype Obj
		  (is is-Char)
		  (= char=)
		  (:feature cltype :value 'standard-char)
		  (:feature initexp :value ''#\0)))

(def-type Symbol (Clump :subtype Obj
		   (is is-CSymbol)
		   (= eq)
		   (:feature cltype :value 'symbol)
		   (:feature initexp :value ''nil)))


(def-type String (Clump :subtype Obj
		     (is is-String)
		     (= equal)
		     (:feature cltype :value 'simple-string)
		     (:feature initexp :value ''"")))

(def-type Sexp (Alt Symbol String Char Number (Lst Sexp)))

;; Type of things that shouldn't be type-checked at all.
(def-type Opaque (:system :universal) (Clump :subtype Obj))

(defparameter opaque-type*
   (globally-defined-type 'Opaque universal-type-sys* true))
(defparameter num-type*
   (globally-defined-type 'Number universal-type-sys* true))
(defparameter float-type*
   (globally-defined-type 'Float universal-type-sys* true))
(defparameter rational-type*
   (globally-defined-type 'Rational universal-type-sys* true))
(defparameter int-type*
   (globally-defined-type 'Integer universal-type-sys* true))
(defparameter ratio-type*
   (globally-defined-type 'Ratio universal-type-sys* true))
(defparameter boolean-type*
   (globally-defined-type 'Boolean universal-type-sys* true))
(defparameter string-type*
   (globally-defined-type 'String universal-type-sys* true))
(defparameter symbol-type*
   (globally-defined-type 'Symbol universal-type-sys* true))
(defparameter char-type*
   (globally-defined-type 'Char universal-type-sys* true))


(def-meth const-type ((c string)) string-type*)
(def-meth const-type ((c symbol)) symbol-type*)
(def-meth const-type ((c integer)) int-type*)
(def-meth const-type ((c ratio)) ratio-type*)
(def-meth const-type ((c float)) float-type*)
(def-meth const-type ((c character)) char-type*)

(defparameter obj-list-type*
   (designated-type '(Lst Obj) true global-env*))

