;-*- Mode: Common-lisp; Package: lisplang; Readtable: ytools; -*-
(in-package :lisplang)
;;; $Id: bvarparse.lisp,v 1.18 2005/11/02 16:41:32 dvm Exp $

(depends-on %module/ ytools nity %ytools/ nilscompat)

(depends-on :at-run-time %nity/ desig)  ;;;;  %langutils/ namespace

(needed-by-macros
   (export '(bvar-list-parse vartypes-bvar-list +no-val-specified+
	     types-separate
	     vartypes-declare-placeholder-params vartypes-typed-arglist)))

(defvar +no-val-specified+ ;;;; "No-val-specified"
        (make-Printable
           (\\ (srm)
              (out (:to srm)
                   "<No value specified>"))))

;;; Returns < vartypes freevars >
;;; 'is-var' is predicate that determines what counts as a legal var.
;;; false means only symbols allowed.
(defun bvar-list-parse (args is-var allow-inits default-type vartypes)
   (cond ((not is-var)
	  (!= is-var #'is-Symbol)))
   (let ((to-be-typed '())
	 (freevars '())
	 (bound-vartypes '()))
      (let-fun ((:def fill-in-types (ty)
		  (repeat :for ((prev :in to-be-typed)
			       (ie (and allow-inits
					(not (eq ty ':tvar))
					(type-find-feature
					   ty 'initexp vartypes))))
		     (cond ((eq ty ':tvar)
			    (let ((new-tvar (create-tvar-for-bvar
					       (Vartype-var prev))))
			       (!= (Vartype-type prev) new-tvar)))
			   (t
			    (!= (Vartype-type prev) ty)
			    (cond ((and ie
					(not (Vartype-initial prev)))
				   (!= (Vartype-initial prev) ie))))))
		  (!= to-be-typed '())))
	 (repeat :for ((al args) a)
	  :until (null al)
	    (!= a (car al))
	    (cond ((eq a '-)
		   (cond ((null (cdr al))
			  (!= al '())
			  (note-defective-exp
			     ((_) "Hyphen at end of bvar list: " args)
			     :place bvar-list-parse
			     (:novalue "I will ignore it")))
			 (t
			  (let ((td (cadr al)))
			     (!= al (cddr al))
			     (cond ((eq td '*)
				    (fill-in-types default-type))
				   ((is-type-desig td vartypes)
				    (let ((ty (designated-type td
							       false
							       vartypes)))
				       (!= freevars (append (Type-freevars ty)
							    *-*))
				       (fill-in-types ty)))
				   (t
				    (note-defective-exp
				        ((_) "Meaningless type designator: " td)
					:place bvar-list-parse
				        :fatal)))))))
		  ((memq a '(:-. :.))
		   (!= al (cdr al))
		   (fill-in-types default-type))
		  (t
		   (multi-let (((var init)
				(cond ((atom a)
				       (values a +no-val-specified+))
				      (t
				       (values (car a) (cadr a))))))
		      (!= al (cdr al))
		      (cond ((funcall is-var var)
			     (let ((new-vt (new-Vartype var '*notype init)))
				(cond ((and (not (eq init +no-val-specified+))
					    (not allow-inits))
				       (!= init +no-val-specified+)
				       (note-defective-exp
					   ((_)
					    "Initial value not allowed: " a)
					   :target new-vt
					   :place bvar-list-parse
					   (:novalue "I will ignore it"))
				       (!= (Vartype-val new-vt) init)))
				(push new-vt to-be-typed)
				(!= bound-vartypes
				    (cons new-vt *-*))))
			    (t
			     (note-defective-exp
			        ((_) "Illegal in bound-variable list: " a)
				:place bvar-list-parse
				(:novalue "I will ignore it")))))))
	  :result (progn (fill-in-types default-type)
			(values (dreverse bound-vartypes)
				freevars))))))
		      
(defun vartypes-bvar-list (vartypes)
   (letrec ((extrude (vtl)
	       (cond ((null vtl)
		      (values '() 'Obj))
		     (t
		      (let ((vt (car vtl)))
			 (let ((var (Vartype-var vt))
			       (vtydesig (type-find-designator
					    (Vartype-type vt)
					    '()))
			       (vv (Vartype-initial vt)))
			    (multi-let (((r rtydesig)
					 (extrude (cdr vtl))))
			       (values
				  `(,(cond ((and vv (not (eq vv +no-val-specified+)))
					    `(,var ,vv))
					   (t var))
				    ,@(cond ((equal vtydesig rtydesig)
					     '())
					    (t `(- ,vtydesig)))
				    ,@r)
				  vtydesig))))))))
      (extrude vartypes)))

(defun types-separate (args default-type vartypes)
   (let ((args-n-types '())
	 (to-be-typed '())
	 (freevars '())
	 (posl !()))
      (letrec ((fill-in-types (ty)
		  (repeat :for ((prev :in to-be-typed))
		     (!= (cadr prev)
			 (cond ((eq ty ':tvar)
				(unknown-tvar-type)))))
		  (!= to-be-typed '())))
	 (repeat :for ((al args) a (pos 0))
	  :until (null al)
	    (!= a (car al))
	    (cond ((eq a '-)
		   (cond ((cdr al)
			  (let ((td (cadr al)))
			     (!= al (cddr al))
			     (!= pos (+ *-* 2))
			     (cond ((eq td '*)
				    (fill-in-types default-type))
				   ((is-type-desig td vartypes)
				    (let ((ty (designated-type td
							       false
							       vartypes)))
				       (!= freevars (append (Type-freevars ty)
							    *-*))
				       (fill-in-types ty)))
				   (t
				    (note-defective-exp
				        ((_) "Meaningless type designator: " td)
					:place bvar-list-parse
				        :fatal)))))
			 (t
			  (!= al '())
			  (note-defective-exp
			     ((_) "Hyphen at end of bvar list: " args)
			     :place bvar-list-parse
			     (:novalue "I will ignore it")))))
		  (t
		   (let ((p (lrecord (car a) '*to-be-typed)))
		      (!= args-n-types (cons p *-*))
		      (!= to-be-typed (cons p *-*)))
		   (!= posl (cons pos *-*))
		   (!= al (cdr al))
		   (!= pos (+ *-* 1))))
	  :result (progn (fill-in-types default-type)
			(!= args-n-types (dreverse *-*))
			(values (<# car args-n-types)
				(<# cadr args-n-types)
				freevars
				posl))))))

(defun vartypes-declare-placeholder-params (high-bdgs env)
   (env-bindings-nconc
       true
       (<# (\\ (vt)
	      (let ((k (nity::type-find-kind (Vartype-type vt) env)))
		 (new-Vartype
		    (Vartype-var vt)  
		    k
		    (unknown-type-for-param
			(Vartype-var vt)
			k
			(Vartype-type vt)
			false))))
	   high-bdgs)
       env))
       
(defun vartypes-typed-arglist (vtl)
   (arglistspec-typed-arglist
      (new-Arglistspec
         (<# (\\ (vt) (new-Argspec (Vartype-var vt)
				   ':required
				   (Vartype-type vt)))
	     vtl))))