;-*- Mode: Common-lisp; Package: lisplang; Readtable: ytools; -*-
(in-package :lisplang)
;;; $Id: flagsource.lisp,v 1.9 2005/07/01 13:47:05 dvm Exp $

(depends-on %module/ ytools nity %ytools/ nilscompat)

(depends-on :at-run-time %lisplang/ typecheck %nity/ typebounds)

(needed-by-macros
   (export '(flagsource flag-count*
	     app-typed-exp-args-flagsource
	     vartype->argspec)))

(def-op flagsource (te)
  (dbg-save :run-loud te)
;;;;  (breakpoint flagsource
;;;;     "Oops: " te)
  `("Don't know how to apply 'flagsource' to " ,te))

(def-meth flagsource ((te Typed-exp))
   (Typed-exp-source te))

(def-meth flagsource :around ((te Typed-exp))
   (letrec ()
      (let ((exp (call-next-method te)))
	 (let ((bugs (Typed-exp-bugs te)))
	    (cond ((null bugs) exp)
		  (t
		   (new-Flagged-subexpression
		      exp
		      (<# (\\ (bug)
			     (cond ((eq (Defective-exp-target bug)
					te)
				    (make-Defective-exp
				       :target exp
				       :observation
				          (Defective-exp-observation bug)
				       :context
				          (Defective-exp-context bug)))
				   (t bug)))
			  bugs))))))))

(def-meth flagsource ((vte Var-typed-exp))
   (cond ((Var-typed-exp-qvar vte)
	  (make-Qvar (Var-typed-exp-var vte) '()))
	(t (Var-typed-exp-var vte))))

(def-meth flagsource ((cte Const-typed-exp))
   (cond ((is-symbolish (Const-typed-exp-source cte))
	  (Const-typed-exp-source cte))
	 (t
	  (Const-typed-exp-val cte))))

(def-meth flagsource ((ate App-typed-exp))
   (let ((fcn-te (App-typed-exp-fcn ate)))
      (let ((res 
	      (cond ((and (App-typed-exp-hidden ate)
			  (or (is-Var-typed-exp fcn-te)
			      (is-Const-typed-exp fcn-te)))
		     (flagsource fcn-te))
		    (t
		     `(,@(include-if (> (App-typed-exp-level ate) 0) '!&)
		       ,(flagsource fcn-te)
		       ,@(app-typed-exp-args-flagsource ate))))))
;;;;	 (cond ((not (null (Typed-exp-bugs ate)))
;;;;		(dbg-save :run-loud ate res)
;;;;		(breakpoint flagsource/App
;;;;		   "res = " res)))
	 res)))

(defun app-typed-exp-args-flagsource (ate)
   (letrec ((flag-em (prefs args)
	       (cond ((null args) '())
		     ((null prefs)
		      (<# flagsource args))
		     (t
		      (let ((a (flagsource (car args)))
			    (pref (car prefs))
			    (remainder (flag-em (cdr prefs)
						(cdr args))))
			 (cond ((matchq ?(:\| ?(:+ ?_ is-Number)
					     (?(:+ ?_ is-Number)))
					pref)
				(cons a remainder))
			       (t
				(cons pref (cons a remainder)))))))))
      (flag-em (App-typed-exp-arg-positions ate)
	       (App-typed-exp-args ate))))

;;;;   (<! (\\ (pref a)
;;;;	  (let ((a (flagsource a)))
;;;;	     (cond ((or (not pref) (is-number pref))
;;;;		    (list a))
;;;;		   ((let (n) (and (matchq (?n) pref)
;;;;				  (is-number n)))
;;;;		    (cond ((is-app-with-fcn a 'list)
;;;;			   (list-copy
;;;;			      (App-typed-exp-args a)))
;;;;			  (t
;;;;			   (list a))))
;;;;		   ((atom pref)
;;;;		    (list pref a))
;;;;		   (t
;;;;		    (append pref (list a))))))
;;;;       (App-typed-exp-arg-positions ate)
;;;;       (App-typed-exp-args ate))

(def-meth flagsource ((tte Type-typed-exp))
   (Type-desig (Type-typed-exp-which tte)))

(def-meth flagsource ((fte Lambda-typed-exp))
   `(,(Lambda-typed-exp-head fte)
     ,@(include-if (> (Lambda-typed-exp-level fte) 0)
		   (Lambda-typed-exp-level fte))
     ,(arglistspec-arglist (Lambda-typed-exp-params fte) true)
     ,@(include-if (Lambda-typed-exp-side-effects fte)
		   (Lambda-typed-exp-side-effects fte))
     ,(flagsource (Lambda-typed-exp-body fte))))

(def-meth flagsource ((ute Unchecked-typed-exp))
   (Unchecked-typed-exp-source ute))

(defun vartype->argspec (vt)
   (make-Argspec (Vartype-var vt) ':required 0 (Vartype-type vt)
		 false '()))

(defun is-app-with-fcn (te fcn)
   (and (is-App-typed-exp te)
	(is-Var-typed-exp (App-typed-exp-fcn te))
	(eq (Var-typed-exp-var (App-typed-exp-fcn te))
	    fcn)))
