;-*- Mode: Common-lisp; Package: lisplang; Readtable: ytools; -*-
(in-package :lisplang)
;;; $Id: funcheck.lisp,v 1.14 2006/03/14 15:55:13 dvm Exp $

;;; Type checking of function constructors and binders.

(depends-on :at-run-time %lisplang/ typecheck funsyn)

(end-header :continue-slurping)

(eval-when (:compile-toplevel :load-toplevel :execute :slurp-toplevel)
   (export '(fundefs-types elim-tvars elim-unks ;;;; function-list-parse
	     fundef-rec-high-funtype fundef-rec-low-funtype fundef-rec-body-env
	     fundef-rec-set-funtype recursive-funtypes-vartypes
	     lambda-term-check lambda-arg-finish funtype-lambda-exp
	     fdrs-tvars-elim high-bdgs-elim-unks
	     ;;;;fundef-rec-low-result-symbols-place
	     )))

;;; In arg position, we postpone the check until later, to give the
;;; tvars time to blend properly.
(defun lambda-term-check (term target-type undo-stack context mvartypes)
   (let ((fdr (fundef->fundef-rec term !() false !() true false mvartypes))
	 (initial-tvar-scope scope-time*)
	 ;; In a Lisp-1, this will always be false, because there's no
	 ;; thing as "x position," in a sense.
	 (functional-position
	    (let ((e (syn-context-lookup context 'arg-vs-fcn)))
	       (and e (not (cadr e))))))
     (cond (functional-position
	    ;; For processing innards of the lambda, we switch back to
	    ;; argument position
	    (!= context (cons-Syn-context (tuple 'arg-vs-fcn true)
					  *-*))))
;;;;     (fundef-rec-low-result-symbols-place fdr mvartypes)
     (multi-let (((funtype _ undo-stack-1)
		  (cond ((> (Fundef-rec-level fdr) 0)
			 (fundef-rec-high-funtype
			     fdr #'identity true
			     undo-stack context mvartypes))
			(t
			 (fundef-rec-low-funtype
			     fdr #'identity false
			     undo-stack context mvartypes)))))
	 (let ((lte (funtype-lambda-typed-exp
		       funtype '() '\\
		       false (Exp-with-rel-exp (Fundef-rec-defn fdr))
		       false fdr initial-tvar-scope mvartypes)))
	    (cond (functional-position
		   (let ((estack (context-find-expstack context false)))
		      (lambda-arg-finish
			  lte
			  (car (Expstack-relations estack))
			  (cons-Syn-context (tuple ':stack (cdr estack))
					    context)
			  undo-stack-1)))
		  (t
		   (!= (Typed-exp-postponed lte) #'lambda-arg-finish)
		   (Typed-exp-set-scope-times
		      lte
		      initial-tvar-scope scope-time*)
		   (type-trans
		      lte target-type undo-stack-1 context)))))))

(!= (alref arg-term-handler-tab* '\\) !'lambda-term-check)

(defun lambda-arg-finish (lte pref super-context ustack)
   (let ((context (context-expstack-push
		     (Typed-exp-source lte)
		     pref super-context)))
      (let ((e (syn-context-lookup context 'arg-vs-fcn)))
	 (cond ((and e (not (cadr e)))
		(!= context
		    (cons-Syn-context (tuple 'arg-vs-fcn true)
				      *-*)))))
      (multi-let (((lfuntype lfunenv)
		   (follow-var-ref (Typed-exp-type lte) global-env*)))
	 (let ((lev (type-find-feature lfuntype 'level lfunenv)))
	    (cond ((= lev 0)
		   (multi-let (((bod-te ustack)
				(term-check
				   (Lambda-typed-exp-body lte)
				   (type-find-feature
				      lfuntype 'resulttype lfunenv)
				   ustack
				   (context-expstack-push
				      (Lambda-typed-exp-body lte)
				      (Exp-with-rel-rel
					  (Fundef-rec-defn
					     (Lambda-typed-exp-fundef-rec lte)))
				      context)
				   (funtype-args-env lfuntype lfunenv))))
		      (!= (Lambda-typed-exp-body lte)
			  bod-te)
		      (!= (Lambda-typed-exp-postponed lte)
			  false)
		      ustack))
		  (t
		   (high-lambda-finish
			  lte lfuntype lfunenv
			  ustack context)))))))

(defun high-lambda-finish (lambda-te lfuntype lfunenv undo-stack context)
   (let ((inner-env (funtype-args-env lfuntype lfunenv)))
      (let ((bod-fun-type
	       (type-find-feature lfuntype 'resulttype lfunenv)))
	 (let ((bod-env (funtype-args-env bod-fun-type inner-env)))
            (multi-let (((bod-te undo-stack-1)
			 (term-check
			    (Lambda-typed-exp-body lambda-te)
			    (type-find-feature bod-fun-type
					       'resulttype inner-env)
			    undo-stack
			    (context-expstack-push
			       (Lambda-typed-exp-body lambda-te)
			       (Exp-with-rel-rel
				  (Fundef-rec-defn
				     (Lambda-typed-exp-fundef-rec lambda-te)))
			       context)
			    bod-env)))
	       (!= (Lambda-typed-exp-body lambda-te)
		   (funtype-lambda-typed-exp
		      lfuntype '() '\\ bod-te false false false
		      (first (Typed-exp-scope-time-interval lambda-te))
		      inner-env))
	       (!= (Lambda-typed-exp-postponed lambda-te)
		   false)
	       undo-stack-1)))))

;;; One of 'body' and 'body-ext' is false, depending on whether
;;; we're storing a Typed-exp or source in the :body field.
(defun funtype-lambda-typed-exp (funtype definer head body body-ext sideff
				 fdr pre-scope-time env)
   (let ((fun-lev
	    (or (type-find-feature
		   funtype 'nity::level env)
		0))
	 (params (funtype-extract-arglist funtype env)))
      (make-inst Lambda-typed-exp
	 :head head
	 :type funtype
	 :env env
	 :level fun-lev
	 :params params
	 :side-effects sideff
	 :fundef-rec fdr
	 :bindings (argspecs-declare
		       params #'identity env)
	 :body (or body body-ext)
	 :source (Fundef-rec-source fdr)
	 :ext `(,@definer ,head - ,(type-find-designator
				     (type-must-find-feature
					funtype 'resulttype env)
				     env)
			 ,(arglistspec-typed-arglist params)
			 ,(or body-ext (Typed-exp-ext body)))
	 :scope-time-interval (tuple pre-scope-time scope-time*)
	 :subexps (cond (body (cons body (arglistspec-defaults params)))
			(t (arglistspec-defaults params))))))

(defun funtype-args-env (funtype vartypes)
   (env-bindings-nconc true
		       (argspecs-placeholder-params
			  (funtype-extract-arglist funtype vartypes)
			  vartypes)
		       vartypes))

(defun lambda-te-source (bod-te funtype env)
   `(\\ - ,(let ((rlspec (type-find-feature funtype 'reslist env)))
	      (cond (rlspec
		     (arglistspec-typed-arglist rlspec))
		    (t
		     (type-find-designator
			(type-find-feature funtype 'resulttype env)
			env))))
	,(arglistspec-typed-arglist
	    (type-find-feature funtype 'arglist env))
	,(Typed-exp-source bod-te)))

;;; Functions for parsing labels-style function-definition lists.


;;; We split function handling into three phases:
;;; 1. Calculate type of function (fundefs-types)
;;; 2. Parse body 
;;; 3. Clean up type, eliminating all tvars and unks. 
;;; The three phases work somewhat differently depending on the function
;;; definer, and what's legal in various Lisp-like dialects.



;;; Returns < fundef-recs, tifel, new-tvars, undo-stack >,
;;; where tifel is a list of ill-formed
;;; expressions that can't be associated with a particular fundef.
;;; If 'restype' is non-false, it's the default resulttype for all the functions.
;;; 'res-type-wrapper' is 'false' if explicit result types are not allowed
;;;    ('restype' is the *only* allowed resulttype)
;;; Otherwise, it's a function that is applied to any explicitly provided
;;; result type to get the actual result type; #'identity if no change.
;;; 'expect-flags' is for use in declaring predicates, where strange
;;; flags can occur in the midst of the function arguments; it's
;;; '()' in all other contexts.
;;; tvars-if-unspec means that if result types or arg types are absent
;;; they should be filled in with fresh tvars.
(defun fundefs-types (defs expect-flags long-body-wrapper res-type-wrapper
		      tvars-if-unspec restype
		      undo-stack context mvartypes)
   (multi-let (((fundef-recs trailing-ill-formed-exps)
		(function-list-decompose
		   defs expect-flags long-body-wrapper
		   (not (not res-type-wrapper))
		   mvartypes)))
      ;; Take care of res-types at the top level.
      (repeat :for ((x :in fundef-recs)
		    (to-be-typed !())
		    :collectors real-fundef-recs)
;;;;	 (out "x = " x :%)
	 (cond ((is-Fundef-rec x)
		(cond ((eq (Fundef-rec-low-result x) ':absent)
		       (!= to-be-typed (cons x *-*)))
		      (t
;;;;		       (!= (Fundef-rec-low-result x)
;;;;			   (exp-env-symbols-place *-* mvartypes))
		       (!= to-be-typed !()))))
	       (t
		;; It's a result type for all the untyped ones so far
		;; (Therefore 'res-type-wrapper' must be nonfalse.)
;;;;		(!= x (exp-env-symbols-place *-* mvartypes))
		(multi-let (((rty _ _)
			     ;; Note that we can't use any high-order
			     ;; (type) variables in this case.
			     (function-row-type
				false x 0 false univ-type* mvartypes)))
		   (!= rty (funcall res-type-wrapper rty mvartypes))
		   (fill-in-types rty))))
       :when (is-Fundef-rec x)
       :collect x
       :result 
	 (repeat :for ((fdr :in real-fundef-recs)
		       (ustack undo-stack) tvl
		       :collector new-tvars)
	    (cond ((eq (Fundef-rec-low-result fdr)
		       ':absent)
		   (!= (Fundef-rec-low-result fdr) restype))
		  (t))
	    (!= < tvl ustack >
		(fundef-rec-set-funtype fdr res-type-wrapper tvars-if-unspec
					ustack
					(context-expstack-push
					   (Fundef-rec-source fdr)
					   (Fundef-rec-context fdr)
					   context)
					mvartypes))
	  :append (:into new-tvars tvl)
	  :result
	    (progn
	       (values real-fundef-recs trailing-ill-formed-exps
		       new-tvars ustack)))

       :where

          (:def fill-in-types (ty)
	    (repeat :for ((prev :in to-be-typed))
	       (cond ((or (not (Fundef-rec-low-result prev))
			  (eq (Fundef-rec-low-result prev) ':absent))
;;;;		      (out "low-result = " ty
;;;;			   :% "in " prev :%)
		      (!= (Fundef-rec-low-result prev)
			  ty))))
	    (!= to-be-typed !())))))

(defun fundef-rec-set-funtype (fdr res-type-wrapper tvars-if-unspec
			       undo-stack context mvartypes)
	    (collecting-defective-exps
		   (td-ife-list ftype new-tvars undo-stack-1)
		   (cond ((Fundef-rec-is-high fdr)
			  (fundef-rec-high-funtype fdr res-type-wrapper
						   tvars-if-unspec
						   undo-stack
						   context
						   mvartypes))
			 (t
			  (fundef-rec-low-funtype
			      fdr res-type-wrapper tvars-if-unspec
			      undo-stack context mvartypes)))
	       (!= (Fundef-rec-funtype fdr) ftype)
	       (!= (Fundef-rec-ill-formed-subexps fdr)
		   (append td-ife-list *-*))
	       (values new-tvars undo-stack-1)))

(defun fundef-rec-high-funtype (rec res-type-wrapper
				tvars-if-unspec undo-stack context mvartypes)
   (multi-let (((high-alspec synerrs)
		(high-funargs-argspecs
		   (Exp-with-rel-exp (Fundef-rec-high-args rec))
;;;;		   (high-parms-symbols-place 
;;;;		      (Exp-with-rel-exp (Fundef-rec-high-args rec))
;;;;		      mvartypes)
		   mvartypes)))
      (cond ((not (null synerrs))
	     (note-defective-exp
		((_) "Syntax errors in function parameters "
		 (Exp-with-rel-exp (Fundef-rec-high-args rec)))
		:place fundef-rec-high-funtype
		(:novalue "I will try to ignore them"))))
      (!= (Fundef-rec-high-arg-bdgs rec)
	  (argspecs-placeholder-params high-alspec mvartypes))
      (let ((high-argtype (arglistspec-argtype
			     high-alspec mvartypes))
	    (desig-env (env-bindings-append
			  false
			  (Fundef-rec-high-arg-bdgs rec)
			  mvartypes)))
	 (multi-let (((low-ftype new-tvars undo-stack-1)
		      (fundef-rec-low-funtype
			  rec res-type-wrapper
			  tvars-if-unspec undo-stack context desig-env)))
	    (!= (Fundef-rec-high-args rec) high-argtype)
	    (!= (Fundef-rec-res-funtype rec) low-ftype)
	       (values
		  (make-funtype
		     1
		     low-ftype high-argtype
		     (args->spec (list low-ftype))
		     high-alspec
		     false mvartypes)
		  new-tvars
		  undo-stack-1)))))

(defun fundef-rec-low-funtype (rec res-type-wrapper
			       tvars-if-unspec undo-stack context env)
;;;;   (cond ((not (eq (Fundef-rec-low-result rec)
;;;;		   ':absent))
;;;;	  (fundef-rec-low-result-symbols-place rec env)))
   (let ((default-type
	    (cond (tvars-if-unspec ':tvar)
		  (t univ-type*))))
      (multi-let (((low-argtype low-alspec arg-tvars)
		   (designated-argtype
		      (Exp-with-rel-exp (Fundef-rec-low-args rec))
		      0 true default-type
		      env))
		  ((has-low-result low-result)
		   (let ((res (Fundef-rec-low-result rec)))
		      (cond ((eq res ':absent)
			     (values false nil))
			    (t
			     (values true
				     (cond ((is-Type res) res)
					   ((is-Exp-with-rel res)
					    (Exp-with-rel-exp res))
					   (t res))))))))
	 (multi-let (((low-restype low-rlspec res-tvars)
		      (cond (has-low-result
			     (cond ((is-Type low-result)
				    (values low-result
					    (type-arglistspec low-result env)
					    !()))
				   (t
				    (function-row-type
				       false low-result 0 false default-type env))))
			    (t
			     (unspec-low-restype tvars-if-unspec rec)))))
	    (cond (res-type-wrapper
;;;;                   (cond ((eq (Fundef-rec-name rec) 'opt::collect-value)
;;;;                          (dbg-save env res-type-wrapper low-restype)
;;;;                          (breakpoint fundef-rec-low-funtype
;;;;                             "Ready to wrap: " low-restype)))
		   (!= low-restype (funcall res-type-wrapper *-* env))
		   (!= (type-feature low-restype 'wrapped-reslist)
		       (cond (low-rlspec
			      (nity::closure-or-closable
				 low-rlspec env 'nity::arglistspec-close
				 (nity::arglistspec-freevars low-rlspec)))
			     (t ':undeclared)))
		   (!= low-rlspec (args->spec (list low-restype)))))
	    (let ((undo-stack-1
		      (defaults-check low-alspec
				      (Exp-with-rel-rel (Fundef-rec-low-args rec))
				      undo-stack context env)))
	       (!= (Fundef-rec-low-args rec)
		   (nity::make-tup-type 'Arg low-alspec false env))
	       (!= (Fundef-rec-low-result rec) low-restype)
;;;;		   (nity::make-tup-type 'Val low-rlspec false env)
	       (values
		  (make-funtype 0 low-restype low-argtype
				low-rlspec low-alspec
				false
				env
;;;;				(cond (in-high no-env*) (t env))
				)
		  (append res-tvars arg-tvars)
		  undo-stack-1))))))

;;;;(defun fundef-rec-low-result-symbols-place (fdr env) 
;;;;   (let ((low-res (Fundef-rec-low-result fdr)))
;;;;      (cond ((and (not (eq low-res '*absent))
;;;;		  (not (is-Type low-res)))
;;;;	     (!= (Fundef-rec-low-result fdr)
;;;;		 (make-Exp-with-rel
;;;;		    (Exp-with-rel-rel low-res)
;;;;		    (exp-env-symbols-place (Exp-with-rel-exp low-res)
;;;;					   env)))))))

(defun defaults-check (specs rel undo-stack context svartypes)
      (!= context
	  (context-expstack-push (arglistspec-typed-arglist specs)
				 rel
				 *-*))
      (repeat :for ((spec :in (Arglistspec-argspecs specs))
		    (ustack undo-stack))
	 (cond ((not (memq (Argspec-mode spec) '(:required :rest)))
		(collecting-defective-exps (deflist def-te undo-stack-1)
					   (term-check
					      (Argspec-default spec)
					      (Argspec-type spec)
					      undo-stack
					      (context-expstack-push
						 (Argspec-default spec)
						 (argspec-default-piece-noter spec)
						 context)
					      svartypes)
		  (:if-aborted
		      :restart-report (lambda (srm)
					  (out (:to srm)
					     "I will give up on checking default"
					     " for argument " (Argspec-name spec)))
		      (!= (Argspec-default spec)
			  (note-bugs (ill-formed-typed-exp
				        *-* (Argspec-type spec)
					svartypes)
				     deflist)))
		  ;; By wrapping it thus we prevent it being taken for
		  ;; actual unchecked code later.
		  (!= (Argspec-default spec)
		      def-te)
		  (!= svartypes
		      (env-cons (argspec-vartype spec)
				*-*))
		  (!= ustack undo-stack-1))))
	 (cond ((Argspec-supplied-param spec)
		(!= svartypes
		    (cons (new-Vartype (Argspec-supplied-param spec)
				       bool-type*
				       nil)
			  *-*))))
       :result ustack))

(defun arglistspec-defaults (alspec)
   (repeat :for ((as :in (Arglistspec-argspecs alspec)))
    :when (Argspec-default as)
    :collect (Argspec-default as)))

(defun unspec-low-restype (tvars-if-unspec fun-name)
   (let ((res-tvar
	    (cond (tvars-if-unspec
		   (anon-tvar 'res false type-type*))
		  (t false))))
      (cond (res-tvar
	     (dbg-out binding-dbg*
		"Creating tvar ?"
		(tvar-type-varname res-tvar)
		" as result type of "
		(:q (fun-name fun-name) (t "anonymous \\\\"))
		:%)))
      (let ((low-restype
	       (or res-tvar univ-type*)))
;;;;	 (!= (Fundef-rec-low-result rec)
;;;;	     low-restype)
	 (values low-restype false (cond (res-tvar (list res-tvar))
					 (t '()))))))

(defun fundef-rec-body-env (fdr env)
   (let ((env (env-bindings-append
	          true
		  (Fundef-rec-high-arg-bdgs fdr)
		  env)))
      (let ((arglist (type-arglistspec (Fundef-rec-low-args fdr)
				       env)))
	 (cond (arglist
		(env-bindings-append true (arglistspec->vartypes arglist) env))
	       (t
		env)))))

;;; Returns < rem-tvar-lists, undo-stack >
(defun fdrs-tvars-elim (fdrlist body-envs pre-scope-time ustack)
       (let (arg-rem-tvar-lists
	     res-rem-tvar-lists)
	  ;; Eliminate tvars from low types, argtypes first
	  (!= arg-rem-tvar-lists
	      (repeat :for ((fdr :in fdrlist)
			    (benv :in body-envs)
			    rem-tvars)
		 (!= < rem-tvars ustack >
		     (elim-tvars true fdr pre-scope-time ustack benv))
	       :collect rem-tvars))
	  (!= res-rem-tvar-lists
	      (repeat :for ((fdr :in fdrlist)
			    (benv :in body-envs)
			    rem-tvars)
		 (!= < rem-tvars ustack >
		     (elim-tvars false fdr pre-scope-time ustack benv))
	       :collect rem-tvars))
	  (values (<# (\\ (tvl1 tvl2) (union tvl1 tvl2 :test #'eq))
		      arg-rem-tvar-lists
		      res-rem-tvar-lists)
		  ustack)))

(defun fdr-tvars-elim (fdr pre-scope-time undo-stack env)
   (multi-let (((arg-rem-tvars undo-stack-1)
		(elim-tvars true fdr pre-scope-time undo-stack env)))
      (multi-let (((res-rem-tvars undo-stack-2)
		   (elim-tvars false fdr pre-scope-time undo-stack-1 env)))
	 (values (union arg-rem-tvars res-rem-tvars :test #'eq)
		 undo-stack-2))))

(defun elim-tvars (arg-vs-res fdr pre-scope-time undo-stack low-env)
   (cond ((Fundef-rec-is-high fdr)
	  (multi-let (((low-funtype-fewer-tvars _ ustack)
		       (tvar-elim
			  (Fundef-rec-res-funtype fdr)
			  true
			  (cond (arg-vs-res
				 (list ':maximize false))
				(t
				 (list false ':minimize)))
			  pre-scope-time undo-stack low-env)))
	     (!= (Fundef-rec-res-funtype fdr)
		 low-funtype-fewer-tvars)
	     (values '() ustack)))
	 (t
	  (multi-let (((low-funtype-fewer-tvars rem-tvars ustack)
		       (tvar-elim
			  (Fundef-rec-funtype fdr)
			  true
			  (cond (arg-vs-res
				 (list false
				       ':max-if-constrained))
				(t
				 (list ':min-if-constrained
				       false)))
			  pre-scope-time undo-stack low-env)))
	     (!= (Fundef-rec-funtype fdr)
		 low-funtype-fewer-tvars)
	     (values rem-tvars ustack)))))
		      
(defun elim-unks (fdr pre-scope-time outer-env)
   (cond ((Fundef-rec-is-high fdr)
	  (let ((low-funtype
		   (high-bdgs-elim-unks
		       (Fundef-rec-res-funtype fdr)
		       (Fundef-rec-high-arg-bdgs fdr)
		       pre-scope-time
		       outer-env)))
	     (!= (Fundef-rec-funtype fdr)
		 (make-funtype
		    1 low-funtype
		    (type-find-feature
		       *-* 'argtype outer-env)
		    (args->spec (list low-funtype))
		    (funtype-extract-arglist *-* outer-env)
		    false outer-env))))))

(defun high-bdgs-elim-unks (low-type high-bdgs pre-scope-time outer-env)
		   (let ((unk-ids 
			    (<# (\\ (vt)
				   (unknown-type-id (Vartype-val vt)))
				high-bdgs)))
		      (cond ((null unk-ids)
			     low-type)
			    (t
			     (unk-elim low-type
				       unk-ids pre-scope-time 
				       (env-bindings-append
					  true
					  (<# (\\ (vt)
						 (new-Vartype
						    (Vartype-var vt)
						    (Vartype-type vt)
						    '*unbound))
					      high-bdgs)
					  outer-env))))))

;;; Notate the default part of this optional or key argspec
;;;    in source representation of arglist.
(defun argspec-default-piece-noter (argspec)
   (let ((name (Argspec-name argspec)))
      (cond ((eq (Argspec-mode argspec) '&optional)
	     (\\ (arglist)
		(let ((opts (memq '&optional arglist)))
		   (cond ((null opts)
			  (values false nil))
			 (t
			  (repeat :for ((a :in (cdr opts) :tail al)
					default)
			   :until (memq a '(&rest &key))
			   :result (values false nil)
			   :until (matchq (?,name ?default)
					  a)
			   :result (values true
					   `(,@(ldiff arglist al)
					     (,name 
					      ,(make-Noted-piece default))
					     ,@(cdr al)))))))))
	    (t
	     (\\ (arglist)
		(let ((keys (memq '&key arglist)))
		   (cond ((null keys)
			  (values false nil))
			 (t
			  (repeat :for ((a :in (cdr keys) :tail al)
					default ns)
			   :result (values false nil)
			   :until (matchq (?(:& ?(:\| ?,name
						      (?_ ?,name))
						?ns)
					   ?default)
					  a)
			   :result (values true
					   `(,@(ldiff arglist al)
					     (,ns ,(make-Noted-piece default))
					     ,@(cdr al))))))))))))

(defun fundef-rec-low-res-desig (fdr env)
   (cond ((Fundef-rec-is-high fdr)
	  (!= env
	      (env-bindings-append
		   true
		   (Fundef-rec-high-arg-bdgs fdr)
		   env))))
   (type-find-designator
      (type-find-feature
	 (Fundef-rec-low-result fdr)
	 'nity::resulttype
	 env)
      env))

(defun fundef-rec-high-bdg-ids (fdr)
   (<# (\\ (vt)
	  (let ((unk (Vartype-val vt)))
	     (cond ((and (is-unknown-type unk)
			 (type-feature unk 'nity::param))
		    (unknown-type-id unk))
		   (t
		    (signal-problem fundef-rec-high-bdg-ids
		       "Can't find id of " unk)))))
       (Fundef-rec-high-arg-bdgs fdr)))

(defun recursive-funtypes-vartypes (fundef-recs)
   (<# (\\ (r)
	  (new-Vartype (Fundef-rec-name r)
		       (Fundef-rec-funtype r)
		       false))
       fundef-recs))