;-*- Mode: Common-lisp; Package: lisplang; Readtable: ytools; -*-
(in-package :lisplang)
;;; $Id: fundef.lisp,v 1.8 2004/02/22 00:46:54 dvm Exp $

THIS FILE IS NO LONGER NECESSARY
  It's been assimilated into typecheck.lisp

(depends-on %module/ ytools nity)

(depends-on :at-run-time %lisplang/ funsyn typecheck)

;;; Functions for parsing labels-style function-definition lists.

(eval-when (:compile-toplevel :load-toplevel :execute :slurp-toplevel)
   (export '(fundefs-types function-list-parse
	     fundef-rec-high-funtype fundef-rec-low-funtype
	     recursive-funtypes-vartypes)))


;;; We split function handling into three phases:
;;; 1. Calculate type of function (fundefs-types)
;;; 2. Parse body 
;;; 3. Clean up type, eliminating all tvars and unks. 
;;; The three phases work somewhat differently depending on the function
;;; definer, and found in definitions of specific Lisp-like dialects.

;;;;(defun vartypes-fun-bindings-ext (vtl)
;;;;   (<# (\\ (vt)
;;;;	  `(,(Vartype-var vt)
;;;;	    ,@(cdr (Typed-exp-ext (Vartype-val vt)))))
;;;;       vtl))

;;; Returns
;;; < list of bindings,
;;;   list of lists of flags found in each fun spec,
;;;   list of lists of ill-formed-expressions found in each,
;;;   list of ill-formed-expressions associated with the whole function list >
(defun function-list-parse (flist expect-flags 
			    restype allow-res-type vartypes)
   (multi-let (((funrecs trailing-ifes)
		(fundefs-types flist expect-flags false restype
			       allow-res-type vartypes)))
      (repeat :for ((fdr :in funrecs)
		    (vtl '())
		    (flagl '())
		    (ill-formed-exps '())
		    fdr-ifes)
	 (!= vtl
	     (cons (new-Vartype
		      (Fundef-rec-name fdr)
		      (Fundef-rec-funtype fdr)
		      false)
		   *-*))
	 (!= fdr-ifes (Fundef-rec-ill-formed-subexps fdr))
	 (!= flagl (cons (Fundef-rec-special-flags fdr) *-*))
	 (cond ((not (eq (Fundef-rec-defn fdr) ':absent))
		(!= fdr-ifes
		    (cons (make-Defective-exp
			     :has-target true :target fdr
			     :observation
				(\\ (_ srm)
				   (out (:to srm)
					"Function body not allowed"
					" in function list: "
					(Fundef-rec-defn fdr))))
			  *-*))))
	 (!= ill-formed-exps
	     (cons fdr-ifes *-*))
       :result (values (reverse vtl)
		       (reverse flagl)
		       (reverse ill-formed-exps)
		       trailing-ifes))))

;; Returns < fundef-recs, tifel >, where tifel is a list of ill-formed
;;; expressions that can't be associated with a particular fundef.
;; If 'restype' is non-false, it's the default resulttype for all the functions
;;; 'res-type-wrapper' is 'false' if explicit result types are not allowed
;;;    ('restype' is the *only* allowed resulttype)
;;; Otherwise, it's a function that is applied to any explicitly provided
;;; result type to get the actual result type; #'cr if no change.
;;; 'expect-flags' is for use in declaring predicates, where strange
;;; flags can occur in the midst of the function arguments; it's
;;; '()' in all other contexts.
;;; tvars-if-unspec means that if result types or arg types are absent
;;; they should be filled in with fresh tvars.
(defun fundefs-types (defs expect-flags tvars-if-unspec restype res-type-wrapper
		      mvartypes)
   (multi-let (((fundef-recs trailing-ill-formed-exps)
		(function-list-decompose defs expect-flags res-type-wrapper
					 mvartypes)))
      ;; Take care of res-types at the top level.
      (repeat :for ((x :in fundef-recs)
		    (to-be-typed !())
		    :collect real-fundef-recs)
	 (cond ((is-Fundef-rec x)
		(cond ((eq (Fundef-rec-low-result x) ':absent)
		       (!= to-be-typed (cons x *-*)))
		      (t
		       (!= to-be-typed !()))))
	       (t
		;; It's a result type for all the untyped ones so far
		;; (Therefore 'res-type-wrapper' must be nonfalse.)
		(multi-let (((rty rlspec _)
			     ;; Note that we can't use any high-order
			     ;; (type) variables in this case.
			     (function-row-type
				false x 0 false univ-type* mvartypes)))
		   (!= (Fundef-rec-low-result (funcall res-type-wrapper rty x))
;;;;		      (cond ((not (eq actual-res-type rty))
;;;;			     (!= rlspec 
;;;;				 (args->spec (list actual-res-type x)))))
		      )
		   (fill-in-types rty))))
       :when (is-Fundef-rec x)
       :collect x
       :result 
	 (repeat :for ((fdr :in real-fundef-recs))
	    (cond ((eq (Fundef-rec-low-result fdr)
		       ':absent)
		   (!= (Fundef-rec-low-result fdr) restype)
;;;;		   (!= (Fundef-rec-low-result fdr)
;;;;		       (or (type-find-feature restype 'nity::elt-types vartypes)
;;;;			   (args->spec (list restype))))
		   ))
	    (fundef-rec-set-funtype fdr tvars-if-unspec res-type-wrapper mvartypes)
	  :result
	    (values fundef-recs trailing-ill-formed-exps))

       :where

          (:def fill-in-types (ty)    ;;; rlspec
	    (repeat :for ((prev :in to-be-typed))
	       (cond ((not (Fundef-rec-low-result prev))
		      (!= (Fundef-rec-low-result prev)
			  ty)
;;;;		      (!= (Fundef-rec-low-result prev)
;;;;			  rlspec)
		      )))
	    (!= to-be-typed '())))))

(defun fundef-rec-set-funtype (fdr tvars-if-unspec res-type-wrapper mvartypes)
	    ;; Create the funtypes
	    (collecting-defective-exps
		   (td-ife-list _)
		   (cond ((Fundef-rec-is-high fdr)
			  (!= (Fundef-rec-funtype fdr)
			      (fundef-rec-high-funtype fdr tvars-if-unspec
						       res-type-wrapper
						       mvartypes)))
			 (t
			  (!= (Fundef-rec-funtype fdr)
			      (fundef-rec-low-funtype fdr tvars-if-unspec
						      res-type-wrapper
						      false mvartypes))))
	      (!= (Fundef-rec-ill-formed-subexps fdr)
		  (append td-ife-list *-*))
	      fdr))

(defun fundef-rec-high-funtype (rec res-type-wrapper
				tvars-if-unspec undo-stack context mvartypes)
   (multi-let (((high-alspec synerrs)
		(high-funargs-argspecs
		   (Exp-with-rel-exp (Fundef-rec-high-args rec))
		   mvartypes)))
      (cond ((not (null synerrs))
	     (note-defective-exp
		((_) "Syntax errors in function parameters "
		 (Exp-with-rel-exp (Fundef-rec-high-args rec)))
		:place fundef-rec-high-funtype
		(:novalue "I will try to ignore them"))))
      (let ((high-argtype (arglistspec-argtype
			     high-alspec mvartypes))
	    (augenv (argspecs-declare-desig-unks
			  high-alspec mvartypes)))
	 (multi-let (((low-ftype undo-stack-1)
		      (fundef-rec-low-funtype
			  rec res-type-wrapper
			  tvars-if-unspec true undo-stack context augenv)))
	    (values
	       (make-funtype
		  1
		  low-funtype high-argtype
		  (args->spec (list low-funtype))
		  high-alspec
		  false mvartypes)
	       undo-stack-1)))))

(defun fundef-rec-low-funtype (rec res-type-wrapper
			       tvars-if-unspec in-high undo-stack context env)
   (let ((default-type
	    (cond (tvars-if-unspec ':tvar)
		  (t univ-type*))))
      (multi-let (((low-argtype low-alspec arg-tvars)
		   (designated-argtype
		      (Exp-with-rel-exp (Fundef-rec-low-args rec))
		      0 true default-type
		      env))
		  ((has-low-result low-result)
		   (let ((res (Fundef-rec-low-result rec)))
		      (cond ((eq res ':absent)
			     (values false nil))
			    (t
			     (values true (Exp-with-rel-exp res)))))))
		 (ignore arg-tvars)
	 (multi-let (((low-restype low-rlspec res-tvars)
		      (cond (has-low-result
			     (function-row-type false low-result 0 false default-type
						env))
			    (t
			     (unspec-low-restype tvars-if-unspec rec)))))
		    (ignore res-tvars)
	    (cond (res-type-wrapper
		   (!= low-restype (funcall res-type-wrapper *-*))
		   (!= low-rlspec (args->spec low-restype))))
	    (let ((undo-stack-1
		      (defaults-check low-alspec undo-stack
			              (context-expstack-push
				          low-alspec
					  (Exp-with-rel-rel (Fundef-rec-low-args rec))
					  context)
				      env)))
	       (values
		  (make-funtype 0 low-restype low-argtype
				low-rlspec low-alspec
				false
				(cond (in-high no-env*) (t env)))
		  undo-stack-1))))))

;;;;	    (multi-let (((bod-te low-bdgs low-env bod-bdgs ustack)
;;;;			 (fundef-body-check fdr rel undo-stack
;;;;					    context
;;;;					    fun-vartypes)))

(defun fundef-rec-low-res-desig (fdr env)
   (cond ((Fundef-rec-is-high fdr)
	  (!= env
	      (env-bindings-append
		   true
		   (funtype-params-declare-unbound
		      (Fundef-rec-high-argtype ref)
		      env)))))
   (type-find-designator
      (type-find-feature
	 (Fundef-rec-low-result ref)
	 'nity::resulttype
	 env)
      env))

(defun recursive-funtypes-vartypes (fundef-recs)
   (<# (\\ (r)
	  (new-Vartype (Fundef-rec-name r)
		       (Fundef-rec-funtype r)
		       false))
       fundef-recs))


