;-*- Mode: Common-lisp; Package: lisplang; Readtable: ytools; -*-
(in-package :lisplang)
;;; $Id: funsyn.lisp,v 1.20 2005/12/01 22:01:43 dvm Exp $

(depends-on %module/ ytools)

(depends-on %langutils/ synutils %nity/ desig)

(end-header :continue-slurping)

;;; The utilities in this file represent type designators found in code,
;;; but never resolve them to types.  See funcheck.lisp and typecheck.lisp
;;; for the routines that do that.

(eval-when (:compile-toplevel :load-toplevel :execute :slurp-toplevel)
   (export '(function-list-decompose fundef-decompose extract-fun-header
	     conn-join n-conn-join conn-flatten
	     Fundef-rec is-Fundef-rec make-Fundef-rec
	     Fundef-rec-name Fundef-rec-level Fundef-rec-special-flags
	     Fundef-rec-res-funtype Fundef-rec-funtype Fundef-rec-high-result
	     Fundef-rec-low-result
	     Fundef-rec-low-args Fundef-rec-high-args Fundef-rec-defn
	     Fundef-rec-context Fundef-rec-low-rel
	     Fundef-rec-source Fundef-rec-high-arg-bdgs
	     Fundef-rec-ill-formed-subexps Fundef-rec-is-high
	     fundef->fundef-rec parms-symbols-place high-parms-symbols-place)))

(def-class Fundef-rec
    (:options :key)
   name
   level
   special-flags
   (res-funtype false)  ;; false or resulttype of funtype if it's high
   (funtype false)

   ;; These fields --
   high-result
   low-result  
   defn  
   low-args  
   high-args 
   ;; -- are initially Exp-with-rels, later types or type-checked entities
   ;; or :absent if missing.

   context  ; -- position of the source for this fdr in context
   low-rel  ; -- position of level-0 fcn in source 
   source ;; -- definition this rec came from
   (high-arg-bdgs !())  ;; -- vartypes for high-args, if any
   (ill-formed-subexps !())
)
;;; low-args are never ':absent'
;;; defn can be ':absent' if it's a function declaration, not a real definition

(defun function-list-decompose (flist possible-flags long-body-wrapper
				allow-inner-res-type vartypes)
   (let ((new-ill-formed-exps !()))
      (repeat :for ((fl flist)
		    (rel = 0)
		    :collectors res-fdr-list)
       :until (null fl)
	 (collecting-defective-exps
		 (f-ill-formed _)
		 (match-cond fl
		    (:? (- ?td ?@r)
		      (!= fl r)
		      (!= rel (+ rel 2))
		      (cond (allow-inner-res-type
			     (one-collect res-fdr-list td))
			    (t
			      (note-defective-exp
				((targ) "Can't specify a result-type"
				 " designator: " targ)
				:target td
				:place function-list-decompose
				(:continue "I will ignore it"))
			    )))
		    (:? (-)
		      (!= fl '())
		      (note-defective-exp
			  ((_) "Hyphen at end of bvar list: " flist)
			  :place function-list-decompose
			  (:continue "I will ignore it")))
		    (:? (?def ?@r)
		      (!= fl r)
		      (one-collect res-fdr-list
				   (fundef->fundef-rec
				      def
				      possible-flags long-body-wrapper
				      new-ill-formed-exps
				      allow-inner-res-type rel vartypes))
		      (!= rel (+ rel 1))
		      (!= new-ill-formed-exps !())))
	    (!= new-ill-formed-exps
		(nconc *-* f-ill-formed)))
       :result (values res-fdr-list
		       new-ill-formed-exps))))

;;; Return a list of Fundef-recs, interspersed with type designators from
;;; result types at the top level of the list.
;;; All the fields of each Fundef-rec is source stuff, which will be resolved
;;; by the caller.
(defun fundef->fundef-rec (def possible-flags
			   long-body-wrapper accum-bad-exps
                           allow-inner-res-type
			   rel vartypes)
   (multi-let (((fname flags level
		 high-res low-res body low-arg high-arg)
		(fundef-decompose def possible-flags long-body-wrapper
				  allow-inner-res-type vartypes)))
      (let-fun ()
	 (let ((new-fdr
		  (make-Fundef-rec
		     :source def
		     :name fname
		     :special-flags flags
		     :level level
		     :high-result high-res
		     :low-result low-res
		     :defn body
		     :low-args low-arg
		     :high-args high-arg
		     :ill-formed-subexps accum-bad-exps
		     :context rel
		     :low-rel (build-low-fcn-rel))))
	    (cond ((and (not (eq (Fundef-rec-low-result new-fdr)
				 ':absent))
			(not allow-inner-res-type))
		   (note-defective-exp
		      ((_)
		       "Explicit result type in forbidden"
		       " context: " (Fundef-rec-low-result
				       new-fdr))
		      :place function-list-decompose
		      (:continue "I will ignore it"))
		   (!= (Fundef-rec-low-result new-fdr)
		       ':absent)))
	    new-fdr)
      :where
         (build-low-fcn-rel ()
            (cond ((or (eq high-arg ':absent)
		       (not (Exp-with-rel-rel high-arg)))
		   'same)
		  (t
		   (piece-marker
		       (nconc (cond ((eq low-res ':absent) !())
				    (t
				     (list (Exp-with-rel-rel low-res))))
			      (cond ((eq body ':absent) !())
				    (t
				     (list (Exp-with-rel-rel body))))
			      (list 
				 (rel-drop-seg
				    (Exp-with-rel-rel low-arg)
				    (rel-last-tail-pos
				       (Exp-with-rel-rel
					  high-arg))))))))))))

;;; Returns < head, flags, level, high-res, low-res, body-exp, low-arg, high-arg >
;;; All but the first 3 fields are Exp-with-rel's, except that
;;; missing piece has value :absent.
;;; All the pieces are source stuff --- no internalization is done
;;; by fundef-decompose.
;;; 'possible-flags' are things like :nochain that get stuck inside arg lists
;;; for want of a better place and must be detected here and returned.
;;; If 'long-body-wrapper' is false, the body must contain exactly one
;;;    element.
;;; If 'long-body-wrapper' is non-false, it is either
;;;    :no-body -- meaning no body allowed
;;; or a function to apply to the body
;;;    to make it into a single expression, in the case where it isn't.
;;; So either a Defective-exp is reported, or the body becomes the
;;;    the Exp-with-rel-exp of the returned 'body'.
(defun fundef-decompose (term
			 possible-flags long-body-wrapper allow-explicit-restype
			 vartypes)
   (multi-let (((head level rtype args body
		      res-pos arg-pos body-pos)
		(extract-fun-header term)))
      (cond ((and (not allow-explicit-restype)
		  (not (eq rtype ':absent)))
	     (note-defective-exp
		((_) "No result type allowed in this context: "
		 rtype)
		:place fundef-decompose
		(:continue "I will ignore it"))
	     (!= rtype ':absent)
	     (!= res-pos false)))
;;;;      (out "before body-length-check, body = " body
;;;;	   :%)
      (!= body (body-length-check *-* long-body-wrapper term head))
;;;;      (out " After, = " body :%)
      (multi-let (((flags args)
		   (classify args (\\ (x) (memq x possible-flags)))))
	 (cond ((> level 0)
		(cond ((eq body ':absent)
		       (note-defective-exp
			  ((_) "Level-1 function must have body: "
			   term)
			  :place fundef-decompose))
		      (t
		       (multi-let (((lam lev0 rty0 aty0 e0
					 res-pos-0 arg-pos-0 e-pos-0)
				    (extract-fun-header body)))
			  (cond ((or (not (memq lam '(\\ lambda)))
				     (not (= lev0 0)))
				 (note-defective-exp
				    ((_) "Illegal as value of"
				     " high-level function: "
				     body)
				    (:continue
				     "I'll try to make sense of it"))))
			  (values head flags level
				  (maybe-exp-with-rel res-pos rtype)
				  (maybe-exp-with-rel
				      `(:compose ,body-pos 0 ,res-pos-0)
				      rty0)
				  (maybe-exp-with-rel
				      `(:compose ,body-pos ,e-pos-0)
				      e0)
				  (make-Exp-with-rel
				     `(:compose ,body-pos 0 ,arg-pos-0)
				     aty0)
				  (maybe-exp-with-rel arg-pos args))))))
	       (t
		(multiple-value-let (low high high-pos)
				    (args-low-high-split
					  args true vartypes)
		      (cond ((null high)
;;;;			     (out "body = " body
;;;;				  :% " maybe-exp-with-rel -> "
;;;;				  (maybe-exp-with-rel body-pos body) :%)
			     (values head flags 0
				     ':absent
				     (maybe-exp-with-rel res-pos rtype)
				     (maybe-exp-with-rel body-pos body)
				     (make-Exp-with-rel arg-pos args)
				     ':absent))
			    (t
			     (multi-let (((low-arg-pos high-arg-pos)
					  (cond (high-pos
						 (values
						    `(:compose ,arg-pos
							       (:seg 0 ,high-pos))
						    `(:compose ,arg-pos
							       (:tail ,high-pos))))
						(t
						 (values arg-pos false)))))
				(values head flags 1
					':absent
					(maybe-exp-with-rel res-pos rtype)
					(maybe-exp-with-rel body-pos body)
					(make-Exp-with-rel low-arg-pos low)
					(maybe-exp-with-rel high-arg-pos high)))))))))))
				
(defun body-length-check (body long-body-wrapper term binder)
	   (cond ((or (null body) (eq body ':absent))
		  (cond ((eq long-body-wrapper ':no-body)
			 ':absent)
			(long-body-wrapper (funcall long-body-wrapper !() binder))
			(t
			 (note-defective-exp
			    ((_) binder " has no elements in body: "
				 term)
			    :place body-length-check
			    :fatal))
			))
		 ((eq long-body-wrapper ':no-body)
		  (note-defective-exp
		      ((_) binder " has a body where none is expected")
		      :place body-length-check
		      (:continue "I'll ignore it")))
		 (t
;;;;		  (out "Inside body-length-check, body = " body :%)
		  (cond ((= (len body) 1)
			 (car body))
			(long-body-wrapper
;;;;			 (out "About to call long-body-wrapper, body = " body :%)
			 (let ((wbody (funcall long-body-wrapper body binder)))
;;;;			    (out "Called wrapper, body = " wbody :%)
			    wbody))
			(t
			 (note-defective-exp
			    (binder " with " (len body) " elements in body: "
				    term)
			    :place body-length-check
			    (:continue "I'll take the last"))
			 (lastelt body))))))


(defun extract-fun-header (exp)
   (let-fun ()
      (let ((level 0))
	 (cond ((atom (car exp))
		(let ((fn (car exp))
		      (stuff (cdr exp))
		      (offset 1))
		   (cond ((and (not (null stuff))
			       (is-Number (car stuff)))
			  (!= level (car stuff))
			  (!= stuff (cdr stuff))
			  (!= offset 2)))
		   ;;(out "stuff = " stuff :%)
		   (match-cond stuff
		      (:? (- ?rty :parameters ?al ?@body)
			(values fn level rty al (body-non-empty body)
				(+ offset 1) (+ offset 3)
				`(:tail ,(+ offset 4))))
		      (:? (:parameters ?al ?@body)
			(check-for-val fn level al body
				       (+ offset 1) `(:tail ,(+ offset 2))))
		      ;; Must distinguish two cases:
		      ;; (f [- rty]  --args--) & no body
		      ;; (f [- rty] (--args--) ---body---)
		      ;; We do it thus: first thing in arglist cannot
		      ;; be a list,
		      ;; so a list after f or rty must be an entire arglist.
		      (:? (- ?rty ?(:+ ?al listp) ?@body)
			(values fn level rty al (body-non-empty body)
				(+ offset 1) (+ offset 2)
				`(:tail (+ offset 3))))
		      (:? (- ?rty ?@al)
			(values fn level rty al ':absent
				(+ offset 1) `(:tail ,(+ offset 2)) 0))
		      (:? (?(:+ ?al is-argl) - ?rty ?@body)
			(values fn level rty al (body-non-empty body)
				(+ offset 2) offset `(:tail ,(+ offset 3))))
		      (:? (?(:+ ?al is-argl) ?@body)
			(check-for-val fn level al (body-non-empty body)
				       offset `(:tail ,(+ offset 1))))
		      (t
		       (values fn level ':absent stuff ':absent
			       0 `(:tail 0) 0)))))
	       (t
		(let ((form (car exp))
		      (stuff (cdr exp)))
		   (let ((fn (car form))
			 (postfn (cdr form)))
		      (cond ((and fn (is-symbolish fn)
				  (not (memq fn '(\\ lambda))))
			     (cond ((and (not (null postfn))
					 (is-Number (car postfn)))
				    (!= level (car postfn))
				    (!= postfn (cdr *-*))))
			     (match-cond postfn
				(:? (- ?rty ?@al)
				  (values fn level rty al stuff
					  `(:compose 0 2)
					  `(:compose 0 (:tail 3))
					  `(:tail 1)))
				(t
				 (match-cond stuff
				    (:? (- ?rty ?@body)
				      (values fn level rty postfn (body-non-empty body)
					      2 `(:compose 0 (:tail 1)) `(:tail 3)))
				    (t
				     (check-for-val fn level postfn stuff
						    `(:compose 0 :tail 1)
						    `(:tail 1)))))))
			    (t
			     (note-defective-exp
				((_) "Ill-formed function definition: " exp)
				:place extract-fun-header))))))))
    :where
      ;; x is an argument list, not the first element of an argument list
      (is-argl (x)
	 ;;(out (tr is-argl ("is-argl> " x)
	 (or (null x)
	     (and (consp x)
		  (not (ytools::is-Qvaroid x))  ;; just in case
		  ))
	 ;;("is-argl< " (car out-vals*))))
	 )

      ;; If no other rty in sight, look for :value clause
      (check-for-val (fn level al body argpos body-pos)
	 (let ((val-clause (memq ':value body)))
	    (cond (val-clause
		   ;; Must come at end or beginning
		   (cond ((not (or (eq val-clause body)
				   (null (cddr val-clause))))
			  (note-defective-exp
			      ((_) "Misplaced :value clause: " body)
			      :place extract-fun-header)))
		   (values fn level
			   (cadr val-clause)
			   al
			   (body-non-empty
			      `(,@(ldiff body val-clause)
				,@(cddr val-clause)))
			   (conn-join ':compose
				      body-pos
				      (cond ((eq val-clause body)
					     1)
					    (t (- (len body) 2))))
			   argpos
			   (cond ((eq val-clause body)
				  (conn-join ':compose body-pos '(:tail 2)))
				 (t
				  (rel-drop-seg body-pos 2)))))
		  (t
		   ;; It's really not there
		   (values fn level ':absent al (body-non-empty body)
			   0 argpos body-pos)))))

      ;;; Not clear why this was here:
      (:def body-non-empty (body)
;;;;	 (cond ((null body)
;;;;		(note-defective-exp
;;;;		   ((targ) "Empty body in " exp " [" targ "]")
;;;;		   "Empty body in " exp
;;;;		   (:continue "I'll assume it's 'nil'"))
;;;;		'nil) (t ...))
	 body)
))

;;; exp is a function definition, or a truncated one with no body.
;;; Return < name, level, result-type-desig, args, body,
;;;                       res-pos, args-pos, body-pos >.
;;; Missing piece has value :absent.  Not all pieces can be missing.
(defun piece-marker (pieces)
   (\\ (term)
      (letrec ()
	 (mark term pieces)
       :where
         (:def mark (subterm pieces-here)
	    (cond ((member '(:tail 0) pieces-here :test #'equal)
		   (make-Noted-piece subterm))
		  (t
		   (repeat :for ((subtl term)
				 (i = 0)
				 :collector marked)
		    :until (null subtl)
		    :result marked
		    :collect
		       (cond ((or (member i pieces-here)
				  (exists (p :in pieces-here)
				     (matchq (:compose ?,i)
					     p)))
			      (!= i (+ i 1))
			      (prog1 (make-Noted-piece (list (car subtl)))
				     (!= subtl (cdr *-*))))
			     (t
			      (repeat :for ((p :in pieces-here) (j false))
			       :result (try-descend)
			       :until (matchq ?(:\| (:tail ?,i)
						    (:seg ?,i ?j))
					      p)
			       :result (let ((seg (cond (j (take (- j i) subtl))
							(t subtl))))
					  (!= subtl (nthcdr j *-*))
					  (!= i (+ i j))
					  (make-Noted-piece seg))
			       :where
				  (:def try-descend ()
				      (let ((pieces-down
					       (repeat :for ((p :in pieces-here)
							     r)
						:when (matchq (:compose ?,i ?@r)
							      p)
						:collect (cond ((null (cdr r))
								(car r))
							       (t `(:compose ,@r))))))
					 (!= i (+ i 1))
					 (prog1 
					    (cond ((null pieces-down)
						   (car subtl))
						  (t
						   (mark (car subtl) pieces-down)))
					    (!= subtl (cdr *-*)))))))))))))))

;;; Produce a function that, given a term, marks the pieces indicated by
;;; 'pieces'.
;;; We assume that all the pieces are disjoint; otherwise, the results
;;; are unpredictable.
#| Too crude; there could be bound variables in the types of the param list, which
   should not be canonicalized.

;;; Parameters should never be canonized; the symbols in types should be.
(defun parms-symbols-place (params env)
  ;; We don't check for syntactic correctness.  That will be handled by
  ;; params-parse, to be applied to the output of this algorithm.
     (let-fun ((:def through-params (pl default-env)
;;;;		   (trace-around through-params
;;;;		      (:> "(through-params: " pl ")")
		   (match-cond pl
		      (:? ()
			!())
		      (:? (-)
			'(-))
		      (:? (- ?y ?@r)
			`(- ,(exp-env-symbols-place y env)
			    ,@(through-params r default-env)))
		      (:? (&rest ?(:+ ?tvl listp) ?v ?(:\| - --) ?y ?@r)
			`(&rest ,tvl ,v -
				,(exp-env-symbols-place
				    y (env-bindings-append
				         true (<# simp-vartype tvl) env))
			  ,@(through-params
			       r (env-aug v default-env))))
		      (:? (&rest ?v - ?y ?@r)
			`(&rest ,v - ,(exp-env-symbols-place y env)
			  ,@(through-params r (env-aug v default-env))))
		      (:? (&rest ?v ?@r)
			`(&rest ,v ,@(through-params r (env-aug v default-env))))
		      (:? (?(:\| &optional &key :& ?a)
			  ?@r)
			`(,a ,@(through-params r default-env)))
		      (:? ((?(:\| (?v ?_) ?v :& ?a) ?@rv)
			  ?@r)
			(let ((aug-d-env (env-aug v default-env)))
			   (match-cond rv
			      (:? (?dv ?@supp)
				`((,a ,(exp-env-symbols-place dv default-env) ,@supp)
				  ,@(through-params
				       r (cond ((null supp) aug-d-env)
						(t aug-d-env)))))
			      (t
			       `(,a ,@(through-params r aug-d-env))))))
		      (:? (?v ?@r)
			`(,v ,@(through-params r (env-aug v default-env))))
		      (t pl))
;;;;		      (:< (val &rest _) "through-params: " val))
		   ))
	(through-params params env)

      :where

	(:def env-aug (v env)
	   (env-cons (simp-vartype v)
		     env))

	(:def simp-vartype (v)
	   (new-Vartype v univ-type* false))))

(defun high-parms-symbols-place (args env)
   (let ((ns (env-find-namespace env)))
     (letrec ()
	(repeat :for ((al args) a
		      :collector trans)
	 :until (or (null al)
		    (eq (car al) '&constraints))
	 :result `(,@trans ,@al)
	   (!= a (car al))
	 :append
	   (match-cond al
	      (:? (?(:\| - < >) ?ty ?@r)
		(!= al r)
		`(,a ,(exp-namespace-symbols-place ty ns env)))
	      (t
	       (!= al (cdr al))
	       `(,a)))))))
|#

(defun Fundef-rec-is-high (fdr)
   (not (eq (Fundef-rec-high-args fdr) ':absent)))

(defun n-conn-join (connective &rest pl)
   (letrec ((roll-from-rear (l)
	       (cond ((null l) (list connective))
		     (t
		      (conn-join connective
				 (car l)
				 (roll-from-rear (cdr l)))))))
      (roll-from-rear pl)))				 

(defun conn-join (connective p1 p2)
   (cond ((car-eq p1 connective)
	  (cond ((null (cdr p1)) p2)
		((car-eq p2 connective)
		 `(,connective ,@(cdr p1) ,@(cdr p2)))
		(t
		 `(,connective ,@(cdr p1) ,p2))))
	 ((car-eq p2 connective)
	  (cond ((null (cdr p2))
		 p1)
		(t
		 `(,connective ,p1 ,@(cdr p2)))))
	 (t
	  `(,connective ,p1 ,p2))))

(defun conn-flatten (connective c)
   (cond ((car-eq c connective)
	  (<! (\\ (x) (conn-flatten connective x))
	      (cdr c)))
	 (t (list c))))

(defun rel-last-tail-pos (rel)
   (match-cond rel
      ((is-Number rel) rel)
      ((atom rel)
       (signal-problem rel-last-tail-pos
	  "Can't find last tail pos of " rel))
     (:? (:tail ?pos)
       pos)
     (:? (:compose ?@rels)
       (rel-last-tail-pos (lastelt rels)))
      (t (signal-problem rel-last-tail-pos
	    "Can't find last tail pos of " rel))))

;;; Find the innermost expression and change to exclude stuff begining with
;;; position 'tailpos'.
(defun rel-drop-seg (rel tailpos)
   (cond ((is-Number rel)
	  `(:seg 0 ,tailpos))
	 ((atom rel)
	  (signal-problem rel-drop-seg
	     "Can't drop seg from stack rel " rel))
	 ((eq (car rel) ':tail)
	  `(:seg ,(cadr rel) ,tailpos))
	 ((eq (car rel) ':seg)
	  (cond ((> (caddr rel) tailpos)
		 `(:seg ,(cadr rel) ,tailpos))
		(t rel)))
	 ((eq (car rel) ':compose)
	  (cond ((null (cdr rel))
		 `(:seg 0 ,tailpos))
		(t
		 (<< n-conn-join ':compose
		     (nconc (butlast (cdr rel))
			    (list (rel-drop-seg (lastelt rel) tailpos)))))))
	 (t
	  (signal-problem rel-drop-seg
	     "Unintelligble stack rel " rel))))

(defun maybe-exp-with-rel (rel exp)
   (cond ((eq exp ':absent) ':absent)
	 (t (make-Exp-with-rel rel exp))))