;-*- Mode: Common-lisp; Package: lisplang; Readtable: ytools; -*-
(in-package :lisplang)

(depends-on %module/ ytools
	    %lisplang/ funcheck)

#|
(handle-high-vars
    ((:env env-var :other-vars other-vars)
     (e-arg --other-args--))
    (:main ...)
;;;;    (:type y-var :other-vals --multi-vars--)
    (:high-vars hvar)
    (:if-high high-init)
    (:high-ob H :other-high-vars --high-vars--)
    (:high-trans ...))
       


(handle-high-vars (env-var -other-vars-) vals-for-all-vars
   low-exp
   &key
   high-vars high-init high-trans)

Bind the variables as indicated by env-bdg etc.

In that environment, evaluates high-vars ; 
       if empty, evaluate and return values(s) of low-exp. (first
       value must be a type).

If they're not empty, 
   -- rebind env-bdg var to env with high-vars bound to unks;
   -- evaluate high-init, which returns as values an object H + new
      values for the vars;
   -- evaluate low-exp with those bindings;
   -- eliminates unks from first value (the type)
   -- rebind env-bdg & other-bdgs with results from high-init (except
      for H)
   -- evaluate low-exp 
   -- call high-trans on H and the values of low-exp; return the result


new context, new undo-stack,
and a value H, which is saved; (c) applies the low-body function to
the enlarged context, undo-stack, and env; (d) eliminates the
unks; (e) passes H + the result(s) of the low-level
computation to high-trans, whose value(s) are returned.


|#

(handle-high-vars
    ((:env env-var :other-vars --other-vars--)
     (e-arg --other-args--))
    (:main ...)
    (:type y-var :other-vals --multi-vars--)
    (:high-vars hvar)
    (:if-high high-init)
    (:high-ob-var H :other-high-vars --high-vars--)
    (:high-trans ...))

(defmacro handle-high-vars (&rest clauses &whole h-exp)
   (match-cond clauses
      (:? (((:env ?env-var ?@other-vars)
	    (?e-arg ?@other-args))
	   (:main ?@low-body)
	   (:low-type ?low-type-var :other-low-vars ?@other-low-vars)
	   (:high-vars ?high-vars)
	   (:if-high ?high-init)
	   (:high-ob-var ?high-ob-var)  ;;;; :other-high-vars ?@other-high-vars
	   (:high-trans ?@high-body))
	(cond ((not (null other-vars))
	       (cond ((eq (car other-vars) ':other-vars)
		      (!= other-vars (cdr *-*)))
		     (t
		      (signal-problem handle-high-vars
			 "Missing :other-vars in: " `(:env ,env-var ,@other-vars)
			 :proceed)))))
	(let ((high-vars-var (gen-var 'hv))
	      (low-fcn-name (gen-var 'low-gen))
	      (high-init-res-var (gen-var 'high-res))
	      (low-res-var (gen-var 'low-res))
	      (pre-scope-time-var (gen-var 'pre-scope-time)))
      `((lambda (,pre-scope-time-var ,env-var ,@other-vars)
	   (!= scope-time* (+ *-* 1))
 	   (let ((,high-vars-var ,high-vars))
	     (flet ((,low-fcn-name (,env-var ,@other-vars)
		        ,@low-body))
	        (cond ((null ,high-vars-var)
		       (,low-fcn-name ,env-var ,@other-vars))
		      (t
		       (let ((,env-var
				(vartypes-declare-placeholder-params
				    ,high-vars-var
				    ,env-var)))
			  (multiple-value-call
			     (lambda (,high-ob-var ,@other-vars)
				(let ((,low-res-var
				          (values->list (,low-fcn-name
							    ,env-var ,@other-vars))))
				     (high-bdgs-elim-unks
					     (car ,low-res-var)
					     high-bdgs
					     ,pre-scope-time-var
					     ,env-var)
				     (apply (\\ (,high-ob-var
						 ,low-type-var
						 ,@other-low-vars)
					       ,@high-body)
					    ,high-init-res-var
					    ,low-res-var)))
			    ,high-init)))))))
         scope-time* ,vals)))
      (t
       (let ((missing-fields
	        (<? (\\ (key)
		       (not (assq key clauses)))
		    '(:main :high-vars :if-high :high-ob-var :high-trans))))
	  (cond ((null missing-fields)
		 (cond ((not (matchq (:env-var ?_ :other-vars ?@_)
				     (first clauses)))
			(note-defective-exp
			   ((h-exp) "Ill-formed variable-binding expression "
				    (first clauses)
				    :% " in " h-exp)
			   :target h-exp
			   :fatal))
		       (t
			(note-defective-exp
			   ((h-exp) "Ill-formed: " h-exp)
			   :target h-exp
			   :fatal))))
		(t
		 (note-defective-exp
		    ((h-exp) "Missing fields: " missing-fields
			     :% " in " h-exp)
		    :target h-exp
		    :fatal))))))))
				    




	



(defmacro handle-high-vars (vars vals low-exp
			    &key high-vars high-init high-trans)
   (let ((env-var (car vars))
	 (high-vars-var (gen-var 'hv))
	 (low-fcn-name (gen-var 'low-gen))
	 (high-bdgs-var (gen-var 'hb))
	 ;;;;(inner-env-var (gen-var 'inner-env))
	 (high-init-res-var (gen-var 'high-res))
	 (low-res-var (gen-var 'low-res))
	 (pre-scope-time-var (gen-var 'pre-scope-time)))
      `((lambda (,pre-scope-time-var ,@vars)
	   (!= scope-time* (+ *-* 1))
 	   (let ((,high-vars-var ,high-vars))
	     (flet ((,low-fcn-name (,vars)
		        ,low-exp))
	        (cond ((null ,high-vars-var)
		       (,low-fcn-name ,@vars))
		      (t
		       (let ((,high-bdgs-var ,high-vars-var))
			  (let ((,env-var
				   (vartypes-declare-placeholder-params
				       ,high-bdgs-var
				       ,env-var)))
			     (multiple-value-call
				(lambda (,high-init-res-var ,@vars)
				  (let ((,low-res-var
				            (values->list (,low-fcn-name ,@vars))))
				     (high-bdgs-elim-unks
					     (car ,low-res-var)
					     high-bdgs
					     ,pre-scope-time-var
					     ,env-var)
				     (apply ,high-trans
					    ,high-init-res-var
					    ,low-res-var)))
				,high-init))))))))
         scope-time* ,vals)))



;;; -- Rewrite of quantified-formula-check (again):
   (multi-let (((te-type te undo-stack-2)
		(handle-high-vars
		   ((:env-var env :other-vars context undo-stack)
		    (mvartypes context undo-stack))
		   (:main
		      (multi-let (((constraining low-bdgs low-ill-formed)
				   (qvar-list-parse low type-type* env)))
			 (let ((zqte (initialize-quantified-te
					low-bdgs constraining low-ill-formed 0 env)))
			    (multi-let (((bte undo-stack-1)
					 (term-check
					       body
					       prop-type*
					       undo-stack
					       (context-expstack-push
						  body 2 context)
					       env)))
			       (multi-let (((bindings)
					    (bdgs-tvar-elim
					       (Quantified-typed-exp-bindings zqte)
					       initial-scope-time
					       undo-stack-1)))
				  (quantified-te-finish
				      zqte bte bindings 0 undo-stack-1))))))
		   (:low-type-var low-type :other-low-vars te undo-stack)
		   (:high-vars high-bdgs)
		   (:if-high 
		      (let ((hqte (initialize-quantified-te
				      high-bdgs false high-ill-formed 1 env)))
			 (cond ((not univ)
				(note-bugs
				   hqte
				   (list (simple-ill-formed-exp
					    "Can't existentially quantify over types"
					    qgoal)))))
			 (values hqte
				 env
				 (cond ((and (not univ)
					     (not keep))
					(cons-Syn-context
					   (tuple 'keep-quantifiers true)
					   context))
				       (t context))
				 undo-stack)))
		   (:high-ob-var hqte)
		   (:high-trans 
		      (quantified-te-finish hqte zqte
					    (Quantified-typed-exp-bindings te)
					    initial-scope-time
					    undo-stack)
		      (values (Typed-exp-type hqte) hqte undo-stack)))))
      -- check for other bugs --)






(defun quantified-formula-check (qgoal target-type undo-stack
				 context mvartypes)
   (multi-let (((quant level qvars body junk)
		(match-cond qgoal
		   (:? (?quant ?(:+ ?lev is-Number) ?qvars ?body ?@junk)
		      (values quant lev qvars body))
		   (:? (?quant ?qvars ?body ?@junk)
		      (values quant 0 qvars body junk))
		   (t
		    (values false nil nil nil nil)))))
      (cond ((not quant)
	     (ill-formed-typed-exp qgoal target-type mvartypes))
	    (t
	     (multi-let (((univ requirements)
			  (quantifier-analyze quant context))
			 (keep (syn-context-lookup context
						   'keep-quantifiers))
			 ((low high _)
			  (cond ((= level 0)
				 (args-low-high-split qvars false mvartypes))
				(t
				 (values !() qvars false)))))
		(let-fun ()
		   (whats-left)
		 :where
 (:def whats-left ()
    (multi-let (((_ high-bdgs high-ill-formed)
		 (qvar-list-parse high type-type* mvartypes)))
       (multi-let (((qte undo-stack-3)
		    (handle-high-vars
		       (env context undo-stack)
		       (mvartypes context undo-stack)

		       (multi-let (((constraining low-bdgs low-ill-formed)
				    (qvar-list-parse low type-type* env)))
			  (let ((zqte (initialize-quantified-te
					 low-bdgs constraining low-ill-formed 0 env)))
			     (multi-let (((bte undo-stack-1)
					  (term-check
						body
						prop-type*
						undo-stack
						(context-expstack-push
						   body 2 context)
						env)))
				(multi-let (((bindings)
					     (bdgs-tvar-elim
						(Quantified-typed-exp-bindings zqte)
						initial-scope-time
						undo-stack-1)))
				   (quantified-te-finish
				       zqte bte bindings 0 undo-stack-1)))))

		       :high-vars high-bdgs
		       :high-init
			  (let ((hqte (initialize-quantified-te
					  high-bdgs false high-ill-formed 1 env)))
			     (cond ((not univ)
				    (note-bugs
				       hqte
				       (list (simple-ill-formed-exp
						"Can't existentially quantify over types"
						qgoal)))))
			     (values hqte
				     env
				     (cond ((and (not univ)
						 (not keep))
					    (cons-Syn-context
					       (tuple 'keep-quantifiers true)
					       context))
					   (t context))
				     undo-stack))

		       :high-trans
			  (\\ (hqte lqte undo-stack)
			     (

    (multi-let (((qte undo-stack-2)
		 (cond ((null high)
			(low-quantified-te context undo-stack mvartypes))
		       (t
			(let 
			   (let ((high-bdgs
				    (Quantified-typed-exp-bindings hqte)))
			      (let ((low-env (vartypes-declare-placeholder-params
						 high-bdgs mvartypes)))
				 (multi-let (((zqte undo-stack-1)
					      (low-quantified-te


						 undo-stack
						 low-env)))
				    (multi-let (((ltype _ undo-stack-2)
						 (tvar-elim
						    (Typed-exp-type zqte)
						    true
						    (list false ':max-if-constrained)
						    initial-scope-time
						    undo-stack-1 low-env)))
				       (quantified-te-finish
					  hqte zqte
					  (high-bdgs-elim-unks
					     ltype
					     high-bdgs initial-scope-time mvartypes)
					  1 undo-stack-2))))))))))
       (repeat :for ((req :in requirements))
	  (cond ((eq req ':existential-effects)
		 ;; Pseudo-requirement, never satisfied
		 (note-existential-in-effect-bug qte))
		(t
		 (verify-requirement req mvartypes qte))))
       (let ((eff-con (syn-context-lookup context 'action-context)))
	  (cond (eff-con
		 (cond ((eq (cadr eff-con) 'condition)
			(verify-requirement
			   (cond ((eq quant 'forall)
				  ':universal-preconditions)
				 (t
				  ':existential-preconditions))
			   mvartypes qte))
		       ((memq quant '(exists exists!))
			(note-bugs
			    qte
			    (list (simple-ill-formed-exp
				     !"Existentials are not allowed ~
				       in action effects"
				     qgoal))))))))
       (cond ((not (null junk))
	      (note-bugs qte (list (simple-ill-formed-exp
				     "Too much stuff in goal body"
				     qgoal)))))
       (values qte undo-stack-2)))

 (:def low-quantified-te (context undo-stack env)
    (let ((zqte (initialize-quantified-te low ':tvar 0 env)))

 (:def initialize-quantified-te (qvarbdgs constraining var-ill-formed level env)
       (let ((te (make-inst Quantified-typed-exp
		    :quantifier quant
		    :level level
		    :keep-quantifier (or (not univ) keep)
		    :use-bindings-as-constraints constraining
		    :universal univ
		    :bindings qvarbdgs
		    :body '()
		    :source qgoal
		    :env mvartypes)))
	  (repeat :for ((vt :in new-qvarbdgs))
	     (!= (vartype-feat vt ':binder) te))
	  (note-bugs te var-ill-formed)
	  te))

 (:def quantified-te-finish (qte body-te bindings level undo-stack)
       (set-fields Quantified-typed-exp qte
	  :body body-te
	  :ext `(,(Quantified-typed-exp-quantifier qte)
		 ,@(include-if (> level 0 level))
		 ,(vartypes-typed-arglist bindings)
		 ,(Typed-exp-ext body-te))
	  :totbugs (+ *-* (Typed-exp-totbugs body-te))
	  :tvars (Typed-exp-tvars body-te)
	  :type (Typed-exp-type body-te)
	  :subexps (list body-te)
	  :bindings bindings)
       (values (Typed-exp-type qte) qte undo-stack)))))))))
       
       
       
       
       
