;-*- Mode: Common-lisp; Package: nity; Readtable: ytools; -*-
(in-package :nity)
;;; $Id: struct.lisp,v 1.4 2005/06/17 13:23:23 dvm Exp $

(depends-on %module/ ytools %ytools/ nilscompat)

;;;;(depends-on :at-run-time extra/ dbghck)
(depends-on :at-run-time %ytools/ debug
			 %nity/ types subtype desig tloader parmutils
				auxdefs parmsparse parmsgen
			 %langutils/ synutils)

;;; Slurp to get macro definitions
(end-header :continue-slurping)

(eval-when (:compile-toplevel :load-toplevel :execute :slurp-toplevel)
   (export '(forward-define  def-type-constructor)))

;;; A key point about 'def-type-constructor' is that it creates two kinds of
;;; terms: (C y) is a type if y is, 
;;; and (make C e) is a term of type (C y) if e is of type y.  

;;; In the Lisp context, the object produced by (make C e) is actually
;;; an object produced by (make-C1 e) for some defstruct C1, although
;;; some care must be taken if the definition of the type constructor
;;; is _not_ wrt the global env, which is impossible for
;;; def-type-constructor.

(datafun to-slurp def-type-constructor
   (defun :^ (dtcform slurp-if-substantive)
      (cond (slurp-if-substantive
	     (match-cond dtcform
		?( (def-type-constructor ?name ?params ?@stuff)
		  (bind ((auxdefs* ':not-allowed))
		     (multi-let (((name alspec sys)
				  (def-type-constructor-parse name params stuff)))
			(let ((cspec (make-Constructor-spec false params)))
			   (let ((tyf (new-Tyfun name alspec cspec
						 (empty-vartypes sys))))
			      (!= (Constructor-spec-tyfun cspec) tyf)
	  ;;;;		       (dbg-save tyf cspec name)
	  ;;;;		       (breakpoint def-type-constructor-to-slurp
	  ;;;;			  "name = " name
	  ;;;;			  " tfs EQ? " (eq (Constructor-spec-tyfun cspec) tyf))
			      (typedecl name
					constructor-type*
					tyf
					sys))))))
		(t
		 (signal-problem def-type-constructor-to-slurp :fatal
		    "Ill-formed: " dtcform)))))
      true))

(defmacro def-type-constructor (name params &rest stuff)
   (bind ((aux-defs* '()))
      (multi-let (((name alspec typeified-alspec sys)
		   (def-type-constructor-parse name params stuff))
		  (sys-var (gensym))
		  (env-var (gensym)))
	 (let ((ae (type-system-acc-env sys))
	       (cspec (make-Constructor-spec false params ???))
	       (tyfun-name (build-symbol (< name) :-tyfun*)))
	    `(eval-when (:load-toplevel :execute :slurp-toplevel :compile-toplevel)
		(let ((,sys-var ,(type-system-loader sys)))
		   (let ((,env-var (place-type-system-env ,sys-var)))
		      (let ((,ctyf-var
			     (constructor-tyfun-circularize
				   (new-Tyfun
				      ',name
				      (circular-object-restore
					 ,(bind ((acc-env* ae))
					     (arglistspec-loader
						alspec '()))
					 arglistspec-re-cycle)
				      ,(bind ((acc-env* ae))
					  (constructor-spec-loader
					     cspec '()))
				      (empty-vartypes ,sys-var)))))
		      (typedecl ',name
				constructor-type*
				,ctyf-var
				,sys-var)
		      (defvar ,tyfun-name (var-val ',name ,env-var))
		      (defstruct (,(build-symbol (< name) " " struct)
				  (:constructor
				      ,(build-symbol make (< name) " " struct)
				      ,(argliststpec-typed-arglist
					  (Constructor-spec-make-params
					      ,ctyf-var))))
			 
		      (defun ,(build-symbol make- (< name) -type)
			     ,params
			 (make-constructed-type
			     ,tyfun-name
			     (list ,@params)
			     ,env-var))
		      (defun ,(build-symbol is- (< name) -type)
			     (ty)
			 (and (is-constructed-type ty)
			      (eq (constructed-type-tyfun ty ,env-var)
				  ,tyfun-name))))))))))

(defun def-type-constructor-parse (name params stuff)
   (multi-let (((_ _ sys)
		(extract-sys false stuff)))
      (multi-let (((alspec _ _ synerrs)
		   (params-parse params
				 true type-type* false true
				 (empty-vartypes sys))))
	 (cond ((not (null synerrs))
		(note-defective-exp
		   ((_) "Syntactic errors in definition of "
			name ": " synerrs)
		   :place def-type-constructor-parse
		   (:continue "I will ignore them"))))
;;;;	 (cond ((not (forall (as :in (Arglistspec-argspecs alspec))
;;;;			(and (eq (Argspec-mode as) ':required)
;;;;			     (eq (Argspec-type as) type-type*))))
;;;;		(note-defective-exp
;;;;			 ((_) "Type constructor " name
;;;;			      " can have only required arguments of type"
;;;;			      " (t)")
;;;;		   :place def-type-constructor
;;;;		   (:continue "I will pretend everything is okay"))))
	 (values name alspec sys))))

