;-*- Mode: Common-lisp; Package: lisplang; Readtable: ytools; -*-
(in-package :lisplang)

(depends-on %module/ ytools)

(depends-on (:at :slurp-time :compile-time) %ytools/ bq)

(end-header :continue-slurping)

(eval-when (:compile-toplevel :load-toplevel :execute :slurp-toplevel)
   (export '(def-language-syntax-table)))

(defmacro def-language-syntax-table (synname params-pattern)
   (let ((syntab-name (build-symbol (< synname) -syntax-table*))
	 (patvars (remove-duplicates (ytools::find-matchvars params-pattern)))
	 (symvar (gensym))
	 (bodvar (gensym))
	 ;;;;(bodqvarname (gensym))
	 (fcnqvar (gensym))
	 (baseqvar (gensym))
	 (macname (build-symbol def- (< synname) -form-handler)))
      !`1(progn
	    (defvar ,syntab-name (make-hash-table :test #'eq))

	    (defmacro ,macname (,symvar &rest ,bodvar)
	       (match-cond ,bodvar
		  (declare (ignore ,@patvars))
		     ?( (#'?(,fcnqvar))
		       !`2#(!= (gethash ',2,1#symvar ,1#syntab-name)
			      #',2,1#fcnqvar))
		     ?( (?(:+ ?(,baseqvar) is-Symbol))
		       !`2#(!= (gethash ',2,1#symvar ,1#syntab-name)
			       (find-in-syntax-table
				     ',2,1#baseqvar ,1#syntab-name ',1#synname)))
		     ?( (,params-pattern ?@_)
		       (let ((fun-name (build-symbol
					  (< ,symvar) - ,synname -handler)))
			  !`2(progn
				(defun ,2#fun-name
				  ,2@,1#bodvar)
				(!= (gethash ',2,1#symvar ,1#syntab-name)
				    #',2#fun-name))))
		     (t
		      (signal-problem ,macname
			 "Mismatch on params for " ,symvar 1 "[" ',synname "]: "
			 :% " Wanted: " ',params-pattern
			 :% " Got: " (car ,bodvar)))))

	    (defun ,(build-symbol (< synname) -form-handler) (form)
	       (cond ((and (is-Pair form) (is-Symbol (car form)))
		      (gethash (car form) ,syntab-name))
		     (t nil))))))

