;-*- Mode: Common-lisp; Package: lisplang; Readtable: ytools; -*-
(in-package :lisplang)
;;; $Id: teshow.lisp,v 1.3 2004/02/22 00:46:55 dvm Exp $

(depends-on %module/ ytools %ytools/ nilscompat)

(depends-on :at-run-time %lisplang/ typedexp %nity/ typebounds desigsubst)

(eval-when (:slurp-toplevel :compile-toplevel :load-toplevel)
   (export '(show show-header type-show)))

(defvar show-env* empty-env*)

(defvar show-tvars* true)

;;; This is more general, and should be defined somewhere else
(def-op show (x)
   (describe x))

(def-meth show ((te Typed-exp))
  (out "Don't know how to show Typed-exp with flag " (Typed-exp-flag te)
       :% " >>> " te :%))

;;; This is completely specific to Typed-exps
(def-op show-header (te)
   (out "---" (Typed-exp-flag te) "---"))

(def-meth show :around ((te Typed-exp))
    (show-header te)
    (out :%)
    (type-show (Typed-exp-type te))
    (out :%)
    (cond ((not (eq (Typed-exp-env te) show-env*))
 	  (out "(")
 	  (repeat :for ((vtl (Env-vartypes (Typed-exp-env te))
			    (cdr vtl))
 		       x)
 	   :until (or (null vtl)
 		     (eq vtl (Env-vartypes show-env*)))
 	   :result (progn (cond ((not (null vtl))
 				(out "^^^")))
 			 (out ")" :%))
 	     (!= x (car vtl))
 	     (cond ((is-Vartype x)
 		    (out (Vartype-var x)))
 		   ((is-Type-system x)
 		    (out (Type-system-name x)))
 		   (t (out x)))
 	     (cond ((not (null (cdr vtl)))
 		    (out 1))))))
    (bind ((show-env* (Typed-exp-env te)))
       (out (:i> 3) 
	    (:e (continue-combined-method te)
	       (:o (:i< 3))
	       (cond ((and show-tvars* (not (null (Typed-exp-tvars te))))
		      (:o "Tvars: " (Typed-exp-tvars te) :%)))
	       (cond ((not (null (Typed-exp-bugs te)))
		      (:o "Bugs: " (Typed-exp-bugs te) :%)))))))

;;; These two are all header:

(def-meth show-header ((vte Var-typed-exp))
   (out (:q ((Var-typed-exp-qvar vte) "?"))
	(Var-typed-exp-var vte)))

(def-meth show ((vte Var-typed-exp))
  (values))

(def-meth show-header ((cte Const-typed-exp))
  (out "Constant: " (Const-typed-exp-val cte)))

(def-meth show ((cte Const-typed-exp))
  (values))

;;; Here's why we use (:e ...) so much below.  
;;; If you write (progn (out ...) xxx), then indentation information
;;; set in (out ...) is lost in xxx.
;;; (out ... (:e xxx)) fixes the problem by evaluating xxx inside the
;;; established out env.

(def-meth show-header ((ate App-typed-exp))
  (out "Application [" (App-typed-exp-level ate) "]: "))

(def-meth show ((ate App-typed-exp))
  (out "Function: " :%
       (:e (show (App-typed-exp-fcn ate))) 
       "<" :%
       (:e (repeat :for ((arg :in (App-typed-exp-args ate))
		       (prefs (App-typed-exp-arg-positions ate)))
	     (out (:q ((null prefs) "? ")
		     (t
		      (car prefs) 1)))
	     (show arg)
	     (cond ((not (null prefs))
		    (!= prefs (cdr *-*))))))
       ">" :%))

(def-meth show-header ((tte Type-typed-exp))
   (let ((which-ty (Type-typed-exp-which tte)))
      (out "Compile-time value-- "
	   (:e (type-show which-ty)))))

(def-meth show ((tte Type-typed-exp))
   (values))

(def-meth show-header ((ute Unchecked-typed-exp))
   (out (:pp (Unchecked-typed-exp-source ute))))

(def-meth show ((ute Unchecked-typed-exp))
   (cond ((eq (Typed-exp-flag ute) 'ill-formed)
	  (out "** ILL-FORMED **"))))

(def-meth show-header ((lte Lambda-typed-exp))
   (out "Lambda [" (Lambda-typed-exp-level lte) "]:"))
   
(def-meth show ((lte Lambda-typed-exp))
   (out (:e (repeat :for ((as :in (Arglistspec-argspecs
				  (Lambda-typed-exp-params lte))))
	      (:o "Arg [" (Argspec-position as)"] " (Argspec-name as)
		 1 (Argspec-mode as) :%
		 (:e (type-show (Argspec-type as)))
		 :% (:q ((Argspec-default as)
		       "Default: " (:i> 5) :%
			  (show (Argspec-default as)))))))
	(:e (show (Lambda-typed-exp-body lte)))))

(defun type-show (ty &optional (strict true))
   (multi-let (((ty tyenv)
		(follow-var-ref ty empty-env*)))
      (multi-let (((lo hi)
		   (type-bounds ty strict tyenv)))
	 (multi-let (((lotype loenv)
		      (follow-var-ref lo tyenv))
		     ((hitype hienv)
		      (follow-var-ref hi tyenv)))
	    (let ((lodesig (desig-subst (type-find-designator lotype loenv)
					'() loenv))
		  (hidesig (desig-subst (type-find-designator hitype hienv)
					'() hienv)))
	       (out "Type: "
		    (:q ((equal lodesig hidesig)
			lodesig)
		       (t
			(desig-subst ty '() tyenv)
			(:i> 3) :%
			"Low  bound: " lodesig :%
			"High bound: " hidesig :%))))))))
