;-*- Mode: Common-lisp; Package: lisplang; Readtable: ytools; -*-
(in-package :lisplang)
;;; $Id: typecheck.lisp,v 1.31 2006/03/14 15:55:13 dvm Exp $

(depends-on %module/ ytools nity)

(depends-on %ytools/ nilscompat)

(depends-on :at-run-time
	    %ytools/ debug 
	    %nity/ argspair tyfun conformer
		   funtypes typebounds tupacceptors tvarelim
	    %langutils/ synutils
	    %lisplang/ typetrans typedexp builtin funsyn)

(eval-when (:compile-toplevel :load-toplevel :execute :slurp-toplevel)
   (export '(type-declare 
	     note-bugs build-res-typed-exp build-Var-typed-exp
	     simple-app-typed-exp simple-var-typed-exp
	     ;;;;const-type
	     body-check args-check 
	     functional-term-check simple-functional-term-check
	     symbol-type-check
	     term-check-and-tidy term-check
	     context-push-for-function-pos
	     |**Missing_Arg**|
	     te-list-tvars arg-vs-fcn arg-term-handler-tab*)))

;;; This is the nucleus of a type checker for any Lisp-like language.
;;; It deals with the Lisp-1 vs. Lisp-2 issue by having a property
;;; arg-vs-fcn that tells us whether the term being checked occurred in
;;; argument or function position.  The dialect is a Lisp-2 if and only
;;; this property is bound.  Because 'lambda' and '\\' expressions are
;;; not handled here, individual dialect handlers must remember to
;;; switch back from arg-vs-fcn=true if the lambda-expression occurs in
;;; functional position.

;; If there were tvars introduced, replace them with their final
;; lower-bounds
(defun term-check-and-tidy (term target-type undo-stack context mvartypes)
   (multi-let (((te undo-stack-1)
		(term-check term target-type undo-stack context mvartypes)))
      (!= (Typed-exp-type te)
	  (type-bound *-* false false ':all mvartypes))
      (!= (Typed-exp-tvars te) '())
      (values te undo-stack-1)))

(defvar check-undo-coherence* false)

;;; mvartypes contains bindings of run-time variables
;;; and type variables in terms being checked.
;;; If similar info is needed for the target-type, it's included in the type closure
;;; constituting the type of the target-type.
;;; context argument typically includes polarity information.
;;; Returns a Typed-exp + new undo-stack
(defun term-check (term target-type undo-stack context mvartypes)
   (collecting-defective-exps (:context context)
		      (badlist term-typed-exp undo-stack-1)
		      (cond ((eq target-type opaque-type*)
			     (values
				(make-inst Unchecked-typed-exp
				   :source term
				   :type target-type)
				undo-stack))
			    (t
			     (multi-let (((h term)
					  (funcall
					     (Typed-dialect-data-handler-finder
						(Syn-context-dialect-handler
						   context))
					     term mvartypes)))
;;;;				 (out "h = " h " term = " term :%)
				(cond (h
				       (funcall h term target-type undo-stack
						context mvartypes))
				      (t
				       (serious-term-check
					  term target-type
					  undo-stack context mvartypes))))))
;;;;      (:if-aborted
;;;;	 :restart-report (lambda (srm)
;;;;			    (out (:to srm) "I will give up on checking " term))
;;;;	 (values (note-bugs (ill-formed-typed-exp term target-type mvartypes)
;;;;			    badlist)
;;;;		 undo-stack))
      (values (note-bugs term-typed-exp badlist)
	      (progn
		 (cond ((and check-undo-coherence*
			     (not (tailp undo-stack undo-stack-1)))
			(dbg-save :run-loud
				  undo-stack undo-stack-1 term target-type
				  context mvartypes)
			(signal-problem term-check
			   "Undo stack screwup")))
		 undo-stack-1))))

(defun serious-term-check (term target-type undo-stack context mvartypes)
   (let ((initial-tvar-no scope-time*))
      (multi-let (((te undo-stack-1)
		   (cond ((is-Qvar term)
			  (values (symbol-type-check (Qvar-sym term) term
						     target-type context mvartypes)
				  undo-stack))
			 ((is-symbolish term)
			  (let ((ns (env-find-namespace mvartypes)))
			     (values (symbol-type-check
					(symbol-namespace-or-env-place
				           term ns mvartypes)
					term target-type context mvartypes)
				     undo-stack)))
			 ((atom term)
			  (values
			     (new-Const-typed-exp
			        `(quote ,term)
				(const-type term)
				term
				mvartypes)
			     undo-stack))
			 (t
			  (functional-term-check
				       term target-type undo-stack context
				       mvartypes)))))
	 (type-trans
	    (Typed-exp-set-scope-times
	       te initial-tvar-no scope-time*)
	    target-type undo-stack-1 context))))

(defun symbol-type-check (sym source target-type context svartypes)
   (let ((vt (var-lookup sym svartypes)))
      (cond (vt
	     (var-val-typed-exp (Vartype-val vt)
				vt source context svartypes))
	    ((is-symbolish sym)
	     (let ((vte (build-Var-typed-exp sym source target-type svartypes)))
		(note-defective-exp ((s) "Undefined symbol " s)
		   :target sym
		   :place symbol-type-check
		   (:novalue "I will pretend it's defined"))
		vte))
	    (t
	     (note-defective-exp 
		((_) "Illegal in this context " sym)
		:place symbol-type-check :fatal
		"Symbol expected, got this instead: " sym)))))

;;;;	    ((is-Qvar source)
;;;;	     ;; Someone is playing games with Qvars; overlook it.
;;;;	     (make-inst Var-typed-exp
;;;;		:var sym
;;;;		:qvar true
;;;;		:source source
;;;;		:ext sym
;;;;		:type univ-type*
;;;;		:env empty-env*
;;;;		:binder false
;;;;		:argspec false
;;;;		:check-time-callable false)))))

;;; Offset is number of elements before the body in the containing
;;; expression.
(defun body-check (body target-type undo-stack offset context bdgs)
   (cond ((null body)
	  (let ((bte (make-inst Body-typed-exp
			:type target-type
			:env bdgs
			:source body
			:tvars !()
			:subexps !())))
	     (note-bugs
	         bte
		 (list (make-Defective-exp
			  :target bte
			  :observation
			     (\\ (_ srm)
				(out (:to srm) 
				     "Empty body in context requiring expression"
				     " of type "
				     :% target-type))
			  :context context
			  :continuable true
			  :signaler
			     (\\ (_)
				(signal-problem
				   "Empty body in context requiring expression"
				       " of type "
				       :% target-type
				   (:continue
				      "I will pretend such an expression was found"))))))
	     (values bte undo-stack)))
	 (t
	  (repeat :for ((exp :in body :tail tl)
			(i = offset :by 1)
			(ustack undo-stack)
			te 
			:collector subexps)
	     (!= context
		 (context-expstack-push exp i *-*))
	     (!= < te ustack >
		 (term-check exp
			     (cond ((null (cdr tl)) target-type)
				   (t univ-type*))
			     ustack context bdgs))
	   :collect te
	   :result (values (make-inst Body-typed-exp
			      :type (Typed-exp-type te)
			      :env bdgs
			      :source body
			      :subexps subexps)
			   ustack)))))

(declaim (special fun-type*))

(defun functional-term-check (term target-type undo-stack context mvartypes)
    (let ((high (memq '!& term)))
      (cond (high
             (cond ((eq (car term) '!&)
                    ;; Level-1 application.
                    ;; We have to check for the possibility that
                    ;; the stuff after '!& ' has a special syntax handler
                    ;; If so, we adopt the convention that we pass
                    ;; everything to the handler, with the '!&' tacked on
                    ;; at the end.
                    (multi-let (((h term)
				 (funcall
                                    (Typed-dialect-data-handler-finder
                                       (Syn-context-dialect-handler
                                          context))
                                    (cdr term) mvartypes)))
                       (cond (h
                              (funcall h `(,@term !&) target-type undo-stack
                                       context mvartypes))
                             (t
                              (simple-functional-term-check
                                  1 (cadr term) (cddr term) univ-type*
                                  undo-stack context context mvartypes)))))
                   (t
                    ;; Treat (f --l-- !& --h--) as ((!& f --h--) --l--)
                    (multi-let (((fte undo-stack-1)
                                 (simple-functional-term-check
                                          1 (car term) (cdr high) univ-type*
                                          undo-stack
                                          (context-push-for-function-pos
                                             `(!& ,(car term) ,@(cdr high))
                                             'high-from-!& context)
                                          context
                                          mvartypes)))
                       (app-check 0
                                  fte
                                  (cdr (ldiff term high))
                                  target-type
                                  undo-stack-1
                                  (context-expstack-push
                                     (ldiff term high) 'low-from-!& context)
                                  mvartypes)))))
	    ((type-find-feature target-type 'meta mvartypes)
	     (values (type-term-check term mvartypes)
		     undo-stack))
	    (t
	     (simple-functional-term-check
	        0 (car term) (cdr term)
		target-type undo-stack
		(context-push-for-function-pos
		   (car term) 0 context)
		context mvartypes)))))

(defun simple-functional-term-check (level fcn args target-type undo-stack
				     fcn-context term-context mvartypes)
   (multi-let (((fte undo-stack-1)
		(term-check fcn univ-type* undo-stack
			    fcn-context
			    mvartypes)))
      (multi-let (((rte undo-stack-1)
		   (app-check level fte
			      args
			      target-type
			      undo-stack-1 term-context mvartypes)))
;;;;	 (cond ((eq fcn '=)
;;;;		(dbg-save fte rte args target-type term-context mvartypes)
;;;;		(breakpoint simple-functional-term-check
;;;;			  "rte = " rte)))
	 (values rte undo-stack-1))))

(defun context-push-for-function-pos (fcn-term rel context)
   (cond ((syn-context-lookup context 'lisplang::arg-vs-fcn)
	  (!= context
	      (cons-Syn-context (tuple 'lisplang::arg-vs-fcn false)
				*-*))))
   (context-expstack-push fcn-term rel context))

(defun type-term-check (term mvartypes)
   (cond ((is-type-desig term mvartypes)
	  (let ((ty (designated-type term true mvartypes)))
	     (make-inst Type-typed-exp
		:which ty
		:source term
		:env mvartypes
		:type type-type*)))
	 (t
	  (note-defective-exp
	     ((targ) "Expected type designator, got " targ)
	     :target false
	     :place type-term-check))))

;;;;(defconstant any-args-spec* 
;;;;    (new-Arglistspec
;;;;       !() :rest (list (new-Argspec '_ ':rest univ-type*))))

(defun app-check (level orig-fte args target-type undo-stack context mvartypes)
   (let (fte)
      (!= < fte undo-stack >
	  (type-trans orig-fte
		      (cond ((= level 0)
			     (range-general-funtype level target-type))
			    (t univ-type*))
		      undo-stack
		      (context-expstack-push
			 (Typed-exp-source orig-fte) 0 context)))
      (multi-let (((f-type f-env)
		   (follow-var-ref (Typed-exp-type fte)
				   (Typed-exp-env fte))))
	 (cond ((is-funtype f-type)
		(let ((arglist (type-find-feature f-type 'arglist f-env)))
		   (cond (arglist
			  (cond ((> level 0)
				 (values
				    (high-fcn-apply
				       level arglist args f-type f-env
				       fte
				       (context-find-source-term context)
				       mvartypes)
				    undo-stack))
				(t
				 (low-app-check 
				    arglist args f-type f-env fte
				    undo-stack context mvartypes))))
			 ((> level 0)
			  (signal-problem app-check
			     "High-level function with no arglist: "
			     fte))
			 (t
			  (let ((restype (type-find-feature
					    f-type 'resulttype f-env)))
			     (cond ((not restype)
				    (cond ((is-funtype f-type)
					   (dbg-save :run-loud fte args f-type)
					   (signal-problem app-check
					      "Function with null restype " f-type
					      :% " in " fte))
					  (t
					   (!= restype univ-type*)))))
			     (vanilla-app-check 0 fte restype args target-type
						undo-stack context mvartypes))))))
	       (t
		(note-bugs
		   fte
		   (list (make-Defective-exp
			    :target fte
			    :observation (\\ (targ srm)
					    (out (:to srm)
					       "Nonfunction " targ
					       " in functional position"))
			    :continuable true
			    :signaler (\\ (this-exp)
					 (signal-problem app-check
					    "Nonfunction: " this-exp)))))
		(vanilla-app-check level fte univ-type* args target-type
				   undo-stack context mvartypes))))))

;;; With no information about args, just check them and collect the results
(defun vanilla-app-check (level fte restype args target-type
			  undo-stack context mvartypes)
   (let ((arg-positions (series 1 (len args)))
	 (arg-targ-type (cond ((= level 0) univ-type*)
			      (t type-type*)))
	 (tel !())
	 (ustack undo-stack))
      (repeat :for ((a :in args)
		   (k :in arg-positions))
	 (multi-let (((te undo-stack-2)
		      (term-check
			   a arg-targ-type
			   ustack (context-expstack-push a k context)
			   mvartypes)))
	    (!= tel (cons te *-*))
	    (!= ustack undo-stack-2)))
      (!= tel (reverse *-*))
      (let ((arglist
		  (new-Arglistspec
		     (<# (\\ (arg-te)
			    (new-Argspec
			       '_ ':required (Typed-exp-type arg-te)))
			 tel))))
	 (!= < fte ustack >
	     (type-trans fte
			 (make-funtype
			       0 target-type
			       (arglistspec-argtype
				  arglist empty-env*)
			       (args->spec (list restype))
			       arglist true empty-env*)
			 ustack context))
	 (values (build-res-typed-exp
		    0 fte tel arg-positions
		    (<# (\\ (_) arg-targ-type)
			tel)
		    (car (context-find-source-term context))
		    !() mvartypes restype)
		 ustack))))

(defun high-fcn-apply (level alspec args f-type f-env fte source mvartypes)
   (multi-let (((arg-vtl _ prefs)
		(tyfun-alspec-args-resolve
			alspec args false
			mvartypes `(,(Typed-exp-source fte)
				    ,@args))))
      (!= arg-vtl
	  (tyfun-args-close *-* mvartypes))
      (let ((r-type
	       (type-must-find-feature
		  f-type 'resulttype
		  (env-bindings-append true arg-vtl f-env))))
	 (let ((actual-fcn (Typed-exp-check-time-callable fte)))
	    ;;;;(out "actual-fcn = " actual-fcn :%)
	    (cond (actual-fcn
		   (funcall actual-fcn arg-vtl prefs r-type mvartypes))
		  (t
		   (build-res-typed-exp
		       level fte
		       (<# (\\ (vt)
			      (let ((vty (Vartype-type vt))
				    (vval (Vartype-val vt)))
				 (cond ((type-feature vty 'meta)
					(make-inst Type-typed-exp
					   :type vty
					   :source (type-find-designator vval mvartypes)
					   :env mvartypes
					   :which vval))  ; tvars?
				       (t
					(make-inst Const-typed-exp
					   :val vval
					   :type vty
					   :source vval
					   :env mvartypes)))))
			   arg-vtl)
		       prefs
		       ;; Probably works 99.9% of the time:
		       (<# (\\ (_) type-type*)
			   arg-vtl)
		       source !() mvartypes r-type)))))))

(defun low-app-check (spec args f-type f-env fte undo-stack context mvartypes)
   (multiple-value-let (tel prefs arg-targs _ pathology undo-stack)
		       (args-check args spec f-env
				   undo-stack context mvartypes)
      (let ((r-type
	       (type-must-find-feature
		   f-type 'resulttype f-env)))
	 (values (build-res-typed-exp
		    0 fte tel prefs arg-targs
		    (context-find-source-term context)
		    pathology mvartypes r-type)
		 undo-stack))))

(defun simple-app-typed-exp (fcn-te arg-tel arg-types source
			     target-type mvartypes)
   (build-App-typed-exp
      0 fcn-te
      arg-tel
      (series 1 (+ 1 (len arg-tel)))
      arg-types
      mvartypes target-type false source))

(defun simple-var-typed-exp (sym env)
   (let ((vt (var-lookup sym env)))
      (cond (vt
	     (var-val-typed-exp (Vartype-val vt)
				vt sym
				(make-Syn-context
				   false (list (tuple 'arg-vs-fcn true)))
				env))
	    (t
	     (signal-problem simple-var-typed-exp
		"Unbound variable: " sym)))))

(defun build-Var-typed-exp (sym source type env)
   (make-inst Var-typed-exp
	      :var sym
	      :qvar (is-Qvar source)
	      :source source
	      :env env
	      :type type
	      :binder false
	      :argspec (var-lookup sym env)))

(defun build-res-typed-exp (level fte tel prefs arg-targs
			    source pathology env r-type)
   (let ((appte (build-App-typed-exp level fte tel prefs arg-targs
				     env r-type false source)))
      (cond ((not (null pathology))
	     (note-defective-exp
	         ((targexp)
		  "Parsing errors: " pathology 1
		  (:pp-nl :linear)
		  "  in " targexp)
		 :target appte
		 :place build-res-typed-exp
		 )))
      appte))

; (defun argtypes->argtype (argtypes)
;    (build-argtype (args->spec argtypes)
; 		 (freevars-union
; 		    (<$ Type-freevars argtypes)
; 		    '())))

;;;(defvar lst-type-fun*
;;;    (let ((vt (name-lookup universal-type-sys* 'Lst)))
;;;	   (cond ((and vt
;;;		       (eq (Vartype-type vt) tyfun-type*))
;;;		  (Vartype-val vt))
;;;		 (t
;;;		  (error-break lst-type-fun* :fatal
;;;		     "Lst type-fun not defined yet")))))

;;; Returns 
;;; < list of Typed-exps, 
;;;   list of "arg prefixes" ((:key) or pos),
;;;   list of target types,
;;;   list of argnames (which no one uses),
;;;   list of bugs,
;;;   undo-stack >
;;; All but the last are the same length and synchronized.
(defun args-check (argl parms-alspec parms-env
		   undo-stack super-context mvartypes)
   (multiple-value-let (regular-pairs rest-pair pathology)
		       (params-args-pair parms-alspec argl)
      (let ((tel '())
	    (prefs '())
	    (targs !(Type))
	    (argnames '())
	    (context (context-expstack-push ':ready-to-check-args
					    ;;`(*** ,@argl)
					    0
					    super-context))
	    (ustack undo-stack))
	 (repeat :for ((s :in (Arglistspec-all-nonrest-argspecs parms-alspec)))
	    (let ((ap (assq s regular-pairs))
		  (arg-target-type (Argspec-type s))
		  (ate false))
	       (cond (ap
		      (!= context (context-expstack-next
				     (cadr ap) (Argspec-position s)
				     *-*))
		      (!= < ate ustack >
			  (arg-check-start (cadr ap)
				(new-Type-closure arg-target-type
						  parms-env)
				ustack context mvartypes)))
		     ((not (eq (Argspec-mode s) ':required))
		      ;;; Use default
		      (let ((dflt (Argspec-default s)))
			 (cond ((is-Typed-exp dflt)
				;; already checked
				(!= ate dflt))
			       (t
				(out (:to *error-output*) "Unparsed default for arg "
				     s " in " argl :%)
				(!= context (context-expstack-next
					       dflt (Argspec-position s)
					       *-*))
				(!= < ate ustack >
				    (term-check dflt
						(Argspec-type s)
						ustack context mvartypes)))))))
	       (!= prefs
		   (cons (argspec-arg-position s) *-*))
	       (!= targs (cons arg-target-type *-*))
	       (!= argnames (cons (Argspec-name s) *-*))
	       (cond (ate
		      (!= tel (cons ate *-*)))
		     (t
		      (!= tel (cons (make-inst Var-typed-exp
				       :var '|**Missing_Arg**|
				       :qvar false
				       :source '|**Missing_Arg**|
				       :env mvartypes
				       :type (Argspec-type s)
				       :binder false
				       :argspec false)
				    *-*))))
		      ;;(out "Warning: no arg for " s :%)
		      ))
	 (cond ((car rest-pair)
		(multi-let (((rest-tel rest-prefs rest-targs rest-names
			      rest-pathology ustack)
			     (rest-args-check
				(car rest-pair)
				parms-env
				(cadr rest-pair)
				ustack context mvartypes)))
		   (!= targs (nconc (reverse targs) rest-targs))
		   (!= argnames (nconc (reverse argnames) rest-names))
		   (!= pathology (nconc pathology rest-pathology))
		   (!= tel (nconc (reverse tel) rest-tel))
		   (!= prefs (nconc (reverse prefs) rest-prefs))
		   (!= ustack
		       (finish-arg-checks tel
					  prefs
					  super-context ustack))))
	       (t
		(!= targs (reverse targs))
		(!= argnames (reverse argnames))
		(!= tel (reverse tel))
		(!= prefs (reverse prefs))
		(!= ustack 
		    (finish-arg-checks tel prefs super-context ustack))))
	 (values tel prefs targs argnames pathology ustack))))

(defun rest-args-check (rest-argspec parms-env rest-args
			undo-stack context mvartypes)
   ;; &rest is nonredundant, so turn extra args into list
   ;; or tuple
   (!= context (context-expstack-next
		  ':ready-to-check-&rest
		  (rest-argspec-pos-adjust rest-argspec)
		  *-*))
   (multi-let (((hairy-rest rest-ty rtyenv)
		(rest-arg-analyze rest-argspec)))
      (repeat :for ((a :in rest-args)
		    (arg-target-type (new-Type-closure rest-ty parms-env))
		    (arg-targs !(Type))
		    (okay true) ate
		    (tel '())
		    (pathology '())
		    (ustack undo-stack))
	 (cond (hairy-rest
		(!= < okay arg-target-type rest-ty _ >
		    (type-tup-split rest-ty true true '() rtyenv))))
;;; BUG: The case where hairy-rest = unknown is not properly
;;; handled.         
       :while okay
	 (!= context
	     (context-expstack-advance *-*))
	 (!= < ate ustack >
	     (arg-check-start a arg-target-type ustack context mvartypes))
	 (!= tel (cons ate *-*))
	 (!= arg-targs (cons arg-target-type *-*))
       :result (progn
		 (cond (okay
			(cond (hairy-rest
			       (!= < okay ustack >
				   (type-acceptable
				      true rest-ty empty-tup-type*
				      ustack rtyenv global-env* !()))
			       (cond ((not okay)
				      (!= pathology
					  (cons '("Too few args")
						*-*)))))))
		       (t
			(!= pathology
			    (cons '("Too many args")
				  *-*))))
		 (values (reverse tel)
			 (rest-args-prefs tel rest-argspec)
			 (reverse arg-targs)
			 (list (Argspec-name rest-argspec))
			 pathology 
			 ustack)))))

(defun rest-arg-analyze (rest-argspec)
   (multi-let (((rest-ty rtyenv)
		(follow-var-ref (Argspec-type rest-argspec)
				global-env*)))
      (values (Argspec-seg-type rest-argspec)
	      rest-ty rtyenv)))
				       
(defun rest-argspec-pos-adjust (aspec)
   (let ((rpos (Argspec-position aspec)))
      (cond ((and (listp rpos)
		  (is-Number (car rpos)))
	     (- (car  rpos) 1))
	    (t
	     (signal-problem rest-argspec-pos-adjust
		"Bogus position in &rest Argspec: " rpos 1 aspec
		(:novalue "I will try to cope"))
	     0))))

(defun arg-pref-down (num-so-far num-added)
   (letrec ((count-down (n)
	       (cond ((= n num-so-far) '())
		     (t
		      (cons n (count-down (- n 1)))))))
      (count-down (+ num-so-far num-added))))

;;; Some terms should get special treatment when they occurs as an
;;; arg to a function.
(defvar arg-term-handler-tab* !())

(defun arg-check-start (term target-type undo-stack context mvartypes)
   (funcall (let ((h (and (is-Pair term)
			  (assq (car term) arg-term-handler-tab*))))
	       (cond (h (cadr h))
		     (t #'term-check)))
;;;;	    (cond ((matchq (\\ ?@_) term)
;;;;		   #'lambda-term-check)
;;;;		  (t #'term-check))
	    term target-type undo-stack context mvartypes))

(defun finish-arg-checks (arg-typed-exps prefs super-context undo-stack)
   (repeat :for ((te :in arg-typed-exps)
		 (pref :in prefs) ; used only for context hacking
		 (ustack undo-stack))
    :result ustack
      (cond ((and (is-App-typed-exp te)
		  (App-typed-exp-hidden te)
		  (is-Lambda-typed-exp (App-typed-exp-fcn te)))
	     ;; Probably the result of 'high-fcn-hide'.
	     (!= te (App-typed-exp-fcn te))
	     (!= pref (high-lambda-pref-compose *-*))
	     ))
      (let ((finisher (Typed-exp-postponed te)))
	 (cond (finisher
		(!= ustack (funcall finisher te pref super-context ustack)))))))

(defun high-lambda-pref-compose (orig-pref)
   (\\ (e)
      (letrec ()
	 (cond ((is-Integer orig-pref)
		(cond ((and (>= orig-pref 0)
			    (< orig-pref (len e)))
		       (let ((tail (nthcdr orig-pref e)))
			  (do-compose
			     (ldiff e tail)
			     (car tail)
			     (cdr tail))))
		      (t
		       (values false nil))))
	       ((is-Keyword orig-pref)
		(repeat :for ((el (cdr e) (cddr el)))
		 :while (and (not (null el))
			    (not (null (cdr el))))
		 :result (values false nil)
		 :until (eq (car el) orig-pref)
		 :result (do-compose
			   (ldiff e (cdr el))
			   (cadr el)
			   (cddr el))))
	       (t
		(values false nil)))
       :where
         (do-compose (beg-outer inner end-outer)
	    (match-cond inner
	       ?( (\\ ?@lev-1-stuff (\\ ?@lev-0-stuff))
		 (values true
			 `(,@beg-outer
			   (\\ ,@lev-1-stuff
			      ,(make-Noted-piece (list `(\\ ,@lev-0-stuff))))
			   ,@end-outer)))
	       (t
		(values false nil)))))))

(defun high-from-!& (term)
   (let ((high-args (memq '!& term)))
      (cond ((and high-args (not (eq high-args term)))
	     (values true
		     `(,(make-Noted-piece (list (car term)))
		       ,@(ldiff (cdr term) (cdr high-args))
		       ,(make-Noted-piece (cdr high-args)))))
	    (t
	     (values false nil)))))

(defun low-from-!& (term)
   (let ((high-args (memq '!& term)))
      (cond ((and high-args (not (eq high-args term)))
	     (values true
		     `(,(make-Noted-piece (ldiff term high-args))
		       ,@high-args)))
	    (t
	     (values false nil)))))

(defun last-sub-exp (term)
   (values true `(,@(drop -1 term) ,(make-Noted-piece (last term)))))

(defun last-of-last (term)
   (let ((le (lastelt term)))
      (let ((le-note
	       `(,@(drop -1 le) ,(make-Noted-piece (last le)))))
	 (values true `(,@(drop -1 term) ,le-note)))))


(defun te-list-tvars (te-list nucleus)
   (letrec ((remove-bounds (tvl)
	       (<? (\\ (tv) (not (Typebdg-val (tvar-type-bdg tv))))
		   tvl)))
      (</ (\\ (tvl te)
	     (tvars-union (remove-bounds (Typed-exp-tvars te)) tvl))
	  (remove-bounds nucleus)
	  te-list)))

;;; Convenience in calling try-accept when id and env are packaged into 
;;; wanted, a typeclo; and undo-stack is irrelevant.
(defun type-check (got wanted envg)
   (try-accept got wanted (empty-undo-stack) envg empty-env* !()))

(defvar break-when-bugs-noted* false)

;;;;(defvar noted-bugs* '())
;;;;(defvar noted-te* nil)

(defun note-bugs (te ill-formed-subexps)
   (cond ((and ill-formed-subexps
	       (not (consp ill-formed-subexps)))
	  (signal-problem note-bugs
	     "Non-list argument to note-bugs: " ill-formed-subexps
	     (:novalue "I will make a list out of it"))
	  (!= ill-formed-subexps (list *-*))))
   (repeat :for ((s :in ill-formed-subexps))
      (cond ((not (is-Defective-exp s))
	     (signal-problem note-bugs :fatal
		"Illegal in Typed-exp bug list: " s))))
   (cond ((not (null ill-formed-subexps))
	  ;(out (tr note-bugs ("note-bugs> " te 1 (len ill-formed-subexps))
	  (progn 
	     (cond (break-when-bugs-noted*
		    (dbg-save :run-loud ill-formed-subexps te)
		    (error-break note-bugs :novalue
		       "New bugs: " ill-formed-subexps :% " on " te)))
	     (!= (Typed-exp-bugs te)
		 (append *-* ill-formed-subexps))
	     (!= (Typed-exp-totbugs te)
		 (+ *-* (len ill-formed-subexps))))
	  ;("note-bugs<")))
	  ))
   te)

(defun conj-append (c1 c2)
   (let ((cl1 (cond ((eq (car c1) 'and)
		     (cdr c1))
		    (t (list c1))))
	 (cl2 (cond ((eq (car c2) 'and)
		     (cdr c2))
		    (t (list c2)))))
      (let ((cl (append cl1 cl2)))
	 (cond ((= (length cl) 1) (car cl))
	       (t `(and ,@cl))))))

(defun syn-context-long-body-wrapper (cxt)
   (let ((e (syn-context-lookup cxt 'long-body-wrapper)))
      (and e (cadr e))))

(defmacro type-declare (sym tydesig sys)
   `(typedecl ',sym (compile-time-designated-type ,tydesig ,sys)
	      nil (find-type-system ',sys true)))




