;-*- Mode: Common-lisp; Package: lisplang; Readtable: ytools; -*-
(in-package :lisplang)
;;; $Id: typeconseq.lisp,v 1.7 2004/04/27 14:13:34 dvm Exp $

(depends-on :at-run-time %nity/ tloader istester types altformer
				typeintsect
			 %lisplang/ typedexp )

(eval-when (:compile-toplevel :load-toplevel :slurp-toplevel)
   (export '(typed-exp-type-narrow
	     type-infer-conseqs fcn-type-invert
	     vt->tyic vartypes-disjoin type-as-boolean)))

;;; Returns < consistent, new-vartypes >
;;; Every undoable action taken during narrowing must actually be
;;; undone.
(defun typed-exp-type-narrow (te this-vs-complement proposed-type)
   (let ((prev-type (Typed-exp-type te)))
      (multi-let (((consistent vacuous new-type)
		   (types-intersect-non-trivially
		      prev-type this-vs-complement proposed-type)))
	 (cond ((and consistent (not vacuous))
		(cond ((is-Var-typed-exp te)
		       (let ((vt (new-Vartype
					(Var-typed-exp-var te)
					new-type
					(Vartype-val
					   (Var-typed-exp-argspec
					      te)))))
			  (!= (vartype-feat vt ':binder)
			      (Var-typed-exp-binder te))
			  (values true (list vt))))
		      (t
		       (multi-let (((consis vtl)
				    (type-infer-conseqs
				       te new-type)))
			  (cond (consis
				 (repeat :for ((vt :in vtl)
					      (res '())
					      exp-vts)
				    (!= < consis exp-vts >
					(match-cond (Vartype-type vt)
					   ?( (not ?newty)
					     (typed-exp-type-narrow
						  (Vartype-var vt)
						  false newty))
					   (t
					    (typed-exp-type-narrow
					       (Vartype-var vt)
					       true
					       (Vartype-type vt)))))
				    (cond (consis
					   (!= res
					       (append exp-vts *-*))))
				  :while consis
				  :result (progn
					   (values consis res))))
				(t
				 (values false nil)))))))
	       (t
		(values consistent '()))))))
	  
;;; Return < consistent, vacuous, intersection >
;;; intersection is non-nil only if consistent and non-vacuous.
;;; "vacuous" means redundant or inexpressible.
;;; Neither type is allowed to have any free params.
(defun types-intersect-non-trivially
               (current-type intersect-vs-complement proposed-type)
   (multi-let (((expressible int-type undo-stack)
		(types-intersect true
				 true current-type
				 intersect-vs-complement proposed-type
				 !(Undo) empty-env* empty-env* '())))
      (undo undo-stack !())
      (cond ((and expressible
		  (not (type-acceptable false current-type int-type
					'() empty-env* empty-env* '())))
	     (cond ((eq int-type void-type*)
		    (values false false nil))
		   (t
		    (values true false int-type))))
	    (t
	     (values true true nil)))))

;;; Given the type of Typed-exp te, infer which variables have further
;;; constrained types.  Returns < consistent, (Lst Vartype) >.
;;; If consistent, the vartypes give the new types of various expressions
;;; (often empty).  If inconsistent, this Typed-exp cannot have this type
;;; as far as we can tell.
;;; The Vartypes returned are "artificial" in that (a) their vals are
;;; always nil, and are not examined by anyone; (b) their vars are 
;;; not symbols, but Typed-exps; (c) their
;;; types are either real types, or of the form (not <realtype>).
;;; (Elsewhere we occasionally refer to these as "tyic-vartypes.")
;;; It's the caller's problem to do further inference from the claim
;;; that the given expression has the given expanded type.
;;; The default is to infer that the new information is consistent but
;;; vacuous.
(def-op type-infer-conseqs (te type)
                           (ignore type)
   (values true '()))

(def-meth type-infer-conseqs ((vte Var-typed-exp) ty)
   (values true (list (new-Vartype vte
				   ty
				   false))))
   
(def-meth type-infer-conseqs ((ate App-typed-exp) ty)
   (let ((fte (App-typed-exp-fcn ate)))
      (cond ((is-Const-typed-exp fte)
	     (fcn-type-invert
	         (Const-typed-exp-val fte) ty (App-typed-exp-args ate)))
	    (t
	     (multi-let (((var env)
			  (cond ((is-Var-typed-exp fte)
				 (values (Var-typed-exp-var fte)
					 (Typed-exp-env fte)))
				((and (is-App-typed-exp fte)
				      (App-typed-exp-hidden fte))
				 (let ((v (App-typed-exp-fcn fte)))
				   (cond ((is-Var-typed-exp v)
					  (values (Var-typed-exp-var v)
						  (Typed-exp-env v)))
					 (t
					  (values false nil)))))
			      (t
			       (values false nil)))))
;;;;		(dbg-save var env ate fte)
;;;;		(breakpoint App-te-type-infer-conseqs
;;;;		   "var = " var "  env = " env)
		(cond (var
		       (let ((fbdg (var-lookup var env)))
			  (cond ((and fbdg
				      (not (eq (Vartype-val fbdg)
					       '*unbound)))
				 (fcn-type-invert
				    (Vartype-val fbdg)
				    ty (App-typed-exp-args ate)))
				(t
				 (note-defective-exp
				     ((e) "Unbound function: " e)
				     :target ate)))))
		      (t
		       (values true '()))))))))

;;; Given an object representing what's known about a function,
;;; infer type consequences of its value having type type.
;;; Returns < consistent, new-vartypes >
(def-op fcn-type-invert (run-time-ob-descrip type args)
                        (ignore type args)
;;;;  (out "fcn-type-invert has trivial answer for "
;;;;       run-time-ob-descrip :%)
  (values true !()))

;;; Any var with a Vartype in *every* list should get the
;;; Alt of the types it has.
;;; These are normal lists, not 'type-infer-conseq'-style lists.
(defun vartypes-disjoin (vartype-lists)
   (cond ((null vartype-lists)
	  '())
	 (t
	  (let ((var-n-binders
		   (<? (\\ (var-n-binder)
			  (forall (vtl in (cdr vartype-lists))
			     (let ((vt (vartypes-lookup (car var-n-binder)
							vtl)))
				(and vt
				     (eq (vartype-feat vt ':binder)
					 (cadr var-n-binder))))))
		       (<# (\\ (vt)
			      (tuple (Vartype-var vt)
				     (vartype-feat vt ':binder)))
			   (car vartype-lists)))))
	    (<! (\\ (var-n-binder)
		    (let ((res-ty (make-alt-type
				     (<# (\\ (vtl)
					    (Vartype-type
					       (vartypes-lookup
						  (car var-n-binder)
						  vtl)))
					 vartype-lists)
				     empty-env*)))
		       (cond ((types-equal res-ty univ-type*
					   empty-env* global-env*)
			      ;; vacuous
			      '())
			     (t
			      (let ((res-vt
				       (new-Vartype (car var-n-binder)
						    res-ty false)))
				 (!= (vartype-feat res-vt ':binder)
				     (cadr var-n-binder))
				 (list res-vt))))))
		 var-n-binders)))))

;;; Convert to artificial Vartype as produced by type-infer-conseqs
(defun vt->tyic (vt env)
   (let ((old-binding (var-lookup (Vartype-var vt)
				  env))
	 (binder (vartype-feat vt ':binder)))
      (cond ((and old-binding
		  (eq (vartype-feat old-binding ':binder)
		      binder))
	     (new-Vartype (make-inst Var-typed-exp
			     :var (Vartype-var vt)
			     :qvar false
			     :source (Vartype-var vt)
			     :type (Vartype-type old-binding)
			     :env env
			     :binder binder
			     :argspec vt
			     :check-time-callable false)
			  (Vartype-type vt)
			  false))
	    (t
	     (dbg-save :run-loud old-binding binder vt)
	     (signal-problem vt->tyic
		(:q (old-binding
		    "Binder fumbled: ")
		   (t
		    "Variable unbound: "))
		vt :% env)))))
		   
;;; Useful in type-conseq inferers
(defun type-as-boolean (ty env)
   (multi-let (((cl found)
		(type-find-feature ty 'consts env)))
      (cond (found
	     (cond ((equal cl '(false)) 'false)
		   ((not (memq 'false cl)) 'true)
		   (t false)))
	    (t
	     (let ((tab (type-find-feature
			   ty 'type-as-boolean-checker env)))
	        (cond (tab
		       (funcall (nisptype::coerce-to-fun tab) ty env))
		      (t false)))))))

