;-*- Mode: Common-lisp; Package: lisplang; Readtable: ytools; -*-
(in-package :lisplang)
;;; $Id: typedexp.lisp,v 1.24 2006/02/27 14:55:50 dvm Exp $

(depends-on %module/ ytools)

(depends-on :at-run-time %nity/ funformers typewalk)

(depends-on :at-compile-time %nity/ tloader funformers foundation)

;; Definitions of Typed-exp and subclasses 

(eval-when (:slurp-toplevel :compile-toplevel :load-toplevel)
   (export '(Typed-exp is-Typed-exp 
	     Typed-exp-flag Typed-exp-type Typed-exp-env 
	     Typed-exp-source Typed-exp-ext
	     Typed-exp-bugs Typed-exp-totbugs Typed-exp-tvars
	     Typed-exp-subexps ;; Typed-exp-ovl-queue 
	     Typed-exp-already-transed Typed-exp-check-time-callable
	     Typed-exp-scope-time-interval Typed-exp-postponed
	     Typed-exp-set-scope-times
	     Var-typed-exp Var-typed-exp-qvar Var-typed-exp-var
	     is-Var-typed-exp
	     App-typed-exp is-App-typed-exp App-typed-exp-level
	     App-typed-exp-fcn App-typed-exp-arg-positions
	     App-typed-exp-args App-typed-exp-hidden
	     App-typed-exp-arg-targ-types
	     hidden args arg-positions fcn 
	     Const-typed-exp new-Const-typed-exp Const-typed-exp-val
	     is-Const-typed-exp
	     Const-typed-exp-source Const-typed-exp-is-literal
	     const-vt-typed-exp const-var-typed-exp
	     Body-typed-exp is-Body-typed-exp make-Body-typed-exp
	     Type-typed-exp is-Type-typed-exp Type-typed-exp-which
	     Binder-typed-exp
	     Binder-typed-exp-bindings Binder-typed-exp-level
             Binder-typed-exp-body
	     Lambda-typed-exp 
	     Unchecked-typed-exp is-Unchecked-typed-exp
	     Unchecked-typed-exp-source
	     flag type env source ext bugs totbugs tvars scope-time-interval
	     check-time-callable already-transed
	     subexps break-when-bugs-noted* break-on-flag*
             attach-features is-of-type
	     is-tester-type* var-val-typed-exp
	     make-Prechecked is-Prechecked Prechecked-te te-list-totbugs)))

#+pre-chunk
(slurp-whole-file)

;;; The key idea is that every syntactic form (if, repeat, let, ...)
;;; has its own subclass of this class.  The definitions are sprinkled 
;;; in various places. 
(def-class Typed-exp (:options (:medium :object) :key)
   flag   ;; (Const var const app fun ...)
   type   ;; Type or Type-closure
   env    ;; Bindings of all free vars in fields other than type
          ;;  (type must be a type-closure to preserve an env)
   source ;; Source this was derived from
   ext    ;; External representation -- Should look like source, but
          ;; perhaps cleaned up (or macro-expanded, or whatever).
   bugs   ;; Errors detected here
   totbugs  ;; Total number of bugs here and below
   tvars  ;; tvars created here or below that might occur in type
   scope-time-interval ;; (begin end) -- scope-times bounding
                       ;; tvar scope times.
   subexps ;; List of all Typed-exp's immediately below this one.
   check-time-callable  ;; false or a function that should actually
                          ;; be called if this Typed-exp occurs in functional
                          ;; position.
   already-transed ;; If true, type-trans need do nothing with this.
   (postponed false)
   ;; -- if non-false, a function that finishes processing this Typed-exp, which 
   ;; is the result of checking an expression that appeared as a function
   ;; argument
   ;;   val-conseqs  ;; (Lst (Tup Obj (Lst (Tup Typed-exp Obj)))): 
                ;;   Consequences of this
                ;;   Typed-exp having various possible values.

   (:handler
      (print (dc s)
	 (cond ((and (not (streamp s))
		     (not (memq s '(t nil))))
		(signal-problem typed-exp-printer
		   "Bogus stream: " s)))
	 (let ((ty (Typed-exp-type dc)))
	    (out (:to s)
	       (:pp-block (:pre "#{")
		 (:pp-ind :block 2)
		 (:q ((not (null (Typed-exp-tvars dc)))
		     "?" (<# tvar-type-varname
			     (Typed-exp-tvars dc))
		     (:pp-nl :linear)))
		 "/" (:q ((is-Type-closure ty)
			 ;; Stream var never used, because body is all e.
			 ;; Generates annoying warning message.  "" makes
			 ;; it go away
			 (:e (type-closure-condense-print ty s)) "")
			((is-Type ty)
			 (Type-desig ty))
			(t ty))
		 (:pp-nl :linear)
		 "/"
		 (:q ((not (numberp (Typed-exp-totbugs dc)))
		     (Typed-exp-totbugs dc) "? ")
		    ((> (Typed-exp-totbugs dc) 0)
		     "[" (Typed-exp-totbugs dc) " bugs]"))
		 (or (Typed-exp-ext dc)
		     (Typed-exp-source dc))
		 (:suf "}")))))))

(def-meth initialize :before ((tc Typed-exp))
   (slot-defaults tc
		  bugs '()
		  env global-env*
		  subexps '()
		  tvars (</ (\\ (tvl sub)
			       (tvars-union tvl (Typed-exp-tvars sub)))
			    '() (Typed-exp-subexps tc))
		  totbugs (</ (\\ (tot sub-te)
				 (+ tot (Typed-exp-totbugs sub-te)))
			      (len (Typed-exp-bugs tc))
			      (Typed-exp-subexps tc))
		  scope-time-interval (tuple 0 scope-time*)
		  source '*random*
		  ext (Typed-exp-source tc)
		  ;;ovl-queue false
		  ;;val-conseqs '()
		  check-time-callable false
		  already-transed false))

(defun Typed-exp-set-scope-times (te beg end)
   (!= (Typed-exp-scope-time-interval te)
       (tuple beg end))
   te)

(def-class Var-typed-exp (:options (:include Typed-exp))
   qvar ;; true if derived from ?var
   var
   binder  ;; Typed-exp or axiom that binds this one; false if global
   argspec   ;; The Vartype in binder
   (:handler
      (initialize :before ((tc Var-typed-exp))
	 (slot-defaults tc
			flag 'var
			binder false))))

(def-class Const-typed-exp (:options (:include Typed-exp))
   val
   ;; -- Literals in the form (quote <actual-val>), because
   ;; fred and 'fred are not the same object.
   is-literal)
   ;; -- true if it's a literal like "abc" as opposed to a constant
   ;; like 'table' is the blocks world.

;;; The 'is-literal' field might seem a trifle redundant, but
;;; perhaps a quoted val might pop up some day that shouldn't be
;;; classified as a literal.
    
(def-meth initialize :before ((tc Const-typed-exp))
   (slot-defaults tc
		  flag 'const
		  is-literal (matchq (:quote (quote ?_))
				     (Const-typed-exp-val tc))
		  ))

(defun new-Const-typed-exp (val type source mvartypes)
   (make-inst Const-typed-exp
      :val val
      :type type
      :source source
      :ext val
      :env mvartypes))

#| 
(defun const-vt-typed-exp (vt env)
   (let ((const (Vartype-val vt)))
      (make-inst Const-typed-exp
	 :val const
	 :source (Vartype-var vt)
	 :ext (Const-name const)
	 :type (Vartype-type vt)
	 :env env)))
|#

(def-class Body-typed-exp
	   (:options (:include Typed-exp))
  (:handler
      (initialize :before ((bte Body-typed-exp))
   	 (slot-defaults bte flag 'body))))

(def-class App-typed-exp (:options (:include Typed-exp))
   level 
   fcn
   arg-positions  ;; (Lst (Alt Integer Keyword (Tup Integer)))
     ;; formerly prefixes  ; &rest, (:keyword), or ()
   args
   arg-targ-types ;; needed by opt/internalize
   hidden   ; true if this was inferred by type-trans, and should be hidden 
   (:handler
      (initialize :before ((tc App-typed-exp))
	 (slot-defaults tc
			flag 'app level 0 hidden false
			subexps (cons (App-typed-exp-fcn tc)
				      (App-typed-exp-args tc))))))

(def-class Type-typed-exp (:options (:include Typed-exp))
   which)

(def-meth initialize :before ((tc Type-typed-exp))
   (slot-defaults tc
		  flag 'type
		  type type-type*))

;; The source is all there is
(def-class Unchecked-typed-exp (:options (:include Typed-exp))
   (:handler
      (initialize :before ((ute Unchecked-typed-exp))
	 (slot-defaults ute
			flag 'unchecked
			ext (Typed-exp-source ute)
			env '()))))

(defun ill-formed-typed-exp (source target-type env)
       (make-inst Unchecked-typed-exp
	  :flag 'ill-formed
	  :type target-type
	  :source source
	  :env env
	  :bugs (list (simple-ill-formed-exp "Ill-formed expression" source))
	  :totbugs 1))

(def-class Binder-typed-exp (:options (:include Typed-exp))
   bindings  ;; vartypes OR arglistspec
   level  ; > 0 if binding types.
   body  ; either a Typed-exp or false if from subclass
          ; with no well defined body
   (:handler
       (initialize :before (bte)
          (slot-defaults bte
                         level 0))))

(def-class Lambda-typed-exp (:options (:include Binder-typed-exp))
   head
   params   ;; an Arglistspec; duplicates some info in bindings
   side-effects
   fundef-rec ;; Fundef-rec for this function (see funsyn.lisp)
   (:handler
      (initialize :before (lte)
	 (slot-defaults lte
			flag 'lambda
			head '\\
			side-effects false)))
)

;;; Allows a value such as Constant in Opt to change what kind of
;;; Typed-exp is built.
(def-op var-val-typed-exp (val vt source context env)
                          (ignore context)
   (let ((sym (Vartype-var vt))
	 (type (Vartype-type vt)))
      (multi-let (((stype svartypes)
		   (follow-var-ref type env)))
;;;;	 (dbg-save val vt context env)
;;;;	 (breakpoint var-val-typed-exp
;;;;	    "vt = " vt)
	 (make-inst Var-typed-exp
	    :var sym
	    :qvar (is-Qvar source)
	    :source source
	    :ext sym
	    :type (new-Type-closure type env)
	    :env env
	    :binder (vartype-feat vt ':binder)
	    :argspec vt
	    :check-time-callable
		  (cond ((and val
			      (is-funtype stype)
			      (> (type-find-feature
				    stype 'level svartypes)
				 0))
			 val)
			(t false))))))

(def-meth var-val-typed-exp ((val Type) vt source context env)
                            (ignore context)
   (let ((var (Vartype-var vt))
	 (type (Vartype-type vt)))
      (multi-let (((stype svartypes)
		   (follow-var-ref type env)))
	 (cond ((not (type-feature stype 'nity::meta svartypes))
		(dbg-save :run-loud stype svartypes vt)
		(signal-problem var-val-typed-exp
		   "Vartype has Type value without being of meta-Type itself: "
		   :% vt
		   (:continue
		    "I will treat it as some weird kind of variable"))
		(make-inst Var-typed-exp
		   :var var
		   :qvar (is-Qvar source)
		   :source source
		   :env env
		   :binder (vartype-feat vt ':binder)
		   :argspec vt))
	       (t
		(make-inst Type-typed-exp
		   :which val
		   :source source
		   :ext (Type-desig val)
		   :env env
		   :type type))))))

(def-class Prechecked 
   te) ;; of type Typed-exp


(def-meth var-val-typed-exp ((pv Prechecked) _ _ _ _)
   (Prechecked-te pv))

;;;;(defun app-te-rebuild-arglist (app-te)
;;;;   (args-sort-and-flag (App-typed-exp-arg-positions app-te)
;;;;		       (App-typed-exp-args app-te)))

(defun args-sort-and-flag (arg-positions tel)
   (letrec ()
      (let ((pairs (pos-arg-pairs arg-positions tel)))
	 (!= pairs
	     (stable-sort *-* #'arg-pos-<
			  :key #'car))
	 (<! (\\ (p)
		(let ((s (arg-pos-mode (car p))))
		   (case s
		      (:rest
		       (list-copy (cadr p)))
		      (:positional
		       (list (cadr p)))
		      (t `(,(car p) ,(cadr p))))))
	     pairs))
    :where
      (pos-arg-pairs (posl tel)
	 (cond ((null posl)
		(cond ((null tel) '())
		      (t (signal-problem args-sort-and-flag
			    "Leftover args: " tel
			    (:novalue "I will ignore them")))))
	       ((or (is-Integer (car posl)) (is-Keyword (car posl)))
		(cons (tuple (car posl) (car tel))
		      (pos-arg-pairs (cdr posl) (cdr tel))))
	       (t
		(list (tuple (car posl) tel)))))))

(defun params-bind-to-tvars (vl)
   (<# (\\ (v)
	  (new-Vartype v type-type* (anon-tvar true v type-type*)))
       vl))

(defun sym-maybe-qvarify (sym qvar)
   (cond (qvar (make-Qvar sym '()))
	 (t sym)))

(defun te-list-totbugs (te-list)
   (</ (\\ (tot te) (+ tot (Typed-exp-totbugs te)))
       0
       te-list))

