;-*- Mode: Common-lisp; Package: lisplang; Readtable: ytools; -*-
(in-package :lisplang)
;;; $Id: typetrans.lisp,v 1.21 2005/11/02 16:41:32 dvm Exp $

(depends-on %module/ ytools %ytools/ nilscompat)

(depends-on :at-run-time
	    %nity/ funtypes typebounds tupacceptors
	    %langutils/ synutils
	    %lisplang/ typedexp)

(end-header :continue-slurping)

(needed-by-macros
   (export '(type-declare 
	     build-App-typed-exp
	     make-Typed-dialect-data Typed-dialect-data-handler-finder
	     Typed-dialect-data-type-transer context-for-functional-position
	     context-find-source-term arglistspec-bind-to-tvars
	     type-trans type-trans-via-handlers
             wrong-type-observation break-on-wrong-type*)))

(def-class Typed-dialect-data
   handler-finder ;; A function that, given a term, returns        
   		  ;; a method for handling it, typically by fetching
		  ;; from a handler table indexed by the first symbol
		  ;; in it.  (Terms are _not_ assumed to be S-expressions.)
   type-transer   ;; false or a function that coerces a Typed-exp to
                  ;; a target-type.  It returns two values, < te, undo-stack >
   ;; where te is either
   ;; ':pass' -- meaning the coercer couldn't handle it
   ;; a Typed-exp -- successful coercion
   ;; false -- wrong type
)

(defun type-trans (te target-type undo-stack context)
   (cond ((Typed-exp-already-transed te)
	  (values (note-new-tvars te) undo-stack))
	 (t
	  (multi-let (((got-type got-env)
		       (follow-var-ref (Typed-exp-type te) empty-env*))
		      ((targ-type targ-env)
		       (follow-var-ref target-type empty-env*)))
	     (cond ((and (is-funtype got-type)
			 (is-funtype targ-type)
			 (> (type-find-feature got-type 'level got-env)
			    (type-find-feature targ-type 'level targ-env)))
		    (!= te (high-fcn-hide te))
		    (multi-let (((got-type got-env)
				 (follow-var-ref (Typed-exp-type te)
						 empty-env*)))
		       (cond ((context-for-functional-position context)
			      (fun-pos-type-trans
				 te got-type targ-type got-env targ-env
				 undo-stack context))
			     (t
			      (arg-pos-type-trans
			          te got-type targ-type got-env targ-env
				  undo-stack context)))))
		   (t
		    (arg-pos-type-trans te got-type targ-type got-env targ-env
					undo-stack context)))))))

(defun fun-pos-type-trans (te got-type targ-type got-env targ-env
			   undo-stack context)
   (cond ((and (= (type-find-feature got-type 'level got-env)
		  0)
	       (= (type-find-feature targ-type 'level targ-env)
		  0))
	  (let ((got-argtype
		   (type-find-feature got-type 'argtype got-env))
		(targ-argtype
		   (type-find-feature targ-type 'argtype targ-env)))
	     (multi-let (((okay undo-stack-1)
			  ;; Usual contravariant inversion:
			  (try-accept targ-argtype got-argtype undo-stack
				      targ-env got-env '())))
		;; Don't even check whether the resulttypes match.
		;; Because we're in functional position, the
		;; resulttypes will be checked again above.
		(cond (okay
		       (values te undo-stack-1))
		      (t
		       (values (note-wrong-type
				  te got-type targ-type got-env targ-env
				  context)
			       (undo undo-stack-1 undo-stack)))))))
	 (t
	  (signal-problem fun-pos-type-trans
	     "Unexpected high-level functions:"
	     :% " Got: " (new-Type-closure got-type got-env)
	     :% " Want: " (new-Type-closure targ-type targ-env)))))

(defun high-fcn-hide (fte)
   (multi-let (((fcn-type fcn-env)
		(follow-var-ref (Typed-exp-type fte) empty-env*)))
      (let ((hargs (funtype-extract-arglist fcn-type fcn-env)))
	 (cond ((not hargs)
		(signal-problem high-fcn-hide
		   "Fumbled arglist of " fcn-type)))
	 (multi-let (((arg-bdgs arg-posl)
		      (arglistspec-bind-to-tvars hargs fcn-env)))
	    (let ((varenv (env-bindings-append
			     true arg-bdgs fcn-env)))
	       (let ((actual-source
		      (type-find-feature fcn-type 'resulttype varenv)))
		   (build-App-typed-exp
		      1 fte
		      (<# (\\ (tvt)
			     (make-inst Type-typed-exp
				:type (Vartype-type tvt)
				:source (Vartype-var tvt)
				:env varenv
				:which (Vartype-val tvt)
				:tvars (list (Vartype-val
						tvt))))
			  arg-bdgs)
		      arg-posl
		      (<# (\\ (_) type-type*)
			  arg-bdgs)
		      varenv
		      (new-Type-closure actual-source
					(make-Env true arg-bdgs))
		      true false)))))))

(defun arg-pos-type-trans (te got-type targ-type got-env targ-env
			   undo-stack context)
   (multiple-value-let (okay undo-stack-1)
		       (try-accept got-type targ-type 
				   undo-stack got-env targ-env '())
      (cond (okay
	     (values (note-new-tvars te) undo-stack-1))
	    (t
	     (let ((type-transer
		      (Typed-dialect-data-type-transer
		         (Syn-context-dialect-handler context))))
	        (cond (type-transer
		       (multi-let (((new-te undo-stack-1)
				    (funcall type-transer
					     te got-type targ-type
					     got-env targ-env
					     undo-stack context)))
			  (cond ((eq new-te ':pass)
;;;;				 (cond ((is-Symbol (Type-desig targ-type))
;;;;					(dbg-save te got-type targ-type
;;;;						  got-env targ-env context)
;;;;					(breakpoint arg-pos-type-trans
;;;;					   "Pass on " got-type
;;;;					   :% " -> " targ-type)))
				 (type-trans-via-handlers 
				    te got-type targ-type got-env targ-env
				    undo-stack context))
				(new-te
				 (values new-te undo-stack-1))
				(t
				 (values (note-wrong-type
					    te got-type targ-type
					    got-env targ-env
					    context)
					 (undo undo-stack-1 undo-stack))))))
		      (t
		       (type-trans-via-handlers te got-type targ-type got-env targ-env
						undo-stack context))))))))

(defun type-trans-via-handlers (te got-type targ-type got-env targ-env
				undo-stack context)
   (let ((r false)
	 (undo-stack-1 undo-stack))
      (multiple-value-let (transfn1 _)
			  (type-find-feature
			      got-type 'type-transfn got-env)
	 (cond (transfn1
;;;;		(out "Trying transfn1" :%)
		(!= < r undo-stack-1 >
		    (funcall transfn1 te got-type targ-type got-env targ-env
			     undo-stack context))
		(cond ((not r)
		       (!= undo-stack-1 (undo *-* undo-stack))))
;;;;		(out "transfn1 result = " r :%)
		))
	 (cond ((not r)
		(multiple-value-let (transfn2 _)
				    (type-find-feature targ-type
						       'type-transfn targ-env)
		   (cond ((and transfn2
			       (not (eq transfn1 transfn2)))
;;;;			  (out "Trying transfn2" :%)
			  (!= < r undo-stack-1 >
			      (funcall transfn2 te
				       got-type targ-type got-env targ-env
				       undo-stack context))
			  (cond ((not r)
				 (!= undo-stack-1 (undo *-* undo-stack))))
;;;;			  (out "transfn2 result = " r :%)
			  )))))
	(values 
	    (cond (r
		   (note-new-tvars r))
		  (t
		   (note-wrong-type
			   te got-type targ-type got-env targ-env
			   context)))
	    undo-stack-1))))

(defvar break-on-wrong-type* false)

(defun note-wrong-type (te got-type targ-type got-env targ-env context)
   (let ((target-type (new-Type-closure targ-type targ-env)))
      (cond ((and (is-funtype targ-type)
		  (context-for-functional-position context)
		  (or (not (is-funtype got-type))
		      (= (type-find-feature got-type 'level got-env)
			 (type-find-feature targ-type 'level targ-env))))
	     ;; in functional position
	     ;; Don't report it here; it will make more sense if reported
	     ;; at next level up.
	    )
	    (t
	     (note-defective-exp
	       (:obs (wrong-type-observation got-type target-type got-env))
	       :target te
	       :context context
	       :place type-trans
	       (:e (:stream srm)
		  (dbg-save :run-loud target-type te context)
		  (display-wrong-type-bug te target-type context srm))
	       (:continue "Bug will be recorded"))
             (cond (break-on-wrong-type*
                    (dbg-save te targ-type got-type got-env targ-env)
                    (signal-problem note-wrong-type
                         "Wrong type: Got " got-type
                         :% " wanted: " targ-type)))
;;; The problem with this is that the types involved can have
;;; free high-order type variables --             
;;;;             (cond (break-on-wrong-type*
;;;;                    (break-with-wrong-type-bug te targ-type context)))
	     (!= (Typed-exp-type te) target-type)))
      (note-new-tvars te)))

(defun wrong-type-observation (got-type target-type got-env)
   (\\ (targ srm)
      (out (:to srm)
	 (:pp-block
	    "Wrong type: " (type-bounds
			      got-type false got-env)
	    1 (:pp-nl :linear)
	    "  for " (:q ((is-Typed-exp targ)
			  "[: " (Typed-exp-ext targ) " :]")
			 (t "[" targ "]"))
	    1 (:pp-nl :linear)
	    "Wanted " target-type))))

(defun display-wrong-type-bug (te target-type context srm)
   (letrec () 
      (multi-let (((te-l te-h)
		   (type-bounds (Typed-exp-type te) false empty-env*))
		  ((tt-l tt-h)
		   (type-bounds target-type false empty-env*))
		  (stack (syn-context-lookup context ':stack)))
	 (out (:to srm)
	    "Wrong type bug: "
	    :% (:q ((tight-bound te-l te-h)
		    te-l)
		   (t
		    (Typed-exp-type te)
		    :% (:i> 3) ">= " te-l
		    :% "=< " te-h (:i< 3)))
	    :% " vs. "
	    :% (:q ((tight-bound tt-l tt-h)
		    tt-l)
		   (t
		    target-type
		    :% (:i> 3) ">= " tt-l
		    :% "=< " tt-h (:i< 3)))
	    :% (:q (stack
		  "Stack:" :%
		  (expstack-show (cadr stack) 5))
		 (t "Can't find expression stack"))))
    :where
      (tight-bound (l h) (equal (Type-desig l) (Type-desig h)))))

(defun break-with-wrong-type-bug (te target-type context)
   (dbg-save :comp-quiet target-type te context)
   (letrec ()
      (multi-let (((te-l te-h)
		   (type-bounds (Typed-exp-type te) false empty-env*))
		  ((tt-l tt-h)
		   (type-bounds target-type false empty-env*))
		  (stack (syn-context-lookup context ':stack)))
	 (error-break type-trans :novalue
	    "Wrong type bug: "
	    :% (:q ((tight-bound te-l te-h)
		  te-l)
		 (t
		  (Typed-exp-type te)
		  :% (:i> 3) ">= " te-l
		  :% "=< " te-h (:i< 3)))
	    :% " vs. "
	    :% (:q ((tight-bound tt-l tt-h)
		  tt-l)
		 (t
		  target-type
		  :% (:i> 3) ">= " tt-l
		  :% "=< " tt-h (:i< 3)))
	    :% (:q (stack
		  "Stack:" :%
		  (expstack-show (cadr stack) 5))
		 (t "Can't find expression stack"))))
    :where
       (tight-bound (l h) (equal (Type-desig l) (Type-desig h)))))

(defun context-for-functional-position (context)
   (let ((r (car (Expstack-relations
		    (context-find-expstack context false)))))
      (and (is-Number r)
	   (= r 0))))

(defun context-find-source-term (context)
   (car (Expstack-expressions (context-find-expstack context false))))

(defun note-new-tvars (te)
   (let ((st-int (Typed-exp-scope-time-interval te)))
      (cond ((> (cadr st-int) (car st-int))
	     (!= (Typed-exp-tvars te)
		 (tvars-union (type-find-tvars (Typed-exp-type te)
					       st-int empty-env* !())
			   *-*))))
      te))

(defun arglistspec-bind-to-tvars (arglspec vartypes)
   (argspecs-declare arglspec
		     (\\ (spec)
			(let ((tv (argspec-tvar-type spec)))
			   (dbg-out binding-dbg*
			      "Introducing ?" (tvar-type-varname tv)
			      " as value of " spec :%)
			   tv))
		     vartypes))
      
(class-feature-datafun type-transfn modified-class
   (defun (obte target-type undo-stack context)
      (multi-let (((source-type senv)
		   (follow-var-ref (Typed-exp-type obte) empty-env*))
		  ((target-type tenv)
		   (follow-var-ref target-type empty-env*)))
	 (let ((js (type-find-feature source-type 'just-new-slots senv))
	       (jt (type-find-feature target-type 'just-new-slots tenv)))
	    (cond ((or js jt)
		   (let ((s-actual
			    (cond (js (type-find-supertype source-type senv))
				  (t source-type)))
			 (t-actual
			    (cond (jt (type-find-supertype target-type tenv))
				  (t target-type))))
		      (cond (js (!= (Typed-exp-type obte)
				    s-actual)))
		      (multi-let (((newte undo-stack-1)
				   (type-trans obte t-actual
				               undo-stack context)))
			 (cond (newte
				(!= (Typed-exp-type newte)
				    target-type)
				(values newte undo-stack-1))
			       (t
				(values false
					(undo undo-stack-1 undo-stack)))))))
		  (t false))))))

(defun build-App-typed-exp (level fte tel prefs arg-targs env r-type
			    hidden source)
;;;;   (trace-around build-App-typed-exp
;;;;      (:> "(build-App-typed-exp: " fte :% 3 tel ")")
   (cond ((not prefs)
	  (!= prefs (series 1 (len tel)))))
   (cond ((not r-type)
	  (signal-problem build-App-typed-exp
	     "Null  r-type")))
   (let ((ext `(,@(include-if (> level 0) '\!&)
		,(fte-source-possibly-hidden fte)
		,@(<# (\\ (x)
			 (cond ((is-Typed-exp x)
				(Typed-exp-ext x))
			       (t x)))
		      (args-sort-and-flag prefs tel)))))
;;;;      (dbg-save ext)
;;;;      (breakpoint build-App-typed-exp
;;;;	 "ext = " ext)
      (let ((appte
	      (make-inst App-typed-exp
		 :level level
		 :type r-type
		 :fcn fte
		 :arg-positions prefs
		 :args tel
		 :arg-targ-types arg-targs
		 :env env
		 :source (or source ext)
		 :ext ext   
		 :totbugs (</ (\\ (totbugs te)
				 (+ totbugs (Typed-exp-totbugs te)))
			     (Typed-exp-totbugs fte)
			     tel)
		 :tvars (</ (\\ (all-tvars te)
			       (append (Typed-exp-tvars te) all-tvars))
			    (Typed-exp-tvars fte)
			    tel)
		 :hidden hidden)))
	appte))
;;;;      (:< (val &rest _) "build-App-typed-exp: " val))
   )

(defun fte-source-possibly-hidden (fte)
   (Typed-exp-source (cond ((and (is-App-typed-exp fte)
				 (App-typed-exp-hidden fte))
			    (App-typed-exp-fcn fte))
			   (t
			    fte))))

