;-*- Mode: Common-lisp; Package: opt; Readtable: ytools; -*-
(in-package :opt)
;;; $Id: action.lisp,v 1.43 2006/10/30 21:49:22 dvm Exp $

; Parser of actions and expansions.

(depends-on %module/ ytools %ytools/ nilscompat)

(depends-on :at-run-time %opt/ more-syntax syntax basics types expansion
			 %langutils/ defectexp
			 %lisplang/ funcheck typecheck flagsource)

(end-header :continue-slurping)

;;; 'defs' each start with :action, :durative, or :process
(defun causations-parse (defs dom)
   (let ((env (domain-place-env dom))
	 (pre-scope-time scope-time*))
      (multi-let (((fundef-recs name-flg-list)
		   (causation-defs-types defs dom env)))
	 (let ((fcns-env
		  (env-bindings-append
		     true 
		     (recursive-funtypes-vartypes fundef-recs)
		     env)))
	    (repeat :for ((fdr :in fundef-recs)
			  (surface-def :in defs)
			  (name-flg :in name-flg-list)
			  (ustack !())
			  :collectors flagged-versions list-of-alists-of-fields
				      low-envs causation-names
				      meth-varbdgs-list okay-defs)
	     :within
	       (let ((defn-source (Exp-with-rel-exp (Fundef-rec-defn fdr)))
		     (defn-rel (Exp-with-rel-rel (Fundef-rec-defn fdr)))
		     (fbdg (place-domain-bdg
			      (Fundef-rec-name fdr)
			      dom)))
		  (let ((fctn (flag-if-inconsistently-declared
				 fbdg (Fundef-rec-funtype fdr)
				 env))
			(low-env
			   (fundef-rec-body-env
			      fdr fcns-env)))
		     (:continue
			:collect (:into low-envs
					low-env))
		     (cond ((not (is-symbolish name-flg))
			    (!= fctn (list *-* name-flg))))
		     (multi-let (((items bad-keyword-flg)
				  (>< (causation-def-field-extractor
					 (car surface-def))
                                      defn-source))
				 ((arglist reslist)
				  (args-res-desigs low-env)))
			(collecting-defective-exps
				    (def-list field-alist def-flg
                                              meth-varbdgs ustack-1)
				    (><
                                      (causation-def-field-checker
                                           (car surface-def))
                                      `((,fctn ,@arglist)
                                        - ,reslist)
                                      fdr items ustack
                                      (context-expstack-push
                                           defn-source defn-rel
                                           (opt-syn-context
                                              surface-def
                                              !()))
                                      low-env)
			   (:if-aborted
			       :restart-report (lambda (srm)
						  (out (:to srm)
						     "I will skip checking "
						     (car surface-def)
						     1 (Fundef-rec-name fdr)))
			      (:continue
			         :collect (:into okay-defs false)
				 :collect (:into causation-names fctn)
				 :collect (:into list-of-alists-of-fields !())
				 :collect (:into flagged-versions
                                              (flag-with-fdr-synerrs
						 surface-def
                                                 fdr
                                                 (append def-list
                                                         bad-keyword-flg)))
				 :collect (:into meth-varbdgs-list
						 !())))
                           (!= ustack ustack-1)
                           (:continue
			      :collect (:into okay-defs true)
                              :collect (:into causation-names fctn)
                              :collect (:into list-of-alists-of-fields
                                              field-alist)
                              :collect (:into flagged-versions
                                              (flag-with-fdr-synerrs
                                                  def-flg fdr
                                                  (append def-list
                                                          bad-keyword-flg)))
                              :collect (:into meth-varbdgs-list
                                              meth-varbdgs))))))
	       :result
	          (progn ;;;;(out "causation-names = " causation-names :%)
		     (multi-let (((_ _)
				  (fdrs-tvars-elim fundef-recs low-envs
						   pre-scope-time ustack)))
			(repeat :for ((fdr :in fundef-recs)
				      (meth-varbdgs :in meth-varbdgs-list))
			   (elim-unks fdr pre-scope-time fcns-env)
			 :result
			   (repeat :for ((fdr :in fundef-recs)
					 (def :in defs)
					 (name :in causation-names)
					 (field-alist :in list-of-alists-of-fields)
					 ;;;;(low-env :in low-envs)
					 )
			    :when (is-symbolish name)
			      (funcall (causation-definer (car def))
				       fdr field-alist meth-varbdgs fcns-env)
			    :result flagged-versions))))
       :where

	  (:def args-res-desigs (res-env)
	      (let ((ftype (Fundef-rec-funtype fdr)))
;;;;		 (dbg-save fdr ftype res-env)
		 (let (;;;;(restype (nity::fun-result-type ftype res-env))
		       (argtype (type-find-feature
				   ftype 'nity::argtype res-env))
		       (arglist (type-find-feature
				   ftype 'nity::arglist res-env)))
		    (cond ((= (type-find-feature ftype 'nity::level env)
			      0)
;;;;			   (dbg-save (ftype-here ftype))
			   (multi-let (((reslist restype)
					(ftype-wrapped-reslist ftype res-env)))
			      (values 
				 (arglistspec-printable
				    arglist argtype res-env)
				 (arglistspec-printable
				    reslist
				    restype res-env))))
			  (t
;;;;			   (dbg-save restype res-env)
			   (let ((restype (nity::fun-result-type ftype res-env)))
			      (multi-let (((low-reslist low-restype)
					   (ftype-wrapped-reslist restype res-env)))
				 (let ((low-reslist
					   (arglistspec-printable
					      low-reslist low-restype res-env))
				       (low-arglist
					     (arglistspec-printable
						(type-find-feature
						   restype 'nity::arglist res-env)
						(type-find-feature
						   restype 'nity::argtype res-env)
						res-env)))
				    (values `(,@low-arglist
					      !& ,@(arglistspec-printable
						      arglist argtype env))
					    low-reslist)))))))))

	  (:def ftype-wrapped-reslist (ftype env)
	     (let ((restype
		      (nity::fun-result-type ftype env)))
		(multi-let (((wrls fnd-wrls)
			     (type-find-feature
			        restype 'lisplang::wrapped-reslist env)))
;;;;		   (dbg-save ftype env wrls)
;;;;		   (breakpoint ftype-wrapped-reslist
;;;;		      "wrls = " wrls)
		   (cond ((and fnd-wrls (not (eq wrls ':undeclared)))
			  (values wrls restype))
			 (t
			  (values
			     (type-find-feature
				 ftype 'nity::reslist env)
			     restype))))))

	  (:def flag-with-fdr-synerrs (exp fdr other-ill-exps)
;;;;              (trace-around flag-with-fdr-synerrs
;;;;                 (:> "(flag-with-fdr-synerrs: " exp :%  fdr
;;;;                         :% "  others -- " other-ill-exps ")")
              (let ((ill-exps (nconc (synerrs-defective-exps 
                                        (Fundef-rec-ill-formed-subexps fdr)
                                        fdr)
                                     other-ill-exps)))
                 (new-Flagged-subexpression
                    exp ill-exps))
;;;;                 (:< (val &rest _) "flag-with-fdr-synerrs: " val))
              )
        )))))

(defvar empty-val-type*
        (make-tup-type 'Row (new-Arglistspec !()) false global-env*))

(defun causation-defs-types (cause-defs dom env)
   (repeat :for ((cd :in cause-defs)
		 (i = 1 :by 1)
		 :collector fundef-recs name-flg-list)
    :result (values fundef-recs name-flg-list)
    :within (let ((fdr (fundef->fundef-rec
			   (cdr cd) !() (\\ (b _) b) !() true i env)))
 	        (multi-let (((name name-flg)
			     (symbol-resolve (Fundef-rec-name fdr)
					     dom true))) 
		   (cond (name
			  (!= (Fundef-rec-name fdr) name)))
		   (let ((res-wrapper
			    (ecase (car cd)
			       (:action
				(cond ((memq ':expansion
					     (Exp-with-rel-exp
                                                (Fundef-rec-defn fdr)))
				       #'make-step-type-in-env)
				      (t
				       #'make-skip-type-in-env)))
			       (:process #'make-slide-type-in-env)
			       (:durative-action #'make-step-type-in-env))))
;;;;                      (cond ((eq name 'collect-value)
;;;;                             (dbg-save res-wrapper env fdr cd)
;;;;                             (breakpoint causation-defs-types
;;;;                                "About to set funtype for collect-value: "
;;;;                                :% fdr)))
                      (cond ((eq (Fundef-rec-low-result fdr)
                                 ':absent)
                             (!= (Fundef-rec-low-result fdr)
                                 empty-val-type*)))
		      (fundef-rec-set-funtype
			  fdr 
			  res-wrapper
			  false
			  (empty-undo-stack)
			  (opt-syn-context cd !())
			  env))
		   (:continue
		    :collect (:into fundef-recs fdr)
		    :collect (:into name-flg-list name-flg))))))

(eval-when (:compile-toplevel :load-toplevel :slurp-toplevel)
   (defvar causation-field-extractors* !()))

(datafun attach-datafun field-extractor
   (defun :^ (_ sym fun-name)
      (!= (alref causation-field-extractors* sym)
	  (symbol->fun fun-name))))

(defun causation-def-field-extractor (def-sort)
   (alref causation-field-extractors* def-sort
	  (signal-problem causation-def-field-extractor
	     "Don't know how to find fields of definition of sort " def-sort)))

(eval-when (:compile-toplevel :load-toplevel :slurp-toplevel)
   (defvar causation-def-field-checkers* !()))

(datafun attach-datafun field-checker
   (defun :^ (_ sym fun-name)
      (!= (alref causation-def-field-checkers* sym)
	  (symbol->fun fun-name))))

(defun causation-def-field-checker (def-sort)
   (alref causation-def-field-checkers* def-sort
	  (signal-problem causation-def-fields-checker
	     "Don't know how to check fields of definition of sort " def-sort)))

(eval-when (:compile-toplevel :load-toplevel :slurp-toplevel)
   (defvar causation-definers* !()))

(datafun attach-datafun causation-definer
   (defun :^ (_ sym fun-name)
      (!= (alref causation-definers* sym)
	  (symbol->fun fun-name))))

(defun causation-definer (def-sort)
   (alref causation-definers* def-sort
	  (signal-problem causation-definer
	     "Don't know how define an entity of sort " def-sort)))

(datafun field-extractor :action
   (defun :^ (defn)
      (multi-let (((items bad-keyword-flg)
		   (keyword-list-smooth
		      defn
		      '(:vars :precondition
			:maintain :effect :expansion
			:only-in-expansions)
		      '(:effect))))
	 (values items
		 bad-keyword-flg))))

(datafun field-checker :action
   (defun :^ (fctn-form fdr items undo-stack context act-env)
      (let ((step-type
	       (Fundef-rec-low-result fdr))
	    (ustack undo-stack)
	    meth-varbdgs vars-flg
	    precond effect maintain expansion
	    (dom (find-domain-in-vartypes act-env)))
	 (!= < meth-varbdgs act-env vars-flg >
	     (causation-vars-parse items act-env))
	 (!= < precond ustack >
	     (cond-field-parse ':precondition items 'true ustack context act-env))
	 (!= < effect ustack >
	     (effect-parse ':effect items step-type ustack context act-env))
	 (!= < maintain ustack >
	     (cond-field-parse ':maintain items false ustack context act-env))
	 (!= < expansion ustack >
	     (expansion-parse items step-type ustack context act-env))
	 (values (list (tuple ':vars meth-varbdgs)
		       (tuple ':precondition precond)
		       (tuple ':effect effect)
		       (tuple ':maintain maintain)
		       (tuple ':expansion expansion))
		`(:action ,@fctn-form
;;;;		    ,@bad-keyword-flg
		    ,@(surface-vars-decl meth-varbdgs vars-flg act-env)
		    :precondition ,(flagsource precond)
		    :effect ,(flagsource effect)
		    ,@(cond (expansion
			     `(:expansion
			       ,(flag-expansion-problems expansion dom)
			       ,@(include-if maintain
				    `(:maintain ,(flagsource maintain)))))
			    (maintain
			     `(:maintain
			       ,(flagexp
				   ":maintain not allowed if no expansion"
				   (flagsource maintain))))
			    (t !())))
		 meth-varbdgs ustack))))

(datafun causation-definer :action
   (defun :^ (fdr field-alist meth-varbdgs env)
      (let ((dom (find-domain-in-vartypes env))
	    (fctn (Fundef-rec-name fdr))
	    (qvarbdgs (alref field-alist ':vars
			     (signal-problem action-causation-definer
				"Fumbled :vars"))))
	 (let ((fbdg (place-domain-bdg fctn dom))
	       (low-env (fundef-rec-low-env fdr env)))
	    (let ((fterm (fundef-rec-term fdr low-env)))
	       (let ((defn (make-Action-defn
			      :function fctn
			      :term fterm
			      :varbdgs (fdr-low-arg-vartypes fdr meth-varbdgs low-env)
			      :condition
				 (alref field-alist ':precondition)
			      :effect
				 (alref field-alist ':effect)
;;;;			      :maintain
;;;;				 (alref field-alist ':maintain)
			      :has-methods (not (not (alref field-alist
							    ':expansion
							    false)))
			      :only-in-expansions
				 (not (not (alref field-alist
						  ':only-in-expansions
								 false))))))
;;;;                  (dbg-save fdr fctn defn)
;;;;                  (breakpoint :action-causation-definer
;;;;                     "About to bind " fctn
;;;;                     " to type " (Fundef-rec-funtype fdr))
		  (bind-causation-function
		     fbdg fctn
		     (Fundef-rec-funtype fdr)
		     defn)
		  (let ((mrg (own-rule-group dom)))
		     (let ((exp (alref field-alist ':expansion false)))
			(cond ((and exp (not (eq exp ':methods)))
			       (add-to-rule-group
				  (def-body-to-method
				     fctn fctn fterm
				     qvarbdgs meth-varbdgs
;;;;				     false ; old 'maint' arg
                                     false exp)
				  mrg)))))))))))

(defun fundef-rec-low-env (fdr env)
   (cond ((> (Fundef-rec-level fdr) 0)
	  (env-bindings-append
	     true
	     (nity::funtype-params-declare-unbound
		(Fundef-rec-funtype fdr)
		env)
	     env))
	 (t env)))

(defun fdr-low-arg-vartypes (fdr extra-bdgs env)
   (let ((alspec (type-arglistspec (Fundef-rec-low-args fdr)
				   env)))
      (cond (alspec
	     (append (arglistspec->vartypes alspec)
		     extra-bdgs))
	    (t
	     (signal-problem fdr-low-arg-vartypes
		"Can't get vartypes from " (Fundef-rec-low-args fdr)
		:%  " for definition of " (Fundef-rec-name fdr))))))

(defun flag-if-inconsistently-declared (fbdg funtype env)
		   (cond ((and (not (Domain-bdg-unbound fbdg))
			       (not (types-equal (Domain-bdg-type fbdg)
						 funtype
						 env env)))
			  (setf (Domain-bdg-val fbdg) nil)
			  (flagexp "Symbol already defined "
				   (Vartype-var fbdg)))
			 (t (Vartype-var fbdg))))

(defun flag-expansion-problems (e dom)
   (cond ((not (eq e ':methods))
	  (!= e (flagsource e))))
   (cond ((domain-declares-requirement dom ':action-expansions)
	  e)
	 (t
	  (flag-if-ill-formed
	     e (list (simple-ill-formed-exp
			!"Action expansion illegal for ~
			  domain not declaring :action-expansions"
			false))))))

(defun surface-vars-decl (meth-varbdgs vars-flg env)
  (cond ((and (null meth-varbdgs) (null vars-flg))
	 '())
	(t `(:vars
	     ,(vars-source-maybe-flag
		 meth-varbdgs
		 vars-flg env)))))

(defun methods-parse (methods dom rg)
   (cond ((null methods) '())
         (t
	  (multiple-value-bind (methods flg)
			       (list-smooth methods #'consp)
	      (let ((flg-al '()))
 		 (dolist (a methods)
		    (multiple-value-bind (flg-a defn)
					 (method-parse a dom)
		       (cond (defn 
			      (let ((fval (find-domain-bdg-val
					       (Method-defn-function defn)
					       dom)))
				 (cond ((is-Action-defn fval)
					(cond (rg
                                               (add-to-rule-group defn rg))))
				       (t
					(setq flg-a
					      (format-flg flg-a
						  "Method definition for ~
						  non-action-function ~
						  (value ~s)"
						  fval)))))))
		       (push flg-a flg-al)))
		 (let ((r `(,@(reverse flg-al)
			    ,@flg)))
		    (cond ((domain-declares-requirement
			      dom ':action-expansions)
			   r)
			  (t
			   (cons (new-Flagged-subexpression
				    false
				    (list (simple-ill-formed-exp
					     !"Methods are illegal for ~
                                               domains not declaring ~
                                               requirement :action-expansions"
					     false)))
				 r)))))))))

; Returns flagged method-body + defined method
(defun method-parse (method-body dom)
   (let ((name (memq ':name method-body))
	 (pre-scope-time scope-time*)
	 (env (domain-place-env dom)))
      (cond (name
	     (!= method-body
		 `(,@(ldiff *-* name) ,@(cddr name)))
	     (!= name (cadr *-*))))
      (let ((fdr (fundef->fundef-rec method-body !() false !() true
				     ':start env)))
	 (fundef-rec-set-funtype fdr #'make-step-type-in-env false
				 (empty-undo-stack)
				 (opt-syn-context method-body !())
				 env)
	 (let ((fctn (Fundef-rec-name fdr))
	       (low-env (fundef-rec-low-env fdr env)))
	    (let ((act-term (fundef-rec-term fdr low-env))
		  (step-type (Fundef-rec-low-result fdr))
		  (context (make-Syn-context opt-dialect-handler* !())))
	       (let ((fbdg (var-lookup fctn env)))
		  (cond ((or (not fbdg)
			     (Domain-bdg-unbound fbdg))
			 (setq fctn
			       (flagexp "Method for undefined action"
					       fctn)))
			(t
			 (let ((type-okay
				  (type-acceptable
				     false
				     (Fundef-rec-funtype fdr)
				     (Vartype-type fbdg)
				     !() env env !()))
			       (inner-env 
				     (fundef-rec-body-env fdr env))
			       (ustack (empty-undo-stack))
			       field-env
			       meth-varbdgs precond effect ;;;; maintain
			       expansion ill-formed-vars)
			    (multi-let (((items bad-keyword-flg)
					 (keyword-list-smooth
					    (Exp-with-rel-exp
					        (Fundef-rec-defn fdr))
					    '(:vars :precondition
					      :effect ;;;; :maintain
					      :expansion)
					    !())))
			       (!= < meth-varbdgs field-env ill-formed-vars >
				   (causation-vars-parse items inner-env))
			       (!= < precond ustack >
				   (cond-field-parse ':precondition items 'true
						     ustack context field-env))
			       (!= < effect ustack >
				   (effect-parse ':effect items step-type
						 ustack context field-env))
;;;;			       (!= < maintain ustack >
;;;;				   (cond-field-parse ':maintain items false
;;;;						     ustack context field-env))
			       (!= < expansion ustack >
				   (expansion-parse
				       items
				       (Fundef-rec-low-result fdr)
				       ustack context field-env))
			       (!= < _ ustack >
				   (fdrs-tvars-elim (list fdr) (list env)
                                                    pre-scope-time ustack))
			       (elim-unks fdr pre-scope-time env)
			       (values
				  `(:method
				    ,(cond (type-okay act-term)
					   (t
					    (new-Flagged-subexpression
					       act-term
					       (list (make-Defective-exp
							:target act-term
							:observation
							   (wrong-type-observation
							      (Fundef-rec-funtype fdr)
							      (Vartype-type fbdg)
							      env))))))
				    ,@(cond (name
					     `(:name
					       ,(cond ((symbolp name) name)
						      (t (flagexp
							       "Illegal method name"
							       name)))))
					    (t '()))
				    ,@(cond ((null meth-varbdgs) '())
					    (t `(:vars
						 ,(vars-source-maybe-flag
						     meth-varbdgs
						     ill-formed-vars
						     env))))
				    :precond ,(flagsource precond)
				    :effect ,(flagsource effect)
				    :expansion ,(cond (expansion
						       (flagsource expansion))
						      (t
						       (flagexp ":expansion missing"
								'(:expansion))))
				    ,@bad-keyword-flg)
				  (cond ((and expansion (symbolp fctn))
					 (def-body-to-method
					   name fctn
					   act-term
					   meth-varbdgs
					   precond ;;;; maintain
                                           effect expansion))
					(t nil)))))))))))))

(defun causation-vars-parse (items env)
   (let ((field (alref items ':vars false)))
      (cond (field
	     (vars-extract-bdgs field env))
	    (t
	     (values !() env !())))))

(defun cond-field-parse (fieldname items default undo-stack context env)
   (let ((field (alref items fieldname false)))
      (cond (field
	     (multi-let (((te _)
			  (term-check field
				      prop-type* undo-stack
				      (cons-Syn-context
					       (tuple ':polarity false)
					       (context-expstack-push
						  field fieldname context))
				      env)))
		(cond ((and (is-Quantified-typed-exp te)
			    (Quantified-typed-exp-keep-quantifier te))
		       (dbg-save field fieldname te context env)
		       (breakpoint cond-field-parse
			  "Kept quantifier: " te)))
                te))
	    (default
	     (values 
		 (new-Const-typed-exp
		    default bool-type* `',default env)
		 undo-stack))
	    (t
	     (values false undo-stack)))))

;;; Redundant
(defun precond-parse (items undo-stack context env)
   (let ((field (alref items ':precondition false)))
      (cond (field
	     (term-check field prop-type* undo-stack
			 (context-expstack-push
			    field ':precondition context)
			 env))
	    (t
	     (values 
		 (new-Const-typed-exp
		    'true bool-type* 'true env)
		 undo-stack)))))

(defun effect-parse (fieldname items step-type undo-stack context env)
   (let ((field (alref items fieldname false)))
      (cond (field
	     (effect-check
		field step-type undo-stack
		(context-expstack-push field fieldname context)
		env))
	    (t
	     (values (new-Const-typed-exp 'true bool-type* 'true env)
		     undo-stack)))))

;;; Redundant
(defun maintain-parse (items undo-stack context env)
   (let ((field (alref items ':maintain false)))
      (cond (field
	     (term-check field prop-type* undo-stack
			 (context-expstack-push field ':maintain context)
			 env))
	    (t
	     (values false undo-stack)))))

(defun expansion-parse (items step-type undo-stack context env)	 
   (let ((field (alref items ':expansion false)))
      (cond (field
	     (cond ((eq field ':methods)
		    (values ':methods undo-stack))
		   (t
		    (term-check
                       field step-type undo-stack
                       (context-push-and-cons
                          field ':expansion
                          'expansion-val-type step-type
                          context)
                       env))))
	    (t
	     (values false undo-stack)))))

;;;;;;; This has moved to typecheck; should be deleted here.
;;;;(defun elim-unks (fdr pre-scope-time outer-env)
;;;;	    (cond ((Fundef-rec-is-high fdr)
;;;;		   (let ((unk-ids 
;;;;			    (<# (\\ (vt)
;;;;				   (unknown-type-id (Vartype-val vt)))
;;;;				(Fundef-rec-high-arg-bdgs fdr))))
;;;;		      (let ((low-funtype
;;;;			       (unk-elim (Fundef-rec-res-funtype fdr)
;;;;					 unk-ids pre-scope-time outer-env)))
;;;;			 (!= (Fundef-rec-funtype fdr)
;;;;			     (make-funtype
;;;;				1 low-funtype
;;;;				(type-find-feature
;;;;			           *-* 'argtype outer-env)
;;;;				(args->spec (list low-funtype))
;;;;				(funtype-extract-arglist *-* outer-env)
;;;;				false outer-env)))))))
;;;;
(defun vars-source-maybe-flag (bdgs ill-forms env)
   (let ((l (var-bindings-sexp bdgs env)))
      (cond ((null ill-forms) l)
	    (t (new-Flagged-subexpression l ill-forms)))))

(defun def-body-to-method (name fctn term mcons precond ;;;; maint
                           effect expansion)
   (cond ((not expansion)
	  (note-defective-exp
	     ((_) "Method " (:q (name name 1)) "with no expansion for " term)
	     :target name
	     :place def-body-to-method :fatal)))
   (make-Method-defn
         :name name
         :function fctn
	 :term term
	 :varbdgs mcons
	 :condition precond
;;;;	 :maint maint
	 :effect effect
	 :expansion expansion))

(defvar argno* 0)

(defun fundef-rec-term (fdr env)
;;;;   (cond ((eq (Fundef-rec-name fdr) 'collect-value)
;;;;          (dbg-save fdr env)
;;;;          (breakpoint fundef-rec-term
;;;;             "fdr = " fdr)))
   `(,(Fundef-rec-name fdr)
     ,@(<# (\\ (argspec)
	      (let ((sym (Argspec-name argspec)))
		 (make-Qvar
		    (cond ((eq sym '_)
			   (build-symbol (:package false)
					 a (++ argno*)))
			  (t sym))
		    !())))
	   (let ((alspec (type-arglistspec
			    (Fundef-rec-low-args fdr)
			    env)))
	      (alspec-args-sort alspec)))))

;;; Returns < new-bindings-from-vars-field, augmented-env, 
;;;           error-flags >
(defun vars-extract-bdgs (vars-field env)
  (let ((dom (find-domain-in-vartypes env)))
     (multi-let (((_ varbdgs ill-formed-vars)
		  (qvar-list-parse vars-field ':tvar env)))
	(cond ((and vars-field
		    (not (or (domain-declares-requirement
				dom ':existential-preconditions)
			     (domain-declares-requirement
				dom ':conditional-effects))))
	       (!= ill-formed-vars
		   (cons (simple-ill-formed-exp
			    !"Illegal for domain not declaring requirements ~
			    :existential-preconditions and ~
			    :conditional-effects"
			    false)
			 *-*))))
	(values varbdgs
		(env-bindings-append true varbdgs env)
		ill-formed-vars))))

(defun bind-causation-function (fbdg fctn funtype defn)
   (cond (fbdg
	  (setf (Domain-bdg-type fbdg) funtype)
	  (setf (Domain-bdg-val fbdg)
		(make-Causation-function
		   :name fctn
		   :type funtype
		   :defn defn)))))

(def-opt-form-handler effect term-checker (effterm target-type undo-stack
					   context mvartypes)
   (cond ((= (len effterm) 2)
	  (effect-check (cadr effterm) (make-Step-type void-type*)
			undo-stack context mvartypes))
	 (t
	  (values
	     (ill-formed-typed-exp effterm target-type mvartypes)
	     undo-stack))))

(defun effect-check (e step-type undo-stack context mvartypes)
   (term-check
      e prop-type* undo-stack
      (cons-Syn-context (tuple 'action-context 'effect)
                        context)
      (cond (step-type
             (let ((act-res-type (and step-type
                                      (steptype-restype step-type mvartypes))))
                (let-fun ()
                   (let ((produce-env (env-cons
                                         (new-Vartype
                                            'produce (produce-type) nil)
                                         mvartypes)))
		      (env-bindings-append
			 true
			 (multi-let (((argtypes found)
				      (type-find-feature
					 act-res-type 'elt-types mvartypes)))
			    (cond (found
				   (<# (\\ (as)
					  (new-Vartype (Argspec-name as)
						       (Argspec-type as)
						       false))
				       (Arglistspec-argspecs argtypes)))
				  (t
                                   (dbg-save :run-loud act-res-type)
				   (signal-problem effect-check
				      "Step type has no recoverable component"
				      " type names: " step-type))))
			 produce-env))
	           
                 :where

                   (:def produce-type ()
                       (multi-let (((argtype argtype-env)
                                    (follow-var-ref act-res-type mvartypes)))
                          (multi-let (((argtype argtype-env 
                                       arglspec arglspec-env)
                                       (decipher-argtype argtype argtype-env)))
;;;;                             (dbg-save argtype argtype-env arglspec
;;;;                                       arglspec-env act-res-type mvartypes
;;;;                                       step-type)
;;;;                             (breakpoint produce-type
;;;;                                "Ready to create funtype")
                             (make-funtype 0 bool-type*
                                      (new-Type-closure argtype argtype-env)
                                      (args->spec (list bool-type*))
                                      (nity::arglistspec-close
                                          arglspec arglspec-env)
                                      false argtype-env))))
                   
                   (:def decipher-argtype (argtype argtype-env)
                      (cond ((eq (nity::tup-val-class argtype)
                                 'Row)
                             (multi-let (((als als-env)
                                          (follow-var-ref
                                             (type-find-feature
                                                argtype 'elt-types
                                                argtype-env)
                                             argtype-env)))
                                (let ((asl (Arglistspec-argspecs als)))
                                   (cond ((= (len asl) 1)
                                          (decipher-argtype
                                             (Argspec-type (first asl))
                                             als-env))
                                         (t (values argtype argtype-env
                                                    als als-env))))))
                            (t
                             (values argtype argtype-env
                                     (args->spec
                                        (list argtype))
                                     argtype-env)))))))
            (t mvartypes))))

(defun val-slot-vartypes (step-type env)
   (let (;;;;(apparent-val-type (step-type-res-type step-type env))
	 (unwrls (type-find-feature step-type 'lisplang::wrapped-reslist env)))
      (cond ((not unwrls)
	     (signal-problem val-slot-vartypes
		"Can't recover result names from " step-type))
	    ((eq unwrls ':undeclared)
	     !())
	    (t
	     (let ((val-type (make-tup-type 'Tup unwrls "" env)))
		(let ((step-val-te
			 (simple-app-typed-exp
			    (simple-var-typed-exp 
			       'step-value env)
			    (list (make-inst Var-typed-exp
				     :var 'this-step
				     :qvar false
				     :source 'this-step
				     :type val-type
				     :env env 
				     :binder false
				     :argspec (list (new-Vartype
						       'this-step val-type false))
				     :check-time-callable false))
			    (list step-type)
			    false val-type env)))
		   (repeat :for ((s :in (Type-slotfns val-type)))
		    :within
		       (let ((slname (Slot-name s))
			     (sltype (Slot-type s)))
			  (:continue
			   :when (and sltype
				      (not (eq slname 'conser)))
			   :collect
			     (new-Vartype
				slname sltype
				(make-Prechecked
				   (let ((sf-te (make-slot-fcn-te
						   s sltype env)))
				      (make-inst Slot-acc-typed-exp
					 :slotname slname
					 :type-invert (Slot-invert s)
					 :fcn sf-te
					 :args (list step-val-te)
					 :arg-positions '(1)
					 :arg-targ-types step-type
					 :hidden false
					 :type sltype
					 :source `(!_ ,slname this-step)
					 :env env
					 :totbugs 0
					 :subexps (list sf-te step-val-te))))))))))))))

#|
(defun val-slot-vartypes (step-type env)
   (let ((val-type (step-type-res-type step-type env)))
      (let ((step-val-te
	       (simple-app-typed-exp
		  (simple-var-typed-exp 
		     'step-value env)
		  (list (make-inst Var-typed-exp
			   :var 'this-step
			   :qvar false
			   :source 'this-step
			   :type val-type
			   :env env 
			   :binder false
			   :argspec (list (new-Vartype 'this-step val-type false))
			   :check-time-callable false))
		  (list step-type)
		  false univ-type* env))) 
	 (<! (\\ (s)
		(let ((slname (Slot-name s))
		      (sltype (Slot-type s)))
		   (cond ((and sltype
			       (not (eq slname 'conser)))
			  (list 
			     (new-Vartype
				slname sltype
				(make-Prechecked
				   (let ((sf-te (make-slot-fcn-te
						   s sltype env)))
				      (make-inst Slot-acc-typed-exp
					 :slotname slname
					 :type-invert (Slot-invert s)
					 :fcn sf-te
					 :args (list step-val-te)
					 :arg-positions '(1)
					 :arg-targ-types step-type
					 :hidden false
					 :type sltype
					 :source `(!_ ,slname this-step)
					 :env env
					 :totbugs 0
					 :subexps (list sf-te step-val-te)))))))
		      (t !()))))
	     (Type-slotfns val-type)))))

Not clear what this was, but steptype-restype in types.lisp is 
supposed to do the same thing --
(defun step-type-res-type (step-type env)
   (multi-let (((atl found)
		(type-find-feature step-type 'nity::arg-vartypes env)))
;;;;      (dbg-save atl found step-type env)
;;;;      (breakpoint step-type-res-type
;;;;	 "atl = " atl)
      (cond (found
	     (let ((vt (vartypes-lookup 'r atl)))
	        (cond (vt
		       (Vartype-val vt))
		      (t
		       (signal-problem step-type-res-type
			  "Step type with no result type: " step-type)))))
	    (t
	     (multi-let (((rtype found)
			  (type-find-feature step-type 'result-type env)))
		(cond (found rtype)
		      (t
		       (signal-problem step-type-res-type
			  "Can't find result type for step type "
			  step-type))))))))
|#

;; ff is either false or of the form (:fieldname typed-exp).
(defun maybe-include-field (ff)
   (cond (ff
;;;;	  (dbg-save :run-loud ff)
;;;;	  (breakpoint maybe-include-field
;;;;	     "About to include " ff)
	  `(,(car ff) ,(flagsource (cadr ff))))
	 (t '())))

;;; Moved to synutils.
;;;;(defun context-push-and-cons (exp k prop val context)
;;;;   (cons-Syn-context (tuple prop val)
;;;;		     (context-expstack-push exp k context)))

