;-*- Mode: Common-lisp; Package: opt; Readtable: ytools; -*-
(in-package :opt)
;;;$Id: axiom.lisp,v 1.14 2005/11/22 12:27:06 dvm Exp $

(depends-on %module/ ytools nity)

(depends-on :at-run-time %opt/ types basics syntax more-syntax
	                 %lisplang/ funcheck typecheck bvarparse flagsource)

(defvar true-te*
    (make-inst Const-typed-exp
       :val 'true
       :type true-type*
       :source 'true
       :env global-opt-env*))

(defvar false-te*
    (make-inst Const-typed-exp
       :val 'false
       :type false-type*
       :source 'false
       :env global-opt-env*))

(defun facts-parse (facts dom rg cxt)
   (multiple-value-bind (literals flg)
                        (list-smooth facts #'consp)
;;;;      (!= literals (expression-symbols-place *-* dom))
      (collecting-defective-exps (ill-formed-exps fact-tes)
				 (<# (\\ (lit)
;;;;					(cond ((matchq (forall ?@_) lit)
;;;;					       (breakpoint facts-parse
;;;;						  "lit = " lit)))
					(formula-typecheck lit true (empty-undo-stack)
							   !() dom))
				     literals)
	 (:if-aborted 
             :restart-report (lambda (srm)
				(out (:to srm)
				     "I will give up on checking the facts in "
				     (car cxt) 1 (cadr cxt)))
	     (list (new-Flagged-subexpression facts ill-formed-exps)))
;;;;	 (repeat :for ((lit :in literals)
;;;;		       (te :in fact-tes))
;;;;	    (cond ((matchq (coerce Boolean ?@_) lit)
;;;;		   (dbg-save te lit dom rg)
;;;;		   (breakpoint facts-parse
;;;;		      "Got coercion fact " lit))))
	 (repeat :for ((te :in fact-tes))
	    (add-to-rule-group (make-Fact te false)
			       rg))
	 `(,@(<# (\\ (te)
		    (flagsource te))
		 fact-tes)
	   ,@flg))))

(defun axioms-parse (axioms dom rg)
   (cond ((null axioms) '())
         (t
	  (multiple-value-bind (axioms flg)
			       (list-smooth axioms #'consp)
	     (let ((flg-all '()))
		(dolist (a axioms)
		   (multiple-value-bind (flg-a defn)
					(axiom-parse a dom)
		      (on-list flg-a flg-all)
                      (cond (rg
;;;;			     (dbg-save rg defn)
;;;;			     (breakpoint axioms-parse
;;;;				"About to add " defn " to " rg)
		             (add-to-rule-group defn rg)))))
		`(,@(reverse flg-all)
		    ,@flg))))))

; axiom-body  is of form (:context ... :implies ...)
(defun axiom-parse (axiom-body dom)
   (let ((initial-scope-time scope-time*))
      (!= scope-time* (+ *-* 1))
      (multi-let (((items bad-keyword-flg)
		   (keyword-list-smooth axiom-body
					'((:vars :parameters)
					  (:antecedent :context)
					  (:consequent :implies)
					  :procedure)
					'(:consequent))))
;;;;	 (repeat :for ((e :in items))
;;;;	    (!= (cadr e) (expression-symbols-place *-* dom)))
	 (let ((vartypes (empty-vartypes dom))
	       (vars (get-field-or-empty ':vars items)))
	    (multi-let (((constraining qvarbdgs defective-exps)
			 (qvar-list-parse vars univ-type* vartypes)))
;;;;		(dbg-save vars vartypes qvarbdgs)
;;;;		(breakpoint quantified-formula-check
;;;;		   "Got qvarbdgs = " qvarbdgs)
	       (let ((af (get-field ':antecedent items))
		     (cf (get-field ':consequent items))
		     (pf (get-field ':procedure items)))
		  (let ((ax (cond (pf
				   (make-Procedural-axiom))
				  (t
				   (make-Axiom)))))
		     (repeat :for ((vt :in qvarbdgs))
		       (!= (vartype-feat vt ':binder) ax))
		     (let ((ant (cond (af (cadr af))
				      (t false))))
			(let ((ate (and ant
					(formula-typecheck
					   ant false (empty-undo-stack)
					   qvarbdgs dom))))
			   (cond ((is-Typed-exp ate)
				  ;;;(dbg-save ate)
				  (cond ((not (slot-boundp ate 'lisplang::type))
					 (dbg-save :run-loud ate qvarbdgs dom ant)
					 (breakpoint axiom-parse
					    "Antecedent has no type: " axiom-body)))))
			   (multiple-value-let (cte _)
					       (formula-typecheck
						  (cadr cf) true (empty-undo-stack)
						  qvarbdgs dom)
;;;;			      (cond ((eq (car (cadr cf)) 'assertion)
;;;;				     (dbg-save cf qvarbdgs dom cte)
;;;;				     (breakpoint
;;;;				        "Got cte early: " cte)))
			      (let-fun ()
				 (finish-axiom-parse)

			       :where

      (:def finish-axiom-parse ()
	 (!= qvarbdgs
	     (bdgs-tvar-elim *-* initial-scope-time
			     !()))
	 (let ((axdef 
		`(,@(cond ((null qvarbdgs)
			   (cond ((null defective-exps)
				  '())
				 (t
				  (list (new-Flagged-subexpression
					    vars defective-exps)))))
			  (t `(:vars
			       ,(flag-if-ill-formed
				   (vartypes-bvar-list qvarbdgs)
				   defective-exps))))
		  ,@(cond (ant
			   `(:context ,(flagsource ate)))
			  (t '()))
		  ,@(cond (cf
			   `(:implies ,(flagsource cte)))
			  (t '()))
		  ,@(cond (pf
			   `(:procedure ,(cadr pf)))
			  (t '()))
		  ,@bad-keyword-flg)))
	    (cond ((exists (n :in axdef) (is-Integer n))
		   (dbg-save :run-loud ant ate cf cte)
		   (breakpoint axiom-parse
		      "Odd axdef: " axdef)))
	    (!= (Axiom-vars ax) qvarbdgs)
	    (!= (Axiom-antecedent ax) ate)
	    (!= (Axiom-consequent ax) cte)
	    (cond (pf
		   (!= pf (proc-compile (cadr pf)))
		   (cond ((and +namespace-mode+ pf (is-Symbol pf))
			  (let ((ns (Domain-namespace dom)))
			     (cond (ns
				    (namespace-associate ns (list pf)))))))
		   (!= (Procedural-axiom-fcn ax) pf)))
	    (!= (Axiom-statement ax)
		(axiom-fact-statement
		   qvarbdgs constraining cte ate pf axiom-body dom))
	    (values
	       `(:axiom ,@axdef)
	       ax))))))))))))))

(defun axiom-fact-statement (varbdgs constraining cte ate pf axbody dom)
   (let ((axte
	    (make-inst Quantified-typed-exp
	       :quantifier 'freevars
	       :keep-quantifier false
	       :bindings varbdgs
	       :use-bindings-as-constraints constraining
	       :universal true
	       :type prop-type*
	       :body (cond ((or ate pf)
			    (formula-typecheck
			       (build-axiom-statement cte ate pf)
			       true (empty-undo-stack) !() dom))
			   (t cte))
	       :source `(:axiom ,@axbody)
	       :env (empty-vartypes dom)
	       :totbugs (+ (Typed-exp-totbugs cte)
			   (cond (ate (Typed-exp-totbugs ate))
				 (t 0)))
	       :subexps (cons cte (cond (ate (list ate))
					(t '()))))))
      (repeat :for ((vt :in varbdgs))
	 (!= (vartype-feat vt ':binder) axte))
      axte))

(defun build-axiom-statement (cte ate pf)
;;;;   (let ((fcn-te
;;;;	    (make-inst Unchecked-typed-exp
;;;;	       :source pf
;;;;	       :type univ-type*
;;;;	       :env (empty-vartypes dom)))) ...)
      `(<- (already-checked ,true ,cte)
	   ,(cond (pf
		   (cond (ate
			  `(and (goal-call ,pf)
				(already-checked ,true ,ate)))
			 (t
			  `(goal-call ,pf))))
		  (t
		   `(already-checked ,true ,ate)))))

(defun derived-parse (clauses dom)
   (repeat :for ((c :in clauses)
		 (dom-env (domain-place-env dom))
		 (own-rg (own-rule-group dom))
		 :collectors preds defs ill-formed)
    :within
      (match-cond c
	 (:? (?pred ?def)
	   (:continue
	    :collect (:into preds pred)
	    :collect (:into defs def)))
	 (t
	  (:continue
	   :collect
	     (:into ill-formed
		(make-Defective-exp
			:target c
			:observation
			   (\\ (targ srm)
			      (out (:to srm)
				targ " must have two fields, pred and defn")))))))
    :result
       (collecting-defective-exps (defexps output)
				  (parse-everything clauses preds defs)
	  (:if-aborted
	     (new-Flagged-subexpression
	        `(:derived ,@c)
		defexps))
	  (cond ((and (null ill-formed) (null defexps))
		 output)
		(t
		 (new-Flagged-subexpression
		    output
		    (append defexps ill-formed)))))
		    
    :where
       (:def parse-everything (clauses preds defns)
	  (multi-let (((vtl _ ill-formed-exps-list _)
		       (function-list-parse preds !() prop-type* false
					    dom-env)))
	     (repeat :for ((vt :in vtl)
			   (ill-formed-exps :in ill-formed-exps-list)
			   (defn :in defns)
			   (clause :in clauses))
	      :within
		 (cond ((null ill-formed-exps)
			(let ((bind-ifel (bind-pred-constant
					    (Vartype-var vt)
					    false
					    (Vartype-type vt)
					    !() dom)))
			   (cond ((null bind-ifel)
				  (collecting-defective-exps
				                   (dl fact-flg)
						   (parse-as-fact vt defn clause)
				     (:if-aborted
					 (new-Flagged-subexpression
					     `(:derived ,@clause) dl))
				     (:continue
				      :collect
					(let ((out-exp
						 `(:derived ,(cadr fact-flg)
							    ,(caddr fact-flg))))
					   (cond ((null dl)
						  out-exp)
						 (t
						  (new-Flagged-subexpression
						     out-exp dl)))))))
				 (t
				  (:continue
				   :collect
				     (new-Flagged-subexpression
				         `(:derived ,@clause) bind-ifel))))))
		      (t
		       (:continue
			:collect (new-Flagged-subexpression
				    `(:derived ,@clause) ill-formed-exps)))))))

       (:def parse-as-fact (vt defn clause)
	  (let ((predtype (Vartype-type vt)))
	     (let ((level (type-feature predtype 'level))
		   (cxt (opt-syn-context
			   `(:derived ,@clause)
			   !())))
	        (cond ((= level 0)
		       (let ((arglist (type-find-feature
				          predtype 'arglist dom-env)))
			  (let ((local-bdgs
				   (<# (\\ (as)
					  (new-Vartype
					     (Argspec-name as)
					     (Argspec-type as)
					     false))
				       (Arglistspec-argspecs arglist)))
				(pred-term
				   `(,(Vartype-var vt)
				     ,@(<# Argspec-name (Arglistspec-argspecs arglist)))))
			     (let ((rule-env (env-bindings-append
						  true local-bdgs dom-env)))
				(let ((ante-te (term-check
						  defn
						  prop-type*
						  (empty-undo-stack)
						  (cons-Syn-context
						     (tuple ':polarity false)
						     (context-expstack-push
							defn 2 cxt))
						  rule-env))
				      (conse-te (term-check
						   pred-term
						   prop-type*
						   (empty-undo-stack)
						   (context-expstack-push
						      pred-term 1 cxt)
						   rule-env)))
;;;;				   (cond ((and (is-Quantified-typed-exp ante-te)
;;;;					       (Quantified-typed-exp-keep-quantifier ante-te)
;;;;					       (eq (Vartype-var vt) 'optop::fed))
;;;;					  (dbg-save ante-te conse-te)
;;;;					  (breakpoint parse-as-fact
;;;;					     "conse-te: " conse-te)))
				   (let ((rule-te
						(construct-quant-if-te
						   local-bdgs arglist
						   ante-te conse-te
						   prop-type*
						   defn pred-term clause rule-env)))
				      (cond ((= (Typed-exp-totbugs rule-te)
						0)
					     (add-to-rule-group
						(make-Fact rule-te false)
						own-rg)))
				      `(:derived
					   (,(Vartype-var vt)
					    ,@(arglistspec-typed-arglist arglist))
					   ,(flagsource ante-te))))))))
		      (t
		       (note-defective-exp
			  ((c) "High-level predicate in " c)
			  :target `(:derived ,@clause)
			  :context cxt))))))))
				       
(defun construct-quant-if-te (local-bdgs arglist ante-te conse-te res-type
			      ante-source conse-source qif-source env)
   (let ((if-te
            (make-inst If-typed-exp
	       :type res-type
	       :env env
	       :test ante-te
	       :prag '<-
	       :iftrue conse-te
	       :iffalse false-te*
	       :subexps (list conse-te ante-te)
	       :tvars (tvars-union (Typed-exp-tvars ante-te)
				   (Typed-exp-tvars conse-te))
	       :source qif-source
	       :ext (if-ext '<- ante-te conse-te false-te*)
	       :source `(<- ,conse-source ,ante-source))))
      (make-inst Quantified-typed-exp
	 :quantifier 'forall
	 :keep-quantifier false
	 :type res-type
	 :use-bindings-as-constraints true
	 :universal true
	 :bindings local-bdgs
	 :source qif-source
	 :ext `(forall ,(arglistspec-typed-arglist arglist)
		  (<- ,(Typed-exp-ext conse-te)
		      ,(Typed-exp-ext ante-te)))
	 :subexps (list if-te)
	 :env env
	 :body if-te)))

(defun bind-pred-constant (predname must-be-new predtype flags dom)
   (bind-constant
      predname must-be-new predtype
      (\\ (predname)
	 (new-Predicate
	    predname predtype
	    :macro false
	    :prechain (memq ':prechain flags)
	    :rigid (memq ':rigid flags)))
      dom))

;;; Returns a list of ill-formed-exps.  'valfn' is function that takes
;;; resolved name and constructs a value.
;;; If 'must-be-new' is false, old binding is okay if of same type.
(defun bind-constant (name must-be-new ctype valfn dom)
   (cond ((not ctype)
	  (signal-problem bind-constant :fatal
	     "Making " name " a constant with null type")))
;;;;   (cond ((memq name '(c1 c2))
;;;;	  (dbg-save dom)
;;;;	  (breakpoint bind-constant
;;;;	     "About to resolve " name " wrt " dom)))
;;;;   (cond ((eq name 'optop::high_skill)
;;;;	  (out (:to *query-io*) "Binding high_skill" :%)))
   (multi-let (((name name-flg)
		(symbol-resolve name dom true)))
      (cond (name
	     (let ((cbdg (place-domain-bdg name dom)))
		(cond ((or (Domain-bdg-unbound cbdg)
			   (and (not must-be-new)
				(or (not (Domain-bdg-type cbdg))
				    (types-equal (Domain-bdg-type cbdg)
						 ctype
						 (domain-place-env dom)
						 (domain-place-env dom)))))
		       (!= (Domain-bdg-val cbdg)
			   (funcall valfn name))
		       (!= (Domain-bdg-type cbdg) ctype)
		       '())
		      (t
;;;;		       (cond ((eq name 'optop::high_skill)
;;;;			      (dbg-save cbdg dom ctype)
;;;;			      (breakpoint bind-constant
;;;;				 "Problem with high_skill")))
		       (list 
			  (out-defective-exp
			     "Object " name " already defined to be"
			     " of type " (Domain-bdg-type cbdg)))))))
	    (t
	     (list name-flg)))))

(defvar auxfn-counter* 0)

;;; The name (usually of a thing defined 'define'd) that distinguishes
;;; its auxiliary functions from other things.
(defvar aux-defs-name* false)

(defun proc-compile (procdef)
   (let-fun ()
      (match-cond procdef
	 ((not procdef)
	  false)
	 ((is-Symbol procdef)
	  (eval procdef))
	 (:? (quote ?(:+ ?s is-Symbol))
	    s)
	 (:? (function ?(:+ ?s is-Symbol))
	    (cond ((fboundp s)
		   (symbol-function s))
		  (t s)))
	 (:? (function ?_)
	   (eval procdef))
	 (:? (\\ ?args ?@body)
	   (multi-let (((args body)
			(ytools::ignore-smooth args body)))
	      (compile-or-eval args body)))
	 (:? (function (lambda ?args ?@body))
	   (compile-or-eval args body))
	 (t
	  (note-defective-exp
	     ((procdef) "Illegal as function spec: " procdef)
	     :target procdef)))

      :where

	(compile-or-eval (args body)
;;;;	   (out (:to *query-io*)
;;;;		"Processing " procdef " by ")
	   (cond ((and eval-aux-defs*
		       (eq aux-defs* ':not-allowed))
;;;;		  (out (:to *query-io*) "evaluation" :%)
		  (eval `(function (lambda ,args ,@body))))
		 (t
		  (let ((name-distinguisher
			   (cond ((not aux-defs-name*)
				  (signal-problem proc-compile
				     "aux-defs-name* unbound in definition "
				     args 1 :% 3 body
				     (:continue "The function will have an ambiguous name"))
				  "")
				 (t aux-defs-name*))))
		     (let ((name (build-symbol
				    auxfn- (< name-distinguisher)
				    - (++ auxfn-counter*))))
;;;;		       (cond ((eq aux-defs* ':not-allowed)
;;;;			      (out (:to *query-io*) "previous ")))
;;;;		       (out (:to *query-io*) "compilation to " name :%)
		       (cond ((not (eq aux-defs* ':not-allowed))
			      (note-aux-def ':fun `(,name ,args ,@body))))
		       name)))))))