;-*- Mode: Common-lisp; Package: opt; Readtable: ytools; -*-
(in-package :opt)
;;; $Id: coerce.lisp,v 1.12 2005/07/26 19:34:17 dvm Exp $

(depends-on %module/ ytools)

(depends-on :at-run-time %opt/ deduction checker)

;;; Necessary because by the time we call 'subtype-coerces-to-supertype'
;;; (defined in builtins.opt), we may be in a domain where the type 
;;; designators no longer denote anything.  This table records what
;;; they denote in the domain we started in.
(defvar coerce-desig-kludge* !())

(defun opt-coercer (te got-type targ-type got-env targ-env
		    undo-stack context)
   (let ((domain (find-domain-in-vartypes (Typed-exp-env te))))
      (cond (domain
	     (repeat :for ((anc :in (Domain-ancestors domain)))
	      :result (signal-problem opt-coercer
			 "No obvious domain to use for coercion for: "
			 domain)
	      :while (domain-under-construction anc)
	      :result (!= domain anc))
	     (let ((got-desig (type-find-designator got-type got-env))
		   (targ-desig (type-find-designator targ-type targ-env)))
		(letrec ()
	           (cond ((and (desig-boring got-desig)
			       (desig-boring targ-desig))
			  (let ((wrapper
				   (try-deduce-coercion-wrapper
				      got-desig targ-desig got-type targ-type domain)))
			     (cond (wrapper
				    (coercion-wrap 
					  wrapper te targ-type undo-stack context))
				   (t
				    (values ':pass undo-stack)))))
			 (t
			  (values ':pass undo-stack)))
		 :where
		    (desig-boring (d)
		       (cond ((or (nisptype::is-param-exp d)
				  (ytools::is-Qvaroid d))
			      false)
			     ((atom d) true)
			     (t
			      (forall (e :in d)
				 (desig-boring e))))))))
	    (t
	     (signal-problem opt-coercer
		"Typed-exp " te " has no domain")))))

(defvar break-on-coerce-fail* false)

(defun try-deduce-coercion-wrapper (got-desig targ-desig got-type targ-type domain)
   (!= domain (domain-indexify domain))
;;;;   (dbg-save got-desig targ-desig domain)
;;;;   (breakpoint try-deduce-coercion-wrapper
;;;;      "About to deduce")
;;;;   (dbg-save got-desig targ-desig domain)
;;;;   (breakpoint
;;;;      "In try-deduce-coercion-wrapper")
   (let ((coerce-goal 
	    (desig-syms-resolve
	       `(coerce ,got-desig ,targ-desig (:!sym ?fn))
	       (domain-place-env domain))))
      ;; Use internalized versions of the desigs.
      (match-let (?_ ?got-desig ?targ-desig ?_)
		 coerce-goal
	 (let ((cal (bind ((coerce-desig-kludge*
			      (list (tuple got-desig got-type)
				    (tuple targ-desig targ-type))))
		       (deduce coerce-goal
			       dummy-id* !()
			       (domain-place-fact-sit domain true)
			       domain))))
;;;;	    (dbg-save cal coerce-goal domain)
;;;;	    (breakpoint try-deduce-coercion-wrapper
;;;;	       "coerce-goal = " coerce-goal "  answers = " cal)
	    (repeat :for ((a :in cal)
			  fn
			  :collector wrappers)
	       (!= fn (unsafe-varsubst '?fn dummy-id* a))
	       (cond ((has-qvars fn)
		      (dbg-save :run-loud
			  cal a coerce-goal
			  (fsit (domain-place-fact-sit domain true))
			  domain 
			  got-desig targ-desig)
		      (signal-problem opt-coercer
			 "Useless coercion output: fn = "
			 fn)))
	     :collect fn
	     :result
	       (cond ((null wrappers)
		      (cond (break-on-coerce-fail*
			     (dbg-save got-desig targ-desig got-type targ-type domain
				       coerce-goal)
			     (breakpoint try-deduce-coercion-wrapper
				"No way to coerce " got-desig " to " targ-desig)))
		      false)
		     ((not (null (cdr wrappers)))
		      (note-defective-exp
			 ((targ) "Ambiguous coercion "
			  :% 3 targ
			  :% "  to type " targ-type
			  :% "  --> " cal)
			 (:continue "I will do a trivial coercion"))
		      'identity)
		     (t
		      (car wrappers))))))))

(defun coercion-wrap (fn te targ-type undo-stack context)
   (match-cond fn
      (:? identity 
;;;;	(!=? (Typed-exp-type te)
;;;;	     targ-type
;;;;	     undo-stack)
	(values te undo-stack))
      (:? (\\ (?v) ?e) 
	(term-check
	   (subst `(already-checked ,true ,te)
		  v e)
	   targ-type undo-stack context
	   (Typed-exp-env te)))
      (:? (compose ?c1 ?c2)
	(multi-let (((te2 undo-stack-2)
		     (coercion-wrap c2 te univ-type* undo-stack context)))
	   (coercion-wrap c1 te2 targ-type undo-stack-2 context)))
      (t
       (term-check
	  `(,fn (already-checked ,true ,te))
	  targ-type undo-stack context
	  (Typed-exp-env te)))))

(cond ((not (Typed-dialect-data-type-transer opt-dialect-handler*))
       (indexify-universal-ancestors)))

(!= (Typed-dialect-data-type-transer opt-dialect-handler*)
    #'opt-coercer)
