(defun compose-substitutions (s1 s2)
  "Compose substitution s1 with s2."
  (let ((s3 (mapcar #'(lambda (B) 
			(make-binding (binding-sym B)
				      (apply-substitution s2 (binding-exp B))))
		    s1))
	(s4 (remove-if #'(lambda (B) 
			   (substitution-bound-p s1 (binding-sym B)))
		       s2)))
    (append s3 s4)))