;-*- Mode: Common-lisp; Package: opt; Readtable: ytools; -*-
(in-package :opt)
;;; $Id: context.lisp,v 1.8 2005/11/07 18:15:01 dvm Exp $

(depends-on :at-run-time %opt/ definers parsers deduction)

(eval-when (:compile-toplevel :load-toplevel :slurp-toplevel)
    (export '(context new-deduction-context find-named-context
	      all-assertions all-axioms sexp-syms-place
              deduce-envs deducible deduce-instances
              default-domain* default-situation* deduce-auto-initialize*
              )))

(declaim (special ground-id* dummy-id*))
         
(defun deduce-envs (goal &key (varid dummy-id*)
                              (env (empty-env))
                              sit dom)
   (multi-let (((sit dom)
                (check-sit-dom sit dom)))
      (deduce goal varid env sit dom)))

(defun deducible (query &key (varid dummy-id*)
                             (env (empty-env))
                             sit dom)
   (multi-let (((sit dom)
                (check-sit-dom sit dom)))
      (not (null (deduce query varid env sit dom)))))

(defun deduce-instances (query &key (varid dummy-id*)
                                    (env (empty-env))
                                    (return-envs false)
                                    sit dom)
   (multi-let (((sit dom)
                (check-sit-dom sit dom)))
      (repeat :for ((a :in (deduce query varid env sit dom))
                    :collectors instances envs)
       :within
          (multi-let (((inst e)
                       (safe-varsubst query varid a)))
             (:continue
              :collect (:into instances inst)
              :when return-envs
              :collect (:into envs e)))
        :result (values instances
                        (cond (return-envs envs)
                              (t nil))))))
   
;;;;(defun dt (q sit)
;;;;   (let ((isit (find-init-situation sit)))
;;;;      (let ((dom (Initial-situation-domain isit)))
;;;;	 (deduce (dsr q dom) 1 (empty-env) sit dom))))

(defvar default-domain* false)
(defvar default-situation* false)

;;; If true, reinitialize with every call, which is normally
;;; too inefficient, but okay for pedagogical contexts.
(defvar deduce-auto-initialize* false)

(defun check-sit-dom (sit dom)
   (cond ((and dom (is-Symbol dom))
          (!= dom (try-domain-with-name dom false))))
   (cond ((is-Domain dom)
          (!= default-domain* dom))
         (t
          (cond (default-domain*
                 (!= dom default-domain*))
                (t
                 (signal-problem 
                    "Deduction with illegal domain " dom)))))
   (cond (deduce-auto-initialize*
          (!= dom (domain-indexify dom))
          (domain-make-current dom)))
   (cond ((and sit (is-Symbol sit))
          (!= sit (find-domain-bdg sit dom))
          (cond (sit
                 (!= sit (Vartype-val *-*))))))
   (cond ((is-Situation sit)
          (!= default-situation* sit))
         (sit
          (signal-problem
              "Deduction with illegal situation " sit))
         ((and default-situation*
               (sit-dom-compatible default-situation* dom))
          (!= sit default-situation*))
         (t
          (!= sit (domain-place-fact-sit dom false))
          (!= default-situation* sit)))
   (cond (deduce-auto-initialize*
          (situation-initialize sit)))
   (values sit dom))

(defun sit-dom-compatible (sit dom)
   (let ((init-sit (find-init-situation sit)))
      (let ((d (Initial-situation-domain init-sit)))
         (or (eq d dom)
             (eq (first (Domain-parents d)) dom)))))

(defun get-var-val (v al &key (id dummy-id*))
	   (cond ((= (length al) 1)
                  (get-var-val-1 v (car al) :id id))
		 (t
		  (cerror "I'll assume a value of nil"
			  "No unique value for ~s  in ~s" 
			  v al)
		  nil)))

(defun get-var-val-1 (v e &key (id dummy-id*))
   (Expclo-skel (Varbdg-val (uvar-lookup v id e))))




(def-opt-form-handler context definer (def-form)
   (situation-define 'context def-form))

(declaim (special flag-count*))

;;; Note: can't have timeless facts in dynamically built context; no
;;; reason not to, just don't anticipate a demand. All rules can be
;;; represented as timeful facts with no efficiency hit. If two
;;; contexts in the same domain have the same name, they will have the
;;; same namespace.
(defun build-context (name doms obs inits)
   (let ((idom (domain-indexify (car doms))))
      (let ((sit (cond (name (domain-place-situation idom name))
		       (t (new-Initial-situation false idom))))
	    (initial-flag-count flag-count*))
	 (let ((subdom (domain-indexify (Initial-situation-domain sit))))
	   (!= (Domain-parents subdom) (mapcar #'domain-indexify doms))
	   (maybe-set-subdom-namespace subdom doms
				       (and (null obs) name))
	   (domain-reset subdom)
	   (reset-ancestors subdom)
	   (let ((flg-consts (constants-parse obs subdom)))
	       (multi-let (((props prop-flg-junk)
			    (list-smooth inits #'consp)))
		  (let ((lits (<# (\\ (a)
				     (formula-typecheck
				        a true
					(empty-undo-stack)
					!()
					subdom))
				  props)))
		     (cond ((not (= flag-count* initial-flag-count))
			    (signal-problem build-context
			      "Syntactic errors in formulas used to initialize context: "
			       (:pp lits)
			       (:proceed "I will use them anyway"))))
		     (!= (Initial-situation-delta sit) lits)
		     (domain-mark-current subdom)
		     (situation-initialize sit)
		     ;; situation-initialize now does this --
		     ;;(context-forward-chain sit)
		     (!= (Situation-frozen sit) false)
		     (values sit
			     flg-consts
			     (append (<# (\\ (l) (Typed-exp-source l))
					 lits)
				     prop-flg-junk)))))))))

;;; 'old' can be any Situation (including another context).
;;; Incremental contexts don't have names; they inherit the namespace of 'old'.
(defun incremental-context (old add delete dom)
   (setq dom (domain-indexify dom))
   (indexed-domain-make-current dom)
   (multi-let (((predecessor new-index)
		(cond (old
		       (values (find-init-situation old)
			       (exp-index-copy (Situation-diff-from-init old))))
		      (t
		       (values (domain-place-timeless-sit dom)
			       (exp-index-init #'Signed-occasion-prop))))))
      (let ((newsit
	       (make-Subsequent-situation
		  :diff-from-init new-index
		  :contents ':variable
		  :init predecessor
		  :frozen false
		  :path (cons 'push-context (cond (old (Situation-path old))
						  (t '())))
		  :query-tab (make-hash-table :test #'eq))))
	 (dolist (d delete)
	     (assertion-erase d newsit dom))
	 (dolist (a add)
	    (assertion-add a newsit dom))
	 newsit)))

;;; If we start an anonymous context from scratch, we have to create an initial
;;; situation to hold a timeless index (and any conclusions drawn purely from
;;; timeless assertions).
(defun domain-place-timeless-sit (dom)
   (let ((placeholder-sit 
	    (domain-place-situation dom (intern (format nil "~a-TIMELESS"
							(Domain-name dom))))))
      (situation-initialize placeholder-sit)
      placeholder-sit))

(defun find-named-context (name dom)
   (let ((bdg (find-domain-bdg name dom)))
     (cond (bdg
	    (let ((c (Domain-bdg-val bdg)))
	       (cond ((is-Initial-situation c)
		      c)
		     (t
		      (error "~s is not a situation of ~s [value: ~s]"
			     name dom c)))))
	   (t
	    (error "~s unbound in ~s"
		   name dom)))))

(defun all-assertions (con)
   (let ((initsit (situation-initialize (find-init-situation con)))
	 (diffs (exp_index-contents (Situation-diff-from-init con)
				    false)))
      (let ((ind (exp-index-copy (Initial-situation-init-index initsit))))
	 (repeat :for ((d :in diffs))
	    (exp-ob-index (Signed-occasion-occ d)
			  ind
			  (Signed-occasion-sign d)))
	 (exp_index-contents ind true))))

(defun all-axioms (con)
   (let ((dom (Initial-situation-domain (find-init-situation con))))
      (let ((fsit (domain-place-fact-sit dom true)))
	 (exp_index-contents
	    (Initial-situation-fact-index fsit)
	    true))))
  
(defun sexp-syms-place (exp dom)
   (let-fun ((massage (e)
		(cond ((and e (is-Symbol e))
		       (nth-value 0 (symbol-resolve e dom false)))
		      ((atom e) e)
		      (t
		       (<# massage e)))))
      (massage exp)))