;-*- Mode: Common-lisp; Package: opt; Readtable: nisp; -*-
(in-package :opt)

(depends-on nils)

(depends-on types)

(depends-on at-run-time opt/ basics types)

NOT CURRENTLY USED

;;; This stuff would be more useful if 'opt-load' knew what to do 
;;; with it.  In the long run, opt-load should go away, and all 'define'
;;; forms should macro-expand to calls to constructs like 'declare-const'
;;; et al.

(defmacro declare-const (name type-desig
			 &key ((:type-system type-sys^)
			      'top-level-type-system*)
			      ((:domain dom^) false))
   `(name-declare-as-const
       ',name ',type-desig
       ,(declare-domain dom^ type-sys^)))

(defmacro declare-func (pat &key ((:type-inverter inv^) 'false)
				 ((:domain dom^) false)
				 ((:type-system type-sys^)
				  'top-level-type-system*))
   `(pat-declare-as-func
	',pat ,(declare-domain dom^ type-sys^) :type-inverter ,inv^)) 

(defmacro declare-pred (pat 
			&key ((:domain dom^) false)
			     ((:type-system type-sys^)
			      'top-level-type-system*)
			     ((:macro macro^) 'false)
			     ((:prechain prechain^) 'false)
			     ((:rigid rigid^) 'false)
			     ((:type-inverter inverter^) 'false))
   `(pat-declare-as-pred
       ',pat
       ,(declare-domain dom^ type-sys^)
       :macro ,macro^ :prechain ,prechain^
       :rigid ,rigid^
       :type-inverter ,inverter^
       ))

(needed-by-macros
(defun declare-domain (dom^ type-sys^)
   (cond ((try-domain-with-name dom^ false)
	  `(try-domain-with-name ',dom^ false))
	 ((find-type-system type-sys^ false)
	  `(find-type-system ',type-sys^ false))
	 (t type-sys^)))
)

(defmacro declare-sym (sym type
		       &key ((:val-ob val-ob^) 'false)
			    ((:domain dom^) false)
			    ((:type-system type-sys^)
			     (ensure-top-level-type-sys)))

   `(typedecl ',sym
	      (designated-type ',type true global-env*)
	      ,val-ob^
	      ,(declare-domain dom^ type-sys^)))

(defun name-declare-as-const (name type-desig dom)
   (let ((const-type
	     (designated-type type-desig true
			      (empty-vartypes dom))))
      (typedecl name const-type
		(make-Constant name const-type)
		dom)))

(defun pat-declare-as-pred (pat dom
			    &key macro prechain rigid type-inverter)
    (multi-let (((name pred-type) (pat-fun-type pat 'Prop dom)))
       (typedecl name pred-type
		 (new-Predicate name pred-type 
				:type-inverter type-inverter
				:macro macro
				:prechain prechain
				:rigid rigid)
		 dom)))
				 
(defun pat-declare-as-func (pat dom
			    &key (type-inverter false)
				 (callable false))
   (multi-let (((head ftype)
		(pat-fun-type pat false dom)))
      (typedecl head ftype
		(make-Functional-constant
		   :name head :type ftype
		   :type-inverter type-inverter
		   :callable callable)
		dom)))

(defun pat-fun-type (pat restype-desig dom)
   (multi-let (((head _ level rty0 aty0 aty1)
		(fundecl-decompose pat '() (not restype-desig))))
      (cond ((eq rty0 '*absent)
	     (!= rty0 (or restype-desig 'Obj))))
      (values head
	      (cond ((= level 0)
		    (build-funtype rty0 aty0 0 false
				   (empty-vartypes dom)))
		    (t
		     (build-funtype `(Fun ,rty0 <- ,aty0)
				    aty1 1 false
				    (empty-vartypes dom)))))))

;;; Returns < head, flags, level, low-res, low-arg, high-arg >
;;; Missing piece has value *absent.
;;; All the pieces are source stuff --- no internalization is done
;;; by fundecl-decompose.
;;; 'flags' are things like :nochain that get stuck inside arg lists
;;; for want of a better place and must be detected here and returned.
(defun fundecl-decompose (term possible-flags allow-explicit-restype)
   (multi-let (((head level rtype args body)
		(nisptype::extract-fun-header term)))
      (cond ((not (or (null body) (eq body '*absent)))
	     (note-defective-exp
		((_) "Declaration of " head
		     " is not allowed to have a definition: " body)
		:place fundecl-decompose
		(:continue "I'll ignore it"))))
      (cond ((and (not allow-explicit-restype)
		  (not (eq rtype '*absent)))
	     (note-defective-exp
		((_) "No result type allowed in this context: "
		 rtype)
		:place fundef-decompose
		(:novalue "I will ignore it"))
	     (!= rtype '*absent)))
      (multi-let (((flags args)
		   (classify args (\\ (x) (memq x possible-flags)))))
	 (cond ((and (> level 0) (car-eq rtype 'Fun))
		(multi-let (((lev0 rty0 aty0 _)
			     (nisptype::funtype-desig-decompose rtype)))
		   (cond ((> lev0 0)
			  (note-defective-exp
			     ((_) "High-level funtype " rtype
				  " as restype of high-level funtype")
			     :place fundecl-decompose
			     (:continue "I'll pretend it's level 0"))))
		   (values head flags level rty0 aty0 args)))
	       (t
		(cond ((> level 0)
		       (note-defective-exp
			  ((_) "Resulttype makes no sense for high-level"
			       " function: " t rtype)
			  :place fundecl-decompose
			  (:continue "I'll assume it's a level-0 function"))))
		(multiple-value-let (low high)
				    (args-low-high-split
					  args true empty-env*)
		      (cond ((null high)
			     (values head flags 0 rtype args '*absent))
			    (t
			     (values head flags 1 rtype low high)))))))))

(def-meth var-val-typed-exp ((val Constant) vt _ env)
   (make-inst Const-typed-exp
      :val val
      :type (Constant-type val)
      :source (Vartype-var vt)
      :env env))
      