;-*- Mode: Common-lisp; Package: opt; Readtable: nisp; -*-
(in-package :opt)

(defmacro symdecl (sym td compile-time-callable sysname)
      `(typedecl ',sym
		 (compile-time-designated-type
		    ,td ,sysname)
		 ,compile-time-callable
		 (find-type-system ',sysname true)))


(defvar num-type*
    (globally-defined-type 'Number universal-type-sys* true))

(defvar str-type*
    (globally-defined-type 'String universal-type-sys* true))

;; How do we attach val-conseqs properties to functions in the 
;; first place?  Like this--

(symdecl atom (attach-features
		      (Fun Boolean <- Obj)
		      (val-conseqs
		         ((x)
			  ((false ((x Pair)))))))
	 false opt)

(symdecl is-of-type (Fun 1 (attach-features
				   (Fun Boolean <- Obj)
				   (val-conseqs
				      ((e)
				       ((true ((e u)))))))
			    (u - (T)))
	  #'is-of-type opt)

(symdecl apply (Fun e (f - (Fun e <- (&rest _ -- v))
		       l - (Tup &rest (v) r - v)
		       !& e - (t) v - (tt)))
	 false opt)

(symdecl map (Fun (Lst e) (f - (Fun e <- (&rest (= u)))
			    &rest (u) l - (Lst u)
			    !& e - t u - tt))
	 false opt)
