;-*- Mode: Common-lisp; Package: opt; Readtable: ytools; -*-
(in-package :opt)
;;; $Id: deduction.lisp,v 1.30 2005/12/01 04:06:18 dvm Exp $

(depends-on :at-run-time %opt/ varsubst expdt index assertion parsers
	                       internalize dedutils)

(end-header :continue-slurping)   ;;;;  :no-compile

(eval-when (:compile-toplevel :load-toplevel :execute :slurp-toplevel)
   (export '(get-var-val get-var-val-1
             ground-deduce deduce deducible deduce-check-many
	     trace-deduce* trace-qagen-graph* trace-deduce
	     deduce-maybe-many back-chainer-is-stratified
             declare-infinite-types lit-analyze)))

(defvar breakpoints-on* false)

(defvar trace-deduce*)

(defvar trace-qagen-graph* false)

(defun trace-deduce (&optional set)
   (!= trace-deduce*
       (case set
          (:on true)
          (:off false)
          (t (not *-*))))
   (!= trace-qagen-graph* trace-deduce*))

;;; Key idea in this file: There is a graph of Query-answer-gens that is
;;; independent of what's true in any particular situation.  This network
;;; captures all the relationships among rules, and between queries and rules.
;;; Within each situation, a Query-answer-gen is associated with a
;;; Query-ans-spec, which represents the answers it has in this situation.
;;; Finding a new answer can open up new ways to answer a Query-ans-gen,
;;; so the situation-independent (QAGen) graph continues to grow as
;;; situations are explored.  Graph growth and answer propagation are
;;; interleaved, so it is vital that the invariants described below are
;;; maintained.

;;; When generating answers (entry point: deduce-after-subst), a unique
;;; 'gen-id' is created, and stored in the 'gen-id' fields of 
;;; Query-answer-gens that are touched along the way (i.e., those that could
;;; possibly yield an answer to the top-level-query) get the same gen-id.

;;; 'body' represents all ways in this domain to answer the query, in disjunctive 
;;; normal form
(def-class Query-answer-gen (:options :key)
   status ; - (Const :new :under-construction :complete)
   occ    ; - (~ Occasion), a uniquified variant of original query
   var-id ; - (~ Varid) (false if no vars in query)
   gen-id ; - Integer
   depth  ; - Integer
   refcount ; - (~ Integer), false if unstratified
   answers ; - (Lst (Lrcd Situation Query-ans-spec))
;;;;   answers-somewhere  ;; currently used just for debugging
;;;;          ; - (Lst (Lrcd (Alt Occasion (Const :many :none))
;;;;          ;              (~ Bdgenv)))
   body   ; - (Lst Query-conjunction)
   ;; -- dnf of right-hand-sides of all rules
   continuations ; - (Lst (Deductive-continuation))
   
   (:handler
       (print (qag srm)
	  (out (:to srm)
	       "#<Query " (Query-answer-gen-query qag)
	           "/" (Query-answer-gen-var-id qag)
		   "*" (Query-answer-gen-gen-id qag)
		   "[" (Query-answer-gen-depth qag) "]~"
		   (Query-answer-gen-refcount qag)
	           " v" (len (Query-answer-gen-body qag))
		   " ^" (len (Query-answer-gen-continuations qag))
		   1 (Query-answer-gen-status qag)
		   ">")))
)

(defun Query-answer-gen-query (qag)
   (let ((q (Occasion-prop (Query-answer-gen-occ qag))))
      (cond ((is-Occasion q)
	     (signal-problem Query-answer-gen-query
		qag " has query " q)))
      q))

(defun new-Query-answer-gen (query depth dom)
   (multi-let (((occ id)
		(cond ((has-qvars query)
		       (values (uniquify-occasion-with-vars query dom)
			       (new-Varid)))
		      (t
		       (values (uniquify-occasion query dom)
			       false)))))
      (make-Query-answer-gen
	 :status ':new
	 :occ occ
	 :var-id id
	 :gen-id 0
	 :depth depth 
	 :refcount 0
	 :answers !()
;;;;	 :answers-somewhere !()
	 :body nil
	 :continuations !())))

(defvar qag-id* (new-Varid))

;;; During deduction, bound to Exp_index where Query-ans-gens are uniquified
(defvar query-ans-gen-index* false)

(defun place-Query-answer-gen (query depth dom)
   (find-or-create-Query-answer-gen query depth dom true))

(defun find-Query-answer-gen (query depth dom)
   (find-or-create-Query-answer-gen query depth dom false))

(defun find-or-create-Query-answer-gen (query depth dom create)
   (cond (query-ans-gen-index*
	  (let ((cands (exp-fetch query query-ans-gen-index* true)))
	  
;;;;  (let ((qag-index (indexed-domain-place-query-ans-gens dom)))
;;;;     (let ((cands (exp-fetch query qag-index true))) ...))

	     (repeat :for ((c :in cands))
	      :result (cond (create
			     (let ((new-qag
				      (new-Query-answer-gen
                                         query (or depth 0) dom)))
				(exp-ob-index
                                   new-qag query-ans-gen-index* true)
;;;;	         		   (exp-ob-index new-qag qag-index true)
				(dbg-out trace-qagen-graph* 
				    "Creating " new-qag :%)
				new-qag))
			    (t false))
	      :until (variants (Query-answer-gen-query c)
			       query
			       (Query-answer-gen-var-id c)
			       qag-id*
			       (empty-env))
	      :result (progn
			 (cond (depth
				(!= (Query-answer-gen-depth c) depth)))
			 c))))
	 (t
	  (signal-problem place-Query-answer-gen
	     "Attempt to place Query-answer-gen for query " query
	     :% " with no index in place"))))

;;; The index will simply be GC'ed.
(defun query-answer-gen-remove (_ _)
   nil)

;;;;(defun query-answer-gen-remove (qag dom)
;;;;   (exp-ob-index qag
;;;;		 (indexed-domain-place-query-ans-gens dom)
;;;;		 false))

;;;;(def-class Goal-call-answer-gen
;;;;    (:options (:include Query-answer-gen))
;;;;    env)


(def-class Query-conjunction
   first        ; - Query-answer-gen (initially an Sexp)
   remaining    ; - (Lst Sexp)
   super       ; - Query-answer-gen
   temp
   ;; - (~ Integer) gen-id to which this guy belongs, or false if
   ;; permanent
)


;;;;(defun indexed-domain-place-query-ans-gens (idom)
;;;;   (let ((ans-gens (Indexed-domain-query-answer-gens idom)))
;;;;      (cond ((not ans-gens)
;;;;	     (!= ans-gens 
;;;;		 (tuple (Domain-generation idom)
;;;;			(exp-index-init #'Query-answer-gen-query)))
;;;;	     (!= (Indexed-domain-query-answer-gens idom)
;;;;		 ans-gens)))
;;;;      (second ans-gens)))

;;; Represents a partial answer to an element of the !_body of a
;;; Query-answer-gen.  A new answer to 'query' allows one to continue
;;; with the remaining queries in !_qconj.  When they're all satisfied,
;;; you can generate a new answer to !_super-ag.
(def-class Deductive-continuation
  (:options :key)
  sense    ; - Boolean
  qc-id    ; - Varid for vars in 'qconj' stored in 'ans-so-far'
  cover-id ; - (~ Varid) for qag transmitting through this continuation
  ans-so-far ; - Bdgenv 
  qconj    ; - Query-conjunction
  succs    ; - (Lst (Lrcd (Alt Occasion (Const :many :none))
           ;              (Alt Query-conjunction 
           ;                   (Lrcd Occasion Bdgenv))))

  (:handler
     (print (cont srm)
	  (out (:to srm)
	     (:pp-block (:pp-ind :block 3)
		"#<Continuation " (:q ((not (Deductive-continuation-sense cont)) "~"))
		"/" (Deductive-continuation-cover-id cont)
		"/" (Deductive-continuation-qc-id cont)
		"/" (Deductive-continuation-ans-so-far cont)
		1
		(:pp-nl :linear)
		(Deductive-continuation-qconj cont)
		1
		(:pp-nl :linear)
		(Deductive-continuation-succs cont)
		1
		(:pp-nl :linear)
		(:q ((Deductive-continuation-temp cont)
		     " Temp: " (Deductive-continuation-temp cont)))
		">"))))
)

(defun Deductive-continuation-super-ag (dc)
   (Query-conjunction-super (Deductive-continuation-qconj dc)))

(defun Deductive-continuation-temp (dc)
   (Query-conjunction-temp (Deductive-continuation-qconj dc)))

(defun situation-place-query-tab (sit)
   (let ((tab (Situation-query-tab sit)))
      (cond ((not tab)
	     (!= tab
		 (tuple (next-generation)
			(make-hash-table :test #'eq)))
	     (!= (Situation-query-tab sit)
		 tab)))
      (second tab)))

(def-class Query-ans-spec 
   status
  ;;- (Const :unprocessed :fetching-assertions :assertions-fetched 
  ;;         :backward-chaining :answers-found :answers-propagated)
   many ;; - Boolean
   welcome ;; - Boolean, false if the system has based non-monotonic
	   ;; conclusions on there being no answers.
   answers ;; - (Lst (Lrcd Occasion Bdgenv)) 
   ;; -- envs may be (and are) simplified to use only id of Query-answer-gen
   (:handler
       (print (qas srm)
	  (out (:to srm)
	     "#<Query answers "
	           (:q ((Query-ans-spec-many qas) "___"))
		   (:q ((not (Query-ans-spec-welcome qas)) "?"))
		   (:q ((not (null (Query-ans-spec-answers qas)))
			(Query-ans-spec-answers qas)))
	     1 (Query-ans-spec-status qas) ">")))

   )
;;;   :fetching-assertions -> grinding assertional answers
;;;;  :assertions-fetched -> assertional answers found
;;;;  :backward-chaining -> finding answers via sub-qagens.
;;;;  :answers-found -> answers derivable from subtree below this node derived
;;;;  :answers-propagated -> those answers have been propagated to continuations

;;; The 'occ' of a Query-answer-gen is the query, uniquified.  If you
;;; prove that, it's the most general possible answer, and you can
;;; stop looking.
(defun found-perfect-answer (qas qag)
   (assq (Query-answer-gen-occ qag)
	 (Query-ans-spec-answers qas)))

;;; Returns the Query-ans-spec for 'qagen' in 'sit'.
(defun place-query-answers (qagen sit)
   (alref (Query-answer-gen-answers qagen)
	  sit
	  (let ((ans-spec (make-Query-ans-spec ':unprocessed false true !())))
	     (!= (Query-answer-gen-answers qagen)
		 (cons (tuple sit ans-spec) *-*))
	     ans-spec)))
			
;;;;   (let ((qhtab (situation-place-query-tab sit)))
;;;;      (let ((q-tab-answers (href qhtab qagen)))
;;;;	 (cond ((not q-tab-answers)
;;;;		(!= q-tab-answers (make-Query-ans-spec ':unprocessed false !()))
;;;;		(!= (href qhtab qagen)
;;;;		    q-tab-answers)))
;;;;	 q-tab-answers)))

(defun query-answers-remove (qagen sit)
                            (ignore qagen sit)
   nil)
;;;;   (remhash qagen (situation-place-query-tab sit)))

(defun find-query-answers (qagen sit)
   (alref (Query-answer-gen-answers qagen) sit))

;;;;   (let ((qhtab (situation-place-query-tab sit)))
;;;;      (href qhtab qagen)))

(def-class Nonmon-restart
   query-answer-gen ; - Query-answer-gen
   query-ans-spec ; - Query-ans-spec
   continuation ; - Deductive-continuation
   )

(defvar query-generation-id* 0)

(defun next-query-generation-id ()
   (!= query-generation-id* (+ *-* 1))
   query-generation-id*)

(indexify-universal-ancestors)

(defun ground-deduce (query sit dom)
   (not (null (deduce query ground-id* (empty-env) sit dom))))

(defun deduce (query qid bdgs sit dom)
   (delete many-bdgs*
	   (deduce-maybe-many query qid bdgs sit dom)
	   :test #'eq))

; first value is t if possibly many solutions, but procedural query handlers
; couldn't tell.  
(defun deduce-check-many (query qid bdgs sit dom)
   (let ((sl (deduce-maybe-many query qid bdgs sit dom)))
      (cond ((member many-bdgs* sl :test #'eq)
	     (values t (delete many-bdgs* sl :test #'eq)))
	    (t
	     (values nil sl)))))

(defun deduce-maybe-many (query qid bdgs sit dom)
   (multi-let (((query bdgs)
		(safe-varsubst query qid bdgs))) 
      (deduce-after-subst query qid bdgs sit dom)))

(defvar last-query-ans-gen-index* false)

;;; List of Nonmon-restarts --
(defvar postponed-nonmons* false)

;;; :error, :warn, or false for passive aggression.
(defvar circular-nonmon-reaction* ':error)

(defvar last-top-qag*)

(defun deduce-after-subst (query qid bdgs sit dom)
   (cond (query-ans-gen-index*
	  (signal-problem deduce-after-subst
	     "Recursive call of deduction machinery with query-ans-gen-index*"
	     " already bound"
	     (:proceed "I'll rebind it locally"))))
   
   (bind ((query-ans-gen-index*
	     (exp-index-init #'Query-answer-gen-query))
	  (postponed-nonmons* !()))
      (!= last-query-ans-gen-index* query-ans-gen-index*)
;;;;   (cond ((not deduction-legal*)
;;;;	  (signal-problem deduce-after-subst
;;;;	     "Attempt to perform deduction under illegal circumstances: "
;;;;	     :% " Query: " query
;;;;	     :% " [" qid "] " bdgs 1 sit 1 dom)))

      (let ((query-dnf (disjunctive-normal-form query true)))
	 (let-fun ()
	     (let ((gen-id (next-query-generation-id)))     
		(let ((query-ag
			 (make-Query-answer-gen
			    :status ':complete
			    ;; This is purely in case someone
			    ;; wants to look.  The occasion
			    ;; is not uniquified. --
			    :occ (make-Occasion query false false)
			    :var-id qid
			    :gen-id gen-id
			    :depth 0
			    :refcount 0
			    :answers !()
   ;;;;			 :answers-somewhere !()
			    :body nil
			    :continuations !())))
		   (cond ((dnf-build-backchains
			      query-dnf qid (empty-env)
			      query-ag gen-id true sit dom)
			  ;; Degenerate true
			  (list bdgs))
			 (t
			  (ans-gen-in-sit query-ag gen-id)))))

	  :where

	    (:def ans-gen-in-sit (query-ag gen-id)
	       (!= last-top-qag* query-ag)

	      (let ()
		(let ((qas (query-gen-generate query-ag gen-id sit dom))
		      (qag-id (Query-answer-gen-var-id query-ag)))
		  (repeat
		    :until (null postponed-nonmons*)
		      (!= postponed-nonmons*
			  (sort *-* #'>
				:key (\\ (nms)
					(Query-answer-gen-depth
					    (Nonmon-restart-query-answer-gen
					        nms)))))
		      (dbg-out trace-qagen-graph*
			 "Postponed nonmons = "
			 :% 5 postponed-nonmons*)
		      (query-generation-restart
		          (off-list postponed-nonmons*)
			  sit dom))
		  (nconc (cond ((Query-ans-spec-many qas)
				(list many-bdgs*))
			       (t !()))
			 (cond (qag-id
				(repeat :for ((occ+env :in (Query-ans-spec-answers qas)))
				 :within
				   (multi-let (((consis ans)
						(env-merge-super
						       (second occ+env)
						       bdgs qag-id qid)))
				      (cond (consis
					     (:continue
					      :collect ans))
					    (t
					     (signal-problem deduce-after-subst
						"Can't reconcile query answers "
						(second occ+env) "/" qag-id
						:% " with original substitution "
						bdgs "/" qid))))))
			       (t
				(<# second (Query-ans-spec-answers qas))))))))))))

;;; Return true if dnf is trivially true
;;; 'env' links vars in 'qag' to those in 'dnf'.  
;;; 'id' is for 'dnf' vars; look in 'qag' for its id.
(defun dnf-build-backchains (dnf id env qag active-gen-id stratified sit dom)
   (cond ((memq !() dnf)
	  true)
	 (t
	  (!= (Query-answer-gen-body qag)
	      (nconc
		 (<# (\\ (c)
			(let ((qc (make-Query-conjunction
				     (car c) (cdr c) qag
				     (and stratified active-gen-id))))
			   (build-sub-backchain-graph
			      qc id env active-gen-id 
			      (+ (Query-answer-gen-depth qag) 1)
			      sit dom)
			   (let ((first-step (Query-conjunction-first qc)))
			      (cond ((Query-answer-gen-refcount first-step)
				     (!= (Query-answer-gen-refcount first-step)
					 (+ *-* 1)))))
			   qc))
		     dnf)
		 *-*))
	  false)))

(defvar delete-temp-deductive-scaffolds* false)

;;; Invariant S[tructural]: 
;;; If qag1 is a Query-answer-gen with status in sit = :answers-propagated
;;; and c1 is one of its continuations, with super-ag qag0, and both
;;; qag0 and qag1 have the current gen-id,
;;; and e1 is one of qag1's answers in sit,
;;; then the 'succs' field of c1 has an entry corresponding to e1.
;;; Must be checked and enforced when 
;;; - An answer to qag1 is found ('query-gen-generate' and 'query-ans-tabulate')
;;; - The status of qag1 advances
;;; - gen-id of qag1 changes (Note that qag0 might = qag1.) ('query-gen-generate')
;;; - continuation is added  ('build-sub-backchain-graph')

;;; Invariant P[ropagational]:
;;; If qag1 has status :answers-propagated in sit, 
;;; and e1 is one of its answers, 
;;; and c1 is one of its continuations consistent with e1
;;; then if the successor for e1 in c1 is an answer e0 to qag0, 
;;;        then e0 is tabulated for qag0 in sit;
;;; and if the successor for e1 in c1 is a Query-conj qc1, then
;;;        the first step in qc1, qag2, is active in sit.

;;; Progression property: If a Query-answer-gen qag is active in
;;; sit, then it will eventually have status :answers-propagated in sit.
;;; (This is obvious, because the only way for it to become active is
;;; for 'query-gen-generate' to be called on it, and if query-gen-generate 
;;; runs to completion, it will push the status to :answers-propagated.
;;; Plus the obvious lemma that the status never goes backward.)

;;; 'env' is bindings accumulated so far, starting with those obtained
;;; by unifying super-query (Query-conjunction-super query-conj)
;;; with rule.  'qc-id' was generated by sit-assertion-fetch when the
;;; rule containing 'query-conj' was found.
;;; If 'sit' is non-false, it is the current situation, and we may
;;; have to interleave graph construction with answer propagation.
(defun build-sub-backchain-graph (query-conj qc-id env active-gen-id
                                  depth sit dom)
   (multi-let (((g1 ans-so-far)
		(safe-varsubst (Query-conjunction-first query-conj)
			       qc-id env))
	       (super-qag (Query-conjunction-super query-conj)))
      (dbg-out trace-qagen-graph*
		"Reducing " super-qag "/" qc-id
		:% " to  [" depth "] " g1
		" + " (debug-varsubst (Query-conjunction-remaining query-conj)
				      qc-id ans-so-far)
		:% " ans-so-far = " ans-so-far
		:% " super-query so far = "
		     (debug-varsubst (Query-answer-gen-query super-qag)
				     (Query-answer-gen-var-id super-qag)
				     ans-so-far)
		:%)
      (multi-let (((lit-sense subq)
		   (lit-analyze g1)))
	 (multi-let (((qag-sense sub-qag)
		      (build-backchain-graph subq active-gen-id depth sit dom)))
;;;;	    (cond ((and breakpoints-on* (matchq (optop::unsafe optop::cb2 ?_) g1))
;;;;		   (dbg-save sub-qag qag-sense)
;;;;		   (breakpoint build-sub-backchain-graph
;;;;		      "Body of 'unsafe cb2' goal = " (Query-answer-gen-body sub-qag))))
	    (!= (Query-conjunction-first query-conj) sub-qag)
	    (let ((sub-id (Query-answer-gen-var-id sub-qag)))
	       (let ((cover-id (cond (sub-id (new-Varid))
				     (t false))))
		  (multi-let (((ok cont-env)
			       (cond (cover-id
				      (unify subq (Query-answer-gen-query sub-qag)
					     qc-id cover-id ans-so-far))
				     (t
				      (values true ans-so-far)))))
			(cond ((not ok)
			       (dbg-save :run-loud subq sub-qag qc-id cover-id
					 cont-env ans-so-far)
			       (signal-problem build-sub-backchain-graph
				  "Goal failed to unify with its Query-answer-gen")))
			(let ((cont 
				 (make-Deductive-continuation
				     :sense (boole-eq lit-sense qag-sense)
				     :ans-so-far cont-env
				     :cover-id cover-id
				     :qc-id qc-id
				     :qconj query-conj
				     :succs !())))
;;;;			   (cond (delete-temp-deductive-scaffolds*
;;;;				  (!= (Query-answer-gen-continuations sub-qag)
;;;;				      (delete-if
;;;;					       (\\ (c)
;;;;						  (let ((tmp
;;;;							 (Deductive-continuation-temp
;;;;							    c)))
;;;;						     (and tmp
;;;;							  (not (= tmp active-gen-id)))))
;;;;					       *-*))))
;;;;			   (cond ((not qag-sense)
;;;;				  (dbg-save query-conj sub-qag cont)
;;;;				  (breakpoint build-sub-backchain-graph
;;;;				     "Got continuation " cont
;;;;				     :% " for " sub-qag)))
			   (!= (Query-answer-gen-continuations sub-qag)
			       (cons cont *-*))
;;;;			   (cond ((and breakpoints-on* (matchq (optop::closed optop::sd1)
;;;;							       (Query-answer-gen-query sub-qag)))
;;;;				  (dbg-save sub-qag sit cont (sub-qas (and sit (place-query-answers sub-qag sit))))
;;;;				  (breakpoint build-sub-backchain-graph
;;;;				     "Adding continuation to " sub-qag " in " sit
;;;;				     :% " -> " cont)))
			   (cond (sit
				  (let ((sub-qas (place-query-answers sub-qag sit)))
				     (case (Query-ans-spec-status sub-qas)
				        ((:unprocessed)
					 (query-gen-generate
					     sub-qag active-gen-id
					     ;;; (Query-answer-gen-depth super-qag)
					     sit dom))
					((:answers-propagated)
					 (cond (trace-deduce*
						(qagen-answers-display
						   ':old sub-qas sub-qag)))
					 (sub-answers-propagate
					     sub-qas sub-qag cont
					     active-gen-id sit dom))))))))))))))

;;; 'query' is a literal.
;;; Returns < sense, Query-answer-gen for query >.
;;; Sense is true unless answers to the Query-answer-gen query *refute* the query.
(defun build-backchain-graph (query active-gen-id depth sit dom)
   (let-fun ()
      (match-cond query
	 (:? (goal-call ?@_)
	   (values
	      true
	      (new-Query-answer-gen-with-id false)))
	 (:? (exists ?bvars ?body)
	    (build-for-exists bvars body))
	 (:? (forall ?bvars ?body)
	    (build-for-forall bvars body))
	 (t (build-using-rules)))

    :where

 (:def build-for-exists (bvars body)
	 (let ((qag (new-Query-answer-gen-with-id false)))
	    (!= (Query-answer-gen-status qag) ':under-construction)
	    (let ((query-with-qvars
		     (subst-noting-binders
		        (<# (\\ (v)
			       (tuple v
				      (make-Qvar
					(build-symbol (< v) - (++ bvar-disting*))
					!())))
			    bvars)
			body))
		  (vid (or (Query-answer-gen-var-id qag) (new-Varid))))
	       (!= (Query-answer-gen-var-id qag) vid)
	       (let ((dnf (disjunctive-normal-form query-with-qvars true)))
		  (cond ((dnf-build-backchains
			    dnf vid (empty-env)
			    qag active-gen-id true sit dom)
			 (signal-problem build-backchain-graph
			    "Trivially true existential: " query)))
		  (!= (Query-answer-gen-status qag) ':complete)))
	    (values true qag)))

 ;; Key idea is that the body of a 'forall' is a search for _counterexamples_
 ;; to the universal quantifier.  The answers accumulated for the 'forall' are
 ;; those counterexamples, so that a :none answer is a success.
 ;; We then have a nonmon continuation _after_
 ;; the 'forall' query that will be taken if no counterexamples are found.
 (:def build-for-forall (bvars body)
    ;; This one works by building goals to find counterexamples to body,
    ;; hoping to fail.
;;;;    (trace-around build-for-forall
;;;;       (:> "(build-for-forall: " bvars 1 body ")")
    (let ((qag (new-Query-answer-gen-with-id false)))
       (cond ((has-qvars body)
	      (cond ((not sit)
		     (signal-problem build-backchain-graph
			"Null situation while building backchain graph for query"
			:% query
			:% " which has (many) answers")))
	      (let ((qagen-answers (place-query-answers qag sit)))
		(!= (Query-ans-spec-many qagen-answers) true)
		(!= (Query-ans-spec-status qagen-answers) ':assertions-fetched))
	      (values true qag))
	     (t
	      (!= (Query-answer-gen-status qag) ':under-construction)
	      (let ((neg-dnf (forall-refuter-dnf bvars body))
		    (vid (new-Varid)))
		 (!= (Query-answer-gen-var-id qag) vid)
		 (cond ((dnf-build-backchains
			   neg-dnf vid (empty-env)
			   qag active-gen-id true sit dom)
			(signal-problem build-backchain-graph
			   "Trivially false universal: " query)))
		 (!= (Query-answer-gen-status qag) ':complete)
		 (values false qag)))))
;;;;       (:< (val qag) "build-for-forall: " val 1 qag))
    )
	 
 (:def build-using-rules ()
;;;;      (out "Before placing: " (exp_index-contents query-ans-gen-index* false)
;;;;	   :%)
	  (let ((qag (new-Query-answer-gen-with-id true)))
	     ;; Reset because uniquified version may have different free vars --
	     (!= query (Query-answer-gen-query qag))
;;;;      (out "After placing: " (exp_index-contents query-ans-gen-index* false)
;;;;	   :% "query = " query
;;;;	   :%)
	     (cond ((eq (Query-answer-gen-status qag) ':new)
		    (!= (Query-answer-gen-status qag) ':under-construction)
		    (let ((qag-id (Query-answer-gen-var-id qag)))
		       (let ((rules (sit-assertion-fetch
					`(<- ,query ?_) qag-id (empty-env)
					true 
					(domain-place-fact-sit
					   dom false))))
;;;;                          (dbg-save rules query qag-id dom)
;;;;                          (breakpoint  build-using-rules
;;;;                               "rules = " rules)
			  (repeat :for ((env+occ+id :in rules)
					:collector disjuncts)
			     (match-let ?(:& (<- ?_ ?rhs) ?rule)
					(Occasion-prop (second env+occ+id))
				(let ((strat (back-chainer-is-stratified
						(second env+occ+id)
						dom)))
				   (cond ((not strat)
					  (!= (Query-answer-gen-refcount qag)
					      false)))
				   (cond ((dnf-build-backchains
					     (disjunctive-normal-form
						rhs true)
					     (third env+occ+id)
					     (first env+occ+id)
					     qag active-gen-id
					     strat sit dom)
					  (signal-problem build-backchain-graph
						"Degenerate rule " rule))))))))
		    (!= (Query-answer-gen-status qag) ':complete)))
	     (values true qag)))

 (:def new-Query-answer-gen-with-id (index)
    (let ((qag (cond (index
		      (place-Query-answer-gen query depth dom))
		     (t
		      (new-Query-answer-gen query depth dom)))))
       (!= (Query-answer-gen-gen-id qag) active-gen-id)
       qag))))

;;; Returns Query-ans-spec for 'qagen' in 'sit'.
;;; The subgraph below 'qagen' must already be built before this is called.
(defun query-gen-generate (qagen gen-id sit dom)
;;;;   (cond ((not (= (Query-answer-gen-gen-id qagen) gen-id))
;;;;	  (!= (Query-answer-gen-gen-id qagen) gen-id)
;;;;	  (!= depth (+ *-* 1))
;;;;	  (!= (Query-answer-gen-depth qagen) depth))
;;;;	 (t ...))
   (let ((depth (Query-answer-gen-depth qagen))
	 (qagen-answers (place-query-answers qagen sit))
	 (query (Query-answer-gen-query qagen))
	 (qid (Query-answer-gen-var-id qagen)))
      (cond ((not (eq (Query-ans-spec-status qagen-answers)
		      ':answers-propagated))
	     (dbg-out trace-deduce*
		0 (:i= (* 3 depth))
		"[" depth "] Trying query ("
		(Query-ans-spec-status qagen-answers) ") " qagen :%)
;;;;	     (cond ((and breakpoints-on*
;;;;			 (eq (Query-ans-spec-status qagen-answers) ':answers-found))
;;;;		    (dbg-save qagen qagen-answers sit dom)
;;;;		    (breakpoint query-gen-generate
;;;;		       "Trying finished goal " qagen)))
	     ))
      (cond ((eq (Query-ans-spec-status qagen-answers) ':unprocessed)
	     (unwind-protect
		(progn
		   (!= (Query-ans-spec-status qagen-answers) ':fetching-assertions)
		   (multi-let (((many immed-answers)
				(match-cond query
				   (:? (goal-call ?proc ?vars ?vals)
				      (goal-proc-unify-and-call
					  proc vars vals qid sit dom qagen))
				   (:? (not ?q)
				      (values (has-qvars q)
					      !()))
				   (t
				    (values false
					    (<# (\\ (env+occ+id)
						   (tuple (second env+occ+id)
							  (env-simplify 
							     (first env+occ+id)
							     qid)))
						(sit-assertion-fetch
						      query qid (empty-env)
						      true sit)))))))
		      (cond ((not (is-Query-answer-gen qagen))
			     (signal-problem query-gen-generate
				"Answers derived for non-Query-ans-gen: " qagen)))
;;;;		      (out "Setting many " many " for " qagen :%)
		      (cond ((not (Query-ans-spec-many qagen-answers))
			     (!= (Query-ans-spec-many qagen-answers) many)))
		      (repeat :for ((ec :in immed-answers))
			 (query-ans-tabulate ec qagen-answers qagen gen-id sit dom))
		      (!= (Query-ans-spec-status qagen-answers) ':assertions-fetched)))
	       (cond ((not (eq (Query-ans-spec-status qagen-answers)
			       ':assertions-fetched))
		      (!= (Query-ans-spec-answers qagen-answers) !())
		      (!= (Query-ans-spec-status qagen-answers) ':unprocessed))))))
      (cond ((eq (Query-ans-spec-status qagen-answers) ':assertions-fetched)
	     (unwind-protect
		(progn
		   (cond ((not (Query-ans-spec-many qagen-answers))
			  (!= (Query-ans-spec-status qagen-answers) ':backward-chaining)
			  (repeat :for ((sub :in (Query-answer-gen-body qagen)))
			   :until (found-perfect-answer qagen-answers qagen)
			     (query-gen-generate
					      (Query-conjunction-first sub) 
					      gen-id sit dom))))
		   (cond (trace-deduce*
			  (qagen-answers-display ':new qagen-answers qagen)))
		   (!= (Query-ans-spec-status qagen-answers) ':answers-found)
		   ;; We have to do this in successive waves because some propagations
		   ;; will generate new answers here.
;;;;		   (out "Continuations for " qagen "--"
;;;;			:% (Query-answer-gen-continuations qagen) :%)
		   (repeat :for ((contins
				    = (Query-answer-gen-continuations qagen)
				    :then :again)
				 (prev = '()
				     :then contins))
		    :until (eq contins prev)
		      (repeat :for ((cont :in contins :tail cl))
		       :when (= (Query-answer-gen-gen-id
				   (Deductive-continuation-super-ag cont))
				gen-id)
;;;;			 (err-out "Running continuation for " query " ["
;;;;				  (len cl)
;;;;				  "," (len (Query-answer-gen-continuations qagen))
;;;;				  "] " :% cont)
;;;;			 (cond ((and breakpoints-on* (matchq (optop::closed optop::sd1 ?_)
;;;;							     query))
;;;;				(dbg-save qagen sit)
;;;;				(breakpoint query-gen-generate
;;;;				   "Running continuation " cont
;;;;				   :% " Total number of continuations: "
;;;;				   (len (Query-answer-gen-continuations qagen)))))
			 (sub-answers-propagate
			    qagen-answers qagen cont gen-id sit dom)
		       :until (eq (cdr cl) prev)))
		   (!= (Query-ans-spec-status qagen-answers) ':answers-propagated))
	       (cond ((eq (Query-ans-spec-status qagen-answers)
			  ':answers-propagated)
		      (query-answer-gen-prune qagen dom))
		     (t
		      (!= (Query-ans-spec-status qagen-answers)
			  ':assertions-fetched))))))
;;;;      (cond ((and delete-temp-deductive-scaffolds*
;;;;		  (eq (Query-answer-gen-status qagen)
;;;;		      ':complete)
;;;;		  (forall (qc :in (Query-answer-gen-body qagen))
;;;;			  (Query-conjunction-temp qc)))
;;;;	     (out "Removing " qagen :%)
;;;;	     (query-answers-remove qagen sit)
;;;;	     (query-answer-gen-remove qagen dom)))
      qagen-answers))

(defun goal-proc-unify-and-call (proc vars vals qid sit dom qagen)
   ;; Get rid of fake pred --
   (!= vars (cdr vars))
   (!= vals (cdr vals))
   (let ((call-id (cond ((null vars) false)
			(t (new-Varid)))))
      (multi-let (((many ansenvs)
		   (call-deduce
		      proc
		      (make-Bdgenv
			 (<# (\\ (var val)
				(make-Varbdg
				   var call-id
				   (make-Expclo val qid)))
			     vars vals))
		      call-id sit dom)))
	 (values
	    many
	    (<# (\\ (e) (env->occ+env e qagen dom))
		ansenvs)))))

;;; IMPORTANT: call-deduce must not be allowed to run a full-scale deduction;
;;; it always computes something local and returns.  It never calls "deduce"
;;; or any of its variants.

(defun call-deduce (proc env qid sit dom)
;;;;   (bind ((deduction-legal* false)) ...)
      (let ((pal (funcall proc qid env sit dom)))
	 (let ((many (memq many-bdgs* pal))) 
	    (let ((answers
		     (cond (many (remove many-bdgs* pal))
			   (t pal))))
;;;;	       (cond (trace-deduce*
;;;;		      (out "Answers = "
;;;;			   (mapcar #'(lambda (a) (debug-varsubst args qid a))
;;;;				   answers)
;;;;			   :%)))
	       (values many answers)))))

;;; Called only when answers to 'qagen' have "all" been found.
;;; New answers may come in later, but they will be handled as they
;;; pop up.
(defun sub-answers-propagate (qag-ans-spec qagen cont gen-id sit dom)
   (let ((answers (Query-ans-spec-answers qag-ans-spec))
	 (many (Query-ans-spec-many qag-ans-spec))
	 (sense (Deductive-continuation-sense cont))
	 (perfect-answer (found-perfect-answer qag-ans-spec qagen))
	 ;;;;(super-ag (Deductive-continuation-super-ag cont))
	 )
      (cond (perfect-answer
	     ;; Probably never happens, but if you get a perfect answer,
	     ;; it should trump "many-ness."
	     (!= many false)
	     (!= answers (list perfect-answer))))
      (cond ((and (not sense) (null answers) (not many))
	     (dbg-out trace-qagen-graph*
		"Postponing exploration of consequences of answerless"
		:% 3 qagen)
	     (on-list (make-Nonmon-restart qagen qag-ans-spec cont)
		      postponed-nonmons*))
	    ((and sense (or many (not (null answers))))
	     (let ()
	       ;; If 'many', then regardless of sense continuation becomes trivial,
	       (answers-propagate
		  (cond (many
			 (list (tuple ':many false)))
			(sense answers)
			((null answers)
			 (list (tuple ':none false)))
			(t
			 ;; If many and (not sense), there must be no answers
			 (signal-problem sub-answers-propagate
			    "Control reached impossible point")))
		  qagen cont gen-id sit dom)))
;;;;	    (t
;;;;	     (out "Not propagating answers " answers
;;;;		  :% " because many = " many " or sense = " sense :%))
)))

(defun query-generation-restart (nm-restart sit dom)
  (let ((qagen (Nonmon-restart-query-answer-gen nm-restart))
	(qas (Nonmon-restart-query-ans-spec nm-restart))
	(cont (Nonmon-restart-continuation nm-restart)))
     (cond ((and (not (Query-ans-spec-many qas))
		 (null (Query-ans-spec-answers qas)))
#|
		 ;; Checking this keeps us from restarting the same
		 ;; one more than once --
		 (Query-ans-spec-welcome qas))
	    (!= (Query-ans-spec-welcome qas)
		false)
      ... which was a BAD IDEA
|#
	    (dbg-out trace-qagen-graph*
	       "Exploring consequences of answerless " :% 3 qagen)
	    (let ((succ (alref (Deductive-continuation-succs cont)
			       ':none
			       ':missing)))
	       (cond ((eq succ ':missing)
		      (let ((new-tup (tuple ':none '*under-construction)))
			 (!= (Deductive-continuation-succs cont)
			     (cons new-tup *-*))
			 (!= (second new-tup)
			     (cont-ans-pursue cont
					      (tuple ':none (empty-env))
					      (Query-answer-gen-var-id qagen)
					      (Query-answer-gen-gen-id qagen)
					      (Query-answer-gen-depth qagen)
					      sit dom))))
		     (t
		      (signal-problem query-generation-restart
			 "Unexpected continuation successor found during"
			 " nonmonotonic restart: " succ)))))
;;;;	   (t
;;;;	    (dbg-save qagen qas cont)
;;;;	    (breakpoint query-generation-restart
;;;;	       "Nonmon restart conks out " qas))
     )))

(defvar trace-propagate* false)

;;; We've already checked to make sure that 'cont' is appropriate given
;;; the sense and gen-id of the answers.
;;; If this is called from 'sub-answers-propagate' when there are no answers,
;;; we've converted to one artificial answer, (:none false).
(defun answers-propagate (answers qagen cont gen-id sit dom)
   (let ((depth (Query-answer-gen-depth qagen))
	 (sub-var-id (Query-answer-gen-var-id qagen)))
;;;;      (cond ((and breakpoints-on*
;;;;		  (not (Deductive-continuation-sense cont)))
;;;;	     (breakpoint answers-propagate
;;;;		"Pursuing nonmon continuation " cont
;;;;		:% " with " answers)))
      (repeat :for ((ans :in answers))
	 (let ((anskey (first ans))
	       (super-ag (Deductive-continuation-super-ag cont)))
	    (let ((succ (alref (Deductive-continuation-succs cont)
			       anskey
			       ':missing)))
	       (cond ((eq succ ':missing)
		      (let ((new-tup (tuple anskey '*under-construction))
			    (super-ag (Deductive-continuation-super-ag cont)))
			 (!= (Deductive-continuation-succs cont)
			     (cons new-tup *-*))
			 (!= (second new-tup)
			     (cond ((eq anskey ':many)
				    (query-ans-tabulate
				        (tuple ':many false)
					(place-query-answers super-ag sit)
					super-ag gen-id sit dom))
				   (t
				    (cont-ans-pursue cont ans sub-var-id gen-id
						     depth sit dom))))))
		     ((eq succ '*under-construction)
		      (signal-problem ans-cont-extend-and-propagate
			 "Attempt to follow successor that is under construction"
			 :% " for anser " ans
			 :% " to " cont))
		     ((is-Query-conjunction succ)
;;;;		      (out "Pursuing old successor continuation "
;;;;			   succ :%)
		      (query-gen-generate
			 (Query-conjunction-first succ)
			 gen-id sit dom))
		     (t
		      ;; yields answer to super-qag directly
		      (query-ans-tabulate
			  succ
			  (place-query-answers super-ag sit)
			  super-ag gen-id sit dom))))))))

(defun cont-ans-pursue (cont ans var-id gen-id depth sit dom)
   (let ((anskey (first ans))
	 (ansenv (second ans))
	 (qconj (Deductive-continuation-qconj cont))
	 (qc-id (Deductive-continuation-qc-id cont))
	 (super-ag (Deductive-continuation-super-ag cont)))
      (let ((remaining-goals (Query-conjunction-remaining qconj))
	    (temp (Query-conjunction-temp qconj)))
	 (multi-let (((consis advance-env)
		      (cont-env-advance
			 anskey ansenv var-id cont)))
	    (cond (consis
		   (cond ((null remaining-goals)
			  (let ((super-ans
				   (query-ans-tabulate
				      (tuple false
					     advance-env)
				      (place-query-answers
					 super-ag sit)
				      super-ag gen-id sit dom)))
			     super-ans))
			 (t
			  (let ((succ-conj
				   (make-Query-conjunction
				      (car remaining-goals)
				      (cdr remaining-goals)
				      super-ag temp)))
			     (build-sub-backchain-graph
				succ-conj qc-id advance-env gen-id
				depth sit dom)
			     succ-conj))))
		  (t
		   (signal-problem ans-cont-extend-and-propagate
		      "Can't reconcile answer env " advance-env
		      :% " with answer so far "
		      (Deductive-continuation-ans-so-far cont))))))))

;;;; FIX THIS --
;;;;		   ((and optimist-fn*
;;;;			 (forall (occ+env :in answers)
;;;;			    (exists (vbdg :in (second occ+env))
;;;;			       (is-Optimist-var
;;;;				  (Varbdg-varname vbdg)))))
;;;;		    (none-ans-extend qagen gen-id dom)
;;;;		    (repeat :for ((e :in (<# (\\ (occ+env)
;;;;						(env-optimism-polarity-switch
;;;;						   (second occ+env)))
;;;;					     answers)))
;;;;		       (ans-cont-propagate (tuple ':none e) cont gen-id sit dom)))

(defun query-ans-tabulate (e answer-tab qagen gen-id sit dom)
   (let ((occ+env (occ+env-simplify e qagen dom))
	 (prev-answers (Query-ans-spec-answers answer-tab))
	 (many (Query-ans-spec-many answer-tab)))
      (let ((anskey (first occ+env))
	    (no-real-prev (= (len prev-answers) 0)))
	 (multi-let (((new noprev)
		      (case anskey
			 (:many
			  (cond ((not many)
				 (!= (Query-ans-spec-many answer-tab) true)
				 (values true no-real-prev))
				(t
				 (values false false))))
			 (otherwise
			  (cond ((assq anskey prev-answers)
				 (values false false))
				(t
				 (!= (Query-ans-spec-answers answer-tab)
				     (cons occ+env *-*))
				 (values true
					 (and (not many)
					      (not (eq anskey ':none))
					      no-real-prev))))))))
	    (cond (new
;;;;		   (cond ((not (assq anskey
;;;;				     (Query-answer-gen-answers-somewhere qagen)))
;;;;			  (!= (Query-answer-gen-answers-somewhere qagen)
;;;;			      (cons occ+env *-*))))
;;;;		   (out "Answer-tab status = " (Query-ans-spec-status answer-tab) :%)
		   (cond ((and (not (Query-ans-spec-welcome answer-tab))
			       (not (eq anskey ':none)))
			  (cond (circular-nonmon-reaction*
				 (err-out "Circular nonmonotonicity at " qagen)
				 (cond ((eq circular-nonmon-reaction* ':error)
					(signal-problem query-ans-tabulate
					   "Yes, circular nonmontonicity")))))))
		   (cond ((eq (Query-ans-spec-status answer-tab)
			      ':answers-propagated)
			  ;; If status is something else, then control will
			  ;; eventually return to query-gen-generate, which
			  ;; will call 'sub-answers-propagate' to handle this stuff --
			  (cond (trace-deduce*
				 (answers-display ':extra (list occ+env) qagen)))
;;;;			  (cond ((and breakpoints-on*
;;;;				      (matchq (optop::affected optop::cb2)
;;;;					      (Query-answer-gen-query qagen)))
;;;;				 (breakpoint query-ans-tabulate
;;;;				    "Extra answers for " qagen)))
			  (repeat :for ((cont :in (Query-answer-gen-continuations
						      qagen)))
			     (let ((super-gen-id
				       (Query-answer-gen-gen-id
					       (Deductive-continuation-super-ag cont))))
;;;;				(out "gen-id = " gen-id
;;;;				     " super gen-id = " super-gen-id :%)
				(cond ((= super-gen-id gen-id)
				       (cond ((Deductive-continuation-sense cont)
					      (cond ((not (eq anskey ':none))
						     (answers-propagate
							(list occ+env) qagen cont gen-id
							sit dom))))
					     ((prog1 (and new noprev)
;;;;						 (cond (breakpoints-on*
;;;;							(dbg-save new noprev cont
;;;;							   occ+env answer-tab qagen)
;;;;							(breakpoint query-ans-tabulate
;;;;							   "Inverted sense: "
;;;;							   cont)))
						 )
;;;;					      (signal-problem query-ans-tabulate
;;;;						 "Prematurely jumped continuation "
;;;;						 cont
;;;;						 (:proceed
;;;;						     !"I'll proceed, ~
;;;;                                                       but the answer ~
;;;;                                                       will be wrong"))
					      )))))))
;;;;			 (breakpoints-on*
;;;;			  (let ((nonmons
;;;;				   (<? (\\ (cont)
;;;;					  (not (Deductive-continuation-sense
;;;;						  cont)))
;;;;				       (Query-answer-gen-continuations
;;;;						      qagen))))
;;;;			     (cond ((not (null nonmons))
;;;;				    (breakpoint query-ans-tabulate
;;;;				       "Postponing nonmonotonic continuations "
;;;;				       nonmons)))))
			 )))
	    occ+env))))

;;;; Note that we keep the refcounts correct even if we don't actually
;;;; delete anything based on them.
;;;; 
(defun query-answer-gen-prune (qagen dom)
   (repeat :for ((qconj :in (Query-answer-gen-body qagen))
		 (any-flushed false))
      (let ((sub-qag (Query-conjunction-first qconj)))
	 (let ((rc (Query-answer-gen-refcount sub-qag)))
	    (cond (rc
		   (!= rc (- *-* 1))
		   (!= (Query-answer-gen-refcount sub-qag) rc)
		   (cond ((and delete-temp-deductive-scaffolds*
			       (=< rc 0))
			  (!= any-flushed true)
			  (query-answer-gen-remove sub-qag dom)))))))
    :result
       (cond ((and delete-temp-deductive-scaffolds* any-flushed)
	      (!= (Query-answer-gen-body qagen) !())))))

(defun qagen-answers-display (status qas qagen)
   (answers-display
      status
      (nconc (cond ((Query-ans-spec-many qas)
		    (list (tuple ':many false)))
		   ((null (Query-ans-spec-answers qas))
		    (list (tuple ':none false)))
		   (t
		    !()))
	     (Query-ans-spec-answers qas))
      qagen))

;;; 'status' is 
;;;    :new -- Just finished generating them, and hopefully they're
;;;            all there are
;;;    :old -- Encountered by 'build-sub-backchain-graph'
;;;    :extra -- Came in after generation was over (because of self-recursion)
;;
(defun answers-display (status answers qagen)
	  (let ((depth (Query-answer-gen-depth qagen)))
	     (let ((dstring (out (:to :string) "[" depth "] ")))
		(err-out
		   0
		   (:i= (* 3 depth))
		   (:a dstring)
		   (:e (ecase status
			   (:new (:o "New"))
			   (:old (:o "Old"))
			   (:extra (:o "Extra"))))
		   " answers to " qagen
		   :% (:_ (length dstring)) "to wit: " answers :%)
)))

(defun cont-env-advance (anskey ansenv id cont)
   (let ((cover-id (Deductive-continuation-cover-id cont))
	 (super-ans-so-far (Deductive-continuation-ans-so-far cont)))
      (cond ((eq anskey ':many)
	     (signal-problem cont-env-advance
		"(many) ans in forbidden role"))
	    ((boole-eq (eq anskey ':none)
		       (not (Deductive-continuation-sense cont)))
	     (cond ((eq anskey ':none)
		    (values true super-ans-so-far))
		   (t
		    (env-merge-super ansenv super-ans-so-far id cover-id))))
	    (t
	     (signal-problem cont-env-advance
		"Negative answer being propagated in positive context")))))

(defun env-merge-super (ansenv super-ans-so-far id cover-id)
	     (let ((ansenv (bdgenv-change-id ansenv id cover-id)))
		 (multi-let (((consis comb-env)
			      (bdgenvs-combine
				 super-ans-so-far ansenv)))
		    (cond (consis
			   (values true
				   (cond ((and cover-id
					       (not (= cover-id id)))
					  (ids-env-elim
					      (list cover-id)
					      comb-env))
					 (t comb-env))))
			  (t
			   (values false super-ans-so-far))))))

(defun env-optimism-polarity-switch (env)
   (<# (\\ (vbdg)
	  (cond ((is-Optimist-var (Varbdg-varname vbdg))
		 (optimist-varbdg-polarity-switch vbdg))
		(t vbdg)))
       env))

(defun optimist-varbdg-polarity-switch (vbdg)
   (let ((skel (Expclo-skel (Varbdg-val vbdg))))
      (let ((oprcd (car skel))
	    (oth-pat (cadr skel)))
	 (make-Varbdg (Varbdg-varname vbdg)
		      (Varbdg-id vbdg)
		      (make-Expclo
			 (list (make-Optimism-rcd
				  (not (Optimism-rcd-polarity oprcd))
				  (Optimism-rcd-opt-pat oprcd)
				  oth-pat
				  (Optimism-rcd-id1 oprcd)
				  (Optimism-rcd-id2 oprcd))
			       oth-pat)
			 (Expclo-id (Varbdg-val vbdg)))))))

(defun occ+env-simplify (occ+env qagen dom)
   (cond ((first occ+env)
	  (tuple (first occ+env)
		 (env-simplify (second occ+env)
			       (Query-answer-gen-var-id qagen))))
	 (t
	  (env->occ+env (second occ+env)
			qagen dom))))

(defun env->occ+env (env qagen dom)
   (let ((ansenv (env-simplify env (Query-answer-gen-var-id qagen))))
      (multi-let (((f e)
		   (safe-varsubst (Query-answer-gen-query qagen)
				  (Query-answer-gen-var-id qagen)
				  ansenv)))
	 (tuple (uniquify-occasion-with-vars f dom)
		e))))

