;-*- Mode: Common-lisp; Package: opt; Readtable: ytools; -*-
(in-package :opt)
;;; $Id: dedutils.lisp,v 1.3 2005/07/05 13:34:13 dvm Exp $

;;; Utilities used by deduction.lisp

(depends-on %opt/ internalize assertion)

(eval-when (:compile-toplevel :load-toplevel :execute :slurp-toplevel)
   (export '(try-postpone-negs forall-refuter-dnf
	     back-chainer-is-stratified)))

; These are not really bdgenv lists; they are used as flags.
(defvar many-bdgs* (list (make-Varbdg 'many 0 (make-Expclo 'many nil))))

(defun many () (list many-bdgs*))

;;; 'goal' is a 'forall' proposition.
;;; First value is true if "many" answers.
;;;;(deffunc univ-counterexamples - (Mlv Boolean (Lst Bdgenv))
;;;;	      (goal - Sexp id - Varid bdgs - Bdgenv sit - Situation dom - Domain)

;;; Not currently used (?)
(defun univ-counterexamples (goal id bdgs sit dom)
;;;;   (trace-around univ-counterexamples
;;;;      (:> "(univ-counterexamples: goal = " goal " [" id "] " bdgs  ")")
   (multi-let (((goal bdgs)
		(safe-varsubst goal id bdgs)))
      ;; Any unassigned qvars in the goal are not bound by this quantifier
      ;; (at this point) --
      (cond ((has-qvars goal)
	     (values (many) (empty-env)))
	    (t
	     ;; Now we turn bound vars into qvars --
	     (let ((neg-dnf (forall-refuter-dnf (cadr goal) (caddr goal))))
		      ;; We don't stop when we've detected a "many," because
		      ;; a counterexample to one disjunct is enough to
		      ;; refute the 'forall'.
	              (repeat :for ((conjunction :in neg-dnf)
				    (many false)
				    :collector all-answers)
		       :within
			 (multi-let (((ok cl)
				      (try-postpone-negs conjunction !())))
			    (cond ((not ok)
				   (:continue
				    (!= many true)))
				  (t
				   (multi-let (((m al)
						(deduce-check-many
						   `(and ,@cl) id bdgs sit dom)))
				      (:continue
					 (cond (m
						(!= many true)))
				       :nconc al)))))
		       :result (values many all-answers))))))
;;;;      (:< (many bdgs) "univ-counterexamples: " many bdgs))
   )

;;;;(specdecl (refuteno* 0) - Fixnum)

;;; Replace occurrences of vars with new qvars, and returned dnf of
;;; negation of result.
(defun forall-refuter-dnf (vars exp)
   (let ((alist (<# (\\ (v)
		       (tuple v
			     (make-Qvar
			        (build-symboid
				   (< v) "-" (++ bvar-disting*))
				!())))
		    vars)))
      (disjunctive-normal-form
         (subst-noting-binders alist exp)
	 false)))

(defvar binder-constructs*
    '(forall exists exists! lambda \\))

;;; Like 'sublis', but (a) alist is 'cadr' mode, not 'cdr'; 
;;; (b) variable binders shadow the substitution as one would expect.
(defun subst-noting-binders (alist exp)
   (cond ((is-Symbol exp)
	  (alref alist exp exp))
	 ((atom exp) exp)
	 ((memq (car exp) binder-constructs*)
	  (let ((shrink (remove-if (\\ (e) (memq (first e) (cadr exp)))
				   alist)))
	     (cond ((null shrink) exp)
		   (t
		    `(,(car exp) ,(cadr exp)
		      ,(subst-noting-binders shrink (caddr exp)))))))
	 (t
	  (<# (\\ (x) (subst-noting-binders alist x))
	      exp))))

;;; Try to move each element of the form (not p) to after where all of p's
;;; freevars are bound.  (Assume the symbols in 'given-vars' are already
;;; bound.)
;;; Returns < ok, rearranged conjuncts >.  'ok' is true iff the postponement
;;; is possible.  The second returned val is a permutation of the conjuncts
;;; in any case.
(defun try-postpone-negs (conjuncts given-vars)
   (let-fun ((:def move-nots-back (cl nots vars-before)
;;;;		(trace-around move-nots-back
;;;;		   (:> "(move-nots-back: " cl 1 nots 1 vars-before ")")
		(cond ((null cl)
		       (cond ((null nots)
			      (values true !()))
			     (t
			      (values false (reverse (<# first nots))))))
		      (t
		       (let ((head-uvars (raw-uvars (head cl))))
			  (cond ((car-eq (head cl) 'not)
				 (cond ((is-sublist head-uvars vars-before :test #'eq)
					(multi-let (((ok tail-val)
						     (move-nots-back
							(tail cl) nots vars-before)))
					   (values ok (cons (head cl)
							    tail-val))))
				       (t
					(move-nots-back
					   (tail cl)
					   (cons (tuple (head cl) head-uvars)
						 nots)
					   vars-before))))
				(t
				 (let ((vars-before
					  (union head-uvars vars-before
						 :test #'eq)))
				    (multi-let (((now-got still-waiting)
						 (nots-classify nots vars-before)))
				       (multi-let (((ok tail-val)
						    (move-nots-back
						       (tail cl)
						       still-waiting
						       vars-before)))
					  (values
					     ok
					     (cons (head cl)
						   (nconc (reverse (<# first now-got))
							  tail-val)))))))))))
;;;;		   (:< (ok res) "move-nots-back: " ok 1 res))
		)
	     (:def nots-classify (nots vars-before)
		(classify nots (\\ (not-pair)
				  (is-sublist
				     (second not-pair)
				     vars-before)))))
      (move-nots-back conjuncts !() given-vars)))

(defun back-chainer-is-stratified (bc dom)
   (let-fun ()
      (let ((strat-backs (indexed-domain-place-strat-backs dom)))
	 (let ((s (href strat-backs bc ':unknown)))
	    (cond ((eq s ':unknown)
		   (let ((bc-pred (atomic-formula-pred
				     (Back-chainer-consequent bc))))
		      (!= s (not (exists-pred-cycle
				    bc
				    (list bc-pred)
				    (domain-place-fact-sit dom false))))
		      (!= (href strat-backs bc) s))))
	    s))

    :where

      (:def exists-pred-cycle (bc pred-path sit)
	 ;;(out (tr epc ("cycle> " bc 1 pred-path)
;;;;	 (trace-around ex-p-cycle
;;;;	    (:> "(ex-p-cycle: " bc ")")
	 (repeat :for ((a :in (formula-antecedent-atoms
			         (Occasion-prop bc)))
		      next-pred bcl)
	  :result false
	    (!= next-pred (car a))
	  :until (memq next-pred pred-path)
	  :result true
	    (!= bcl (backchain-fetch a dummy-id* '() false sit))
	  :until (exists (feeder :in bcl)
		   (exists-pred-cycle
		      (caddr feeder)
		      (cons next-pred pred-path)
		      sit)))
;;;;	    (:< (val &rest _) "ex-p-cycle: " val))
	 
	 ;;("cycle< " (car out-vals*))))
	 )

      (:def atomic-formula-pred (fmla)
	 (multi-let (((_ p)
		      (lit-analyze fmla)))
	    (car p)))))

(defun indexed-domain-place-strat-backs (idom)
   (let ((sb (Indexed-domain-stratified-backchains idom)))
      (cond ((not sb)
	     (!= sb
		 (tuple (Domain-generation idom)
			(make-hash-table :test #'eq :size 50)))
	     (!= (Indexed-domain-stratified-backchains idom)
		 sb)))
      (second sb)))

;;; Return list of triples (rule-varid env occ).
(defun backchain-fetch (query qid bdgs filter-pred sit)
   (let ((rule-id (new-Varid)))
      (multiple-value-bind (ok e)
			   (unify '?conse query rule-id qid bdgs)
	 (cond (ok
		(multiple-value-bind (rulepat e)
				     (safe-varsubst '(<- ?conse ?ante)
						    rule-id e)
		   (let ((envs-and-rules
			    (sit-assertion-fetch rulepat rule-id e true sit)))
		      (cond (filter-pred
			     (<! (\\ (env+occ)
				    (cond ((funcall filter-pred
						    (cadr env+occ) sit)
					   (list (lrecord rule-id
							  (car env+occ)
							  (cadr env+occ))))
					  (t '())))
				 envs-and-rules))
			    (t (<# (\\ (env+occ)
				      (lrecord rule-id (car env+occ)
					               (cadr env+occ)))
				   envs-and-rules))))))
	       (t
		(signal-problem backchain-fetch
		   "Fumbled sure-thing unification: "
		   :% " ?conse [_" rule-id "] vs. " query " [_" qid "]"
		   :% " Reality has broken down, so there is no way to"
		     " recover from this failure"))))))

(defun formula-antecedent-atoms (fmla)
   (cond ((or (atom fmla) (is-Qvar fmla))
	  ;; shouldn't ever get here
	  '())				
         (t
          (let ((fcn (car fmla)))
             (cond ((member fcn '(and or not) :test #'eq)
		    (<! formula-antecedent-atoms (cdr fmla)))
                   ((memq fcn '(freevars forall exists exists!))
		    (formula-antecedent-atoms (caddr fmla)))
		   ((eq fcn '<-)
		    (formula-antecedent-atoms (caddr fmla)))
		   ((memq fcn '(when -> <- if))
		    (formula-antecedent-atoms (cadr fmla)))
                   (t
		    (list fmla)))))))

(defvar gen-test-id* (new-Varid))

(datafun add-handler >-
   (defun :^ (pat sit dom)
      (repeat :for ((a :in (deduce (cadr pat) gen-test-id* (empty-env) sit dom)))
       :nconc
	 (assertion-clo-add (caddr pat) gen-test-id* a sit dom))))

;; This is ridiculous, but it's not clear what to replace it with.
;; Under type theory, things like "or" and "+" count as Obj's.
;; Probably should get all the nonfunction objects.  
;; It should go through the local bindings of all ancestors of sit's
;; domain, because get-situation-contents returns only the "local"
;; contents, that is, the contents that distinguish this situation
;; from others in the same space.
(defun objects-mentioned (sit)
   (reduce #'(lambda (l occ)
	        (reduce #'(lambda (l x)
			    (adjoin x l :test #'eq))
			(cdr (Signed-occasion-prop occ))
			:initial-value l))
	   (get-situation-contents sit)
	   :initial-value '()))

(defun unifiers (t1 t2 e1 e2 e)
   (multiple-value-bind (ok e)
			(unify t1 t2 e1 e2 e)
       (cond (ok (list e))
	     (t '()))))


;;;;(defun ded (pat sit dom)
;;;;   (let ((al (deduce pat 1 '() sit dom)))
;;;;      (<# (\\ (ans)
;;;;	     (multi-let (((r ans)
;;;;			  (safe-varsubst pat 1 ans)))
;;;;		(lrecord r (bdgenv-contract ans 2))))
;;;;	  al)))
	  
;; Simple-minded scheme for skipping attempt to generate (e.g.) all
;; Numbers
(defmacro declare-infinite-types (dom &rest tdl)
   `(let ((dom-env (env-for-domain ',dom)))
       ,@(<# (\\ (td)
		`(!= (type-feature (designated-type ',td true dom-env)
				   'infinite)
		     true))
	     tdl)))

(needed-by-macros
(defun env-for-domain (x)
   (let ((dom (try-domain-with-name x false)))
      (cond (dom (domain-place-env dom))
	    (t
	     (let ((sys (find-type-system x false)))
	        (cond (sys
		       (nisptype::place-type-system-env sys))
		      (t
		       (signal-problem env-for-domain
			  "Can't find referent of " x
			  :fatal))))))))
)

;;type-index creates axioms for sub/super type links
(defun type-index (ty initsit idom)
   (let ((handled '())
	 ;;(typename (Type-desig ty))
	 (vartypes (empty-vartypes idom)))
      (let-fun ((super-if-sub (ty)
		  (cond ((and (is-CSymbol (Type-desig ty))
			      (not (member ty handled :test #'eq)))
			 (push ty handled)
			 (let ((par (Type-super ty)))
			    (cond ((and par
					(not (eq par univ-type*))
					(is-CSymbol (Type-desig par)))
				   (let ((pp (type-predify
						par '?x vartypes))
					 (inst-generator
					       #'(lambda (rid env sit idom)
						    (collect-subtype-elements
							ty rid env sit idom))))
				      (assertion-add
					 `(<- ,pp
					      ,(build-goal-call
						  inst-generator))
					  initsit idom)
				      (super-if-sub par)))))))))
	  (super-if-sub ty))))

(!= type-indexer* #'type-index)

(defun collect-subtype-elements (subty rid env sit dom)
   (cond ((has-uvars '?x rid env)
	  (deduce `(is ,(Type-desig subty) ?x) rid env sit dom))
	 (t '())))

(defun sits-compare (s1 s2)
   (let ((c1 (get-situation-contents s1))
	 (c2 (get-situation-contents s2)))
      (format *terminal-io*
	      "Situation 1: ~s~%Situation 2: ~s~%Both: ~s"
	      (set-difference c1 c2 :test #'eq)
	      (set-difference c2 c1 :test #'eq)
	      (intersection c1 c2 :test #'eq))))

(defun lit-analyze (lit)
   (cond ((car-eq lit 'not)
	  (multiple-value-let (opp p)
			      (lit-analyze (cadr lit))
	     (values (not opp) p)))
	 ((car-eq lit 'prelinked)
          (lit-analyze (cadr lit)))
	 (t (values true lit))))

