;-*- Mode: Common-lisp; Package: opt; Readtable: ytools; -*-
(in-package :opt)
;;; $Id: definers.lisp,v 1.10 2004/08/02 14:12:09 dvm Exp $

(depends-on %module/ ytools)

(depends-on %opt/ parsers)

(depends-on :at-run-time %langutils/ synutils)

(eval-when (:compile-toplevel :load-toplevel :execute :slurp-toplevel)
   (export '(requirement domain
	     addendum problem situation)))

;;; Each definer returns two values: The form with errors flagged, and
;;; a (~ Namespace), which is non-nil if it's the namespace to use if the form
;;; is printed.

;;; This is one way to define a requirement.  The other way is to define a domain
;;; with a :defines-requirement field.

(def-opt-form-handler requirement definer (def-form)
   (values
      (let ((name (extract-defined-name def-form)))
	 (cond ((symbolp name)
		(let ((req (try-requirement-with-name name t)))
		   (cond ((is-Requirement req)
			  (multiple-value-bind (fields flg-junk)
					       (list-smooth
						   (cddr def-form)
						   #'consp)
			     (let ((builtins
				      (append-field ':builtins fields))
				   (implications (append-field ':implies fields))
				   (flg-fields
				      (collect-bad-fields '(:builtins :implies)
							  fields)))
				(requirement-parse
				   req builtins implications 
				   `(,@flg-fields ,@flg-junk)))))
			 (t
			  `(define (requirement
				      ,(flag-wrong-type req name 'requirement))
				   ,@(cddr def-form))))))
	       (t
		`(define (requirement
			       ,(flagexp "Unintelligible requirement name"
					 name))
			 ,@(cddr def-form)))))
      false))

(def-opt-form-handler domain definer (def-form)
;;;;   (out "Entering domain-definer, parents = "
;;;;	(langutils::Namespace-parents requirement-namespace*) :%)
   (let ((name (extract-defined-name def-form)))
      (cond ((is-Symbol name)
	     (!= name (symbol->actual-global-name *-* ':domain))
             (let ((dom (try-domain-with-name name true)))
                (cond ((is-Domain dom)
		       (values
			  (multiple-value-bind (fields flg-junk)
					       (list-smooth
						   (cddr def-form) #'consp)
			     (let ((parents (append-field ':extends fields))
;;;;				   (allusions
;;;;				      (append (append-field ':alludes-to fields)
;;;;					      (append-field ':uses-names-from fields)))
				   (namespaces
				      (append (append-field ':namespace fields)
					      (append-field ':namespaces fields)))
				   (defreq-triples
				       (defrequire-fields
					   (collect-field
					      ':defines-requirement fields)))
				   (require (append-field ':requirements fields))
				   (types (collect-field ':types fields))
				   (x-types (collect-field ':type fields))
				   (typefuns (collect-field ':type-fun fields))
				   (typecons (collect-field ':type-constructor
							    fields))
				   (objects (append
					       (collect-field ':objects fields)
					       (collect-field ':constants
							      fields)))
				   (domain-vars
				      (append (collect-field ':parameters
							     fields)
					      (collect-field ':domain-variables
							       fields)))
				   (predicates (append-field
						  ':predicates fields))
				   (derived (collect-field ':derived fields))
				   (functions (collect-field ':functions fields))
				   (x-functions (collect-field ':function fields))
				   (facts1 (append-field ':facts fields))
				   (facts2 (append-field ':axioms fields))
				   ;(safety (append-field ':safety fields))
				   (axioms (collect-field ':axiom fields))
				   (causations (causations-collect fields))
				   (methods (collect-field ':method fields))
				   (exports (collect-field ':export fields))
				   (flg-fields (collect-bad-fields
						  '(:namespace :namespaces
						    :export
						    ;;;; :alludes-to :uses-names-from
						    :extends
						    :defines-requirement
						       :requirements :types
						       :type :type-fun :type-constructor
						       :facts :axioms
						       :objects :constants
						       :parameters
						       :domain-variables
						       :predicates :derived :process
						       :durative-action
						       :functions :function
						       :timeless ;:safety
						       :axiom :action :method :export)
						  fields)))
				(let-fun ()
;;;;				   (out "Ready to call parse-it, parents = "
;;;;					(langutils::Namespace-parents
;;;;					   requirement-namespace*) :%)
;;;;
				   ;; This is the last-ditch collector for
				   ;; odd stuff not
				   ;; inside the more serious collectors.
				   (collecting-defective-exps (ifel flg-dom)
							      (parse-it)
				      (cond ((null ifel)
					     flg-dom)
					    (t
					     ;;;;(out "flagging first!" :%)
					     (new-Flagged-subexpression
						flg-dom ifel)))
				      (:if-aborted
					 :restart-report
					    (lambda (srm)
					       (out (:to srm)
						    "I will give up"
						    " on domain "
						    name))
					 ;;;;(out "flagging second!" :%)
					 (new-Flagged-subexpression
					    def-form
					    (append
					        ifel
						(ill-exps flg-fields)
						(ill-exps flg-junk)))))
						    
				 :where
				   (parse-it ()
				      (domain-parse
					 :dom dom :parents parents
					 ;;;; :allusions allusions
					 :namespaces namespaces :export exports
					 :defrequire defreq-triples
					 :require require :types types
					 :xtypes x-types  :typefuns typefuns
					 :typecons typecons
					 :objects objects :domain-vars domain-vars
					 :predicates predicates
					 :derived derived
					 :functions functions
					 :xfunctions x-functions
					 :facts (append facts1 facts2)
					 :axioms axioms
					 :causations causations
					 :methods methods
   ;;;;				      :actions actions  
   ;;;;				      :processes processes
   ;;;;				      :durative-actions durative-actions
					 :flg-junk `(,@flg-fields ,@flg-junk)))

				   (ill-exps (fsubs)
				      (<$ langutils::Flagged-subexpression-ill-exps
					  fsubs)))))
			  (Domain-namespace dom)))
	              (t
		       (values
			  `(define (domain ,(flag-wrong-type dom name 'domain))
				   ,@(cddr def-form))
			  false)))))
            (t
	     (values
		`(define (domain ,@name) ,@(cddr def-form))
		false)))))

;;; Returns a list of triples 
;;; (requirement-name implications bad-keyword-flg).
;;; It's conceivable that a domain might define more than one requirement
(defun defrequire-fields (defreqs)
   (repeat :for ((defreq :in defreqs)
		 :collector triples)
    :collect 
      (multi-let (((fields flg-junk)
		   (list-smooth (cdr defreq) #'consp)))
	 (let ((implications (append-field ':implies fields))
	       (flg-fields
		  (collect-bad-fields '(:implies)
				   fields)))
	    (tuple (car defreq) implications `(,@flg-fields ,@flg-junk))))))

(defun causations-collect (fields)
   (repeat :for ((field :in fields))
    :when (memq (car field) '(:action :process :durative-action))
    :collect field))

(def-opt-form-handler addendum definer (def-form)
   (multiple-value-bind (status name dom fields flg-junk)
			(massage-domain-entity-def-form def-form)
      (cond ((and (is-Domain dom)
		  (eq (Domain-inherited-bdgs dom)
		      '*obsolete))
	     (dbg-save :run-loud dom)
	     (signal-problem addendum-form-handler
		"Domain was indexified but name binding not changed: "
		dom
		:novalue)))
      (case status
	 (:okay
	  (let ((methods (collect-field ':method fields))
		(axioms (collect-field ':axiom fields))
		(facts1 (append-field ':facts fields))
		(facts2 (append-field ':axioms fields))
		;(safeties (collect-field ':safety fields))
		(bad-fields (collect-bad-fields
				'(:method
				  :axiom ;:safety
				  :facts :axioms
				  :domain)
				fields)))
	     (values
	        (addendum-parse name dom methods
				axioms (append facts1 facts2) ;safeties
				`(,@bad-fields ,@flg-junk))
		(Domain-namespace dom))))
	 (t
	  (values
	     (note-domain-entity-bogosity status name dom fields flg-junk
					  def-form)
	     false)))))         

(def-opt-form-handler situation definer (def-form)
		      (situation-define 'situation def-form))

(defun situation-define (sit-type def-form)
   (multiple-value-bind (status name dom fields flg-junk)
                        (massage-domain-entity-def-form def-form)
      (case status
         (:okay
          (let ((facts (append-field ':facts fields))
		(obs (collect-field ':objects fields))
                (inits (append-field ':init fields))
                (bad-fields (collect-bad-fields '(:domain :objects :init
						  :facts)
                                                fields)))
             (values
	        (situation-parse sit-type name dom facts obs inits
				 `(,@bad-fields ,@flg-junk))
		(Domain-namespace dom))))
         (t
	  (values
             (note-domain-entity-bogosity status name dom fields flg-junk
					  def-form)
	     false)))))

(def-opt-form-handler problem definer (def-form)
   (multiple-value-bind (status name dom fields flg-junk)
                        (massage-domain-entity-def-form def-form)
      (case status
         (:okay
	  (!= name (symbol->actual-global-name *-* ':problem))
          (let ((requirements (append-field ':requirements fields))
                (situation (append-field ':situation fields))
		(facts (append-field ':facts fields))
                (obs (collect-field ':objects fields))
                (lnth (append-field ':length fields))
                (inits (append-field ':init fields))
                (goal (append-field ':goal fields))
		(expansion (append-field ':expansion fields))
		(metric (collect-field ':metric fields))
                (bad-fields (collect-bad-fields '(:domain :requirements
						  :situation :objects :init
                                                  :length :goal :expansion
						  :facts :metric )
                                                fields)))
	     (values
		(collecting-defective-exps
		       (ifel flg-prob)
		       (problem-parse name dom requirements
				      situation facts obs inits goal
				      expansion lnth metric
				      `(,@bad-fields ,@flg-junk))
		   (:if-aborted :restart-report
				(lambda (srm)
				   (out (:to srm)
					"I will give up on problem " name))
   ;;;;		   (dbg-save ifel)
   ;;;;		   (breakpoint problem-parse
   ;;;;		      "ifel = " ifel)
		      (new-Flagged-subexpression
			 def-form ifel))
		   flg-prob)
		(multi-let (((prob okay _)
			     (get-global-opt-sym name)))
		   (and okay
			(is-Problem prob)
			(let ((sit (Problem-sit prob)))
			   (and sit
				(let ((dom (Initial-situation-domain sit)))
				   (and dom
					(Domain-namespace dom))))))))))
         (t
	  (values
             (note-domain-entity-bogosity status name dom fields flg-junk
					  def-form)
	     false)))))

(defun massage-domain-entity-def-form (def-form)
   (let ((name (extract-defined-name def-form)))
      (cond ((symbolp name)
	     (multi-let (((status dom fields flg-junk)
			  (extract-domain-and-fields (cddr def-form))))
		(values status name dom fields flg-junk)))
            (t
             (values ':bogus name nil nil nil)))))

(defun extract-domain-and-fields (fields)
	     (multiple-value-bind (fields flg-junk)
				   (list-smooth fields #'consp)
                (let ((domnames (append-field ':domain fields)))
                  (cond ((and (= (length domnames) 1)
                              (symbolp (car domnames)))
                         (let ((dom (try-domain-with-name
                                       (car domnames) nil)))
                            (cond ((is-Domain dom)
                                   (values ':okay dom fields flg-junk))
                                  (dom
                                   (values ':undef 
		                           (flag-wrong-type dom (car domnames)
				                            'domain)
                                           fields flg-junk))
		                  (t
                                   (values ':undef
		                           (flagexp "Undefined domain"
			                            (car domnames))
                                           fields flg-junk)))))
                        (t
                         (values ':illegal domnames fields flg-junk))))))

(defun note-domain-entity-bogosity (status name dom fields flg-junk
                                    def-form)
   (case status                                     
      (:undef
       `(define (,(caadr def-form) ,name)
	   (:domain ,dom)
	   ,@fields ,@flg-junk))
      (:illegal
       (flagexp "Incoherent domain name"
		`(define (,(caadr def-form) ,name)
	            ,@(cddr def-form))))
      (:bogus
       `(define (,(caadr def-form) ,@name) ,@(cddr def-form)))))

(defun extract-defined-name (def-form)
   (let ((n (cdadr def-form)))
      (cond ((and (= (length n) 1)
		  (symbolp (car n)))
	     (car n))
	    (t (flagexp "Unintelligible name"
			n)))))

; no-op inserted to stop syntax checker from checking things that are too big
(defun stop-syncheck ())

