;-*- Mode: Common-lisp; Package: opt; Readtable: ytools; -*-
(in-package :opt)
;;; $Id: expansion-exc.lisp,v 1.7 2006/03/09 16:12:01 dvm Exp $

(depends-on :at-run-time %langutils/ defectexp %lisplang/ typedexp
	    %opt/ types syntax)

(eval-when (:compile-toplevel :load-toplevel :execute :slurp-toplevel)
   (export '(legal-link-keywords*)))

(def-opt-form-handler seq term-checker
                      (seq-exp target-type undo-stack context qvarbdgs)
   (let-fun ()
      (functional-term-check
          `(seq ,@(resolve-shorthand-links (cdr seq-exp)))
	  target-type undo-stack context qvarbdgs)

    :where
       (:def resolve-shorthand-links (steps)
	  (match-cond steps
	     (:? ()
		'())
	     (:? (:link ?@_)
		(ill-formed-typed-exp seq-exp target-type qvarbdgs))
	     (:? (?step :link ?lnk ?next ?@rem)
		`(,(link-wrap step lnk ':output)
		  ,@(resolve-shorthand-links
		       `(,(link-wrap next lnk ':input)
			 ,@rem))))
	     (t `(,step ,@(resolve-shorthand-links (cdr steps))))))

       (:def link-wrap (step linkname in-or-out)
	  (match-cond step
	     (:? (link ?a ?@links)
	       `(link ,a ,in-or-out ,linkname ,@links))
	     (t
	      `(link ,step ,in-or-out ,linkname))))))

(def-class Action-binder-typed-exp (:options (:include Typed-exp))
   bindings  ;; Arglistspec
   body   ;; may be false
   (:handler
      (initialize :before (bte)
	 (slot-defaults bte bindings no-args-spec*)
	 (!= (Typed-exp-subexps bte)
	     (let-fun ((list-if-not-false (x)
			  (cond (x (list x))
				(t !()))))
		(list-if-not-false
		   (Action-binder-typed-exp-body bte)))))))

(def-meth show-header ((qte Action-binder-typed-exp))
  (out (:a (string-capitalize (Typed-exp-flag qte))) 1 
       (arglistspec-typed-arglist (Action-binder-typed-exp-bindings qte))))
       ;;;;(Action-binder-typed-exp-bindings qte)

(def-meth flagsource ((abte Action-binder-typed-exp))
   (with-slots (suchthat) abte
      `(,(nisptype::arglistspec-typed-arglist
	    (Action-binder-typed-exp-bindings abte))
	,(flagsource suchthat)
	,@(include-if (Action-binder-typed-exp-body abte)
	     (flagsource (Action-binder-typed-exp-body abte))))))

(def-meth show ((qte Action-binder-typed-exp))
   (out (:e (show (Action-binder-typed-exp-body qte)))
	:%))

(def-class Forsome-typed-exp (:options (:include Action-binder-typed-exp))
   suchthat
   (:handler
      (initialize :before ((tc Forsome-typed-exp))
	 (slot-defaults tc flag 'forsome))
      (initialize :after ((tc Forsome-typed-exp))
	 (!= (Forsome-typed-exp-subexps tc)
	     (cons (Forsome-typed-exp-suchthat tc) *-*)))))

(def-meth show ((fste Forsome-typed-exp))
   (out (:e (show (Forsome-typed-exp-suchthat fste)))
	:%))

(def-meth flagsource ((fste Forsome-typed-exp))
   `(forsome
     ,@(call-next-method fste)))

(def-opt-form-handler forsome term-checker
                      (forsome-spec target-type undo-stack context qvarbdgs)
   (match-cond forsome-spec
      ?( (forsome ?vars ?suchthat ?act)
	(forsome-check vars suchthat act target-type
		       undo-stack context qvarbdgs))
      ?( (forsome ?vars ?act)
	(forsome-check vars false act target-type
		       undo-stack context qvarbdgs))
      (t
       (values
	  (ill-formed-typed-exp forsome-spec target-type qvarbdgs)
	  undo-stack))))

(defun forsome-check (vars suchthat act target-type
		      undo-stack context orig-qvarbdgs)
   (multi-let (((_ new-qvarbdgs defective-exps)
		(qvar-list-parse vars univ-type* orig-qvarbdgs)))
      (!= context (context-expstack-push 'forsome 0 context))
      (let ((qvarbdgs (append new-qvarbdgs orig-qvarbdgs)))
	 (multi-let (((ste undo-stack-1)
		      (cond (suchthat
			     (!= context (context-expstack-advance *-*))
			     (term-check suchthat prop-type*
					 undo-stack context qvarbdgs))
			    (t
			     (values
				(build-Var-typed-exp 'true 'true
						     prop-type* qvarbdgs)
				undo-stack)))))
	    (!= context (context-expstack-advance *-*))
	    (multi-let (((ate undo-stack-2)
			 (term-check act target-type
				     undo-stack-1 context qvarbdgs)))
	       (values
		  (note-bugs
		     (make-inst Forsome-typed-exp
			:suchthat ste
			:body ate
			:bindings new-qvarbdgs
			:env orig-qvarbdgs
			:source `(forsome ,(var-bindings-sexp
					      new-qvarbdgs orig-qvarbdgs)
				    ,(Typed-exp-source ste)
				    ,(Typed-exp-source ate)))
		     defective-exps)
		  undo-stack-2))))))

(def-class Foreach-typed-exp (:options (:include Action-binder-typed-exp))
   suchthat
   (:handler
      (initialize :before ((tc Foreach-typed-exp))
	 (slot-defaults tc flag 'foreach))
      (initialize :after ((tc Foreach-typed-exp))
	 (!= (Foreach-typed-exp-subexps tc)
	     (cons (Foreach-typed-exp-suchthat tc) *-*)))))

(def-meth show ((fste Foreach-typed-exp))
   (out (:e (show (Foreach-typed-exp-suchthat fste)))
	:%))

(def-meth flagsource ((fste Foreach-typed-exp))
   `(forsome
     ,@(call-next-method fste)))

(def-opt-form-handler foreach term-checker
                      (foreach target-type undo-stack context qvarbdgs)
   (match-cond foreach
      ?( (foreach ?vars ?suchthat ?act)
	(multi-let (((_ new-qvarbdgs defective-exps)
		     (qvar-list-parse vars univ-type* qvarbdgs)))
	   (!= qvarbdgs (append new-qvarbdgs *-*))
	   (multi-let (((gte undo-stack-1)
			(formula-typecheck suchthat false
					   undo-stack qvarbdgs false)))
	      (multi-let (((ate undo-stack-2)
			   (action-term-check act
					      undo-stack-1 context qvarbdgs)))
		 (values
		    (note-bugs
	               (make-inst Foreach-typed-exp
			  :source foreach
			  :bindings new-qvarbdgs
			  :suchthat gte
			  :body ate)
		       defective-exps)
		    undo-stack-2)))))
      (t
       (ill-formed-typed-exp foreach target-type qvarbdgs))))

(def-class Link-typed-exp (:options (:include Typed-exp))
  act
  linkrels  ; (Lst (Tup CSymbol Vartype)) or 'Domain-bdg' instead of Vartype
   (:handler
      (initialize :before ((tc Link-typed-exp))
	 (slot-defaults tc
			flag 'link
			subexps (list (Link-typed-exp-act tc))))))

(def-meth show-header ((lte Link-typed-exp))
   (out "Link"))
   
(def-meth show ((lte Link-typed-exp))
   (out (:e (show (Link-typed-exp-act lte)))
	(:e (repeat :for ((rel :in (Link-typed-exp-linkrels lte)))
	      (:o (car rel) 1 (Vartype-var (cadr rel)))))))

(def-meth flagsource ((lte Link-typed-exp))
  `(link ,(flagsource lte)
	 ,@(<! (\\ (rel)
		  (list (car rel)
			(Vartype-var (cadr rel))))
	       (Link-typed-exp-linkrels lte))))

;;; These are used just as vals of links at type-check time 
(def-class Link-descrip
  name
  implicit-lv
  contents-type)

;;; ... so we can have this --
(def-meth var-val-typed-exp ((ld Link-descrip)
			     vt source context env)
                            (declare (ignore vt context))
   (with-slots ((link-name name) implicit-lv (link-type type)) ld
      (let ((link-te
	       (build-Var-typed-exp link-name link-name link-type env)))
	 (cond (implicit-lv
		(simple-app-typed-exp
		   (build-Var-typed-exp 'lv 'lv link-type env)
		   (list link-te)
		   (list link-type)
		   source link-type env))
	       (t link-te)))))

;;; These are even more microscropic; they are used as vals of
;;; _slots_ of links.

(def-class Link-slot-descrip
    slot-name
    link-name ;; -- symbol or list of names, in which case slot-name
              ;; is ambiguous and the rest
              ;; of the fields are meaningless.
    slot-type
    link-type)

(def-meth var-val-typed-exp ((lsd Link-slot-descrip)
			     _ source _ env)
   (let ((slname (Link-slot-descrip-slot-name lsd))
	 (lnkname (Link-slot-descrip-link-name lsd))
	 (slot-type (Link-slot-descrip-slot-type lsd))
	 (struc-type (Link-slot-descrip-link-type lsd)))
      (cond ((consp lnkname)
	     ;; Ambiguous
	     (let ((vte (build-Var-typed-exp
			     slname slname univ-type* env)))
		(note-defective-exp ((slname) "Multiply defined slot "
					      slname
					      " -- could be from any of "
					      lnkname)
		   :target slname
		   :place Link-slot-descrip/var-val-typed-exp
		   (:novalue "I will pretend it's well defined"))
		vte))
	    (t
	     (let ((fcn-te (fcn-te-from-slot false struc-type slname
					     (empty-undo-stack)
					     env))
		   (arg-te (var-val-typed-exp (make-Link-descrip
					          lnkname true struc-type)
					      nil lnkname nil env)))
		(cond (fcn-te
		       (make-inst Slot-acc-typed-exp
			  :slotname slname
			  :type-invert false
			  :fcn fcn-te
			  :args (list arg-te)
			  :arg-positions '(1)
			  :arg-targ-types (list struc-type)
			  :hidden false
			  :type slot-type
			  :source source
			  :ext `(!_(,(Type-desig slot-type) ,slname)
				 ,lnkname)
			  :env env
			  :totbugs (+ (Typed-exp-totbugs fcn-te)
				      (Typed-exp-totbugs arg-te))
			  :subexps (list fcn-te arg-te)))
		      (t
		       (signal-problem Link-slot-descrip/var-val-typed-exp
			  "Can't get Typed-exp for slot " slname
			  :% " of " struc-type))))))))

(defvar legal-link-keywords* '(:output :input :then :wait
			       :begin-then :wait-end :span))

(def-opt-form-handler link term-checker
         (linkterm target-type undo-stack con vartypes)
   (function-unless-require :action-expansions
	      linkterm target-type undo-stack con vartypes
      (repeat :for ((l (cdr linkterm))
		    (offset 1)
		    (act-offset false)
		    act
		    :collector rel-triples)
       :until (null l)
       :result (cond (act-offset
		      (check-it))
		     (t
		      (values
			 (ill-formed-typed-exp linkterm target-type vartypes)
			 undo-stack)))
       :within
	 (cond ((is-Keyword (car l))
		(cond ((null (cdr l))
		       (note-defective-exp
			   ((_) "Extra item at end of keyword list " linkterm)
			 :place link-opt-form-handler
			 (:proceed "I will ignore it"))
		       (!= l !()))
		      (t
		       (:continue
			:collect (tuple (car l) (cadr l) offset)
			  (!= l (cddr l))
			  (!= offset (+ *-* 2))))))
	       (t
		(cond (act-offset
		       (note-defective-exp
			  ((_) "Action specified twice in " linkterm)
			  :place link-opt-form-handler
			  (:proceed "I will ignore all but the first")))
		      (t
		       (!= act (car l))
		       (!= act-offset offset)))
		(!= offset (+ *-* 1))
		(!= l (cdr l))))
       :where

 (:def check-it ()
    (let ((existing-link-vartypes
	     (repeat :for ((rel :in rel-triples)
			   keyword linkname keyword-okay
			   :collectors link-vartypes)
	      :result link-vartypes
		(!= keyword (car rel))
		(!= keyword-okay (memq keyword legal-link-keywords*))
		(!= linkname (cadr rel))
	      :within
		(cond ((and keyword-okay
			    (is-symbolish linkname))
		       (:continue
			:collect
			  (let ((vt (var-lookup linkname vartypes)))
			    (cond (vt
				   (cond ((is-link-type (Vartype-type vt))
					  vt)
					 (t
					  (note-defective-exp
					     ((_) linkname
						  " is not the name of a link")
					     :fatal))))
				  (t
				   (note-defective-exp
				      ((_) "Unbound link name " linkname)
				      :fatal))))))
		      (t
		       (cond ((not (is-CSymbol linkname))
			      (note-defective-exp
			         ((_) "Nonatomic link name: " linkname)
				 :place link-opt-form-handler
				 :fatal)))
		       (cond ((not keyword-okay)
			      (note-defective-exp
			              ((_) "Illegal keyword in 'link' list: "
					   keyword)
				 :place link-opt-form-handler
				 :fatal))))))))
       (put-it-together (input-vartypes existing-link-vartypes)
			(check-outputs existing-link-vartypes))))

 (:def input-vartypes (existing-link-vartypes)
    (repeat :for ((rel-trip :in rel-triples)
		  (vt :in existing-link-vartypes)
		  ;; This is an alist because we must watch out
		  ;; for the rare case of a duplicate --
		  (slot-descrips !((Lrcd CSymbol (Lst Link-slot-descrip))))
		  :collectors input-vartypes)
     :when (eq (car rel-trip) ':input)
     :collect (new-Vartype (Vartype-var vt)
			   (type-find-feature
			      (Vartype-type vt)
			      'val-type
			      vartypes)
			   (make-Link-descrip
			       (Vartype-var vt)
			       true
			       (type-find-feature
				   (Vartype-type vt)
				   'link-contents-type
				   vartypes)))
       (cond ((eq (car rel-trip) ':input)
	      (repeat :for ((slot :in (Type-slotfns (Vartype-type vt))))
	       :when (not (memq (Slot-name slot)
				'(conser =)))
		  (on-list (make-Link-slot-descrip
			      (Slot-name slot)
			      (Vartype-var vt)
			      (Slot-type slot)
			      (Vartype-type vt))
			   (alref slot-descrips (Slot-name slot) !())))))
     :result (nconc (gather-slot-defs slot-descrips)
                    input-vartypes)))

 ;; Transform slot-descrips into actual vartypes, which is usually
 ;; straightforward, but if two input links have slots with the same names
 ;; it's ambiguous to refer to those slots with just the names.
 (:def gather-slot-defs (slot-descrips)
     (<# (\\ (a)
	    (multi-let (((slot-type res-descrip)
			 (cond ((= (len (second a)) 1)
				;; Unambiguous
				(values
				   (Link-slot-descrip-slot-type
				       (first (second a)))
				   (first (second a))))
			       (t
				;; Ambiguous
				(values univ-type*
					(make-Link-slot-descrip
					   (first a)
					   (<# Link-slot-descrip-link-name
					       (second a))
					   nil nil))))))
	       (new-Vartype (first a)
			    slot-type
			    res-descrip)))
	  slot-descrips))

 (:def check-outputs (existing-vartypes)
       (repeat :for ((trip :in rel-triples)
		     (vt :in existing-vartypes)
		     (ustack undo-stack)
		     (ok true))
	:result ustack
	  (cond ((eq (car trip) ':output)
		 (!= < ok ustack >
		     (accept-as-equal true
				      (Vartype-type vt)
				      target-type
				      ustack
				      global-opt-env*
				      global-opt-env*
				      !()))
		 (cond ((not ok)
			(note-defective-exp
			   ((lt) "Output link " (Vartype-var vt)
				 " incompatible with target-type "
				 :% 1 target-type " in " :%
				 lt)
			   :target linkterm)))))))

 (:def put-it-together (input-vartypes undo-stack)
    (multi-let (((ate undo-stack-1)
		 (term-check act target-type undo-stack
			     (context-expstack-push
				linkterm act-offset con)
			     (env-bindings-append
				true input-vartypes vartypes))))
       (values
	  (make-inst Link-typed-exp
	     :act ate
	     :linkrels (<! (\\ (trip) (list (car trip) (cadr trip)))
			   rel-triples)
	     :type (Typed-exp-type ate)
	     :env input-vartypes
	     :source `(link ,(Typed-exp-source ate)
			 ,@(<! (\\ (rel vt)
				  (list (car rel)
					(Vartype-var vt)))
			       rel-triples
			       input-vartypes))
	     :subexps (list ate))
	  undo-stack-1))))))

(def-class With-links-typed-exp (:options (:include Binder-typed-exp))
   constraints
   arglistspec
  ;; (Lst (Tup which - (Con :postcondition :maintain)
   ;;           link - Vartype
   ;;           prop - Typed-exp))
   (:handler
       (initialize :before ((wlte With-links-typed-exp))
	  (slot-defaults wlte flag 'with-links)))
)

(def-meth show-header ((wlte With-links-typed-exp))
   (out "With-links " (arglistspec-typed-arglist
		         (With-links-typed-exp-arglistspec wlte))))

(def-meth show ((wlte With-links-typed-exp))
   (out (:i> 3)
	(:e (show (With-links-typed-exp-body wlte)))
	(:i< 3)
	(:e (repeat :for ((con :in (With-links-typed-exp-constraints wlte)))
	      (:o (car con) 1 (Vartype-var (cadr con)) :%
		  (:i> 3)
		  (:e (show (caddr con)))
		  :%)))))

(def-meth flagsource ((wlte With-links-typed-exp))
   `(with-links ,(var-bindings-flagsource
		   (With-links-typed-exp-bindings wlte))
       ,(flagsource (With-links-typed-exp-body wlte))
       ,@(<! (\\ (con)
		(list (car con)
		      (Vartype-var (cadr con))
		      (flagsource (caddr con))))
	     (With-links-typed-exp-constraints wlte))))

(def-opt-form-handler with-links term-checker
               (wlterm target-type undo-stack con mvartypes)
   (let-fun ()
      (match-cond wlterm
	 ?( (with-links ?bdgs ?act ?constraints)
	   (check-it bdgs act constraints))
	 (t
	  (note-defective-exp ((wlterm) "Ill-formed: " wlterm)
	     :target wlterm
	     :place with-links-term-checker)))

      :where

 (:def check-it (bdgs act constraints)
    (multi-let (((alspec new-varbdgs)
		 (with-link-bdgs-parse bdgs mvartypes)))
       (let ((augenv (env-bindings-append
		        true new-varbdgs mvartypes)))
	  (multi-let (((ate undo-stack-1)
		       (term-check act target-type undo-stack
				   (context-expstack-push
				      wlterm 2 con)
				   augenv)))
	     (repeat :for ((con :in constraints)
			   (ustack undo-stack-1)
			   prop-te
			   (pos = 4 :by 2)
			   :collectors res)
	      :nconc 
		(match-cond con
		   ?( (?(:\| :postcondition :maintain)
		       ?(:+ ?linkname is-CSymbol)
		       ?proposition)
		     (let ((vt (var-lookup linkname augenv)))
		        (cond ((and vt (is-link-type (Vartype-type vt)))
			       (!= < prop-te ustack >
				   (term-check
				      proposition
				      prop-type*
				      ustack
				      (context-expstack-push
					 wlterm pos con)
				      augenv))
			       (list (tuple (car con) vt prop-te)))
			      (t
			       (note-defective-exp
				   ((_) "Non-linkname " linkname)
				   :target wlterm
				   :place with-links-opt-term-handler
				   (:proceed
				      "I'll ignore this constraint"))
			       !()))))
		   (t
		    (note-defective-exp
		        ((_) "Ill-formed constraint " con)
			:target wlterm
			:place with-links-opt-term-handler
			(:proceed "I'll ignore this constraint"))
		    !()))
	      :result (put-it-together res)
	      :where

 (:def put-it-together (processed-constraints)
    (make-inst With-links-typed-exp
       :constraints processed-constraints
       :arglistspec alspec
       :body ate
       :bindings new-varbdgs
            ;;(vars-source-maybe-flag new-varbdgs ill-formed-vars)
       :type (Typed-exp-type ate)
       :subexps (cons ate (<# caddr processed-constraints))
       :env mvartypes
       :source `(with-links ,@(arglistspec-typed-arglist alspec)
		   ,(Typed-exp-source ate)
		   ,@(<! (\\ (pc)
			    (list (car pc)
				  (Vartype-var (cadr pc))
				  (Typed-exp-source (caddr pc))))
			 processed-constraints)))))))))))

;;; Moved to action.lisp (and altered, hopefully without changing it)
;;;; (defvar empty-val-type* (compile-time-designated-type (Val) opt))

(defun with-link-bdgs-parse (link-decls env)
   (multi-let (((orig-alspec _ _ synerrs)
		(params-parse link-decls true
			      empty-val-type* false false env)))
      (let ((link-alspec
	       (new-Arglistspec
		  (<# (\\ (as)
			 (make-Argspec
			    (Argspec-name as)
			    (Argspec-mode as)
			    (nisptype::Argspec-position as)
			    (make-link-type (Argspec-type as) env)
			    false
			    (<# list-copy (nisptype::Argspec-props as))))
		      (Arglistspec-argspecs orig-alspec)))))
	 (repeat :for ((err :in synerrs))
	    (defective-exp-notify
	       (make-Defective-exp
		  ;;;; :has-target false
		  :target false
		  :observation (\\ (_ srm)
				  (synerr-out err srm))
		  :signaler (\\ (this-exp)
			       (signal-problem :place with-link-bdgs-parse
				  "Syntactic error in 'with-links'["
				  " vars list: " this-exp
				  (:continue "I'll ignore it"))))
	       true))
	 (values orig-alspec
		 (arglistspec->vartypes link-alspec)))))

;;; This works only in contexts where a non-symbol is accepted.
(defun action-term-check (action-spec undo-stack context qvarbdgs)
   (cond ((consp action-spec)
          (multiple-value-bind (action-spec flg-junk)
                               (list-smooth action-spec
                                            #'any)
	     (multi-let (((ate undo-stack-1)
			  (clean-action-term-check
                             action-spec undo-stack context qvarbdgs)))
		(values
		   (note-bugs ate flg-junk)
		   undo-stack-1))))
	 (t
	  (values
	     (ill-formed-typed-exp action-spec action-type* qvarbdgs)
	     undo-stack))))

(defun clean-action-term-check (action-spec undo-stack context qvarbdgs)
   (term-check action-spec action-type* undo-stack context qvarbdgs))

