;-*- Mode: Common-lisp; Package: opt; Readtable: nisp; -*-
(in-package :opt)

Apparently never used.

;;; Given an expression as used inside the deductive engine, transform
;;; it to an S-expression a human being might comprehend.
;;; The resulting thing should be checkable by term-check.
;;; Turns Sym-with-type's back into Symbols.
;;; Returns < external-form, freevars >
(defun externalize (intexp)
   (cond ((is-Sym-with-type intexp)
	  (values (Sym-with-type-actual intexp) !()))
	 ((is-Qvar intexp)
	  (values (Qvar-sym intexp) (list (Qvar-sym intexp))))
	 ((atom intexp)
	  (values intexp !()))
	 (t
	  (letrec ()
	     (let ((a (car intexp)))
		(cond ((atom a)
		       (try-handler a))
		      ((is-Sym-with-type a)
		       (try-handler (Sym-with-type-actual a)))
		      (t
		       (signal-problem externalize
			  "Internal form has illegal item in functional"
			  " position: "
			  t 3 a))))
	   where
	     (try-handler (a)
		(let ((h (externalize-handler a)))
		   (cond (h
			  (funcall h intexp))
			 (t
			  (list-externalize intexp)))))))))
	  
(defun list-externalize (intexp-list)
   (multi-let (((r vl)
		(multi-reduce
		   (\\ (r vl i)
		      (multi-let (((e ivl)
				   (externalize i)))
			 (values (cons e r)
				 (unionq ivl vl))))
		   (list !() !())
		   intexp-list)))
      (values (dreverse r)
	      vl)))

(defvar externalize-handlers* (make-eq-hash-table))

(defun externalize-handler (a)
   (strip-sym-with-type a)
   (table-entry externalize-handlers* a))

(datafun attach-datafun externalizer
   (defun (_ sym fname)
      (!= (table-entry externalize-handlers* sym)
          (symbol->fun fname))))

(datafun funcall externalizer
   (defun (intexp)
       (list-externalize (cdr intexp))))

(datafun cons externalizer
   (defun (intexp)
      (multi-let (((ae avl)
		   (externalize (cadr intexp)))
		  ((de dvl)
		   (externalize (caddr intexp))))
	 (values
	    (cond ((or (eq de !())
		       (eq (car de) 'list))
		   `(list ,ae ,@(cond ((eq de !())
				       !())
				      (t (cdr de)))))
		  (t
		   `(cons ,ae ,de)))
	    (unionq avl dvl)))))
		


(defun reduce2 (fn init1 init2 &rest lists)
   (cond ((<V null lists)
	  (values init1 init2))
	 (t
	  (<< reduce2 fn
	      (nconc (multiple-value-list
		        (apply fn init1 init2 (<# car lists)))
		     (<# cdr lists))))))




;;;;change Constant to include field internalizer


