(defun fluent-eval (e vid bdgs sit dom)
   (cond ((is-Qvar e) 
	  (let ((b (uvar-lookup (Qvar-sym e) vid bdgs)))
	     (cond (b
		    (fluent-eval (Expclo-skel (Varbdg-val b))
				 (Expclo-id (Varbdg-val b))
				 bdgs sit dom))
		   (t
		    '*unevaluable))))
	 ((is-Symbol e)
	  (let ((b (find-domain-bdg e dom)))
	     (cond (b
		    (let ((v (Domain-bdg-val b)))
		       (cond ((is-Domain-var v)
			      (Domain-var-val v))
			     ((is-Constant v)
			      (cond ((type-is-fluent (Constant-type v))
				     (fluent-current-value e sit dom))
				    (t
				     (Constant-name v))))
			     (t
			      (error "Symbol not usable in eval-context: ~s"
				     e)))))
		   (t
		    (error "Unbound domain variable ~s" e)))))
	 ((atom e) e)
	 ((eq (car e) 'sum)
	  (sum-eval (caddr e) (cadddr e)
		    vid bdgs sit dom))
	 ((eq (car e) 'constant)
	  (let ((v (unsafe-varsubst (cadr e) vid bdgs)))
	     (cond ((has-qvars v) '*unevaluable)
		   (t (opt-eval v sit !() dom)))))
	 ((is-Symbol (car e))
	  (let ((args (mapcar #'(lambda (x) (fluent-eval x vid bdgs sit dom))
			      (cdr e))))
	     (cond ((member '*unevaluable args :test #'eq)
		    '*unevaluable)
		   (t
		    (let ((b (find-domain-bdg-val (car e) dom)))
		       (cond (b
			      (let ((bty (Domain-bdg-type b)))
				 (cond ((and (is-funtype bty)
					     (type-is-fluent
						(fun-result-type
						   bty
						   (empty-vartypes dom))))
					(fluent-current-value
					   `(,(car e) ,@args)
					   sit dom))
				       (t '*unevaluable))))
			     (t
			      (apply (symbol-function (car e))
				     args))))))))
	 (t
	  (error "Ill-formed fluent expression: ~s" e))))

(defun type-is-fluent (ty) (type-feature ty 'is-fluent))

(defun sum-eval (p e vid bdgs sit dom)
   (let ((total 0)
	 (instances (deduce p vid bdgs sit dom)))
      (dolist (a instances total)
	 (let ((v (fluent-eval e vid a sit dom)))
	    (cond ((eq v '*unevaluable)
		   (return v)))
	    (setf total (+ total v))))))