;-*- Mode: Common-lisp; Package: opt; Readtable: ytools; -*-
;;;$Id: internalize.lisp,v 1.28 2005/12/26 21:05:24 dvm Exp $
(in-package :opt)

(depends-on %module/ ytools)

(depends-on :at-run-time %opt/ more-syntax syntax process axiom
			 %nity/ typeintsect)

;;;;(depends-on :at-compile-time %misc/ multvalhacks)

(end-header :continue-slurping)

;;; This mechanism is obsolete; or at least I haven't thought about
;;; how it interacts with the query-caching scheme in deduction.lisp.
;;; Leave it turned off (by setting prelink* to false) for now.
;;; How linkspots work: As 'internalize' traverses a Typed-exp,
;;; turning it into an S-expression, it replaces (pred ...) with
;;;    (prelinked (pred ...) pl)
;;; where pl is an empty Prelink-list:

(def-class Prelink-list
   rules)

;;; Occurrences of (prelinked ...) are then collected during the
;;; 'internalize' traversal.  Finally, for each linkspot
;;; (prelinked (pred ...) pl), the rules that appear to unify
;;; with (pred ...) are collected and put into the Prelink-list-rules
;;; slot of 'pl'.

;;; "Finally" means as late as possible, and in particular after all
;;; internalization and indexing are done, because the rules we want
;;; are not accessible until then.  Muito importante.

;;; 'goal-position' is either ':consequent', ':antecedent', or false.
;;; 'freevars' is variables that are bound in universal quantifiers
;;; that have been skolemized away.
(def-op internalize (te freevars goal-position))
   
;;; Principle: Although 'internalize' sometimes builds new Typed-exps,
;;; it never creates any new bugs in them, or pays attention to any that
;;; are created as a byproduct.  If the type checker did its job
;;; correctly, there will not be any bugs (!). 

(def-meth internalize ((vte Var-typed-exp) freevars _)
   (let ((var (Var-typed-exp-var vte)))
      (values
         (repeat :for ((e :in freevars))
	  :result var
	  :until (eq e var)
	  :result (make-Qvar var !())
	  :until (car-eq e var)
	  :result ;;;;(make-Qvar (second e) !())
		  (second e))
	 '())))

(def-meth internalize ((const-te Const-typed-exp) _ _)
   (let ((val (Const-typed-exp-val const-te)))
      (values
	 (cond ((car-eq val 'quote)
		(cond ((is-symbolish (cadr val))
		       val)
		      (t (cadr val))))
	       ((is-Constant val)
		(Constant-name val))
	       ((atom val) val)
	       (t
		(signal-problem internalize
		   "Illegal as val of Const-typed-exp: " val)))
	 '())))

(def-meth internalize ((appte App-typed-exp) freevars goal-pos)
   (let ((fcn (App-typed-exp-fcn appte)))
      (multi-let (((intfcn fcn-linkspots)
		   (internalize fcn freevars false)))
	 (cond ((or (eq intfcn 'iff)
		    (and (is-Sym-with-type intfcn)
			 (eq (Sym-with-type-actual intfcn) 'iff)))
		(iff-internalize
		   (App-typed-exp-args appte)
		   freevars goal-pos))
;;;;	       ((or (eq intfcn 'not)
;;;;		    (and (is-Sym-with-type intfcn)
;;;;			 (eq (Sym-with-type-actual intfcn) 'not)))
;;;;		...)
	       (t
		(normal-app-typed-exp-internalize
		   fcn intfcn appte freevars fcn-linkspots)))))) 

(defun iff-internalize (args freevars goal-pos)
   (let ((p (car args))
	 (q (cadr args)))
      (multi-let (((p-l p-l-ls)
		   (internalize p freevars
				(goal-pos-flip goal-pos)))
		  ((p-r p-r-ls)
		   (internalize p freevars goal-pos))
		  ((q-l q-l-ls)
		   (internalize q freevars
				(goal-pos-flip goal-pos)))
		  ((q-r q-r-ls)
		   (internalize q freevars goal-pos)))
	 (values
	    `(and ,(if-sexp 'if p-l q-r 'true)
		  ,(if-sexp 'if q-l p-r 'true))
	    (nconc p-l-ls p-r-ls q-l-ls q-r-ls)))))

(defun normal-app-typed-exp-internalize (fcn intfcn appte
					 freevars fcn-linkspots)
   (multi-let (((intargs arg-linkspots)
	        (list-internalize
		  (App-typed-exp-args appte)
		  freevars false)))
      (values
	 (cond ((and (App-typed-exp-hidden appte)
		     (or (is-Var-typed-exp fcn)
			 (is-Const-typed-exp fcn)))
		(let ((tb (type-bound
			     (Typed-exp-type appte)
			     true true ':all empty-env*)))
		 (make-Sym-with-type 
		    (cond ((is-Var-typed-exp fcn)
			   (Var-typed-exp-var fcn))
			  (t
			   (is-Const-typed-exp fcn)
			   (Constant-name (Const-typed-exp-val fcn))))
		    tb)))
	       (t
		`(,@(cond ((or (is-symbolish intfcn)
			       (is-Sym-with-type intfcn))
			   !())
   ;;;;                         ((App-typed-exp-hidden appte)
   ;;;;                          '(!&))
			  (t '(funcall)))
		  ,intfcn
		  ,@intargs)))
	 (nconc fcn-linkspots arg-linkspots))))

;;; If we really want to do something spiffy with
;;; &rest, &optional, and &key args, this would be the
;;; place to do it.  (Although non-Const fcns have to be handled in a 
;;; similar way.)
;;; This is not actually called by anyone.
(defun const-fcn-app-internalize (fcn appte freevars goal-position)
   (let ((fcnval (Const-typed-exp-val fcn)))
      (let ((fint (Functional-constant-internalizer fcnval)))
	 (cond (fint
		(funcall fint appte freevars goal-position))
	       ((is-Predicate fcnval)
		(predication-internalize
		   fcnval appte freevars goal-position))
	       (t
		(form-internalize fcnval appte freevars))))))

(defvar prelink* false)  ;; Never set to true!

(defun predication-internalize (pred appte freevars goal-position)
   ;; Interesting things happen only if we're in the antecedent
   ;; of an implication, i.e., the predication is an actual goal.
   (let-fun ()
      (cond ((eq goal-position ':antecedent)
	     (cond ((Predicate-macro pred)
		    (multi-let (((basic ls)
				 (internalize-it)))
		       ;; Macros apply to already-internalized form
		       ;; linkspots are assumed to be untouched by
		       ;; macro
		       (values (funcall (Predicate-macro pred)
					basic freevars goal-position)
			       ls)))
		   ((Predicate-prechain pred)
		    (cond (prelink*
			   (multi-let (((basic ls)
					(internalize-it)))
			      (cond ((not (null ls))
				     (err-out "Unexpected linkspots")))
			      (let ((exp `(prelinked ,basic
						     (make-Prelink-list '()))))
				 (values exp (list exp)))))
			  (t
			   (out (:to *error-output*) "Not prelinking " appte :%)
			   (internalize-it))))
		   (t
		    (internalize-it))))
	    (t
	     (internalize-it)))
    :where
      (internalize-it ()
	 (form-internalize pred appte freevars))))

(defun form-internalize (fcnval appte freevars)
   (multi-let (((args linkspots)
		(app-typed-exp-args-internalize appte freevars false)))
      (values `(,(Constant-name fcnval)
		,@args)
	      linkspots)))

(defun list-internalize (te-list freevars goal-pos)
   (multi-let (((r ls)
		(multi-reduce
		   (\\ (r ls arg)
		      (multi-let (((e linkspots)
				   (internalize arg freevars goal-pos)))
			 (values
			    (cons e r)
			    (nconc linkspots ls))))
		   (list !(Sexp) !(Sexp))
		   te-list)))
      (values (dreverse r)
	      ls)))

(def-meth internalize ((tte Type-typed-exp) _ _)
   (values
      (type-find-designator (Type-typed-exp-which tte)
			    (Typed-exp-env tte))
      '()))

(def-meth internalize ((tte Type-test-typed-exp) freevars goal-pos)
   (multi-let (((arg-exp arg-ls)
		(internalize (Type-test-typed-exp-arg tte)
			     freevars goal-pos)))
      (let ((tyexp (Type-test-typed-exp-which tte)))
         (cond ((is-Type-typed-exp tyexp)
                (let ((ty (Type-typed-exp-which tyexp)))
                  (cond ((is-Type ty)
                          (let ((is-exp
                                   (type-predify ty arg-exp global-opt-env*)))
                             (values 
	                        is-exp arg-ls)))
                        (t
                         (signal-problem Type-test-typed-exp/internalize
                            "Can't extract a type from " tyexp)))))
               (t
                (signal-problem Type-test-typed-exp/internalize
                   "Not a Typed-typed-exp: " tyexp))))))

;;;;(((which-exp which-ls)
;;;;		(internalize 
;;;;			     freevars goal-pos))
	      


(defvar bvar-disting* 0)

;; bindings slot contains qvarbdgs
(def-meth internalize ((qte Quantified-typed-exp) freevars goal-pos)
   (let ((qvarbdgs (Quantified-typed-exp-bindings qte))
	 (quantifier (Quantified-typed-exp-quantifier qte))
	 (universal (Quantified-typed-exp-universal qte)))
;;;;      (dbg-save qte qvarbdgs quantifier universal
;;;;		(kq (Quantified-typed-exp-keep-quantifier qte)))
;;;;      (breakpoint Quantified-typed-exp-internalize
;;;;	 "Internalizing: " qte)
      (let* ((keep-quantifier
		(Quantified-typed-exp-keep-quantifier qte))
	     (nonvacuous-qvarbdgs
		 (cond ((Quantified-typed-exp-use-bindings-as-constraints
			   qte)
			(<? (\\ (vt)
			       (not (eq (Vartype-type vt) univ-type*)))
			    qvarbdgs))
		       (t !())))
	     (qvars (<# (\\ (qv)
			  (let ((v (Vartype-var qv)))
			     (tuple v
				    (let ((new-name
					     (build-symbol
						(< v) -
						(++ bvar-disting*))))
				       (cond ((or (not keep-quantifier)
						  (eq quantifier 'freevars))
					      (make-Qvar new-name
							 !()))
					     (t new-name))))))
		       qvarbdgs))
	     (freevars (append qvars freevars)))
;;;;	    (out (:to *query-io*)
;;;;	       "universal = " universal
;;;;	       " goal-pos = " goal-pos :%)
;;;;	    (cond (keep-quantifier
;;;;		   (dbg-save qte quantifier universal)
;;;;		   (breakpoint qte/internalize
;;;;		      "Existential about to survive internalization")))
	    (let-fun ()
	       (let ((body-te 
			(cond ((null nonvacuous-qvarbdgs)
			       (Quantified-typed-exp-body qte))
			      ((or (eq quantifier 'forall)
				   (and universal
					(eq quantifier 'freevars)))
			       (add-type-filter-prec
					 (Quantified-typed-exp-body qte)
					 nonvacuous-qvarbdgs
					 (cond (keep-quantifier 'if)
					       (t '<-))))
			      (t
			       (add-type-filter-conj
					(Quantified-typed-exp-body qte)
					nonvacuous-qvarbdgs)))))
		  (multi-let (((body-formula linkspots)
			       (internalize body-te freevars goal-pos)))
		     (values (build-it body-formula)
			     linkspots)))
		:where

    (:def build-it (e)
       (cond (keep-quantifier
	      (cond ((eq quantifier 'exists!)
		     (let ((paired-vars (<# (\\ (_) (gensym))
					    qvars)))
			(let ((alist (<# (\\ (v1 v2)
					    (tuple (second v1) v2))
					 qvars paired-vars)))
			   `(exists ,(<# second qvars)
			       (and ,e
				    (forall ,paired-vars
				       (if ,(sublis alist e)
					   (and
					     ,@(<# (\\ (v pv)
						      `(= ,pv ,(second v)))
						   qvars
						   paired-vars)))))))))
		    (t
		     `(,quantifier ,(<# second qvars) ,e))))
	     (t e)))))))


;;;;	       (cond (universal
;;;;		      (let ((body-te
;;;;			       (cond ((null nonvacuous-qvarbdgs)
;;;;				      (Quantified-typed-exp-body qte))
;;;;				     (t
;;;;				      (add-type-filter-prec
;;;;					 (Quantified-typed-exp-body qte)
;;;;					 nonvacuous-qvarbdgs
;;;;					 (cond (keep-quantifier 'if)
;;;;					       (t '<-)))))))
;;;;			(multi-let (((body-formula linkspots)
;;;;				     (internalize body-te freevars goal-pos)))
;;;;			   (values (build-it body-formula)
;;;;				   linkspots))))
;;;;		     (t
;;;;		      (let ((body-te
;;;;			      (cond ((null nonvacuous-qvarbdgs)
;;;;				     (Quantified-typed-exp-body qte))
;;;;				    (t
;;;;				     (add-type-filter-conj
;;;;					(Quantified-typed-exp-body qte)
;;;;					nonvacuous-qvarbdgs)))))
;;;;			  (multi-let (((e ls)
;;;;				       (internalize
;;;;					  body-te freevars goal-pos)))
;;;;			     (values (build-it e)
;;;;				     ls))))))))))

;;; 'type-filter-vartypes' is known to be non-().
(defun add-type-filter-prec (te type-filter-vartypes prag)
   (cond ((is-If-typed-exp te)
	  (multi-let (((filt-consis useful-filters)
		       (type-filter-conj (If-typed-exp-test te)
					 type-filter-vartypes)))
	     (cond (filt-consis
		    (cond ((null useful-filters)
			   te)
			  (t
			   (let ((prag (If-typed-exp-prag te))
				 (ty (Typed-exp-type te))
				 (env (Typed-exp-env te))
				 (totbugs (Typed-exp-totbugs te))
				 (tvars (Typed-exp-tvars te))
				 (test (If-typed-exp-test te))
				 (iftrue (If-typed-exp-iftrue te))
				 (iffalse (If-typed-exp-iffalse te)))
			      (let-fun ((if-filters (te1 cond1 prag1)
					   (let ((test-te
						    (typed-exp-conjoin-with-filters
						       cond1 useful-filters env)))
					      (make-inst If-typed-exp
						 :type ty
						 :env env
						 :prag prag1
						 :test test-te
						 :iftrue te1
						 :iffalse iffalse
						 :source (if-source
						            prag1 test-te te1 iffalse)
						 :ext (if-ext
						         prag1 test-te te1 iffalse)
					     :totbugs (Typed-exp-totbugs te1)
					     :tvars tvars))))
				 (case prag
				    ((<- >-)
				     (if-filters iftrue test prag))
				    (->
				     (let ((test-te (If-typed-exp-test te))
					   (true-te
					      (if-filters iftrue false '>-)))
					(make-inst If-typed-exp
					   :type ty
					   :env env
					   :prag '->
					   :test test-te
					   :iftrue true-te
					   :iffalse iffalse
					   :source (if-source
						      '-> test-te true-te iffalse)
					   :ext (if-ext
						   '-> test-te true-te iffalse)
					   :totbugs totbugs
					   :tvars tvars)))
				    (t
				     (if-filters te false 'if))))))))
		   (t
		    true-te*))))
	 ((and (is-Boolapp-typed-exp te)
	       (eq (Boolapp-typed-exp-fcn te) 'and))
	  (let ((conjuncts
		   (<# (\\ (c)
			  (add-type-filter-prec c type-filter-vartypes prag))
		       (Boolapp-typed-exp-args te))))
	     (build-and-typed-exp
	        conjuncts (Typed-exp-env te))))
	 (t
	  (typed-exp-conditionalize
	     te
	     (typed-exp-conjoin-with-filters
	        false type-filter-vartypes (Typed-exp-env te))
	     prag))))

(defun build-and-typed-exp (arg-tel env)
   (repeat :for ((arg-te :in arg-tel)
		can-continue can-stop 
		(can-stop-early false)
		continue-bdgs stop-bdgs
		(all-continue-bdgs !(Vartype))
		(stop-alts !((Lst Vartype))))
      (!= < can-continue continue-bdgs >
	  (typed-exp-type-narrow arg-te true true-type*))
      (!= < can-stop stop-bdgs >
	  (typed-exp-type-narrow arg-te true false-type*))
      (cond ((and can-stop (not can-stop-early))
	     (!= can-stop-early true)))
    :while can-continue
      (!= all-continue-bdgs
	  (append continue-bdgs *-*))
      (!= stop-alts (cons stop-bdgs *-*))
    :result (make-inst Boolapp-typed-exp
		 :fcn 'and
		 :args arg-tel
		 :source `(and ,@(<# Typed-exp-source arg-tel))
		 :ext `(and ,@(<# Typed-exp-ext arg-tel))
		 :type-conseqs
		    (tuple (tuple can-continue
				  (vartypes-rem-duplicates all-continue-bdgs))
			   (tuple can-stop-early
				  (vartypes-disjoin stop-alts)))
		 :type prop-type*
		 :env env
		 :bugs '())))

(defun typed-exp-conditionalize (te condition prag)
   (let ((ext (if-ext prag condition te true-te*)))
      (make-inst If-typed-exp
	 :type (Typed-exp-type te)
	 :env (Typed-exp-env te)
	 :prag prag
	 :test condition
	 :iftrue te
	 :iffalse true-te*
	 :source (if-source prag condition te false)
	 :ext ext
	 :totbugs (Typed-exp-totbugs te)
	 :tvars (Typed-exp-tvars te))))

(defun add-type-filter-conj (te type-filter-vartypes)
   (multi-let (((filt-consis useful-filters)
		(type-filter-conj te type-filter-vartypes)))
      (cond (filt-consis
	     (cond ((null useful-filters)
		    te)
		   (t
		    (typed-exp-conjoin-with-filters
		       te useful-filters (Typed-exp-env te)))))
	    (t
	     false-te*))))

(defun type-filter-conj (te type-filter-vartypes)
   (multi-let ((inferred-vartypes
		(typed-exp-argtypes-infer
		   te prop-type* 'true 
		   (<# Vartype-var type-filter-vartypes))))
      (multi-let (((filt-consis useful)
		   (type-filters-cull type-filter-vartypes
				      inferred-vartypes)))
	 (cond (filt-consis
		(values true useful))
	       (t
		(err-out "Type filters " type-filter-vartypes
			 :% " inconsistent with " te)
		(dbg-save :run-loud te type-filter-vartypes inferred-vartypes)
		(breakpoint type-filter-conj
		   "What now?")
		(values false nil))))))

;;; Returns < consis, non-vacs >
;;; where consis iff all type-filter-vartypes are consistent with
;;; inferred-vartypes; non-vacs are all type-filter-vartypes that do not
;;; follow-from inferred-vartypes.
;;; If consis=false, non-vacs is meaningless and unimportant.
(defun type-filters-cull (type-filter-vartypes inferred-vartypes)
   (repeat :for ((tfvt :in type-filter-vartypes)
		 (non-vacs !(Vartype))
		 (consis true))
      (let ((inf (vartypes-lookup (Vartype-var tfvt)
				  inferred-vartypes)))
	 (cond (inf
		(let ((inferred-type (Vartype-type inf))
		      (filter-type (Vartype-type tfvt)))
		   (cond ((not (type-acceptable
				  false inferred-type filter-type !()
				  global-opt-env* global-opt-env* !()))
			  ;; Nonvacuous, but is it consistent?
			  (cond ((type-acceptable
				    false filter-type inferred-type !()
				    global-opt-env* global-opt-env* !())
				 ;; Yes
				 (!= non-vacs (cons tfvt *-*)))
				(t
				 ;; Oops
				 (!= consis false)))))))
	       (t
		(!= non-vacs (cons tfvt *-*)))))
    :while consis
    :result (values consis non-vacs)))
	   
;;; te is false if vacuous.  useful-filters is non-()
(defun typed-exp-conjoin-with-filters (te useful-filters env)
   (multi-let (((te-consistent te-true-bdgs)
		(cond (te (typed-exp-type-narrow te true true-type*))
		      (t (values true '()))))
	       ((te-nonvacuous te-false-bdgs)
		(cond (te (typed-exp-type-narrow te true false-type*))
		      (t (values false nil))))
	       (source-conjuncts
		  (qvarbdgs-constraints useful-filters env)))
      (make-inst Boolapp-typed-exp
	 :fcn 'and
	 :args (nconc (cond (te (list te))
			    (t !()))
		      (<# (\\ (vt)
			      (vartype-test-typed-exp vt env))
			  useful-filters))
	 :source `(and ,@(include-if te (Typed-exp-source te))
		       ,@source-conjuncts)
	 :ext `(and ,@(include-if te (Typed-exp-ext te))
		       ,@source-conjuncts)
	 :type-conseqs
	    (tuple (tuple te-consistent
			  (append useful-filters te-true-bdgs))
		   (tuple te-nonvacuous
			  te-false-bdgs))
	 :type prop-type*
	 :env env
	 :bugs '()
	 :totbugs (cond (te (Typed-exp-totbugs te)) (t 0)))))

(defun vartype-test-typed-exp (vt env)
   (let ((var (Vartype-var vt))
	 (type (Vartype-type vt)))
      (let ((type-te
	       (make-inst Type-typed-exp
		  :which type
		  :source (type-find-designator
			     type global-opt-env*)
		  :env global-opt-env*))
	    (var-te
	       (make-inst Var-typed-exp
		  :var var
		  :qvar false
		  :source var)))
	 (make-inst Type-test-typed-exp
	    :which type-te
	    :arg var-te
	    :env env
	    :source `(is ,(Typed-exp-source type-te) ,var)
	    :ext `(is ,(Typed-exp-ext type-te) ,var)
	    :subexps (list type-te var-te)
	    :tvars '()))))

(def-meth internalize ((mte Maker-typed-exp) freevars _)
   (multi-let (((arg-tel linkspots)
		(app-typed-exp-args-internalize mte freevars false)))
      (values `(make (Maker-typed-exp-type mte)
		;; ,(internalize (Maker-typed-exp-fcn mte) freevars false)
		,@arg-tel)
	      linkspots)))

(def-meth internalize ((slte Slot-acc-typed-exp) freevars _)
   (multi-let (((acc ls-slot)
		(internalize (Slot-acc-typed-exp-fcn slte)
			     freevars false))
	       ((args ls-args)
		(app-typed-exp-args-internalize slte freevars false)))
      (values
	 `(,acc ,@args)
	 (nconc ls-slot ls-args))))

(def-meth internalize ((sfte Slot-fun-typed-exp) _ _)
   (values (Slot-fun-typed-exp-fcn-name sfte)
	   !()))

(def-meth internalize ((ute Unchecked-typed-exp) freevars _)
   (values
      (match-cond (Unchecked-typed-exp-source ute)
	 (:? (goal-call ?pf)
	    `(goal-call ,pf
			;; We put in a fake pred so we can unify these
			;; things --
			(fake-pred
			   ,@(<# (\\ (v)
				    (cond ((consp v)
					   (cadr v))
					  (t v)))
				 freevars))
			(fake-pred
			   ,@(<# (\\ (v)
				    (make-Qvar (cond ((consp v) (cadr v))
						     (t v))
					       !()))
				 freevars))))

	 (:? ?e
	   (qvarify-freevars e freevars)))
      !()))

(defun build-goal-call (proc) `(goal-call ,proc ,(make-Qvar proc '())))

(def-meth internalize ((ifte If-typed-exp) freevars goal-pos)
   (multi-let (((test-exp test-ls)
		(internalize (If-typed-exp-test ifte)
			     freevars
			     (goal-pos-flip goal-pos)))
	       ((iftrue-exp iftrue-ls)
		(internalize (If-typed-exp-iftrue ifte)
			     freevars goal-pos))
	       ((iffalse-exp iffalse-ls)
		(internalize (If-typed-exp-iffalse ifte)
			     freevars goal-pos)))
      (values
	 (if-sexp
	    (If-typed-exp-prag ifte)
	    test-exp iftrue-exp iffalse-exp)
	 (nconc test-ls iftrue-ls iffalse-ls))))

(def-meth internalize ((bappte Boolapp-typed-exp) freevars goal-pos)
   (multi-let (((args linkspots)
		(list-internalize
		   (Boolapp-typed-exp-args bappte)
		   freevars goal-pos)))
      (values
	 `(,(Boolapp-typed-exp-fcn bappte)
	   ,@args)
	 linkspots)))

(def-meth internalize ((dtte Durham-timed-typed-exp) freevars goal-pos)
   (multi-let (((term linkspots)
		(internalize (Durham-timed-typed-exp-term dtte)
			     freevars goal-pos)))
      (values
         `(,@(Durham-timed-typed-exp-time-spec dtte)
	   ,term)
	 linkspots)))

(def-meth internalize ((wlte With-links-typed-exp) freevars goal-pos)
   (let* ((link-vars
	     (<# (\\ (qv)
		    (let ((v (Vartype-var qv)))
		       (tuple v
			      (build-symbol
				 (< v) - (++ bvar-disting*)))))
		 (With-links-typed-exp-bindings wlte)))
	  (local-vars (append link-vars freevars)))
      (multi-let (((act-intern ls-a)
		   (internalize (With-links-typed-exp-body wlte)
				local-vars goal-pos))
		  ((constraints-intern ls-c)
		   (track-extra-vals :extra ((ls !()))
	              (<# (\\ (con)
			     `(,(first con)
			       ,(Vartype-var (second con))
			       ,(extra-vals (linkspots)
				   (internalize (third con)
						local-vars goal-pos)
				   :+ (!= ls (nconc linkspots *-*)))))
			  (With-links-typed-exp-constraints wlte)))))
	 (values
	    `(with-links ,link-vars ,act-intern ,constraints-intern)
	    (nconc ls-a ls-c)))))

(def-meth internalize ((lte Link-typed-exp) freevars goal-pos)
   (multi-let (((term linkspots)
		(internalize (Link-typed-exp-act lte)
			     freevars goal-pos)))
      (values
         `(link ,term ,(Link-typed-exp-linkrels lte))
	 linkspots)))

(defun goal-pos-flip (goal-pos)
			     (selq goal-pos
				(:consequent ':antecedent)
				(:antecedent ':consequent)
				(t false)))

;;; From the assumption that 'te' has a well-defined value (when
;;; first-orderified), infer what the types of the variables that
;;; occur in it must be.  'targ-type' is the type that we can infer
;;; for 'te' given the context it occurred in.  This is often less
;;; specific than (Typed-exp-type te).
;;; 'val' is a characterization of the value,
;;; either 'true', 'false', or 'def'.  'def' means "a value about which
;;; we can prove something."
;;; 'vars' are the variables that
;;; we are interested in.  
(def-op typed-exp-argtypes-infer (te targ-type val vars)
                                 (ignore val vars targ-type)
   !(Vartype))

(def-meth typed-exp-argtypes-infer ((vte Var-typed-exp) targ _ vars)
   (let ((var (Var-typed-exp-var vte)))
      (cond ((memq var vars)
	     (list (new-Vartype var targ nil)))
	    (t '()))))

(def-meth typed-exp-argtypes-infer ((appte App-typed-exp) _ val vars)
   (let ((fcnval (let ((fcn (App-typed-exp-fcn appte)))
		    (and (is-Const-typed-exp fcn)
			 (Const-typed-exp-val fcn)))))
;;;;      (dbg-save :run-loud appte fcnval)
;;;;      (breakpoint typed-exp-argtypes-infer/app
;;;;	 "Got: " fcnval)
      (cond ((and (eq val 'false)
		  (is-Predicate fcnval))
	     ;; Can't infer anything from the falsehood of a first-order
	     ;; predicate.
	     !(Vartype))
	    ((and fcnval
		  (memq val '(true false))
		  (eq (Constant-name fcnval) 'not))
	     (typed-exp-argtypes-infer
	        (car (App-typed-exp-args appte))
		prop-type*
		(cond ((eq val 'true) 'false)
		      (t 'true))
		vars))
	    (t
	     (repeat :for ((a :in (App-typed-exp-args appte))
			  (targ :in (App-typed-exp-arg-targ-types appte))
			  (res !(Vartype)))
		(!= res
		    (vartypes-conjoin
		       *-*
		       (typed-exp-argtypes-infer a targ 'def vars)))
	      :result res)))))

(def-meth typed-exp-argtypes-infer ((iste Type-test-typed-exp) _ val vars)
   (let ((arg (Type-test-typed-exp-arg iste)))
      (cond ((and (eq val 'true)
		  (is-Var-typed-exp arg))
	     (list (new-Vartype (Var-typed-exp-var arg)
				(Type-test-typed-exp-extract-which-type
				   iste)
				nil)))
	    (t
	     (typed-exp-argtypes-infer arg univ-type* 'def vars)))))

(def-meth typed-exp-argtypes-infer ((boolte Boolapp-typed-exp) _ val vars)
   (cond ((memq val '(true false))
	  (let ((arg-inferences
		   (<# (\\ (a)
			  (typed-exp-argtypes-infer a prop-type* val vars))
		       (Boolapp-typed-exp-args boolte)))
		(fcn (Boolapp-typed-exp-fcn boolte)))
	     (cond ((eq fcn (cond ((eq val 'true) 'and)
				  (t 'or)))
		    (</ vartypes-conjoin
			!(Vartype) arg-inferences))
		   (t
		    (vartypes-disjoin arg-inferences)))))
	 (t !(Vartype))))

;;; This is not that general!!  It is tailored to the needs of
;;; typed-exp-argtypes-infer.
(defun vartypes-conjoin (vtl1 vtl2)
   (let ((cl !(Vartype))
	 (vtl2c (list-copy vtl2)))
      (repeat :for ((vt1 :in vtl1))
	 (let ((var (Vartype-var vt1)))
	    (!= cl
		(cons (let ((vt2 (vartypes-lookup var vtl2c)))
			 (cond (vt2
				(!= vtl2c (dremove1q vt2 *-*))
				(multi-let (((expressible int12 undo-stack)
					       (types-intersect
						  true
						  true (Vartype-type vt1)
						  true (Vartype-type vt2)
						  !(Undo)
						  global-opt-env*
						  global-opt-env* !())))
				   (cond (expressible
					  (new-Vartype 
					     var int12 nil))
					 (t
					  (undo undo-stack !())
					  vt1))))
			       (t vt1)))
		      *-*)))
       :result (nconc cl vtl2c))))

(def-meth typed-exp-argtypes-infer ((qte Quantified-typed-exp) targ val vars)
   (cond ((eq (Quantified-typed-exp-quantifier qte)
	      'exists)
	  (typed-exp-argtypes-infer
	     (Quantified-typed-exp-body qte)
	     targ
	     val
	     (complementq
	         vars
		 (<# Vartype-var (Quantified-typed-exp-bindings qte)))))
	 (t !(Vartype))))

(defun app-typed-exp-args-internalize (ate freevars goal-pos)
   (list-internalize (App-typed-exp-args ate) freevars goal-pos))

(defun qvarify-freevars (e freevars)
   (cond ((is-Qvar e)
	  (leaf-qvarify (Qvar-sym e) true freevars))
	 ((atom e)
	  (leaf-qvarify e false freevars))
	 (t
	  (<# (\\ (y) (qvarify-freevars y freevars))
	      e))))	  

(defun leaf-qvarify (sym was-qvar freevars)
   (repeat :for ((e :in freevars))
    :result (cond ((is-Symbol sym)
		   (cond (was-qvar
			  (dbg-save :run-loud freevars)
			  (signal-problem leaf-qvarify
			     "Unexpected qvar ?" sym " treating as " sym :%
			     :novalue)))
		   sym)
		  (was-qvar (make-Qvar sym !()))
		  (t sym))
    :until (eq e sym)
    :result (make-Qvar sym !())
    :until (car-eq e sym)
    :result (make-Qvar (second e) !())))

(defun qvarbdgs-constraints (qvarbdgs env)
   (mapcan #'(lambda (v)
	        (let ((type (Vartype-type v)))
		   (let ((p (type-predify
				   type
			           (make-Qvar (Vartype-var v) '())
				   env)))
		     (cond ((matchq (is Obj ?_) p)
			    '())
			   (t
			    (list p))))))
	   qvarbdgs))

;;; Change type into predicate
(defun type-predify (n x vartypes)
   (multiple-value-let (fcn found)
		       (type-find-feature n 'predifier vartypes)
      (cond (found
	     (funcall fcn n x vartypes))
	    ((eq n univ-type*)
	     `(is Obj ,x))
	    ((is-symbolish (Type-desig n))
	     `(is ,(Type-desig n) ,x))
	    (t
	     `(is Obj ,x)))))

(class-feature-datafun predifier (alt-class opt)
   (defun (eity arg vartypes)
      (cond ((atom (Type-desig eity))
	     `(is ,(Type-desig eity) ,arg))
            (t
	     (multiple-value-let (alt-types vartypes found)
				 (type-find-feature-spread
				    eity 'nisptype::alt-types vartypes)
		(cond (found
		       (repeat :for ((component :in alt-types)
				    (res '()))
			  (!= res
			      `(,(type-predify component arg vartypes)
				,@*-*))
			:result `(or ,@(dreverse res))))
		      (t
		       (error-break alt-predifier :fatal
			  "Alt with no alt-types: " eity))))))))

(defun multi-reduce (fn inits &rest lists)
   (cond ((<v null lists)
	  (values-list inits))
	 (t
	  (<< multi-reduce fn
	      (cons (multiple-value-list
		       (apply fn (append inits (<# car lists))))
		    (<# cdr lists))))))