;-*- Mode: Common-lisp; Package: opt; Readtable: ytools; -*-
(in-package :opt)
;;;$Id: kons.lisp,v 1.3 2005/11/08 12:33:59 dvm Exp $

(depends-on %module/ ytools)

;;; This file gives us Prolog-style lists, indicated with brackets.
;;; [e1 e2 ... eN \| tl] is a list of N elements plus an optional tail.
;;; The spaces around the tail indicator '\|' are necessary.
;;; Internally the list is represented as 
;;;      (kons e1 (kons e2 ...(kons eN tl)))
;;; If the '\| tl' is omitted, that's equivalent to '\| []', where [] 
;;; is the empty list.  

;;; Note: in this file we can't assume that bracketed expressions
;;; are read as Kons-lists, so we use standard Lisp syntax to denote
;;; them.  In particular, the empty Kons-list is |[]|.

;;; The system for reading and writing kons-lists is turned on and off
;;; with 'brack-enable' and 'brack-disable'.  Declaring 'kons' is
;;; done independently, by :extending the domain kons-hack.

;;; In the long run 'kons' will be supplanted by an improved internal
;;; representation in which lists are a special datatype.  

(define (domain kons-hack)
   (:types Kons-list)

   (:objects |[]| - Kons-list)

   (:functions
       (kons a - Obj d - Kons-list)
       - Kons-list)

;;;;   (:facts
;;;;      ;; This shouldn't be necessary
;;;;      (forall (x y)
;;;;         (is Kons-list (kons x y))))
   )

(defun kons-pprint (srm k-exp)
   (let-fun ()
      (multi-let (((ok elements tail)
                   (k-exp-analyze k-exp)))
         (out (:to srm)
            (:q (ok
                 "[" (:e (repeat :for ((e :in elements :tail el))
                             (:o e (:q ((not (eq (tail el) nil))
                                        " ")))))
                      (:q ((not (eq tail '|[]|))
                           ;; If non-nil, must be a Qvar
                           " \\| " tail))
                    "]")
                (t
                 (:pp-block (:pre "(kons ")
                     (:e (pprint-linear srm (cdr k-exp) false))
                     (:suf ")"))))))
    :where
      (k-exp-analyze (k-exp)
         (repeat :for (a d
                       :collector elements)
          :while (matchq (kons ?a ?d) k-exp)
          :collect a
             (!= k-exp d)
          :result (cond ((eq k-exp '|[]|)
                         (values true elements d))
                        ((and (is-Qvaroid k-exp)
                              (null (Qvar-notes k-exp))
                              (not (yt::Qvaroid-atsign k-exp))
                              (not (yt::Qvaroid-comma k-exp)))
                         (values true elements k-exp))
                        (t
                         (values false elements k-exp)))))))
                        
(set-pprint-dispatch '(cons (eql kons))
		     #'kons-pprint
		     1)

(defun read-kons (srm _)
   (let ((elts (read-delimited-list '#\] srm)))
      (let-fun ((:def konsify (el)
                   (cond ((null el)
                          '|[]|)
                         ((eq (head el) '\|)
                          (let ((tl (tail el)))
                             (cond ((= (len tl) 1)
                                    (let ((v (head tl)))
                                       (cond ((is-Qvar v)
                                              (cond ((yt::Qvaroid-atsign v)
                                                     (qvar-cleanup v))
                                                    (t v)))
                                             ((or (atom v)
                                                  (eq (car v) 'kons))
                                              v)
                                             (t
                                              (konsify v)))))
                                   (t (konsify tl)))))
                         ((null (tail el))
                          (let ((h (head el)))
                             (cond ((is-Qvar h)
                                    (cond ((yt::Qvaroid-atsign h)
                                           (qvar-cleanup h))
                                          (t `(kons ,h |[]|))))
                                   (t
                                    `(kons ,h |[]|)))))
                         (t
                          `(kons ,(head el)
                                 ,(konsify (tail el)))))))
         (konsify elts)

       :where

          ;; Flush the '@'.  There really shouldn't be any other
          ;; distractions from the sym, but we'll let them survive.
          (:def qvar-cleanup (h)
             (yt::make-Qvaroid
                false
                (yt::Qvaroid-comma h)
                (Qvar-sym h)
                (Qvar-notes h))))))

(defun brack-enable ()
   (set-macro-character #\] (get-macro-character #\) nil))
   (set-macro-character #\[ #'read-kons))

(defun brack-disable ()
   (set-syntax-from-char '#\[ '#\a)
   (set-syntax-from-char '#\] '#\a))

(brack-enable)

;;;;(yt::def-excl-dispatch #\< (srm _)
;;;;   (unwind-protect
;;;;       (progn
;;;;          (set-macro-character '#\> (\\ (_ _) '>))
;;;;)
;;;;     (set-syntax-from-char '#\> '#\a)))
                                       
;;; Generate a difference-list notation for string 's'
(defun ssd (s)
   `(d ,(string-split s) |[]|))

;;; Split string at spaces and generate a kons list --
(defun string-split (s)
   (let-fun ((chew (s pos)
                (let ((begin-word (position-if-not #'is-whitespace s
                                                   :start pos)))
                   (cond (begin-word
                          (let ((end-word (or (position-if #'is-whitespace s
                                                           :start begin-word)
                                              (length s))))
                             `(kons ,(subseq s begin-word end-word)
                                    ,(chew s end-word))))
                         (t '|[]|)))))
      (chew s 0)))