;-*- Mode: Common-lisp; Package: opt; Readtable: ytools; -*-
(in-package :opt)
;;; $Id: more-syntax.lisp,v 1.28 2005/12/26 21:05:24 dvm Exp $

(depends-on %module/ lisplang)

(depends-on :at-run-time %opt/ syntax %nity/ tvarelim
	                 %lisplang/ typeconseq typecheck)

(eval-when (:compile-toplevel :load-toplevel :execute :slurp-toplevel)
   (export '(be lit)))

(defun dont-check (term target-type undo-stack _ env)
   (cond ((and +namespace-mode+
	       (car-eq term 'coerce))
	  (!= term (desig-syms-resolve *-* env))))
   (values
      (make-inst Unchecked-typed-exp
	 :source term
	 :type target-type
	 :env env)
      undo-stack))

(def-opt-form-handler coerce term-checker #'dont-check)
(def-opt-form-handler goal-call term-checker #'dont-check)
(def-opt-form-handler call term-checker #'dont-check)

(def-opt-form-handler quote term-checker (term target-type undo-stack context env)
   (let ((qte (make-inst Const-typed-exp
		 :val (cadr term)
		 :type (const-type (cadr term))
		 :source term
		 :ext term
		 :env env)))
      (type-trans
	 (Typed-exp-set-scope-times
	       qte scope-time* scope-time*)
	 target-type undo-stack context)))

(def-meth var-val-typed-exp ((fv (eql 'true)) _ source _ env)
   (bool-var-val-typed-exp true source env))

(def-meth var-val-typed-exp ((fv (eql 'false)) _ source _ env)
   (bool-var-val-typed-exp false source env))

(defun bool-var-val-typed-exp (bval source env)
   (let ((cte (new-Const-typed-exp bval bool-type* source env)))
      (!= (Const-typed-exp-is-literal cte) true)
      cte))

(defvar true-typed-exp*
    (bool-var-val-typed-exp 'true 'true global-opt-env*))

(def-opt-form-handler empty-list term-checker (term _ undo-stack
					       _ mvartypes)
   (let ((elt-type-desig (cadr term)))
      (let ((elt-ty
	       (cond (elt-type-desig
		      (designated-type elt-type-desig true mvartypes))
		     (t
		      (let ((elt-tvar
			       (nisptype::anon-tvar 'elt true type-type*)))
			 (dbg-out nity::binding-dbg*
			    "Creating tvar ?"
			    (tvar-type-varname elt-tvar)
			    " as element type of empty list")
			 elt-tvar)))))
        (values
	   (make-inst Const-typed-exp
	      :val '()
	      :type (make-lstype elt-ty)
	      :source term
	      :ext term
	      :env mvartypes)
	   undo-stack))))

(def-opt-form-handler not term-checker (term target-type undo-stack
				        context mvartypes)
   (match-cond term
      (:? (not ?a)
	(multi-let (((arg-te undo-stack-1)
		     (term-check a prop-type* undo-stack
			  (context-expstack-push
			     a 1
			     (context-polarity-flip context))
			  mvartypes)))
	   (values
	      (build-App-typed-exp
		 0
		 (let ((not-vt (var-lookup 'not mvartypes)))
		    (cond (not-vt
			   (var-val-typed-exp
			      (Vartype-val not-vt)
			      not-vt term context mvartypes))
			  (t
			   (signal-problem not-term-checker
			      "Not not defined: " term
			      :fatal))))
		 (list arg-te)
		 false
		 prop-type*
		 mvartypes
		 (cond ((type-acceptable
			   false
			   (Typed-exp-type arg-te)
			   bool-type*
			   '() empty-env* global-env* '())
			bool-type*)
		       (t prop-type*))
		 false term)
	      undo-stack-1)))
      (t
       (values
	  (ill-formed-typed-exp term target-type mvartypes)
	  undo-stack))))

(defun context-polarity-flip (c)
   (make-Syn-context (Syn-context-dialect-handler c)
		     (cons (tuple ':polarity (not (context-polarity c)))
			   (Syn-context-props c))))

(def-class If-typed-exp (:options (:include Typed-exp))
   prag  ;; ->, <-, -<, when, or if
   test
   iftrue
   iffalse)

(def-meth initialize :before ((tc If-typed-exp))
   (with-slots (prag test iftrue iffalse)
               tc
      (slot-defaults tc
		     flag 'if
		     subexps (list test iftrue iffalse)
		     ext (if-source prag test iftrue iffalse))))

(def-meth show-header ((ite If-typed-exp))
   (out "If:"))

(def-meth show ((ite If-typed-exp))
   (out (:e (show (If-typed-exp-test ite)))
	"if true: " :%
	(:e (show (If-typed-exp-iftrue ite)))
	"if false: " :%
	(:e (show (If-typed-exp-iffalse ite)))
	:%))

(def-meth flagsource ((ite If-typed-exp))
   (if-sexp (If-typed-exp-prag ite)
	    (flagsource (If-typed-exp-test ite))
	    (flagsource (If-typed-exp-iftrue ite))
	    (flagsource (If-typed-exp-iffalse ite))))

(defun if-sexp (prag test iftrue iffalse)
   ;;;;(out (tr ("if-sexp> " prag 1 test 1 iftrue 1 iffalse)
   (selq prag
      ((if) `(,prag ,test ,iftrue ,iffalse))
      ((-> >-  when) `(,prag ,test ,iftrue))
      (<-
       (match-cond iftrue
          (:? (<- ?q ?p)
             `(<- ,q ,(sexps-conjoin p test)))
          (t
           `(<- ,iftrue ,test))))
      (t
       (signal-problem if-sexp
	  "Unknown if style: " prag
	  (:continue "I will treat it as 'if'"))
       `(if ,test ,iftrue ,iffalse)))
   ;;;;("if-sexp< " (car out-vals*))))
)

(defun sexps-conjoin (e1 e2)
   (let-fun ()
      `(and ,@(conjuncts e1) ,@(conjuncts e2))
    :where
      (:def conjuncts (e)
         (match-cond e
              (:? (and ?@cl)
                 cl)
              (t `(,e))))))

(defvar bool-or-prop-type*
        (designated-type '(Alt Boolean Prop) true global-opt-env*))

(def-opt-form-handler if term-checker (term target-type undo-stack
				       context mvartypes)
  (if-handle term target-type undo-stack context mvartypes))

(def-opt-form-handler imply term-checker (term target-type undo-stack
				       context mvartypes)
  (if-handle term target-type undo-stack context mvartypes))

(defun if-handle (term target-type undo-stack context mvartypes)
   (match-cond term
      (:? (?_ ?ante ?conse ?else)
	(if-check 'if ante conse else term target-type
		  undo-stack context mvartypes))
      (:? (?_ ?ante ?conse)
	(if-check 'if ante conse 'true term target-type
		  undo-stack context mvartypes))
      (t
       (values (ill-formed-typed-exp term target-type mvartypes)
	       undo-stack))))

(def-opt-form-handler -> term-checker (term target-type undo-stack
				       context mvartypes)
   (match-cond term
      (:? (-> ?ante ?conse)
	(if-check '-> ante conse 'true term target-type
		  undo-stack context mvartypes))
      (t 
       (values (ill-formed-typed-exp term target-type mvartypes)
	       undo-stack))))

(def-opt-form-handler >- term-checker (term target-type undo-stack
				       context mvartypes)
   (match-cond term
      (:? (>- ?ante ?conse)
	(if-check '>- ante conse 'true term target-type
		  undo-stack context mvartypes))
      (t 
       (values (ill-formed-typed-exp term target-type mvartypes)
	       undo-stack))))

(def-opt-form-handler <- term-checker (term target-type undo-stack
				       context mvartypes)
   (match-cond term
      (:? (<- ?conse ?ante)
	(if-check '<- ante conse 'true term target-type
		  undo-stack context mvartypes))
      (t 
       (values (ill-formed-typed-exp term target-type mvartypes)
	       undo-stack))))

(defun if-check (prag ante conse else source target-type undo-stack
		 context mvartypes)
   (multi-let (((test-te undo-stack-1)
		(term-check ante bool-or-prop-type*
			    undo-stack
			    (context-expstack-push
				 ante 1 (context-polarity-flip context))
			    mvartypes)))
      (if-check-after-ante prag test-te conse else source target-type undo-stack-1
			   context mvartypes)))

(defun if-check-after-ante (prag test-te conse else source target-type
			    undo-stack-1 context mvartypes)
      (multi-let (((true-consis true-bdgs)
		   (test-typed-exp-type-narrow test-te true-type*))
		  ((false-consis false-bdgs)
		   (test-typed-exp-type-narrow test-te false-type*)))
	 (multi-let (((true-te undo-stack-2)
		      (value-constrained-type-check
			 conse 
			 true-consis true-bdgs 
			 target-type undo-stack-1
			 (context-expstack-push
			    conse 2 context)
			 mvartypes)))
	    (multi-let (((false-te undo-stack-3)
			 (value-constrained-type-check
			    else
			    false-consis false-bdgs
			    target-type undo-stack-2
			    (context-expstack-push
			       else 3 context)
			    mvartypes)))
;;;;	       (breakpoint if-check-after-ante
;;;;		  "About to make if for " source)
	       (values
		  (make-inst If-typed-exp
			:type (make-alt-type
				 (list (Typed-exp-type true-te)
				       (Typed-exp-type false-te))
				 mvartypes)
			:env mvartypes
			:test test-te
			:prag prag
			:iftrue true-te
			:iffalse false-te
			:totbugs (+ (Typed-exp-totbugs test-te)
				    (Typed-exp-totbugs true-te)
				    (Typed-exp-totbugs false-te))
			:tvars (tvars-union
				  (Typed-exp-tvars test-te)
				  (tvars-union (Typed-exp-tvars true-te)
					       (Typed-exp-tvars false-te)))
			:ext (if-ext prag test-te true-te false-te)
			:source source
			)
 		  undo-stack-3)))))

(defun if-ext (prag test-te true-te false-te)
   (cond ((eq prag '<-)
	  `(<- ,(Typed-exp-ext true-te)
	       ,(Typed-exp-ext test-te)))
	 (t
	  `(,prag ,(Typed-exp-ext test-te)
		  ,(Typed-exp-ext true-te)
		  ,@(include-if false-te (Typed-exp-ext false-te))))))

(defun test-typed-exp-type-narrow (test-te outcome-type)
   (cond ((type-acceptable false (Typed-exp-type test-te) bool-type*
			   !(Undo) global-opt-env* global-opt-env* false)
	  (typed-exp-type-narrow test-te true outcome-type))
	 (t
	  (let ((env (Typed-exp-env test-te)))
	     ;; If the :fluents requirement isn't defined yet,
	     ;; we're in builtins, and we should punt.
	     (cond ((and (try-requirement-with-name ':fluents false)
			 (env-declares-requirement env ':fluents))
		    (typed-exp-type-narrow
			;; This is really pointless if
			;; no one knows how to invert 'fl-v'
			(build-App-typed-exp
			   0
			   (let ((fl-v-cs (symbol-env-place 'fl-v env)))
			      (let ((fl-v-vt (var-lookup fl-v-cs env)))
				 (cond (fl-v-vt
					(var-val-typed-exp
					   (Vartype-val fl-v-vt)
					   fl-v-vt 'fl-v
					   (opt-syn-context 'fl-v !())
					   env))
				       (t
					(signal-problem test-typed-exp-type-narrow
					   "fl-v gone in domain extending :fluents")))))
			   (list test-te)
			   '(1)
			   (list prop-type*)
			   env
			   bool-type*
			   false false)
			true outcome-type))
		   (t
		    (values true '())))))))

(defun if-source (prag test-te true-te false-te)
   (let ((test-source (Typed-exp-source test-te))
	 (true-source (Typed-exp-source true-te))
	 (false-source (and false-te (Typed-exp-source false-te))))
      (cond ((eq prag '<-)
	     `(<- ,true-source ,test-source))
	    (t
	     `(,prag ,test-source ,true-source
		     ,@(include-if (and false-source (memq prag '(if when)))
				   false-source))))))

(defun value-constrained-type-check (term consistent local-bdgs target-type
				     undo-stack context mvartypes)
   (cond (consistent
	  (let ((initial-scope-time scope-time*)
		(local-env
		   (env-bindings-append true local-bdgs mvartypes)))
	     (!= scope-time* (+ *-* 1))
	     (multi-let (((te undo-stack-1)
			  (term-check term target-type
				      undo-stack context local-env)))
		(multi-let (((clean-te-type _ undo-stack-2)
			     (tvar-elim
				(Typed-exp-type te)
				false (list false 'maximize)
				initial-scope-time undo-stack-1 mvartypes)))
		   ;; None of the type inferences are permanent,
		   ;; except for the upper bound on the type
		   (undo undo-stack-2 undo-stack)
		   (cond (clean-te-type
			  (!=? (Typed-exp-type te)
			       clean-te-type
			       undo-stack))
			 (t
			  (note-bugs
			     te
			     (list (make-Defective-exp
				      :target te
				      :observation
					 (\\ (target srm)
					    (out (:to srm)
					      "Ungeneralizable type "
					      (:pp-nl :linear)
					      (Typed-exp-type te) 1
					      (:pp-nl :linear)
					      " for " target))
				      :context context)))))
		   (values te undo-stack)))))
	 (t
	  (let ((te (make-inst Unchecked-typed-exp
			         :env mvartypes
				 :source term
				 :type target-type))) 
	     (values
		(note-bugs
		   te
		   (list (make-Defective-exp
			    :target te
			    :observation
			       (\\ (target srm)
				  (out (:to srm)
				     "Unreachable code; 'if' test cannot "
				     "have value required to reach "
				     (:pp-nl :linear)
				     target))
			    :context context)))
		undo-stack)))))

;;; (iff e1 e2) allows prags <- and -> to appear as follows:
;;; An arrow pointing to one of the e's indicates whether it should
;;; appear to the left or the right
;;; (iff -> e1 ...) means that the e1-concluder should be 
;;;     (-> e2 e1)
;;; (iff e1 <- ...) means it should be (<- e1 e2)
;;; Similarly for e2: (iff e1 -> e2) or (iff e1 e2 <-).
;;; (iff e1 <- -> e2) means (and (<- e1 e2) (-> e1 e2))
;;; (iff e1 <- e2 <-) means (and (<- e1 e2) (<- e2 e1)).
;;; If prags omitted, they default to '<-'.

;;; Not necessary if iffs are always expanded to conjunctsion of ifs --
;;;;(def-class Iff-typed-exp (:options (:include Typed-exp))
;;;;   prop1 
;;;;   prop2
;;;;   prag-if 
;;;;   prag-only-if)

(def-opt-form-handler iff term-checker (iff-exp targ-type undo-stack
					context env)
   (let-fun ()
      (match-cond iff-exp
	 (:? (iff ?(:& -> ?prag-if) ?e1
		  ?@e2-stuff)
	    (e2-stuff-parse e2-stuff e1 prag-if 2 `(-> ,e1) `(:seg 1 2)))
	 (:? (iff ?e1 ?(:& <- ?prag-if)
		  ?@e2-stuff)
	    (e2-stuff-parse e2-stuff e1 prag-if 2 `(,e1 <-) `(:seg 1 2)))
	 (:? (iff ?e1 ?@e2-stuff)
	    (e2-stuff-parse e2-stuff e1 '<- 1 e1 1))
	 (t
	  (values (ill-formed-typed-exp iff-exp targ-type env)
		  undo-stack)))
    :where
       (:def e2-stuff-parse (e2-stuff e1 prag-if e2-offset e1-source e1-rel)
	  (let-fun ()
	     (match-cond e2-stuff
		(:? (?(:& -> ?prag-only-if) ?e2)
		   (assemble e2 prag-only-if
			     `(-> ,e2) `(:seg ,e2-offset ,(+ e2-offset 1))))
		(:? (?e2 ?(:& <- ?prag-only-if))
		   (assemble e2 prag-only-if
			     `(<- ,e2) `(:seg ,e2-offset ,(+ e2-offset 1))))
		(:? (?e2)
		   (assemble e2 '<- e2 e2-offset))
		(t
		 (values (ill-formed-typed-exp iff-exp targ-type env)
			 undo-stack)))
	   :where

	      (:def assemble (e2 prag-only-if e2-source e2-rel)
		 (track-extra-vals :extra-vars ((ustack undo-stack))
		    (typed-exps-conjoin 
			 (list (extra-vals 
				  (if-check
				       prag-if e2 e1 'true e1-source
				       targ-type undo-stack
				       (context-expstack-push
					  e1-source e1-rel context)
				       env)
				  :+ ustack)
			       (extra-vals 
				  (if-check 
				       prag-only-if e1 e2 'true e2-source
				       targ-type ustack
				       (context-expstack-push
					  e2-source e2-rel context)
				       env)
				  :+ ustack))
			 env)))))))

(def-class Boolapp-typed-exp (:options (:include Typed-exp))
   fcn ;; 'and' or 'or'
   args
   type-conseqs
     ;; -- tuple ((could-finish finish-bdgs) (could-stop stop-bdgs))
     ;; "could-finish" means it could return its "normal" value,
     ;; true for 'and', false for 'or'.  "could-stop" means it could
     ;; return its "abnormal" value.
   (:handler
       (initialize :before ((bte Boolapp-typed-exp))
          (with-slots (fcn args)
	              bte
	     (slot-defaults bte
			    flag 'boolean-app
			    subexps args
			    ext `(,fcn
				  ,@(<# Typed-exp-ext args)))))))

(def-meth show-header ((ate Boolapp-typed-exp))
  (out (Boolapp-typed-exp-fcn ate) ": "))

(def-meth show ((ate Boolapp-typed-exp))
  (out "<" :%
       (:e (repeat :for ((arg :in (Boolapp-typed-exp-args ate))
		       (i = 1 :by 1))
	     (:o i 1) (show arg)))
       ">" :%))

(def-meth flagsource ((ate Boolapp-typed-exp))
   `(,(Boolapp-typed-exp-fcn ate)
     ,@(<# flagsource (Boolapp-typed-exp-args ate))))

(defvar vacuously-true-boolapp*
        (make-inst Boolapp-typed-exp
	   :fcn 'and
	   :args !()
	   :source '(and)
	   :type-conseqs (tuple (tuple true !()) (tuple false !()))
	   :type bool-type*
	   :env global-opt-env*))

(defvar vacuously-false-boolapp*
        (make-inst Boolapp-typed-exp
	   :fcn 'or
	   :args !()
	   :source '(or)
	   :type-conseqs (tuple (tuple true !()) (tuple false !()))
	   :type bool-type*
	   :env global-opt-env*))

(defun typed-exps-conjoin (tel env)
   (cond ((= (len tel) 1) (car tel))
	 (t
	  (make-inst Boolapp-typed-exp
	     :fcn 'and
	     :args tel
	     :source `(and ,@(<# Typed-exp-source tel))
	     :type-conseqs (tuple (tuple true !())  
				  (tuple (not (null tel)) !()))
	     :type bool-type*
	     :env env))))

(def-opt-form-handler and term-checker (term _ undo-stack context
					env)
   (boole-form-handler 'and (cdr term) undo-stack context env))

(def-opt-form-handler or term-checker (term _ undo-stack context
					env)
   (boole-form-handler 'or (cdr term) undo-stack context env))

(defun boole-form-handler (fcn args undo-stack term-context env)
   (multi-let (((finish-case stop-case)
		(cond ((eq fcn 'and) (values "true" "false"))
		      (t (values "false" "true"))))
	       (initial-scope-time scope-time*)
	       (and-vs-or (eq fcn 'and)))
      ;; Continuing (and finishing) vs stopping:
      ;; If 'and', continue means true, stop means false;
      ;;    trivial means necessarily true, stopping early means
      ;;    necessarily false.
      ;; If 'or', switch "true" and "false" in the previous paragraph.
      (!= scope-time* (+ *-* 1))
      (repeat :for ((pl args :then (cdr pl))
		   p
		   (context (context-expstack-push fcn 0 term-context))
		   (env-with-conseqs env)
		   pte (ustack undo-stack)
		   true-consis true-bdgs false-consis false-bdgs
		   (can-continue true) must-stop-early
		   (must-finish true) trivial-arg
		   continue-bdgs stop-bdgs
		   ;; 'stop-alts' is a list of all ways the form
		   ;; can stop, i.e., a list of 'stop-bdgs' vals.
		   (stop-alts '())
		   ;; 'all-continue-bdgs' is the collection of
		   ;; all the continue-bdgs, appended together
		   ;; in reverse order.
		   (all-continue-bdgs '())
		   (arg-tel '())
		   (totbugs 0))
       :until (null pl)
	 (!= p (car pl))
	 (!= context (context-expstack-advance context))
	 (!= < pte ustack > (term-check p prop-type* ustack
					context env-with-conseqs))
	 (!= totbugs (+ *-* (Typed-exp-totbugs pte)))
	 (!= arg-tel (cons pte *-*))
;;;;	 (dbg-save pte)
	 (!= < true-consis true-bdgs >
	     (test-typed-exp-type-narrow pte true-type*))
	 (!= < false-consis false-bdgs >
	     (test-typed-exp-type-narrow pte false-type*))
	 (cond ((and (not true-consis) (not false-consis))
		(dbg-save :run-loud pte true-bdgs false-bdgs)
		(signal-problem boole-form-handler
		   "Not consistently true or false: " pte)))

	 (!= < can-continue trivial-arg continue-bdgs stop-bdgs >
	     (cond (and-vs-or
		    (values true-consis (not false-consis)
			    true-bdgs false-bdgs))
		   (t
		    (values false-consis (not true-consis)
			    false-bdgs true-bdgs))))
	 (!= must-finish (and *-* trivial-arg))
	 (cond (trivial-arg
;;;;		(out "Trivial: " p :% pte :%)
		(note-bugs pte (list (make-Defective-exp
					:target pte
					:observation
					    (\\ (targ srm)
					       (out (:to srm)
						  "Condition cannot be "
						  (:a stop-case) ": "
						  (:pp-nl :linear) targ))
					:context context)))
		(!= totbugs (+ *-* 1))))
       :while can-continue
	 (!= env-with-conseqs
	     (env-bindings-append true continue-bdgs *-*))
	 (!= all-continue-bdgs
	     (append (bdgs-tvar-elim continue-bdgs initial-scope-time ustack)
		     *-*))
	 (!= stop-alts (cons (bdgs-tvar-elim stop-bdgs initial-scope-time ustack)
			     *-*))
       :result (let ((bugs '())
		     finish-bdgs no-finish-bdgs
		     (ans-tel `(,@(reverse arg-tel)
				,@(<# (\\ (unreachable)
					 (make-inst Unchecked-typed-exp
					    :source unreachable
					    :flag 'unreachable
					    :bugs (list (simple-ill-formed-exp
							   "Unreachable"
							   unreachable))
					    :totbugs 1))
				      (cdr pl)))))
;;;;		 (cond ((and (not can-continue) (not (null (cdr pl))))
;;;;			(dbg-save pl arg-tel)
;;;;			(breakpoint boole-form-handler
;;;;			   "Stopped before: " (cdr pl)
;;;;			   :% arg-tel)))
		 (!= must-stop-early (not can-continue))
		 (!= all-continue-bdgs (vartypes-rem-duplicates *-*))
		 (!= finish-bdgs all-continue-bdgs)
		 (!= no-finish-bdgs
		     (vartypes-disjoin stop-alts))
		 (cond (must-stop-early
			(!= bugs
			    (cons (make-Defective-exp
				     :target false
				     :observation
					(\\ (targ srm)
					   (out (:to srm)
					      "Necessarily "
					      (:a stop-case) ": "
					      (:pp-nl :linear) targ))
				     :context term-context)
				  *-*))
			(!= totbugs (+ *-* (len (cdr pl)) 1))))
		 (cond (must-finish
			(!= bugs
			    (cons (make-Defective-exp
				     :target false
				     :observation
					(\\ (targ srm)
					   (out (:to srm)
					      "Necessarily "
					      (:a finish-case) ": "
					      (:pp-nl :linear) targ))
				     :context term-context)
				  *-*))
			(!= totbugs (+ *-* 1))))
		 (values
 		    (make-inst Boolapp-typed-exp
		       :fcn fcn
		       :args ans-tel
		       :source `(,fcn ,@args)
		       :type-conseqs (tuple (tuple (not must-stop-early)
						   finish-bdgs)
					    (tuple (not must-finish)
						   no-finish-bdgs))
		       :type bool-type*
		       :env env
		       :bugs bugs
		       :totbugs totbugs)
		    undo-stack)))))

(def-meth type-infer-conseqs ((bte Boolapp-typed-exp) ty)
   (let ((b (type-as-boolean ty empty-env*)))
      (cond (b
	     (let ((fcn (Boolapp-typed-exp-fcn bte))
		   (tctup (Boolapp-typed-exp-type-conseqs bte)))
		(let ((consis-bdgs (cond ((eq (eq b 'true)
					      (eq fcn 'and))
					  (car tctup))
					 (t
					  (cadr tctup)))))
		   (cond ((car consis-bdgs)
			  (values true
				  (<# (\\ (vt)
					 (vt->tyic vt (Typed-exp-env bte)))
				      (cadr consis-bdgs))))
			 (t
			  (values false nil))))))
	    (t
	     (values true '())))))

;;; Returns
;;; < list of bindings,
;;;   list of lists of flags found in each fun spec,
;;;   list of lists of ill-formed-expressions found in each,
;;;   list of ill-formed-expressions associated with the whole function list >
(defun function-list-parse (flist expect-flags 
			    restype res-type-wrapper vartypes)
   (multi-let (((funrecs trailing-ifes _ _)
		(fundefs-types flist expect-flags ':no-body res-type-wrapper
			       false restype
			       (empty-undo-stack)
			       (opt-syn-context flist !())
			       vartypes)))
     (repeat :for ((fdr :in funrecs)
		    :collectors vtl flag ill-formed-exps
		                fdr-ifes)
       :collect (:into vtl 
		       (new-Vartype
			  (Fundef-rec-name fdr)
			  (Fundef-rec-funtype fdr)
			  false))
	 (!= fdr-ifes (Fundef-rec-ill-formed-subexps fdr))
       :collect (:into flag
		       (Fundef-rec-special-flags fdr))
	 (cond ((not (eq (Fundef-rec-defn fdr) ':absent))
		(!= fdr-ifes
		    (cons (make-Defective-exp
			     :target fdr
			     :observation
				(\\ (_ srm)
				   (out (:to srm)
					"Function body not allowed"
					" in function list: "
					(Fundef-rec-defn fdr))))
			  *-*))))
       :collect (:into ill-formed-exps fdr-ifes)
       :result (values vtl flag ill-formed-exps trailing-ifes))))

;;; In Opt tvars-if-unspec is always false, but for Nisp4 we are going
;;; to need the functionality.
(defun unspec-low-restype (tvars-if-unspec rec)
   (let ((res-tvar
	    (cond (tvars-if-unspec
		   (nisptype::anon-tvar 'res false type-type*))
		  (t false))))
      (cond (res-tvar
	     (dbg-out nity::binding-dbg*
		"Creating tvar ?"
		(tvar-type-varname res-tvar)
		" as result type of "
		(Fundef-rec-name rec) :%)))
      (let ((low-restype
	       (or res-tvar univ-type*)))
	 (!= (Fundef-rec-low-result rec)
	     low-restype)
	 (values low-restype false (cond (res-tvar (list res-tvar))
					 (t '()))))))

(defun arith-opt-checker (exp target-type undo-stack
			  context mvartypes)
   (let ((fcn (car exp))
	 (args (cdr exp)))
      (cond ((eq fcn '<=)
	     (!= fcn '=<)))
      (let ((con (context-expstack-push fcn 0 context)))
	 ;; This should be pro-forma, because only standard
	 ;; functions (+, -, >, ...) use arith-opt-checker
	 (multi-let (((fte undo-stack-1)
		      (term-check fcn univ-type* undo-stack
				  con mvartypes)))
	   ;; ... unless we're in a no-numbers domain
	   (let ((is-fun (is-funtype (Typed-exp-type fte))))
	    (let ((pred (and is-fun
			     (type-acceptable
				false
				(nisptype::fun-result-type
				   (Typed-exp-type fte) (Typed-exp-env fte))
				boolean-type*
				undo-stack-1
				(Typed-exp-env fte) empty-env* !())))
		  (many-args
		     (or (not is-fun)
			 (let ((alspec (type-find-feature
					  (Typed-exp-type fte)
					  'nisptype::arglist
					  (Typed-exp-env fte))))
			    (cond (alspec
				   (not (null (nisptype::Arglistspec-rest
						  alspec))))
				  (t
				   (signal-problem arith-opt-checker
				      "Can't find arglist spec for "
				      :% fte)))))))
	       (let-fun ()
		  (multi-let (((good-targ undo-stack-2)
			       (target-num-type)))
		     (repeat :for ((a :in args)
				   (con con)
				   ate
				   (ustack undo-stack-2)
				   :collectors argtel)
			(!= con (context-expstack-advance con))
			(!= < ate ustack >
			    (term-check a good-targ ustack
					con mvartypes))
;;;;			(out "Term " a " checks to " ate :%)
		      :collect ate
		      :result
			 (repeat :for ((narrow-type
					  :in
					  (list ratio-type* int-type*
						rational-type*
						float-type* num-type*)))
			  :result
			     (progn (dbg-save argtel)
				    (out "Noting it!" :%)
				    (note-defective-exp
				      ((_) "Failed to verify that all of "
					   :% argtel :% " are numerical")
				      :context context
				      :place arith-opt-checker
				      "Failed to verify that all of"
				      :% argtel :% " are numerical"))
;;;;			    (out (:to *query-io*)
;;;;			      "Trying " narrow-type :%)
			  :until (all-acceptable-as argtel narrow-type)
			  :result (let ((new-arg-tel
					   (repeat :for ((a :in argtel))
					    :collect
					       (cond ((is-Const-typed-exp a)
						      (const-typed-exp-coerce
							 a narrow-type))
						     (t a)))))
				     (let ((res-te 
					      (build-res-typed-exp
						 0 fte new-arg-tel false
						 (<# (\\ (_) narrow-type)
						     new-arg-tel)
						 exp
						 !() mvartypes
						 (cond (pred
							boolean-type*)
						       (t
							narrow-type)))))
					(check-for-bugs
					   res-te argtel ustack))))))

		:where

 (:def all-acceptable-as (argtel narrow-type)
    (repeat :for ((ate :in argtel)
		  (ustack (empty-undo-stack)))
     :result true
     :within
       (multi-let (((accep ustack1)
		    (type-acceptable true (Typed-exp-type ate) narrow-type
				     ustack empty-env* empty-env* !())))
	  (cond ((not accep)
		 (cond ((eq narrow-type float-type*)
			(!= < accep ustack1 >
			    (type-acceptable
				true (Typed-exp-type ate) rational-type*
				ustack empty-env* empty-env* !()))))))
          (:continue
	   :while accep
	      (!= ustack ustack1)
	   :result (progn (undo ustack1 '())
			  false)))))

 (:def target-num-type ()
    (cond (pred
	   (values num-type* undo-stack-1))
	  (t
	   (multi-let (((want-num undo-stack-2)
			(try-accept target-type num-type*
				    undo-stack
				    empty-env* empty-env*
				    !())))
	      (cond (want-num
		     (values target-type undo-stack-2))
		    (t
		     (values num-type*
			     (undo undo-stack-2
				   undo-stack-1))))))))

 (:def check-for-bugs (res-te argtel ustack)
    (cond ((and (not many-args)
		(not (= (len argtel)
			2)))
	   (note-bugs res-te
	      (list (make-Defective-exp
		       :target res-te
		       :observation
			  (\\ (te srm)
			     (out (:to srm)
				"Wrong number of arguments: "
				te))
		       :context context)))))
    (values
       (verify-requirement ':numbers mvartypes res-te)
       ustack)))))))))

(def-opt-form-handler + term-checker #'arith-opt-checker)
(def-opt-form-handler - term-checker #'arith-opt-checker)
(def-opt-form-handler * term-checker #'arith-opt-checker)
(def-opt-form-handler / term-checker #'arith-opt-checker)
(def-opt-form-handler > term-checker #'arith-opt-checker)
(def-opt-form-handler < term-checker #'arith-opt-checker)
(def-opt-form-handler =< term-checker #'arith-opt-checker)
(def-opt-form-handler <= term-checker #'arith-opt-checker)
(def-opt-form-handler >= term-checker #'arith-opt-checker)
(def-opt-form-handler =~ term-checker #'arith-opt-checker)
(def-opt-form-handler /=~ term-checker #'arith-opt-checker)
(def-opt-form-handler min term-checker #'arith-opt-checker)
(def-opt-form-handler max term-checker #'arith-opt-checker)

(def-opt-form-handler = term-checker (exp targ-type undo-stack context mvartypes)
;;;;   (trace-around =-check
;;;;      (:> "(=-check: " exp ")")
   (cond ((and pddl2.1-compatible*
	       (= (len exp) 3)
	       (try-requirement-with-name ':fluents false)
	       (env-declares-requirement mvartypes ':fluents))
	  (control-nest
	     (let ((=-bdg (var-lookup '= mvartypes)))
	        (cond (=-bdg
		       (let ((=-const (Vartype-val =-bdg)))
			  :start-undo))
		      (t
		       (signal-problem =-term-checker
			  "environment declares requirement :fluents, "
			  "but has no binding for '=': " mvartypes))))
	   :start-undo
	     (multi-let (((arg1 undo-stack-1)
			  (term-check (cadr exp) univ-type*
				      undo-stack context mvartypes)))
		:next-undo)
	   :next-undo
	     (multi-let (((arg2 undo-stack-2)
			  (term-check (caddr exp) univ-type*
				      undo-stack-1 context mvartypes)))
		:next-undo)
	   :next-undo
	     (multi-let (((one-is-flu undo-stack-3)
			  (try-accept (Typed-exp-type arg1) fluent-type*
				      undo-stack-2 mvartypes
				      global-opt-env* !())))
		:next-undo)
	   :next-undo
	     (multi-let (((two-is-flu undo-stack-4)
			  (try-accept (Typed-exp-type arg2) fluent-type*
				      undo-stack-3 mvartypes global-opt-env*
				      !())))
		(let* ((arg1-te (cond (one-is-flu
				       (fl-v-typed-exp arg1 mvartypes))
				      (t arg1)))
		       (arg2-te (cond (two-is-flu
				       (fl-v-typed-exp arg2 mvartypes))
				      (t arg2)))
		       (arg1-type (Typed-exp-type arg1-te))
		       (arg2-type (Typed-exp-type arg2-te)))
		   (multi-let (((argtype undo-stack-5)
				(types-common-supertype
				    true (list arg1-type arg2-type)
				    undo-stack-4 mvartypes)))
		      :after-undo)))
	   :after-undo
	     (let* ((=-arg-types (args->spec (list argtype argtype)))
		    (fte (build-App-typed-exp
			     1 (make-inst Const-typed-exp
				  :val =-const
				  :source '=
				  :ext '=
				  :type (Vartype-type =-bdg)
				  :env mvartypes)
			     (list (make-inst Type-typed-exp
				       :type type-type*
				       :source (Type-desig argtype)
				       :env mvartypes
				       :which argtype
				       :tvars !()))
			     (list 1 2)
			     (list type-type*)
			     mvartypes
			     (make-funtype 0
				bool-type*
				(make-tup-type
				    'nity::Row =-arg-types
				    false mvartypes)
				(args->spec (list bool-type*))
				=-arg-types false mvartypes)
			     true ;; -- hidden
			     exp)))
	       (values (simple-app-typed-exp
			  fte
			  (list arg1-te arg2-te)
			  (list arg1-type arg2-type)
			  exp targ-type mvartypes)
		       undo-stack-5))))
	 (t
	  (functional-term-check exp targ-type undo-stack context mvartypes)))
;;;;      (:< (val &rest _) "=-check: " val))
   )

(defun fl-v-typed-exp (te mvartypes)
   (let ((te-type (Typed-exp-type te)))
      (simple-app-typed-exp
	 (simple-var-typed-exp 'fl-v mvartypes)
	 (list te)
	 (list te-type)
	 `(fl-v ,(Typed-exp-source te))
	 (type-must-find-feature (Typed-exp-type te) 'basetype mvartypes)
	 mvartypes)))

(def-opt-form-handler declare term-checker (exp targ-type undo-stack context mvartypes)
   (cond ((= (len exp) 3)
	  (multi-let (((constraining bdgs defexps)
		       (qvar-list-parse (cadr exp) univ-type* mvartypes)))
	     (letrec ()
		(cond (constraining
		       (repeat :for ((vt :in bdgs)
				     (ustack undo-stack)
				     okay var oldtype
				     :collector type-bugs)
			  (!= var (Vartype-var vt))
			  (!= oldtype (var-lookup var mvartypes))
			  (cond (oldtype
				 (!= < okay ustack >
				     (try-accept (Vartype-type oldtype)
						 (Vartype-type vt)
						 ustack
						 mvartypes mvartypes !()))
				 (cond ((not okay)
					(one-collect type-bugs
						     (make-type-bug
						        var
							(Vartype-type vt))))))
				(t
				 (one-collect
				     type-bugs
				     (make-Defective-exp
					:observation
					   (\\ (_ srm)
					      (out (:to srm)
						 "Unbound variable: " var))))))
			:result (check-and-note-bugs type-bugs ustack)))
		      (t
		       (multi-let (((te undo-stack-2)
				    (check-and-note-bugs !() undo-stack)))
			  (note-bugs te
				     (list (make-Defective-exp
					      :target te
					      :observation
					         (\\ (_ srm)
						    (out (:to srm)
						       "Variables are 'unconstraining'"
						       " in declarations")))))
			  (values te undo-stack-2))))
	      :where
	         (check-and-note-bugs (type-bugs undo-stack)
		    (multi-let (((te undo-stack-2)
				 (term-check (caddr exp)
					     targ-type
					     undo-stack
					     (context-expstack-push
						(caddr exp) 2 context)
					     (env-bindings-append
						true bdgs mvartypes))))
		       (!= (Typed-exp-source te)
			   exp)
		       (note-bugs te defexps)
		       (repeat :for ((tb :in type-bugs))
			  (!= (Defective-exp-target tb) te))
		       (note-bugs te type-bugs)
		       (values te undo-stack-2)))

		 (make-type-bug (var goal-type)
		    (make-Defective-exp
				 :observation
				    (\\ (_ srm)
				       (out (:to srm)
					  "Variable " var
					  " can't be shown to be of type "
					  :% goal-type))
				 :context context)))))
	 (t
	  (values (ill-formed-typed-exp exp targ-type mvartypes)
		  undo-stack))))

(def-opt-form-handler be term-checker (exp targ-type undo-stack context mvartypes)
   (cond ((= (len exp) 3)
	  (let ((decl-type (designated-type (cadr exp) true mvartypes)))
	     (multi-let (((te undo-stack-1)
			  (term-check (caddr exp)
				      univ-type*
				      undo-stack
				      (context-expstack-push
				         (caddr exp) 2 context)
				      mvartypes)))
		(multi-let (((okay undo-stack-2)
			     (try-accept (Typed-exp-type te)
					 decl-type
					 undo-stack-1
					 mvartypes mvartypes !())))
		   (cond ((not okay)
			  (note-bugs te
			     (list (make-Defective-exp
				      :target te
				      :observation
				         (\\ (_ srm)
					    (out (:to srm)
					       "Expression " te
					       :% " can't be shown to have type"
					       :% decl-type)))))))
		   (!= (Typed-exp-type te) decl-type)
		   (values te undo-stack-2)))))
	 (t
	  (values (ill-formed-typed-exp exp targ-type mvartypes)
		  undo-stack))))

(def-opt-form-handler lit term-checker (exp targ-type undo-stack context mvartypes)
   (match-cond exp
      (:? (lit ?v)
	 (repeat 
          :within
	    (multi-let (((te ustack)
			 (term-check v targ-type undo-stack
				     (context-expstack-push v 1 context)
				     mvartypes)))
	       (:continue
		:until (and (is-Const-typed-exp te)
			    (Const-typed-exp-is-literal te))
		:result (values te ustack)
		  (!= ustack (undo *-* undo-stack))
		  (let ((alt-v (type-find-feature targ-type 'initexp mvartypes)))
		     (let ((user-v
			      (note-defective-exp 
				 ((_) "Illegal literal: " v)
				 :target exp
				 :context context
				 "Illegal literal: " v
				 (:prompt-for
				    (out-to-string
				       "A constant of type " targ-type " (default: "
				       alt-v ")")
				    alt-v))))
			(!= v user-v)))))))
      (t
       (values (ill-formed-typed-exp exp targ-type mvartypes)
	       undo-stack))))

(defun const-typed-exp-coerce (te new-type)
   (let ((cltype (type-find-feature
		     new-type 'lisplang::cltype global-opt-env*)))
      (cond (cltype
	     (let ((val (Const-typed-exp-val te)))
		(let ((realval
			 (match-cond val
			    (:? (quote ?v) v)
			    (:? empty-list !())
			    (:? true true)
			    (:? false false))))
		   (let ((new-val (coerce realval cltype)))
		      (make-inst Const-typed-exp
			 :val new-val
			 :type new-type
			 :ext `(quote ,new-val)
			 :source (Typed-exp-source te) 
			 :env (Typed-exp-env te))))))
	    (t
	     (signal-problem const-typed-exp-coerce
		"No CL type for " new-type)))))

(defun impossible-val-bug (te val c)
   (make-Defective-exp
      :target te
      :observation
	 (\\ (targ srm)
	    (out (:to srm)
	       "Expression cannot have value " val ": "
	       (:pp-nl :linear) targ))
      :context c))

(defun vartypes-rem-duplicates (vtl)
   (letrec ((remove-em (vtl already-seen)
	       (cond ((null vtl) '())
		     ((memq (Vartype-var (car vtl)) already-seen)
		      (remove-em (cdr vtl) already-seen))
		     (t
		      (cons (car vtl)
			    (remove-em (cdr vtl)
				       (cons (Vartype-var (car vtl))
					     already-seen)))))))
      (remove-em vtl '())))