fun nextlex nl = 
   let fun
           split_after_run (x::y::l)
            = if x<y then let val (run,rem) = split_after_run (y::l)
			  in (x::run, rem)
			  end
		     else ([x], y::l)
	 | split_after_run [x] = ([x], [])
	 | split_after_run [] = ([],[])

   and
           split_at_smallest_greater r l
	     = let fun search [] = raise Fail("Fumble")
		     | search (n::l) 
			   = if n>r then ([], n, l)
				    else let val (lfront, sg, lrem) 
						   = search l
					 in (n::lfront, sg, lrem) end
	       in search l end

   and list_to_string (l: int list)
	  = case l of [] => "[]"
		    | _ => let val n = length l
			       val front = List.take(l, n-1);
			       val [back] = List.drop(l, n-1)
			   in
			       "[" ^ (foldr (fn (i, s) =>  (Int.toString i) ^ ", " ^ s)
					    (Int.toString back)
					    front)
			       ^ "]"
			   end
   and
       show(front, sg, back, r, rs)
         = print (list_to_string front ^ ", " ^  Int.toString sg
		  ^ ", " ^ list_to_string back
		  ^ ", " ^ Int.toString r
		  ^ ", " ^ list_to_string rs)
   in
     let val (run, rem) = split_after_run (rev nl)
     in 
	case rem of 
              [] => NONE
            | r::rs => let val (front, sg, back) 
			          = split_at_smallest_greater r run
			   val (h::t) = rem
		       in
                          SOME (rev rs @ [sg] @ front @ [r] @ back)
		       end
     end
   end;

fun all_perms l =
   l :: (let val next = nextlex l
	 in case next of NONE => []
		       | SOME p => all_perms p
	 end);
