;-*- Mode: Common-lisp; Package: opt; Readtable: ytools; -*-
(in-package :opt)
;;; $Id: parsers.lisp,v 1.41 2006/01/24 13:33:26 dvm Exp $

(depends-on %module/ ytools)

(depends-on %module/ nity)

(depends-on %langutils/ defectexp synutils namespace)

(depends-on :at-run-time %opt/ types basics syntax more-syntax
			       process action axiom
                         %lisplang/ funcheck typecheck bvarparse flagsource)

(eval-when (:compile-toplevel :load-toplevel :execute :slurp-toplevel)
   (import '(nity::arglistspec-type-ify))
   (export '(recover-type problem-metric-parse)))

; The way this works: domain-parse returns a (define (domain ...) ...) 
; expression 
; with syntactic errors annotated.  I use the morpheme "flg" ("flagged 
; subexps") to mean such an annotated expression.
; domain-parse has as side effect adding all
; the definitions it can decipher to the relevant tables (just as a
; production version would).
; The components are parsed in an order such that the side effects
; necessary to understand component X occur before component X is parsed.
; Hence the parse functions need only to be passed the domain in order
; to work; all the required information is already stored there.

;;; All the requirement-defining domains in requirements.opt use this
;;; namespace, and all domains import from it.
(defvar requirement-namespace*
        (place-Namespace-with-exports
	   (cond (web-mode*
		  (merge-uris
	             (make-instance 'uri
			:fragment "requirements")
		     opt-home-web-site*))
		 (t 'requirements))
	   false
	   +all-symbols+))

(namespace-add-import
   requirement-namespace*
   (new-Namespace-import true opt-namespace* "" +all-symbols+))

(defun requirement-parse (req builtins implications flg-junk)
   (multiple-value-let (flg-builtins built-doms)
		       (builtins-parse builtins)
      (multiple-value-bind (flg-implics implied-reqs)
	                   (implications-parse implications)
         (setf (Requirement-builtins req) built-doms)
         (setf (Requirement-implies req)
               implied-reqs)
         `(define (requirement ,(Requirement-name req))
		  ,flg-builtins
		  ,flg-implics
		  ,@flg-junk))))

(defun domain-parse (&key dom namespaces parents defrequire require
		     types xtypes typefuns typecons objects
		     domain-vars
		     predicates derived functions xfunctions facts
		     axioms causations methods export
		     flg-junk)
   (domain-reset dom) ; destroy *all* rule groups, among other things
;;;;   (out "Entering domain-parse, parents = "
;;;;	(langutils::Namespace-parents requirement-namespace*) :%)
   (multi-let (((namespace ns-flg)
		(namespace-parse namespaces dom defrequire)))
;;;;      (out "After namespace-parse, parents = "
;;;;	(langutils::Namespace-parents requirement-namespace*) :%)
      (multiple-value-bind (flg-parents pdl imports)
			   (parents-parse parents)
	 (cond ((-- +namespace-mode+)
		(repeat :for ((imp :in imports))
		   (cond ((not (eq (Namespace-import-exporter imp)
				   namespace))
			  (namespace-add-import namespace imp))))))
;;;;	 (out "New domain " dom " has namespace " namespace
;;;;	      :% " with parents " (Namespace-parents namespace) :%)
	 (multi-let (((flg-req reql import-from)
		      (require-parse require)))
	    (setf (Domain-parents dom) pdl)
	    (setf (Domain-requirements dom) reql)
	    (namespaces-link namespace import-from)
	    (reset-ancestors dom)
	    (!= (Domain-generation dom)
		(next-generation))
	    ; The order of var evals is significant, because earlier ones have
	    ; side effects the later ones depend on:
	    (let ((flg-defrequire
		     (defrequire-parse defrequire dom))
		  (flg-types (mapcar #'(lambda (ty) (types-parse ty dom))
				     types))
		  (flg-xtypes (complex-types-parse xtypes dom))
		  (flg-typefuns (mapcar #'(lambda (e) (typefun-parse e dom))
					typefuns))
		  (flg-typecons (<# (\\ (c) (constructor-parse c dom))
				    typecons))
		  (flg-objects (constant-lists-parse ':objects objects dom))
		  (flg-domainvars (mapcar #'(lambda (dl)
					       (domain-vars-parse dl dom))
					  domain-vars))
		  (flg-predicates (predicates-parse predicates dom))
		  (flg-functions (functions-parse functions dom))
		  (flg-xfunctions (<# (\\ (e) (complex-function-parse e dom))
				      xfunctions))
		  (flg-derived (derived-parse derived dom))
		  (flg-causations (causations-parse causations dom))
		  (flg-facts (facts-parse facts dom
					  (own-rule-group dom)
					  `(domain ,(Domain-name dom))))
		  ;(flg-safety (safety-parse safety dom (own-rule-group dom)))
		  (flg-axioms (axioms-parse axioms dom (own-rule-group dom)))
		  (flg-methods (methods-parse methods dom
					      (own-rule-group dom)))
		  (flg-exports (exports-parse export namespace dom))
		  (dom-uri (get (Domain-name dom) 'uri))
		  )
	       (domain-mark-current dom)
	       `(define (domain ,(Domain-name dom)
				,@(include-if dom-uri (uri->string dom-uri)))
		   ,@ns-flg
		   ,@(include-if-not-null ':extends flg-parents)
		   ,@(include-if-not-null ':requirements flg-req)
		   ,@flg-exports
		   ,@flg-defrequire
		   ,@flg-types
		   ,@flg-xtypes
		   ,@flg-typefuns
		   ,@flg-typecons
		   ,@flg-objects
		   ,@flg-domainvars
		   ,@(include-if-not-null ':predicates flg-predicates)
		   ,@flg-functions
		   ,@flg-derived
		   ,@flg-xfunctions
		   ,@flg-causations
   ;;;;                ,@flg-actions
   ;;;;		,@flg-durative-actions
   ;;;;		,@flg-processes
		   ,@flg-methods
		   ,@(include-if-not-null ':facts flg-facts)
		   ;,@flg-safety
		   ,@flg-axioms
		   ,@flg-junk))))))

(defun namespace-parse (namespaces dom defrequire)
   (multi-let (((namespace ns-flg)
		(cond ((-- +namespace-mode+)
		       (cond ((shorter namespaces 2)
			      (cond ((null namespaces)
				     (values
					(cond ((null defrequire)
					       (place-Namespace-with-exports
						  (Domain-name dom)
						  false +all-symbols+))
					      (t requirement-namespace*))
					!()))
				    (t
				     (values (place-Namespace
					        (car namespaces) false false)
					     `((:namespace ,(car namespaces)))))))
			     (t
			      (note-defective-exp
				 ((dom) "More than one namespace"
					" specified in definition of"
					" domain " (Domain-name dom))
				 :target dom
				 :place namespace-parse
				 (:continue "I will ignore all but the first"))
			      (values (place-Namespace (car namespaces) false false)
				      `((:namespace
					   ,(flagexp "Too many namespaces"
						     namespaces)))))))
		      (t
		       (cond ((not (null namespaces))
			      (out (:to *error-output*)
				   "Ignoring namespace field " namespaces
				   " (not in namespace mode)"
				   :%)))
		       (values false !())))))
;;;;      (out "After checking namespaces, namespace = " namespace
;;;;	   " parents = "
;;;;	   (langutils::Namespace-parents requirement-namespace*) :%)
      (cond (namespace
	     ;; Here's where we screw up the parents of requirement-namespace*
	     ;; -- without this check
	     (cond ((and (not (eq namespace requirement-namespace*))
			 (not (eq namespace opt-namespace*)))
		    (namespace-add-import
			namespace
			(new-Namespace-import false requirement-namespace*
					      "" +all-symbols+))))
	     (!= (Domain-namespace dom) namespace)
;;;;	     (out "After setting domain namespace to = " namespace
;;;;		  " parents = "
;;;;		  (langutils::Namespace-parents requirement-namespace*) :%)
	     (let-fun ()
		(repeat :for ((udom :in universal-ancestors*))
		   (cond ((not (eq udom dom))
			  (let ((anc-ns (Domain-namespace udom)))
			     (cond (anc-ns
				    (one-more-import anc-ns)
;;;;				    (out "After one-more-import"
;;;;					 " parents = "
;;;;					 (langutils::Namespace-parents
;;;;					    requirement-namespace*) :%)
				    ))))))
;;;;		(out "After importing universal parents = "
;;;;		     (langutils::Namespace-parents requirement-namespace*) :%)
		(cond ((not (eq namespace opt-namespace*))
		       (one-more-import opt-namespace*)))
		;;;(one-more-import requirement-namespace*)

	      :where

		(:def one-more-import (ns)
;;;;		   (out "Linking exporter " ns " to " namespace :%)
		   (cond ((not ns)
			  (dbg-save :run-loud ns namespace)
			  (signal-problem namespace-parse
			     "Null namespace being imported from, to " namespace)))
		   (cond ((not (namespace-has-import
				  namespace false ns))
			  (let ((nsi (new-Namespace-import false ns "" +all-symbols+)))
			     (cond ((not (langutils::Namespace-import-exporter nsi))
				    (dbg-save :run-loud nsi ns)
				    (signal-problem namespace-parse
				       "Namespace-import with null exporter: " nsi)))
			     (namespace-add-import namespace nsi))))))))
      (values namespace ns-flg)))

(defun include-if-not-null (flag l)
   (cond ((null l) '())
	 (t `((,flag ,@l)))))

(defun addendum-parse (addname dom methods 
		       axioms facts ; safeties
		       flg-junk)
   (domain-make-current dom)
   (let ((rg (domain-place-rule-group dom addname)))
      (let ((real-rg (cond ((is-Rule-group rg) rg)
			   (t nil))))
         (cond (real-rg
                (setf (Domain-generation dom)
                      (next-generation))
                (setf (Rule-group-rules rg) '())
		(let (;(flg-safety (safety-parse safeties dom real-rg))
		      (flg-axioms (axioms-parse axioms dom real-rg))
		      (flg-methods (methods-parse methods dom real-rg))
		      (flg-facts (facts-parse facts dom real-rg `(addendum ,addname)))
		      )
		   (cond (real-rg
			  (setf (Rule-group-generation rg)
				(Domain-generation dom))))
		   `(define (addendum
			       ,(cond (real-rg addname)
				      (t
				       (flag-wrong-type rg addname 'addendum))))
		       (:domain ,(Domain-name dom))
		       ;,@flg-safety
		       ,@flg-methods
		       ,@flg-axioms
		       ,@(include-if-not-null ':facts flg-facts)
		       ,@flg-junk)))
	       (t
		`(define (addendum ,real-rg)))))))

(defun situation-parse (sit-type name dom facts obs inits flg-junk)
      (domain-make-current dom)
      (multiple-value-bind (sit flg-facts flg-consts flg-inits)
			   (build-initial-situation
			       name (list dom)
			       facts obs inits `(situation ,name))
	 `(define (,sit-type ,(cond ((is-Situation sit) name)
				    (t (flag-wrong-type
						sit name 'situation))))
	     (:domain ,(Domain-name dom))
	     ,@(include-if (not (null flg-facts))
		  `(:facts ,@flg-facts))
	     ,@flg-consts
	     (:init ,@flg-inits)
	     ,@flg-junk)))

(defun problem-parse (name dom requirements sits facts obs inits
		      goals expansions
                      lnth metrics flg-junk)
   (domain-make-current dom)
   (multiple-value-let (prob _ _)
		       (get-global-opt-sym name)
;;;;      (cond (okay
;;;;	     (format *error-output*
;;;;		     "Warning -- redefining problem ~s~%"
;;;;		     name)))
      (setq prob (make-Problem :name name))
      (set-global-opt-sym name prob problem-type*)
      (multi-let (((flg-req reql req-imports)
		   (require-parse requirements)))
      	 (let ((base-sit (cond ((null sits) nil)
			       ((= (length sits) 1)
				(let ((b (find-domain-bdg-val (car sits) dom)))
				   (cond ((is-Initial-situation b)
					  b)
					 (t
                                          (let ((b (get-global-opt-sym
                                                      (car sits))))
                                             (cond ((is-Problem b)
						    (cond ((same-as-prob-domain
							      dom b)
							   (Problem-sit b))
							  (t
							   (flagexp
							      "Problem based on problem from other domain"
							      b))))
                                                   (t
					            (flagexp "Not a situation"
						             (car sits)))))))))
			       (t (flagexp "Illegal situation spec" sits)))))
	    (multiple-value-let
	               (sit flg-facts flg-obs flg-inits)
		       (cond ((not base-sit)
			      (build-initial-situation
			         (init-sit-name name)
				 (list dom)
				 facts obs inits `(problem ,name)))
			     ((is-Initial-situation base-sit)
			      (let ((sit-dom (Initial-situation-domain
					        base-sit)))
				 (cond ((and (null facts)
					     (null obs)
					     (null inits)
					     (null requirements)
					     (member dom
						     (Domain-ancestors
							sit-dom)))
					(values base-sit !() !() !()))
				       (t
					(build-initial-situation
					   (init-sit-name name)
					   (list dom sit-dom)
					   facts obs inits `(problem ,name))))))
			     (t
			      (values nil nil nil nil)))
	        (cond ((and (is-Initial-situation sit)
			    (is-Initial-situation base-sit)
			    (not (eq sit base-sit)))
		       (setf (Initial-situation-parent sit)
			     base-sit)))
	        (cond ((and sit +namespace-mode+)
		       (let ((subdom (Initial-situation-domain sit)))
;;;;			  (let ((par-ns
;;;;				   (Domain-namespace subdom))) ...)
			  (cond ((not (and (null obs) (null req-imports)))
				 (let ((new-sub-ns
					  (new-sub-namespace name subdom false)))
				    (namespaces-link new-sub-ns req-imports)
				    (!= (Domain-namespace subdom)
					new-sub-ns)))))))
		(multiple-value-let  (goal-te max-or-min metric-te flg-act _)
				     (cond ((is-Initial-situation sit)
					    (fill-problem
					        prob sit reql goals metrics
						expansions lnth))
					   (t
					    (values nil nil nil)))
		     `(define (problem ,name)
			(:domain ,(Domain-name dom))
			,@(cond ((null requirements) '())
				(t `((:requirements ,@flg-req))))
			,@flg-obs
			,@(cond ((null flg-facts) !())
				(t `((:facts ,@flg-facts))))
			,@(cond (base-sit
				 `((:situation
				      ,(cond ((is-Initial-situation base-sit)
					      (Initial-situation-name
						 base-sit))
					     ((is-Flagged-subexpression base-sit)
					      base-sit)
					     (t "??")))))
				(t '()))
			(:init ,@flg-inits)
			(:goal ,(cond (goal-te
				       (flagsource goal-te))
				      (t
				       (flagexp "Missing goal" '__))))
			,@(include-if metric-te
			     `(:metric ,max-or-min ,(flagsource metric-te)))
			,@(include-if flg-act)
			,@flg-junk)))))))

(defun namespaces-link (ns import-from)
   (cond ((-- +namespace-mode+)
	  (repeat :for ((imp-ns :in import-from))
	     (cond ((not (eq imp-ns ns))
		    (namespace-add-import
		       ns
		       (new-Namespace-import false imp-ns "" +all-symbols+))))))))

(defun same-as-prob-domain (dom b)
   (let ((bdom (Problem-domain b)))
      (or (eq dom bdom)
	  (eq dom (car (Domain-parents bdom))))))

(defun fill-problem (prob sit reql goals metrics expansions _)
  (let ((subdom (Initial-situation-domain sit)))
    (setf (Domain-requirements subdom) reql)
    (multi-let (((metric-te max-or-min)
		 (cond ((null metrics) (values false false))
		       ((forall (m :in (cdr metrics))
			   (equal m (car metrics)))
			(problem-metric-parse (car metrics) subdom))
		       (t
			(values
			   (note-bugs
			      (ill-formed-typed-exp
				 metrics num-type* (empty-vartypes subdom))
			      (list (new-Flagged-subexpression
				       false (simple-ill-formed-exp
						"Multiple metrics" metrics))))
			   false))))
	      (goal-te
		 (cond ((= (length goals) 1)
			(nth-value 0
			   (formula-typecheck (car goals) false (empty-undo-stack)
					      !() subdom)))
		       ((null goals) false)
		       (t
			(note-bugs
			    (ill-formed-typed-exp goals prop-type*
						  (empty-vartypes subdom))
			    (new-Flagged-subexpression
			       nil (simple-ill-formed-exp "Multiple goals"
							  goals))))))
	      (flg-act (cond ((null expansions) '())
			     (t
			      (flagexp "Expansions forbidden in problem specs"
				       expansions)))))
       (setf (Problem-sit prob) sit)
       (cond ((and goal-te
		   (= (Typed-exp-totbugs goal-te)
		      0))
	      (setf (Problem-goal prob)
		    ;;;;(typed-exp-sexp ... false)
		    goal-te)))
       (setf (Problem-metric prob) 
	     (cond ((and metric-te
			 (= (Typed-exp-totbugs metric-te)
			    0))
		    (tuple max-or-min metric-te))
		   (t false)))
       (values goal-te max-or-min metric-te flg-act `()))))

(defun problem-metric-parse (metric sitdom)
			(match-cond metric
			   (:? (?(:& ?w ?(:\| minimize maximize)) ?mexp)
			     (values
			        (term-typecheck
				   mexp num-type*
				   !() !()
				   (list (new-Vartype
					    'total-time
					    (constant-fun-type
					       num-type*
;;;;					       (make-Fluent-type num-type*)
					       )
					    false)
					 (new-Vartype
					    'total-steps
					    (constant-fun-type
					       num-type*
;;;;					       (make-Fluent-type num-type*)
					       )
					    false))
				   sitdom)
				w))
			   (t
			    (values
			       (ill-formed-typed-exp
				  metric
				  num-type* (empty-vartypes sitdom))
			       false))))

(defvar empty-arg-type*
    (nisptype::make-tup-type 'Row (args->spec !()) false global-opt-env*))

(defun constant-fun-type (restype)
   (make-funtype
      0 restype empty-arg-type*
      (args->spec (list restype))
      (args->spec !())
      false global-opt-env*))

(defun init-sit-name (probname)
   (build-symbol (< probname) "/" initial-situation))

(defun build-initial-situation (name doms facts obs inits cxt)
   (let ((sit (domain-place-situation (car doms) name)))
      (let ((subdom (Initial-situation-domain sit)))
	(setf (Domain-parents subdom) doms)
	(maybe-set-subdom-namespace subdom doms
				    (and (null obs) name))
	(domain-reset subdom)
	(reset-ancestors subdom)
	(let ((flg-consts (constant-lists-parse ':objects obs subdom))
	      (subdom-rg (own-rule-group subdom)))
	   (cond ((domain-declares-requirement subdom ':timed-initial-literals)
		  (multi-let (((at-inits other-inits)
			       (classify inits
				  (\\ (fmla) (matchq (at ?(:+ ?_ is-Number) ?_)
						     fmla)))))
		     (!= facts (nconc at-inits *-*))
		     (!= inits
			 (cons `(current-value clock 0.0)
			       other-inits)))))
	   (let ((flg-facts (facts-parse facts subdom subdom-rg cxt)))
	      (multi-let (((props prop-flg-junk)
			   (list-smooth inits #'consp)))
		 (let ((lit-tes (mapcar (\\ (a)
					   (sit-init-typecheck a subdom))
					props)))
		    (setf (Initial-situation-delta sit)
			  ;;;;(<# (\\ (l) (typed-exp-sexp l false)) ...)
		          lit-tes)
		    (domain-mark-current subdom)
		    (values sit flg-facts flg-consts
			    (append (<# (\\ (l) (flagsource l))
					lit-tes)
				    prop-flg-junk)))))))))

;;; Handle those awkward fluent equalities in a special way.
(defun sit-init-typecheck (fmla dom)
   (let (e1 e2)
      (cond ((and pddl2.1-compatible*
		  (matchq (= ?e1 ?e2) fmla))
	     (let ((env (make-Env true (list dom))))
;;;;		(out "env = " env :%)
		(multi-let (((e1-te undo-stack-1)
			     (term-typecheck
				e1 univ-type* (empty-undo-stack)
				!() !() dom)))
		   (multi-let (((numerical-flu undo-stack-2)
				(type-acceptable
				     true
				     (Typed-exp-type e1-te) num-fluent-type*
				     undo-stack-1 env env !())))
		      (cond ((not numerical-flu)
			     (!= undo-stack-2
				 (undo undo-stack-2 undo-stack-1))))
		      (multi-let (((e2-te _)
				   (term-typecheck
				       e2
				       (cond (numerical-flu num-type*)
					     (t univ-type*))
				       undo-stack-2
				       !() !() dom)))
			 (let ((actual-e1-te
				  (cond (numerical-flu
					 (simple-app-typed-exp
					    (simple-var-typed-exp 'fl-v env)
					    (list e1-te)
					    (list (Typed-exp-type e1-te))
					    fmla num-fluent-type* env))
					(t e1-te))))
			    (simple-app-typed-exp
			       (build-App-typed-exp
				  1
				  (simple-var-typed-exp '= env)
				  (list (make-inst Type-typed-exp
					   :which num-type*
					   :source 'Number
					   :subexps !()))
				  '(1)
				  (list num-type*)
				  env
				  (let ((als (args->spec
					        (list num-type* num-type*))))
				     (make-funtype
				        0 prop-type*
					(arglistspec-argtype als env)
					(args->spec (list prop-type*))
					als false env))
				  true false)
			       (list actual-e1-te e2-te)
			       (list num-type* num-type*)
			       fmla prop-type* env)))))))
	    (t
	     (formula-typecheck fmla true (empty-undo-stack) !() dom)))))

(defun maybe-set-subdom-namespace (subdom doms name)
	(cond ((-- +namespace-mode+)
	       (cond (name
		      (!= (Domain-namespace subdom)
			  (new-sub-namespace name (car doms) true)))
		     (t
		      (!= (Domain-namespace subdom)
			  (Domain-namespace (car doms))))))))

(defun new-sub-namespace (name parent local)
   (let ((new-ns
	    (place-Namespace-with-exports
	       name
	       (cond (local
		      (or (Domain-namespace-tab parent)
			  (let ((new-namespace-tab
				   (make-hash-table :test #'eq :size 5)))
			     (!= (Domain-namespace-tab parent)
				 new-namespace-tab)
			     new-namespace-tab)))
		     (t false))
	       +all-symbols+))
	 (par-ns (Domain-namespace parent)))
      (cond (par-ns
	     (namespace-add-import
		new-ns (new-Namespace-import false par-ns "" +all-symbols+)))
	    (t
	     (signal-problem new-sub-namespace
		"Domain with no namespace " parent)))
      new-ns))

(defun constant-lists-parse (argname cll dom)
  (mapcar #'(lambda (cl)
	       `(,argname ,@(constants-parse cl dom)))
	  cll))

; The "parsing" functions after this always return as their first value a 
; version of their input annotated with syntax-check comments.

(defun builtins-parse (builtins)
   (let ((bl '())
         (flg '()))
      (multiple-value-bind (bnames flg-junk)
                           (list-smooth builtins #'symbolp)
         (dolist (bn bnames)
            (let ((dom (try-domain-with-name bn nil)))
               (cond ((is-Domain dom)
                      (push dom bl)
                      (setq flg `(,bn ,@flg)))
                     ((not dom)
                      (setq flg `(,(flagexp "Undefined domain"
                                            bn)
                                  ,@flg)))
                     (t
                      (setq flg `(,(flag-wrong-type dom bn 'domain)
                                  ,@flg))))))
         (values `(:builtins ,@(reverse flg) ,@flg-junk)
                 bl))))

(defun defrequire-parse (defreq-triples dom)
   (repeat :for ((defreq :in defreq-triples))
    :collect
      (multi-let (((req req-flag)
		   (try-define-requirement (car defreq))))
	 (multi-let (((flg-implics implied-reqs)
		      (implications-parse (cadr defreq))))
	    (cond (req
		   (setf (Requirement-builtins req) (list dom))
		   (setf (Requirement-implies req) implied-reqs)))
	    `(:defines-requirement
		 ,(cond (req (car defreq))
			(t (flagexp req-flag (car defreq))))
		 ,@flg-implics
 		 ,@(caddr defreq))))))

(defun implications-parse (implics)
   (let ((il '())
         (flg '()))
      (multiple-value-bind (inames flg-junk)
                           (list-smooth implics #'symbolp)
         (dolist (impn inames)
            (let ((req (try-requirement-with-name impn nil)))
               (cond ((is-Requirement req)
                      (push req il)
                      (setq flg `(,impn ,@flg)))
                     ((not req)
                      (setq flg `(,(flagexp "Undefined requirement"
                                            impn)
                                  ,@flg)))
                     (t
                      (setq flg `(,(flag-wrong-type
                                      req impn 'requirement)
                                  ,@flg))))))
         (values `(:implies ,@(reverse flg) ,@flg-junk)
                 il))))

(defvar uri-loading-stack* !())

;;; Returns < flagged-input, parent-domains, Namespace-imports >.
(defun parents-parse (parents)
  (let ()
     (multiple-value-bind (parents flg-junk)
			  (list-smooth parents
				       (\\ (x) (or (is-Symbol x)
						   (and (is-Pair x)
							(memq (car x)
							      '(:url :uri :name
								:parent :domain))))))
	(let-fun ()
	   (collecting-defective-exps (defexps flg pdl imports)
				      (parents-handle)
	      (:if-aborted 
	       :restart-report (lambda (srm)
			          (out (:to srm)
				      "I will give up on checking parents "
				       parents))
		 (langutils::defective-exps-renotify defexps true)
		 (values flg-junk !() !()))
;;;;	      (out "Imports from parents = " imports :%)
	      (values (cond ((null defexps) flg)
			    (t
			     (let ((fs (new-Flagged-subexpression
					  parents `(,@defexps ,@flg))))
				(dbg-save :run-loud fs defexps parents flg)
				(breakpoint parents-parse
				   "What now?")
			        (list fs))))
		      pdl imports))
 :where

 (:def parents-handle ()
    (repeat :for ((par :in parents)
		  :collectors pdl flg imports)
;;;;       (out "Parsing parent " par :%)
     :within
       (multi-let (((name props)
		    (match-cond par
		       (:? (?(:\| :domain :uri :name :url) ?u ?@props)
			 (values (cond (web-mode*
					(cond ((is-Symbol u)
					       (symbol->actual-global-name u ':domain))
					      ((is-String u)
					       (let ((uri (intern-uri
							     (parse-uri u)
							     opt-uri-space*)))
						  (uri-place-opt-name uri)))
					      (t
					       (note-defective-exp
						   ((_) "Meaninglesss URI " u))
					       )))
				       (t
					(note-defective-exp
					   ((par) "Illegal when not in web mode: "
						par)
					   :target par)))
				 props))
		       ((is-Symbol par)
			(values (symbol->actual-global-name par ':domain)
				!()))
		       (t
			(note-defective-exp
			   ((par) 
			    "Indecipherable parent spec for domain: " par)
			   :target par
			   (:proceed "I will ignore this parent"))
			(values false !())))))
	  (cond (name
		 (let ((par-dom (load-domain-with-name
				   (or (get name 'uri) name))))
		    (cond ((is-Domain par-dom)
			   (:continue
			    :collect (:into pdl par-dom)
			    :within
			      (cond ((and (is-Symbol name) (null props))
				     (cond ((and (-- +namespace-mode+)
						 (not (Domain-namespace par-dom)))
					    (dbg-save :run-loud par-dom)
					    (breakpoint parents-parse
					       "Parent " par-dom
					       " has null namespace")))
				     (:continue
				      :collect (:into imports
						      (new-Namespace-import
						         false
							 (Domain-namespace par-dom)
							 "" +all-symbols+))
				      :collect (:into flg name)))
				    (t
				     (multi-let (((imps props-flg)
						  (parent-props-parse par-dom props)))
					(:continue
					 :nconc (:into imports imps)
					 :collect
					    (:into flg
					       `(,(cond (web-mode* ':uri)
							(t ':name))
						 ,name ,@props-flg))))))))
			  (t
			   (cond ((not par-dom)
				  (dbg-save :run-loud name props)
				  (breakpoint parents-parse
				     "Domain " name " undefined")))
			   (:continue
			    :collect (:into flg
					    (flagexp (cond (par-dom "Parent not a domain")
							   (t "Parent undefined"))
						     name)))))))))
     :result
       (values `(,@flg ,@flg-junk)
	       pdl
	       imports)
   :where
      (:def parent-props-parse (par props)
	 (repeat :for ((pl = props)
		       (mentioned-so-far !())
		       :collectors imps props-flg)
	  :until (null pl)
	  :within
	    (match-cond pl
	       ?( (?(:\| :prefix :import) ?(:\| (?str ?@syms) ?str :& ?symspec)
			   ?@remainder)
		 (!= pl remainder)
;;;;		     (out "str = " str " syms = " syms :%)
		 (cond ((is-Symbol str)
			(!= str (symbol-name *-*))))
		 (cond ((is-String str)
			(:continue
			 :append (:into props-flg
					`(:prefix ,symspec))
			 :when (not (equal syms '(:none)))
			   (cond ((null (Domain-namespace par))
				  (signal-problem parents-parse
				     "Importing from parent with no namespace "
				     par)))
			 :collect (:into imps
				     (new-Namespace-import
					false
					(Domain-namespace par)
					str
					(match-cond syms
					   (:? (:all)
					     (!= mentioned-so-far +all-symbols+)
					     +all-symbols+)
					   (:? ?(:\| (:remainder) () (()))
					     (exclude mentioned-so-far symspec))
					   (:? (:all-but ?@excluded)
					     (exclude (syms->prefixed-syms excluded)
						      symspec))
;;;;					   ((null syms)
;;;;					    (!= mentioned-so-far +all-symbols-but+)
;;;;					    +all-symbols+)
					   (t
					    (let ((inclu (syms->prefixed-syms syms)))
					       (!= mentioned-so-far
						   (append inclu *-*))
					       inclu)))))))
		       (t
			(:continue
			 :append (:into props-flg
					`(:prefix
					    ,(flagexp "No prefix in" symspec)))))))
	       (t
		(:continue
		 :collect (:into props-flg
				 (flagexp "Unintelligible" pl)))
		(!= pl !())))
	  :result (values imps props-flg)

          :where

      (:def exclude (excluded symspec)
	 (cond ((eq mentioned-so-far +all-symbols+)
		(err-out "Use of :remainder in import spec " symspec
			 " when no symbols can be left"))
	       (t
		(!= mentioned-so-far +all-symbols+)
		`(,+all-symbols-but+ ,@excluded))))

      (:def syms->prefixed-syms (symlist)
	  (<# (\\ (s)
		 (cond ((is-Symbol s)
			(make-Prefixed-symbol (list "")
					      (symbol-as-keyword s)))
		       ((is-Prefixed-symbol s)
			s)
		       (t
			(note-defective-exp
			   ((ob) "Illegal symbol in symlist: " ob)
			   :target symlist
			   :fatal))))
	      symlist))))))))))

;;; Returns < flagged-input, all-implied-requirements, namespaces-to-import-from >
(defun require-parse (require)
   (let ()
      (multiple-value-bind (require flg-junk)
			   (list-smooth require #'symbolp)
	 (repeat :for ((req :in require) 
		       :collectors flg rql)
	  :within
	    (multi-let (((x okay _)
			 (get-global-opt-sym req)))
	       (cond (okay
		      (cond ((is-Requirement x)
			     (:continue
			      :append (:into rql (requirement-implications x))
			      :collect req))
			    (t
			     (:continue
			      :collect (flagexp "Nonrequirement" req)))))
		     (t
		      (:continue
		       :collect (flagexp "Unknown requirement" req)))))
	  :result (let ((rql (nodup rql)))
		     (values `(,@flg ,@flg-junk)
			     rql
			     (cond ((-- +namespace-mode+)
				    (nodupq
				       (repeat :for ((req :in rql)
						     :collector namespaces)
					:nconc
					   (repeat :for ((bdom :in
							       (Requirement-builtins
								  req)))
					    :collect (Domain-namespace bdom)))))
				   (t !()))))))))

;;; Returns < req, bogosity >.  If req is false, bogosity is string
;;; describing problem.  If req is a requirement, bogosity is false.
(defun try-define-requirement (name)
   (cond ((is-Symbol name)
	  (cond ((not (is-Keyword name))
		 (!= name (intern (Symbol-name name) keyword-package*))))
 	  (let ((req (try-requirement-with-name name true)))
	     (cond ((is-Requirement req)
		    (values req false))
		   (t
		    (values false
			    (out (:to :string)
			       "Wrong type (value "
			       req ", not of type Requirement)"))))))
	 (t
	  (values false "Unintelligible requirement name"))))

(defun types-parse (types dom)
   (let ()
      (labels ((types-track (tl new)
		  (cond ((null tl)
			 (declare-types new univ-type*))
			((eq (car tl) '-)
			 (cond ((null (cdr tl))
				`(,@(declare-types new univ-type*)
				  -  ,(flagexp "Missing type" "__")))
			       (t
				(let ((superty (domain-type (cadr tl) dom)))
;;;;				   (dbg-save superty tl dom)
;;;;				   (breakpoint types-parse
;;;;				      "Got: " superty)
				   `(,@(declare-types new superty)
				     - ,(Type-desig superty)
				     ,@(types-track (cddr tl) '()))))))
			((is-symbolish (car tl))
;;;;		        (or ...
;;;;			  (and (consp (car tl))
;;;;			       (is-symbolish (caar tl))))
			 (multi-let (((newsym sym-flg)
				      (symbol-resolve (car tl) dom true)))
			    `(,@(include-if (not (eq sym-flg newsym))
				   sym-flg)
			      ,@(types-track (cdr tl)
					     (cond (newsym
						    (cons newsym new))
						   (t new))))))
			(t
			 `(,(flagexp "Illegal type name" (car tl))
			   ,@(types-track (cdr tl) new)))))
	       (declare-types (new superty)
;;;;		  (trace-around declare-types
;;;;		     (:> "(declare-types: " new ")")
		  (let ((flg-new '()))
		     (dolist (n new)
			(push (declare-type n superty dom) flg-new))
		     flg-new)
;;;;		     (:< (val &rest _) "declare-types: " val))
		  ))
	 `(:types ,@(types-track types '())))))

(defun declare-type (newt superty dom)
   (multiple-value-bind (newty const-tester)
			(cond ((consp newt)
			       (values (car newt) (cadr newt)))
			      (t
			       (values newt nil)))
;;;;      (!= newty (symbol-place *-* dom))
      (define-if-unbound newty type-type*
			 (new-Type
			    nisptype::boring-class* newty '() superty '()
			    (cons (tuple 'nisptype::home dom)
				  (cond (const-tester
					 (list (tuple
						  'is
						  (symbol->fun const-tester))))
					(t '()))))
			 dom)))

; spec is very similar to a def-type
(defun complex-types-parse (specs dom)
   (let ()
      (let ((parsed
	       (repeat :for ((spec :in specs))
		:collect
		  (multi-let (((typename type-desig def-flg)
			       (type-def-parse spec dom)))
		     (multi-let (((sym sym-flg)
				  (symbol-resolve typename dom true)))
			(tuple sym sym-flg type-desig def-flg))))))
	 ;; parsed is list of four elements (typename typename-flg definiens flg-junk)
	 (repeat :for ((quad :in parsed)
		       :collector forward-types)
	  :within
	     (cond ((car quad)
		    (let ((fortype (forward-type (car quad) dom)))
		       (define-if-unbound (car quad) type-type* fortype dom)
		       (:continue :collect fortype)))
		   (t
		    (:continue :collect false)))
	  :result
	     (repeat :for ((quad :in parsed)
			   (fortype :in forward-types))
	      :collect
		(match-let (?typename ?tn-flg ?definiens ?flg-junk)
			   quad
		   (cond (fortype
   ;;;;		       (!= definiens
   ;;;;			   (expression-symbols-place *-* dom))
			  (let ((newtype (designated-type-with-name
					    definiens false typename
					    (empty-vartypes dom))))
			     (type-displace fortype newtype)
			     `(:type ,tn-flg ,definiens ,@flg-junk)))
			 (t
			  `(,tn-flg ,@flg-junk)))))))))

;;; 'spec' 
(defun typefun-parse (spec dom)
   (multi-let (((typefun-name params body)
		(match-cond spec
		   (:? (?(:+ ?name is-Symbol) ?params ?@body)
		      (values name params body))
		   (:? ((?(:+ ?name is-Symbol) ?@params) ?@body)
		      (values name params body))
		   (t
		    (let ((exp `(:type-fun ,@spec)))
		       (note-defective-exp
			   ((targ) "Ill-formed type-fun definition: " targ)
			   :target exp
			   "Ill-formed type-fun definition -- " exp
			   :fatal))))))
      (multi-let (((_ definiens flg-junk)
		   (type-def-parse body dom)))
	 (cond (definiens
		(multi-let (((typefun-name name-flg)
			     (symbol-resolve typefun-name dom true))
			    (env (domain-place-env dom)))
		   (cond (typefun-name
			  (collecting-defective-exps
					   (ill-formed-exps params _ _ synerrs)
					   (params-parse params true type-type*
							 true false env)
			     (let ((defn (nisptype::typefun-body-designation
						    typefun-name definiens params
						    env)))
				`(:type-fun
				     (,(define-if-unbound typefun-name tyfun-type*
						   (new-Tyfun
						       typefun-name params
						       defn
						       env)
						   dom)
				      ,@(synerrs-flag
					   synerrs
					   (arglistspec-typed-arglist params)
					   true))
				     ,definiens ,@ill-formed-exps ,@flg-junk))))
			 (t
			  `(:type-fun
			      (,name-flg ,@params)
			      ,definiens ,@flg-junk)))))
	       (t
		flg-junk)))))

(defun constructor-parse (condef domain)
   (match-cond condef
      (:? (?(:+ ?name is-symbolish) ?params)
        
	(collecting-defective-exps (ill-formed name alspec _)
				   (nisptype::def-type-constructor-parse
				       name params !())
	   (:if-aborted 
	    :restart-report (lambda (srm)
			       (out (:to srm)
				    "I will give up on checking type-constructor"
				    name))
	      (new-Flagged-subexpression
		   `(:type-constructor ,@condef) ill-formed))
	   (multi-let (((name name-flg)
			(symbol-resolve name domain true)))
	      (cond (name
		     (let ((cspec (nisptype::make-Constructor-spec
				     false alspec)))
			(let ((tyf (new-Tyfun name alspec cspec (domain-place-env domain))))
			   (!= (nisptype::Constructor-spec-tyfun cspec) tyf)
			   (define-if-unbound name constructor-type* tyf domain)
			   `(:type-constructor ,name
					       ,(<# Argspec-name
						    (Arglistspec-argspecs alspec))))))
		    (t
		     `(:type-constructor ,name-flg ,params))))))
      (t
       (new-Flagged-subexpression
	  `(:type-constructor ,@condef)
	  (nconc (cond ((not (is-symbolish (cadr condef)))
			(list (simple-ill-formed-exp "Nonsymbol: " (cadr condef))))
		       (t !()))
		 (cond ((not (null (cddr condef)))
			(list (simple-ill-formed-exp "Stuff after params: "
						     (cddr condef))))
		       (t !())))))))

;; Must place a local binding *or* inherit from another domain, not
;; opt-basics.
(defun define-if-unbound (name type val dom)
   (let ((bdg (find-domain-bdg name dom))
	 (nogood (find-domain-bdg name basic-domain*)))
      (cond ((eq bdg nogood)
	     (create-local-bdg name type val dom)
	     name)
	    ((Domain-bdg-unbound bdg)
	     (!= (Domain-bdg-type bdg) type)
	     (!= (Domain-bdg-val bdg) val)
	     name)
	    (t
	     (format-flg name "Attempt to redefine (binding ~s)" nogood)))))
	       
(defun type-def-parse (spec dom)
                      (ignore dom)
   (match-cond spec
      (:? ()
         (values nil nil (flagexp "Empty type spec" ':type)))
      (:? (?typename)
	 (values typename `(Clump :subtype Obj) `(:type ,typename)))
      (:? (?typename ?(:\| :subtype :modified :& ?mod) ?@s)
	 (match-cond s
	    (:? ()
	       (values typename `(Clump ,mod Obj) (flagexp "Missing supertype" nil)))
	    (:? (?supertype ?@junk)
	       (values typename `(Clump ,mod ,supertype) false
		       (and (not (null junk))
			    (flagexp "Extra junk" junk))))
	    (t
	     (values typename `(Clump ,mod Obj) (flagexp "Unintelligible: " spec)))))
      (:? (?typename ?supertype ?@s)
	 (values typename supertype (and (not (null s))
					 (flagexp "Extra junk: " s))))
      (t
       (values nil nil (flagexp "Unintelligible: " spec)))))
			    
;;;;	       
;;;;
;;;;   (cond ((null spec)
;;;;	  (values nil nil (flagexp "Empty type spec" ':type)))
;;;;	 (t
;;;;	  (let ((typename (car spec)
;;;; ;;;         Names must be symbols bound in this domain --
;;;; ;;;;			  (symbol-place (car spec) dom)
;;;;			  ))
;;;;	     (cond ((null (cdr spec))
;;;;		    (values typename `(Clump :subtype Obj) `(:type ,typename)))
;;;;		   ((memq (cadr spec) '(:subtype :modified))
;;;;		    (cond ((null (cddr spec))
;;;;			   (values typename `(Clump ,(cadr spec) Obj)
;;;;				   (flagexp "Missing supertype" nil)))
;;;;			  (t
;;;;			   (values typename 
;;;;				   `(Clump ,(cadr spec) ,(caddr spec))
;;;;				   (cond ((null (cdddr spec))
;;;;					  '())
;;;;					 (t
;;;;					  `(,(flagexp "Extra junk" (cdddr spec)))))))))
;;;;		   (t
;;;;		    (values typename
;;;;			    (cadr spec)
;;;;	     ;;;;			    (expression-symbols-place (cadr spec) dom)
;;;;			    (cond ((null (cddr spec))
;;;;				   '())
;;;;				  (t`(,(flagexp "Extra junk" (cddr spec))))))))))))

(defun constants-parse (constants dom)
   (collecting-defective-exps (ill-formed cvtl _)
			      (bvar-list-parse constants #'is-symbolish
					       false univ-type*
					       (empty-vartypes dom))
      (:if-aborted 
	 :restart-report (lambda (srm)
			    (out (:to srm)
				 "I will give up on checking the constants in"
				 constants))
	 (list (new-Flagged-subexpression
		  constants ill-formed)))

      (do ((cl cvtl (cdr cl))
	   (av))
	  ((null cl)
	   (cond ((null ill-formed)
		  (vartypes-bvar-list cvtl))
		 (t
		  (list (new-Flagged-subexpression
			   (vartypes-bvar-list cvtl)
			   ill-formed)))))
	 (!= av (car cl))
	 (cond ((not (eq (Vartype-val av)
			 +no-val-specified+))
		(!= ill-formed
		    (cons (make-Defective-exp
			     :observation
			     (\\ (_ srm)
				(out (:to srm)
				     "Constant with initializer: "
				     "(" (Vartype-var av) 1
				         (Vartype-val av) ")")))
			  *-*))))
	 (let ((ifl (bind-constant (Vartype-var av)
				   true 
				   (Vartype-type av)
				   (\\ (aname)
				      (make-Constant aname (Vartype-type av)))
				   dom)))
	    (!= ill-formed
		(nconc ifl *-*))))))

(defun domain-vars-parse (domain-vars dom)
   `(:parameters
     ,@(collecting-defective-exps (ill-formed dvtl _)
				  (bvar-list-parse
				     domain-vars #'is-symbolish
				     true univ-type* (empty-vartypes dom))
	  (:if-aborted
             :restart-report (lambda (srm)
				(out (:to srm)
				     "I will give up on checking the domain"
				     " parameters in " domain-vars))
	     (list (new-Flagged-subexpression domain-vars
					      ill-formed)))
	  (do ((dvl dvtl (cdr dvl))
	       (dvt) (dvar))
	      ((null dvl)
	       (cond ((null ill-formed)
		      (vartypes-bvar-list dvtl))
		     (t
		      (list (new-Flagged-subexpression
			       (vartypes-bvar-list dvtl)
			       ill-formed)))))
	     (!= dvt (car dvl))
	     (!= dvar (symbol-resolve (Vartype-var dvt) dom false))
	     (let ((dbdg (place-domain-bdg dvar dom)))
		(cond ((or (Domain-bdg-unbound dbdg)
			   ; Okay if previously unbound,
			   ; or bound to
			   ; a domain-var in an ancestor
			   (and (is-Domain-var (Domain-bdg-val dbdg))
				(not (eq (Domain-bdg-domain dbdg)
					 dom))))
		       (let ((dvtype (Vartype-type dvt)))
			  (setq dbdg
				(place-local-domain-bdg
				   dvar dom))
			  (!= (Domain-bdg-val dbdg)
				(make-Domain-var
				   :name dvar
				   :val (Vartype-val dvt)
				   :type dvtype))
			  (!= (Domain-bdg-type dbdg)
			      dvtype)
			  (cond ((not (const-of-type
					 (Vartype-val dvt) dvtype '()))
				 (!= ill-formed
				     (cons (out-defective-exp
					      "Value " (Vartype-val dvt)
					      " of wrong type for domain var "
					      dvar)
					   *-*))))))
		      (t
		       (!= ill-formed
			   (cons (out-defective-exp
				    "Domain var " dvar " already defined as "
				    (Domain-bdg-val dbdg))
				 *-*)))))))))

(defun predicates-parse (predicates dom)
   (multi-let (((pred-defs flg)
		(list-smooth predicates #'consp)))
      (multi-let (((vtl flag-lists ill-formed-subexps extra-ill-formed)
		   (function-list-parse pred-defs
					'(:prechain :rules-only :rigid)
					prop-type* false
					(empty-vartypes dom))))
	 (repeat :for ((pred-vt :in vtl)
		      (flags :in flag-lists)
		      (ifel :in ill-formed-subexps)
		      (final-ill-formed-list '()))
	    (let ((predname (Vartype-var pred-vt))
		  (predtype (Vartype-type pred-vt)))
	       (let ((ifel1 (bind-pred-constant
			       predname true predtype flags dom)))
		 (!= final-ill-formed-list
		     (cons (append ifel ifel1) *-*))))
	  :result (let ((ext (fcn-vartypes-list vtl flag-lists
					       true prop-type*
					       (empty-vartypes dom))))
		    `(   ;;:predicates
		      ,@(<# flag-if-ill-formed
			    ext
			    (reverse final-ill-formed-list))
		      ,@flg
		      ,@(include-if (not (null extra-ill-formed))
			   (flag-if-ill-formed '** extra-ill-formed))))))))

(defun functions-parse (funcls dom)
   (let ((env (empty-vartypes dom)))
      (repeat :for (funcl :in funcls)
       :collect
	    (multi-let (((fvtl _ ill-formed-exp-lists trailing-ifes)
			 (function-list-parse
			     funcl !()
			     (cond (pddl2.1-compatible* num-fluent-type*)
				   (t false))
			     (\\ (ty _) ty)
			     env)))
	       (repeat :for ((fvt :in fvtl)
			    (ife-list :in ill-formed-exp-lists)
			    (new-ill-formed-exp-lists))
		  (let ((fname (Vartype-var fvt)))
		     (!= ife-list
			 (append (bind-constant
				    fname true (Vartype-type fvt)
				    (\\ (fname)
				       (make-inst Functional-constant
					  :name fname
					  :type (Vartype-type fvt)
					  :type-inverter false
					  :internalizer false
					  :callable false))
				    dom)
				 *-*))
		     (!= new-ill-formed-exp-lists
			 (cons ife-list *-*)))
		:result (let ((ext (fcn-vartypes-list fvtl '() true false env)))
			  `(:functions
			     ,@(<# flag-if-ill-formed
				   ext
				   (dreverse new-ill-formed-exp-lists))
			     ,@(include-if (not (null trailing-ifes))
				  (flag-if-ill-formed
				     '** trailing-ifes)))))))))

(defun complex-function-parse (fun-spec dom)
   (let-fun ()
      (collecting-defective-exps
		      (de-list output-pat)
		      (parse-it)
	   (flag-if-ill-formed output-pat de-list)
	   (:if-aborted
	       (new-Flagged-subexpression
		  `(:function ,@fun-spec) de-list)))
    :where
       (parse-it ()
	  (let ((env (domain-place-env dom))
		(context (opt-syn-context fun-spec !())))
	     (let ((fdr (fundef->fundef-rec
			    fun-spec !() (\\ (x _) x)
			    !() true ':start env)))
;;;;		(fundef-rec-low-result-symbols-place fdr env)
	        (multi-let (((fname fn-flg)
			     (symbol-resolve (Fundef-rec-name fdr) dom true)))
		   (cond (fname
			  (!= (Fundef-rec-name fdr) fname)))
		   (fundef-rec-set-funtype fdr false false (empty-undo-stack)
					   context env)
		   (let ((ftype (Fundef-rec-funtype fdr)))
		      (let ((tif-def false) (callable-def false)
			    (keyword-exp (Fundef-rec-defn fdr)))
		   ;;;;		      (out "fdr = " fdr :%)
			 (repeat :for ((kl = (Exp-with-rel-exp keyword-exp)
					   :then (cddr kl)))
			  :until (null kl)
			    (case (car kl)
			       (:type-inverter (!= tif-def (cadr kl)))
			       (:callable (!= callable-def (cadr kl)))
			       (t
				(note-defective-exp
				   ((k) "Illegal in :function definition: " k)
				   :target (car kl)
				   (:continue "I'll ignore it")))))
			 (let ((tifcn (proc-compile tif-def))
			       (callfcn (proc-compile callable-def))
			       (fun-name (Fundef-rec-name fdr)))
			    (cond ((is-symbolish fun-name)
				   (typedecl fun-name ftype
					     (make-Functional-constant
						:name fun-name
						:type ftype
						:type-inverter tifcn
						:callable callfcn)
					     dom))))))
		   (cond ((not fname)
			  (!= (Fundef-rec-name fdr) fn-flg)))
		   `(:function ,@fun-spec ,fn-flg)))))))

;;; Having more than one field makes sense only if they're symbol lists
;;; with the same polarity (all :all-but or all not).
;;; dom's namespace field is already set to 'namespace', so the
;;; two params are a bit redundant.
(defun exports-parse (exp-fields namespace dom)
   (declare (ignorable dom namespace))
   (cond ((-- +namespace-mode+)
	  (cond ((null exp-fields)
		 (!= (Namespace-exports namespace) ':all)
		 !())
		(t
		 (let-fun ()
		    (multi-let (((mode syms)
				 (harmonize)))
		       (cond ((eq mode ':disharmony)
			      `(,(flagexp "Incoherent :export fields"
					  exp-fields)))
			     (t
			      (let ((old-export-spec (Namespace-exports namespace))
				    (new-export-spec 
				       (cond
					  ((eq mode ':all)
					   ':all)
					  (t
					   (cond ((eq mode ':inclusive) syms)
						 (t `(:all-but ,@syms)))))))
				 (namespace-change-exports
				    namespace old-export-spec new-export-spec)
				 `((:export ,new-export-spec))))))

		  :where
		     (:def harmonize ()
			 (repeat :for ((exp-field :in exp-fields)
				       (mode false)
				       :collector syms)
			  :result (values (cond ((and (eq mode ':all)
						      (not (null syms)))
						 ':disharmony)
						(t mode))
					  syms)
			  :append 
			     (cond ((eq (car exp-field) ':all-but)
				    (try-set-mode ':exclusive)
				    (cdr exp-field))
				   ((eq (car exp-field) ':all)
				    (try-set-mode ':all)
				    (cdr exp-field))
				   (t
				    (try-set-mode ':inclusive)
				    exp-field))
			  :where
			    (:def try-set-mode (m)
			       (cond ((not mode)
				      (!= mode m))
				     ((not (eq mode m))
				      (!= mode ':disharmony))))))))))
	 ((not (null exp-fields))
	  `(,(flagexp "Allowed only in namespace mode"
		      exp-fields)))))

(defvar stream-being-synchecked* "")

; Used to extract args from parsed expressions.  l may contain junk,
; but already flagged and therefore harmless.
(defun get-arg-or-empty (n l)
   (cond ((null l) '())
	 ((eq (car l) n) (cadr l))
	 ((null (cdr l)) '())
	 (t (get-arg-or-empty n (cddr l)))))

(defun conjoin (e1 e2)
   (cond ((car-eq e1 'and)
	  `(and ,@(cdr e1) ,@(cond ((car-eq e2 'and)
				    (cdr e2))
				   (t
				    `(,e2)))))
	 ((car-eq e2 'and)
	  `(and ,e1 ,@(cdr e2)))
	 (t
	  `(and ,e1 ,e2))))

(defun note-bad-inits (badinits flg)
  (cond ((null badinits)
         flg)
        (t
         (flagexp
             (with-output-to-string (srm)
                (format srm "Domain var(s) bound to object of wrong type ")
                (dolist (bi badinits)
                   (format srm "~s ~s (want ~s)/ "
                           (Domain-var-name bi)
                           (Domain-var-val bi)
                           (Domain-var-type bi))))
             flg))))

(defun note-decl-problems (duplicate-names badtypes flg)
   (cond ((not (null duplicate-names))
          (setq flg (flagexp
                        (with-output-to-string (srm)
                           (format srm "Attempt to redeclare existing names ")
			   (dolist (dup duplicate-names)
                              (format srm "~s (domain: ~s)// "
                                      (Domain-bdg-sym dup)
                                      (Domain-name (Domain-bdg-domain dup)))))
                        flg))))
   (cond ((null (null badtypes))
          (setq flg (flagexp
                       (format nil "Bad types: ~s " badtypes)
                       flg))))
   flg)

(defun maybe-wrap-with-ill-formed (exp ill-formed-exps)
   (cond ((null ill-formed-exps) exp)
	 (t (new-Flagged-subexpression exp ill-formed-exps))))

;; It's a pity we have to run typechecking at "run time", or rather a
;; pity we don't save the information from earlier type check.
(defun recover-type (term target-type env)
   (let ((te (term-check-and-tidy
		term target-type '()
		(opt-syn-context term '())
		env)))
;;;;      (cond ((> (Typed-exp-totbugs te) 0)
;;;;	     (signal-problem recover-type
;;;;		(:before-break (dbg-save te))
;;;;		"Routine term-check rerun found bugs: "
;;;;		te
;;;;		(:novalue "I'll ignore the bugs"))))
      (Typed-exp-type te)))

(defun symbol->actual-global-name (sym sort)
   (cond (web-mode*
	  (cond ((or (eq sort ':problem)
		     (null uri-loading-stack*)
		     (eq (uri-scheme (car uri-loading-stack*))
			 ':file))
		 sym
;;;;		 (signal-problem symbol->actual-global-name
;;;;		    "Can't translate " sym " to uri, because uri-loading-stack*"
;;;;		    " is empty")
		 )
		(t
		 ;; sort = :domain
		 (let ((uri (intern-uri
			       (merge-uris
				  (make-instance 'uri
				     :query (out (:to :string)
					       "ontol=" 
					       (:a (symbol-name sym))))
				  (car uri-loading-stack*))
			       opt-uri-space*)))
		    (uri-place-opt-name uri sym)))))
	 (t sym)))

