(in-package :user)

#| turn 
(approved |http://www.mastercard.com| 
	  |http://www.monsterbank.com/customer999/mc| 200)
into
<rdf:Description about="http://mastercard.com">
  <credit:approved>
   <rdf:description about "...999/mc"><etc> 200</etc>
   </description>
  </approved>
</description>

|#

;;; some utils stolen from elsewhere

(defmacro concat (&rest strings)
  `(concatenate 'string ,@strings))


(defun char-from-string (char-str)
  (if (stringp char-str)
    (elt char-str 0) ;; char from string length 1
    #\  ))

(defun substringp (str1 str2 &optional (test #'char-equal))
  (loop for i from 0 to (1- (length str2))
      do (if (loop for j from 0 to (1- (length str1))
		 for ij from i
		 unless (funcall test (elt str1 j) (elt str2 ij))
		 do (return nil)
		 finally (return t))
	     (return i))))

(defun some-substringp (str1 strlist &optional (test #'char-equal))
  (let ((first-chars (mapcar #'(lambda (str) (elt str 0)) strlist)))
    (loop for i from 0 to (1- (length str1))
	for ch = (elt str1 i)
	for stri = (position ch first-chars :test test)
	when stri
	do (let ((str2 (nth stri strlist)))
	     (if (loop for j from 0 to (1- (length str2))
		     for ij from i
		     unless (funcall test (elt str2 j) (elt str1 ij))
		     do (return nil)
		     finally (return t))
		 (return i))))))



(defun string-prefixp (prefix string &optional (test #'char-equal))
  (loop for j from 0 to (1- (length prefix))
      unless (funcall test (elt prefix j) (elt string j))
      do (return nil)
      finally (return t)))

(defparameter *resource-substrings* '(":" "//" "#"))


(defun resourcep (exp)
  (and (or (stringp exp) (symbolp exp))
       (let ((str (if (stringp exp) exp (symbol-name exp))))
	 (some-substringp str *resource-substrings*))))

;;;; top fn - wraps it in <RDF> form, as a whole file
;;;; takes a list of predicate forms
(defun preds-to-rdf (forms &optional (stream t))
  (format stream "<rdf:RDF xml:lang=\"en\"~%~
~3Txmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"~%~
~3Txmlns:rdfs=\"http://www.w3.org/2000/01/rdf-schema#\"~%~
~3Txmlns:daml=\"http://www.daml.org/2001/03/daml+oil#\"~%~
~3T>~%" )
  (dolist (form forms) (pred2rdf form stream))
  (format stream "</rdf:RDF>~2%")
  )

;;; for now. 
(defun resource-string (thing)
  (cond ((stringp thing) thing)
	((symbolp thing) (symbol-name thing))
	((numberp thing) thing)
	(t (format nil "~a" thing))))

#|
(p a) -> <rdf:description rdf:about=a> <rdf:type resource=p></description>


<rdf:Description about="http://mastercard.com">
  <credit:approved>
   <rdf:description about "...999/mc"><etc> 200</etc>
   </description>
  </approved>
</description>

(P a b c) -> (P (etc a (etc b c))) -> (D a [P (D b [etc c]]]
(P a b c d) -> (D a [P [etc b [c [etc d]]]] 
|#

;;; do one predicate like (P a b c)
;;; will need some work to do AND, OR, NOT, IF...

(defun pred2rdf (form &optional (stream t) (indent 0))
  (format stream "~VT<rdf:Description rdf:about=~s>~%" 
	  indent (resource-string (second form)))
  (let ((ind2 (+ 2 indent))
	(pred (resource-string (car form))))
    (cond ((null form) nil)
	  ((not (consp form)) (resource-string form)) ;; this shouldnt happen
	  ((null (cddr form))  ;; (p a)  -> <rdfs:type rdf:resource=class>  - 'A' better be a resource!
	   (format stream "~VT<rdfs:type rdf:resource=~s>~%"
		   ind2 (resource-string pred)))
	  ((null (cdddr form)) ;; (p a b) -> <pred resource=b> or <pred>b</pred>
	   (cond ((resourcep (third form))
		  (format stream "~VT<~a rdf:resource=~s>~%"
			  ind2 (resource-string pred)
			  (resource-string (third form))))
		 ((consp (third form)) 
		  (longprop2rdf pred (third form) ind2 stream))
		 (t (format stream "~VT<~a>~s</~a>" ind2 pred (resource-string (third form)) pred)
	      )))
	  (t (longprop2rdf pred (etc-args (cddr form)) ind2 stream)) ; cddr should have 2 at least
	  )		
    (format stream "~&~VT</rdf:Description>" indent)
  ))

;;; generates <pred>\newline..stuff..\newline</pred>
(defun longprop2rdf (pred form ind stream)
  (format stream "~VT<~a>~%" ind pred)
  (pred2rdf form (+ 2 ind) stream)
  (format stream "~%~VT</~a>~%" ind pred)
  )


;;; args (a b c) -> (etc a (etc b c))
(defun etc-args (restargs)
  (list "ctl:etc" (first restargs)
	(if (null (cddr restargs)) (second restargs)
	  (etc-args (cdr restargs)))))




