;-*- Mode: Common-lisp; Package: opt; Readtable: ytools -*-
(in-package :opt)
;;; $Id: process.lisp,v 1.13 2004/04/30 13:35:47 dvm Exp $

; Parser of processes and durative actions

(depends-on %module/ ytools %ytools/ nilscompat)

(depends-on :at-run-time %opt/ action more-syntax syntax basics types
			 %lisplang/ typecheck flagsource)

(eval-when (:compile-toplevel :load-toplevel :execute :slurp-toplevel)
   (export '(at start end over all when)))

(datafun field-extractor :process
   (defun :^ (defn)
      (multi-let (((items bad-keyword-flg)
		   (keyword-list-smooth
		      defn
		      '(:vars :condition
			:start-effect :effect :stop-effect
			:only-in-expansions)
		      '(:effect))))
	 (values items
		 bad-keyword-flg))))

(datafun field-checker :process
   (defun :^ (fctn-form fdr items undo-stack context proc-env)
      (let ((step-type (Fundef-rec-low-result fdr))
	    (ustack undo-stack)
	    (meth-varbdgs !()) vars-flg
	    condition start-effect effect stop-effect maintain 
	    (inner-env proc-env)
	    (dom (find-domain-in-vartypes proc-env)))
	 (!= < meth-varbdgs inner-env vars-flg >
	     (causation-vars-parse items proc-env))
	 (!= < condition ustack >
	     (cond-field-parse ':condition items 'true ustack context inner-env))
	 (!= < start-effect ustack >
	     (effect-parse ':start-effect items false ustack context inner-env))
	 (!= < effect ustack >
	     (effect-parse ':effect items false ustack context inner-env))
	 (!= < stop-effect ustack >
	     (effect-parse ':stop-effect items step-type ustack context inner-env))
	 (values 
	    (list (tuple ':vars meth-varbdgs)
		  (tuple ':condition condition)
		  (tuple ':start-effect start-effect)
		  (tuple ':effect effect)
		  (tuple ':stop-effect stop-effect)
		  (tuple ':maintain maintain))
	    (let ((flagged-def
		     `(:process ,@fctn-form
;;;;			    ,@bad-keyword-flg
			    ,@(surface-vars-decl meth-varbdgs  vars-flg proc-env)
			    :condition ,(flagsource condition)
			    :start-effect ,(flagsource start-effect)
			    :effect ,(flagsource effect)
			    :stop-effect ,(flagsource stop-effect)
			    ,@(cond (maintain `(:maintain ,maintain))
				    (t !())))))
	       (cond ((domain-declares-requirement dom ':processes)
		      flagged-def)
		     (t
		      (new-Flagged-subexpression
			 flagged-def
			 (simple-ill-formed-exp
			    !"Illegal for ~
			      domain not declaring :processes"
			    false)))))
	    meth-varbdgs ustack))))

(datafun causation-definer :process
   (defun :^ (fdr field-alist vars-bdgs env)
      (let ((fctn (Fundef-rec-name fdr))
	    (dom (find-domain-in-vartypes env)))
	 (let ((fbdg (place-domain-bdg fctn dom))
	       (defn (make-Process-defn
			   :function fctn
			   :term (fundef-rec-term fdr env)
			   :varbdgs (fdr-low-arg-vartypes fdr vars-bdgs env)
			   :condition
			      (alref field-alist ':condition)
			   :start-effect
			      (alref field-alist ':start-effect)
			   :effect
			      (alref field-alist ':effect)
			   :stop-effect
			      (alref field-alist ':stop-effect))))
	       (bind-causation-function
		  fbdg fctn
		  (Fundef-rec-funtype fdr)
		  defn)))))

;;; NOT CURRENTLY USED
(defun actions-or-processes-parse (whatever parser dom)
   (let ((mr (own-rule-group dom)))
      (multiple-value-bind (whatever flg)
			   (list-smooth whatever #'consp)
	  (let ((flg-al '()))
	     (dolist (a whatever)
		(multiple-value-bind (flg-a defn)
				     (funcall parser a dom)
		   (push flg-a flg-al)
		   (cond (defn
			  ;; This may be silly, but hopefully harmless
			  (add-to-rule-group defn mr)))))
	     `(,@(reverse flg-al)
	       ,@flg)))))

(datafun field-extractor :durative-action
   (defun :^ (defn)
      (multi-let (((items bad-keyword-flg)
		   (keyword-list-smooth
		      defn
		      '(:vars :duration :condition :effect)
		      '(:duration :effect))))
	 (values items bad-keyword-flg))))

(datafun field-checker :durative-action
   (defun :^ (fctn-form fdr items undo-stack context dur-env)
      (let ((step-type (Fundef-rec-low-result fdr))
	    (ustack undo-stack)
	    (meth-varbdgs !()) vars-flg
	    duration condition effect
	    (inner-env dur-env)
	    (dom (find-domain-in-vartypes dur-env)))
	 (!= < meth-varbdgs inner-env vars-flg >
	     (causation-vars-parse items dur-env))
	 (let ((dur-field (alref items ':duration)))
	    (cond (dur-field
		   (!= < duration ustack >
		       (duration-check
			  dur-field ustack
			  (context-expstack-push
			     dur-field ':duration context)
			  inner-env)))
		  (t
		   (!= duration
		       (new-Const-typed-exp 'true bool-type* 'true dur-env)))))
	 (let ((cnd-field (alref items ':condition)))
	    (cond (cnd-field
		   (!= < condition ustack >
		       (durative-cond-check cnd-field ustack
					    (context-expstack-push
					       cnd-field ':condition context)
					    inner-env)))
		  (t
		   (!= condition
		       (new-Const-typed-exp 'true bool-type* 'true dur-env)))))
	 (let ((eff-field (alref items ':effect)))
	    (cond (eff-field
		   (!= < effect ustack >
		       (durative-eff-check 
			  eff-field step-type undo-stack
			  (context-expstack-push
			     eff-field ':effect context)
			  inner-env)))
		  (t
		   (!= < effect ustack >
		       (new-Const-typed-exp 'true bool-type* 'true inner-env)))))
	 (values (list (tuple ':vars meth-varbdgs)
		       (tuple ':duration duration)
		       (tuple ':condition condition)
		       (tuple ':effect effect))
		 (let ((flagged-def
			  `(:durative-action ,@fctn-form
;;;;			      ,@bad-keyword-flg
			      ,@(surface-vars-decl meth-varbdgs vars-flg dur-env)
			      :duration ,(flagsource duration)
			      :condition ,(flagsource condition)
			      :effect ,(flagsource effect))))
		    (cond ((domain-declares-requirement dom ':processes)
			   flagged-def)
			  (t
			   (new-Flagged-subexpression
			      flagged-def
			      (simple-ill-formed-exp
				 !"Illegal for ~
				   domain not declaring :processes"
				 false)))))
		 meth-varbdgs ustack))))

(datafun causation-definer :durative-action
   (defun :^ (fdr field-alist vars-bdgs env)
      (let ((fctn (Fundef-rec-name fdr))
	    (dom (find-domain-in-vartypes env)))
	 (let ((fbdg (place-domain-bdg fctn dom))
	       (defn (make-Durative-action-defn
			:function fctn
			:term (fundef-rec-term fdr env)
			:varbdgs (fdr-low-arg-vartypes fdr vars-bdgs env)
			:condition (alref field-alist ':condition)
			:effect (alref field-alist ':effect)
			:duration (alref field-alist ':duration))))
	    (bind-causation-function
	       fbdg fctn
	       (Fundef-rec-funtype fdr)
	       defn)))))

(def-class Durham-timed-typed-exp
    (:options (:include Typed-exp))
    time-spec ;; '(at start)', '(at end)', '(over all)'
    term  ;; Typed-exp
  (:handler
     (initialize :before ((dtte Durham-timed-typed-exp))
;;;;	(dbg-save dtte)
;;;;	(breakpoint dtte-initializer "Before initialization")
	(slot-defaults dtte
		       flag 'durham-thing
		       source `(,@(Durham-timed-typed-exp-time-spec dtte)
				,(Typed-exp-source
				    (Durham-timed-typed-exp-term dtte)))
		       subexps (list (Durham-timed-typed-exp-term dtte))
		       type (Typed-exp-type
			        (Durham-timed-typed-exp-term dtte)))))
  )

(def-meth show-header ((dtte Durham-timed-typed-exp))
   (let ((ts (Durham-timed-typed-exp-time-spec dtte)))
      (out (:a (string-capitalize (symbol-name (car ts))))
	   1 (cadr ts) ":")))

(def-meth show ((dtte Durham-timed-typed-exp))
  (out (:i> 3)
       (:e (show (Durham-timed-typed-exp-term dtte)))))

(def-meth flagsource ((dtte Durham-timed-typed-exp))
   `(,@(Durham-timed-typed-exp-time-spec dtte)
     ,(flagsource (Durham-timed-typed-exp-term dtte))))

;;; Returns a Typed-exp + undo-stack.
;;; The Typed-exp is always a conjunction of (in)equalities on
;;; the 'duration' variable.
(defun duration-check (exp undo-stack con env)
   (match-cond exp
      ?( (and ?@conjl)
	(repeat :for ((conj :in conjl)
		      (i = 1 :by 1)
		      (ustack undo-stack)
		      cte
		      :collectors dtel)
	   (!= < cte ustack >
	       (duration-check conj ustack
			       (context-expstack-push
				  conj 1 con)
			       env))
	 :collect cte
	 :result (values (typed-exps-conjoin dtel env)
			 ustack)))
      ?( (?(:& ?op ?(:\| = =< <= >=))
	  ?dvar ?dval)
	(cond ((not (or (eq dvar 'duration)
			(and (is-Qvar dvar)
			     (eqn (Qvar-sym dvar)
				  'duration))))
;;;;	       (dbg-save dvar)
;;;;	       (breakpoint duration-check
;;;;		  "bad dvar = " dvar)
	       (note-defective-exp ((_)
				    "Illegal duration variable "
				    dvar)
		  :place duration-check)))
	(multi-let (((val-te undo-stack-1)
		     (term-check dval num-type* undo-stack
				 (context-expstack-push
				    dval 2 con)
				 env)))
	   (values
	      (build-simple-app
		 op (list (make-inst Var-typed-exp
			      :var 'duration
			      :qvar false
			      :source 'duration
			      :ext 'duration
			      :type float-type*
			      :env env
			      :binder false
			      :argspec false
			      :check-time-callable false)
			  val-te)
		    (list num-type* num-type*)
		    exp prop-type* env)
	      undo-stack-1)))
      (t
       (note-defective-exp
		     ((_) "Ill-formed duration constraint "
			  exp)
	  :place duration-check))))

;;; The official grammar *requires* a Fox-Long modality.
;;; We liberalize this to allow (over all P) to be written just P.
(defun durative-cond-check (exp undo-stack con env)
   (term-check exp prop-type* undo-stack
	       (cons-Syn-context
		   (tuple ':polarity false)
		   (cons-context-with-foxlong-modalities
		       '((at start) (over all) (at end))
		       con))
	       env))

(defun durative-eff-check (exp step-type undo-stack con env)
   (effect-check exp step-type undo-stack
		 (cons-context-with-foxlong-modalities
		     '((at end) (at start))
		     con)
		 env))

;;; These form handlers work around the clumsiness about the definitions of
;;; 'at' and 'over'.

(def-opt-form-handler at term-checker
		      (term target-type undo-stack context mvartypes)
   (match-cond term
      ?( (at ?(:& ?which ?(:\| start end))
	     ?p)
	(cond ((and (eq target-type prop-type*)
		    (foxlong-context-permits `(at ,which) context))
	       (multi-let (((te undo-stack-1)
			    (term-check
			       p prop-type* undo-stack
			       (context-push-and-cons-foxlong-modalities
				   p 2 !() context)
			       mvartypes)))
		  (values
		     (make-inst Durham-timed-typed-exp
			:time-spec `(at ,which)
			:term te
			:env mvartypes)
		     undo-stack-1)))
	      (t
	       (functional-term-check
		  term target-type undo-stack context mvartypes))))
      (t
       (functional-term-check
	term target-type undo-stack context mvartypes))))

(def-opt-form-handler over term-checker
		      (term target-type undo-stack context mvartypes)
   (match-cond term
      ?( (over all ?p)
	(cond ((and (eq target-type prop-type*)
		    (foxlong-context-permits '(over all) context))
	       (multi-let (((te undo-stack-1)
			    (term-check
			       p prop-type* undo-stack
			       (context-push-and-cons-foxlong-modalities
				  p 2 !() context)
			       mvartypes)))
		  (values
		     (make-inst Durham-timed-typed-exp
			:time-spec '(over all)
			:term te
			:env mvartypes)
		     undo-stack-1)))
	      (t
	       (functional-term-check
		  term target-type undo-stack context mvartypes))))
      (t
       (functional-term-check
	  term target-type undo-stack context mvartypes))))

;;; This is here only because it must be sensitive to Durham issues.
(def-opt-form-handler when term-checker
		      (exp target-type undo-stack context env)
   (match-cond exp
      ?( (when ?precond ?eff)
	(let ((eff-con (syn-context-lookup context 'action-context)))
	(multi-let (((pcte undo-stack-1)
		     (term-check
			precond prop-type* undo-stack
			(context-push-and-cons
			    precond 1
			    'action-context 'condition
			    (context-polarity-flip context))
			env)))
	   (multi-let (((whente undo-stack-2)
			(if-check-after-ante 'when pcte eff 'true exp target-type
					     undo-stack-1 context env)))
	      (cond ((foxlong-time-earlier
		        (earliest-foxlong-time
			   (If-typed-exp-iftrue whente))
			(latest-foxlong-time pcte))
		     (note-bugs whente
			(list (simple-ill-formed-exp
			         !"'when' antecedent refers to time after ~
                                   consequent"
				 exp)))))
	      (cond ((or (not eff-con)
			 (not (eq (cadr eff-con) 'effect)))
		       (note-bugs whente
			  (list (simple-ill-formed-exp
				   "'when' allowed only in action effect: "
				   exp)))))
	      (values whente undo-stack-2)))))
      (t
       (values
	  (ill-formed-typed-exp exp target-type env)
	  undo-stack))))

(defun latest-foxlong-time (te)
   (cond ((is-Durham-timed-typed-exp te)
	  (match-cond (Durham-timed-typed-exp-time-spec te)
	     ?( (at ?which)
	       which)
	     (t 
	      'end)))
	 ((eq (Typed-exp-type te) prop-type*)
	  (repeat :for ((sub :in (Typed-exp-subexps te))
			(latest 'start))
	     (let ((subtime (latest-foxlong-time sub)))
	        (cond ((foxlong-time-earlier latest subtime)
		       (!= latest subtime))))
	   :result latest))
	 (t false)))

(defun earliest-foxlong-time (te)
   (cond ((is-Durham-timed-typed-exp te)
	  (match-cond (Durham-timed-typed-exp-time-spec te)
	     ?( (at ?which)
	       which)
	     (t 
	      'start)))
	 ((eq (Typed-exp-type te) prop-type*)
	  (repeat :for ((sub :in (Typed-exp-subexps te))
			(earliest 'stop))
	     (let ((subtime (earliest-foxlong-time sub)))
	        (cond ((foxlong-time-earlier subtime earliest)
		       (!= earliest subtime))))
	   :result earliest))
	 (t false)))
	     
(defun foxlong-time-earlier (flt1 flt2)
   (memq flt2 (cdr (memq flt1 '(start mid stop)))))

(defun foxlong-context-permits (time-spec context)
   (let ((p (syn-context-lookup context 'foxlong)))
      (and p (member time-spec (cadr p) :test #'equal))))
	  
(defun context-push-and-cons-foxlong-modalities (e k modl context)
   (context-push-and-cons e k 'foxlong-modalities modl context))

(defun cons-context-with-foxlong-modalities (time-specs context)
   (cons-Syn-context (tuple 'foxlong time-specs)
		     context))

(defun build-simple-app (fcn-name arg-tel arg-types source
			 target-type mvartypes)
   (simple-app-typed-exp 
      (simple-var-typed-exp fcn-name mvartypes)
      arg-tel arg-types source target-type mvartypes))
 

