;-*- Mode: Common-lisp; Package: opt; Readtable: ytools; -*-
(in-package :opt)
;;; $Id: qagprint.lisp,v 1.4 2004/03/08 12:29:53 dvm Exp $

(depends-on :at-run-time %hacks/ dagprint %opt/ deduction)

;;;;(def-class qag-occ qag gen-id)

(defun qag-children (recent)
   (\\ (qag)
      (repeat :for ((qc :in (Query-answer-gen-body qag))
		    (gen-id (Query-answer-gen-gen-id qag))
		    (children-explored !()))
       :nconc (query-conjunction-children qag qc)

       :where
          (:def query-conjunction-children (sub-qag qc)
;;;;	     (trace-around query-conj-children
;;;;		(:> "(query-conj-children: " qc ")")
	     (let ((first-step (Query-conjunction-first qc)))
		(cond ((and (or (not recent)
				(= (Query-answer-gen-gen-id first-step)
				   gen-id))
			    (not (memq first-step children-explored)))
		       (on-list first-step children-explored)
;;;;		       (out qc " has "
;;;;			    (len (Query-answer-gen-continuations first-step))
;;;;			    " continuations"
;;;;			    :%)
		       (cons first-step
			     (repeat :for ((dc :in (Query-answer-gen-continuations
						       first-step)))
			      :when (eq (Deductive-continuation-super-ag dc)
					sub-qag)
			      :nconc (succ-children sub-qag dc))))
		      (t
;;;;		       (out "recent = " recent
;;;;			    " gen-id = " (Query-answer-gen-gen-id first-step)
;;;;			    :%)
		       !())))
;;;;		(:< (val &rest _) "query-conj-children: " val))
	     )

          (:def succ-children (sub-qag ded-cont)
;;;;		(trace-around succ-children
;;;;		   (:> "(succ-children: " ded-cont ")")
		(repeat :for ((succ :in (Deductive-continuation-succs ded-cont)))
		 :when (is-Query-conjunction (second succ))
		 :nconc (query-conjunction-children sub-qag (second succ)))
;;;;		   (:< (val &rest _) "succ-children: " val))
		))))

(defvar qag-print-id* 0)

(defun qag-display (sit)
   (\\ (pdn)
      (let ((qag (Printable-DAG-node-node pdn))
	    (pdn-id
	       (or (Printable-DAG-node-id pdn)
		   (cond ((> (Printable-DAG-node-cycle pdn) 0)
			  (!= qag-print-id* (+ *-* 1))
			  (!= (Printable-DAG-node-id pdn) qag-print-id*)
			  qag-print-id*)
			 (t false)))))
	 (let ((qag-id (Query-answer-gen-var-id qag))
	       (conts (Query-answer-gen-continuations qag))
	       (ans-spec (cond (sit (place-query-answers qag sit))
			       (t false))))
	    (let ((answers (cond (sit (Query-ans-spec-answers ans-spec))
				 (t (Query-answer-gen-answers-somewhere qag))))
		  (leftovers (list-copy conts)))
	       (out
		  (:e (:stream srm)
		     (let-fun ()
			(:o (:q (pdn-id "[" pdn-id "]: "))
			    (Query-answer-gen-query qag)
			    (:q ((Query-answer-gen-var-id qag)
				 "/" qag-id))
			    1 (Query-answer-gen-status qag)
			    :% "Answers"
			    (:q (sit
				 (:q ((not (eq (Query-ans-spec-status ans-spec)
					       ':answers-found))
				      "[" (Query-ans-spec-status ans-spec) "]"))
				 ": " :%
				 (:q ((Query-ans-spec-many ans-spec)
				      "(many) "
				      (:e (display-continuations ':many nil false))))
				 (:q ((null answers)
				      (:e (display-continuations ':none nil false)))
				     (t
				      (:e (repeat :for ((a :in answers))
					     (display-continuations
					        (first a) (second a) false)))))
				 (:q ((assq (Query-answer-gen-occ qag) answers)
				      (:_ 8) "(perfect)" :%)))
				(t
				 " in some situation:" :%
				 (display-continuations ':many nil true)
				 (display-continuations ':none nil true)
				 (:e (repeat :for ((a :in answers))
					(display-continuations
					   (first a) (second a) false)))))
			    (:q ((not (null leftovers))
				 "Continuations unlinked with answers: "
				 :%
				 (:e (repeat :for ((cont :in leftovers))
					(:o (:q ((Deductive-continuation-sense
						    cont)
						 " ->")
						(t
						 " ~>"))
					    (Query-answer-gen-query
					       (Deductive-continuation-super-ag cont))
					    " given " (len (Query-conjunction-remaining
							      (Deductive-continuation-qconj
							         cont)))
					    " step(s)" :%))))))
 :where
    (:def display-continuations (ansocc ansenv only-if-exists)
	    (let ((a-conts (<? (\\ (c)
				  (assq ansocc (Deductive-continuation-succs c)))
			       conts)))
	       (cond ((not (and only-if-exists (null a-conts)))
		      (out (:to srm)
			 ansocc 1 ansenv 
			 (:q ((null a-conts)
			      " No continuations" :%)
			     (t
			      (:i> 2)
			      (:e (repeat :for ((ac :in a-conts))
				     (repeat :for ((succ :in (Deductive-continuation-succs
							        ac))
						   (super-qag
						      (Deductive-continuation-super-ag
							 ac))
						   (qc-id (Deductive-continuation-qc-id ac))
						   (ans-so-far
						       (Deductive-continuation-ans-so-far
							     ac)))
				      :when (eq (first succ) ansocc)
					(!= leftovers (delete ac *-*))
					(multi-let (((consis adv-env)
						     (cont-env-advance
						        ansocc ansenv qag-id ac)))
					   (:o :%  
					       (:q ((Deductive-continuation-sense
						       ac)
						    " ->")
						   (t
						    " ~>"))
					       (:q ((not consis)
						    " ??"))
					       " ["
					       (debug-varsubst
						   (Query-answer-gen-query super-qag)
						   (Query-answer-gen-var-id super-qag)
						   adv-env)
					       "] after "
					       (debug-varsubst
						  (Query-conjunction-remaining
						     (Deductive-continuation-qconj ac))
						  qc-id adv-env)
					       :%))))))))))))))))))))

(defun qag-down-print (pdn)
   (let ((qag (Printable-DAG-node-node pdn)))
      (out "[" (Query-answer-gen-query qag) "]")))

(defun qag-up-print (parents _)
   (cond ((not (null parents))
	  (out 2
	       (:e (repeat :for ((p :in parents))
		      (:o "^" (Query-answer-gen-query
			          (Printable-DAG-node-node p)))))))))

(defun qag-cycle-print (pdn)
   (let ((anc (Printable-DAG-node-ancestor pdn)))
      (let ((ancid (Printable-DAG-node-id anc)))
	 (out "[^^ " (:q (ancid ancid)
			 (t "??"))
	      "]" :%))))

(defun qag-indent (i)
   (node-indent-dot-printer i)
   (* 3 i))

;;;;(defvar qag-struct-spec*)
;;;;(defvar qag-print-spec*)

;;;;(setq qag-struct-spec*
;;;;	     (make-DAG-struct-spec #'qag-children))
;;;;
;;;;(setq qag-print-spec*
;;;;     (make-inst DAG-print-spec
;;;;		:direct-printer #'qag-display
;;;;		:down-printer #'qag-down-print
;;;;		:up-printer #'qag-up-print
;;;;		:cycle-printer #'qag-cycle-print
;;;;		:indent-printer #'qag-indent))

;;;;		:indent-printer #'qag-indent

;;; If 'sit' is false, display structure of reductions and answers
;;; available somewhere.
;;; Otherwise, 'sit' is a situation, which had better be the one in effect
;;; during the last deduction (the one that set the gen-id's of all relevant
;;; Query-answer-gen's).  The display is limited to nodes and answers from
;;; that deduction.
(defun qag-print (topnode sit)
   (bind ((qag-print-id* 0))
      (dag-print (list topnode)
		 (make-DAG-struct-spec (qag-children sit))
		 (make-inst DAG-print-spec
		    :direct-printer (qag-display sit)
		    :down-printer #'qag-down-print
		    :up-printer #'qag-up-print
		    :cycle-printer #'qag-cycle-print
		    :indent-printer #'qag-indent))))
