;-*- Mode: Common-lisp; Package: opt; Readtable: ytools; -*-
(in-package :opt)
;$Id: qapply.lisp,v 1.5 2006/08/24 13:53:02 dvm Exp $

#|
 The most complex unifier is the one for 'apply', because
 (apply ?f ...) can match almost anything.  The trickiest part 
 is to come up with a single unifier in spite of the fact that
 in general there are an infinite number of them.  The one we
 pick must in some sense be "natural," but must also satisfy a
 symmetry property, namely, that there is no equally good one 
 obtained by switching the two unificands.  So in
    (apply ?f a)
    (apply ?g b)
 we can't return f = (\\ (x) x), g = (\\ (_) a), because
 reversing the roles of f and g would work just as well.  Instead,
 we should prefer f = g = (\\ (_) ?w), where 'w' is a 
 new variable.  
 But cf. (apply ?f (list a a)) vs. (apply ?g a).  Good result
 is g = (\\ (x) (apply ?f (list x x))).  
 In general, if we can find instances in side S of args from side T, 
 then we should try to view T as abstraction of S.  But watch out 
 for symmetry!  E.g., 
    (apply ?f a (list b b)) vs. (apply ?g b (list a a))
 No reason to abstract one way instead of the other, so we must
 fall back on f = g = (\\ (_ _) ?w)
 Note that key case is 'apply' with a variable as function. 
 In general, it may take some transformations to put the variable there. 
 E.g., (apply ((apply ?g ?l) ?x) (list ?x b))
 should be thought of as (apply ?g1 (cons ?l (cons ?x (list ?x b)))),
 with g = (\\ (&rest l) 
             (\\ (x)
                (\\ (&rest m) (apply ((apply ?g1 l) x) m))))

In general, we beta-reduce or apply this transformation until 
either 'apply' is eliminated or it fits one of these patterns:
    (apply lambda-exp non-list)
    (apply variable arg)
    (apply term arg), where term is not variable or lambda-exp
(If lambda-exp is applied to list, as in
    (apply (lambda (x y) b) (cons ?u ?l)), 
we can beta-reduce to (apply (lambda (y) b) ?l) with x = ?u.
Or (apply (lambda (&rest r) b) (cons ?u ?l))
    => b, with r = (cons ?u ?l).)

We now have 9 cases, because each pattern can occur in left or right
arg to unify.  Symmetry occurs when same case on both sides.
|#

(depends-on %module/ ytools nity)

(depends-on (:at :run-time) %opt/ qunify qexp-classes)

;;; 'head' is a function; 'args' has one element, a list.
;;; Because a general function has args of type &rest l -- ?u,
;;;; we can match any functional term with (apply ?f ?l).
(let-fun ()
   (def-qexp-class apply
      :upriority 70
      :long true
      :unify-handler
	 (\\ (app exp aid eid env)
	    (multi-let (((reduced body body-id env)
			 (apply-try-reduce app aid env)))
	       (cond (reduced
		      ;; Not necessarily an apply any more
		      (pat-unify body exp body-id eid env))
		     (t
		      (unify-fcns-and-args app exp aid eid env))))))

      :variant-handler
	 (\\ (app qexp app-id q-id pairings env)
	    (cond ((eq (Qexp-classname qexp) ':apply)
		   (multi-let (((heads-variants pl1 d)
				(qexp-variants (Long-Qexp-head app)
					       (Long-Qexp-head qexp)
					       app-id q-id pairings env)))
		      (cond (heads-variants
			     (qexp-variants
				(head (Long-Qexp-args app))
				(head (Long-Qexp-args qexp))
				app-id q-id pl1 env))
			    (t
			     (values false pl1 d)))))
		  (t
		   (values false pld1 discrim-bdgs*))))

      :occur-checker
	 (\\ (var a-qexp v-id q-id env)
	    (let ((h-res (occur-check var (Long-Qexp-head a-qexp) v-id q-id env))
		  (args (Long-Qexp-args a-qexp)))
	       (case h-res
		  (*self '*circular)
		  ((*circular *has-boundvars) h-res)
		  (t
		   (cond ((listp (first args))
			  h-res)
			 (t
			  (let ((a-res (occur-check
					  var (first args) v-id q-id env)))
			     (occur-check-res-combine h-res a-res))))))))
      :sexp-maker
	 (\\ (app)
	    `(apply ,(Qexp-sexp (Long-Qexp-head app))
		    ,(Qexp-sexp (first (Long-Qexp-args app))))))

   :where

 (:def unify-fcns-and-args (app exp aid eid env)
    (let ((eclass (Qexp-classname exp))
	  (fcn (Long-Qexp-head app)))
       (multi-let (((f-ok f-env)
		    (qexp-unify fcn
				(cond ((eq eclass ':list)
				       (ensure-list-fcn-qexp))
				      (t
				       (Long-Qexp-head exp)))
				aid eid env)))
	  (cond (f-ok
		 (let ((list-type (fun-result-tup-type fcn))
		       (exp-len (Long-Qexp-length exp))
		       (exp-freevars (Long-Qexp-freevars exp))
		       (exp-args (Long-Qexp-args exp)))
		    (let-fun ()
		       (multi-let (((a-ok a-env)
				    (qexp-unify
				       (first (Long-Qexp-args app))
				       (case eclass
					  (:simple-app
					   (simple-list-exp exp-args))
					  (:simple-rest-app
					   (rest-list-exp))
					  (:simple-key-app
					   (key-list-exp))
					  (:complex-app
					   (cond ((first exp-args)
						  (cond ((consp exp-args)
							 (key-list-exp))
							(t
							 (rest-list-exp))))
						 (t
						  (simple-list-exp
						     (rest exp-args))))))
				       aid eid f-env)))
			  (cond (a-ok
				 (values a-ok a-env))
				(t
				 (get-really-hairy fcn))))

			:where
			  
			  (:def simple-list-exp (args)
			     (make-Long-Qexp
				:handler list-qexp-class*
				:type list-type
				:head empty-list-qexp*
				:args args
				:length exp-len
				:freevars exp-freevars))

			  (:def rest-list-exp ()
			      (make-Long-Qexp
				 :handler list-qexp-class*
				 :type list-type
				 :head (first exp-args)
				 :args (rest exp-args)
				 :length (- exp-len 1)
				 :freevars exp-freevars))

			  (:def key-list-exp ()
			      (make-Long-Qexp
				 :handler list-qexp-class*
				 :type list-type
				 :head empty-list-qexp*
				 :args (key-args-sexp (first exp-args)
						      (rest exp-args))
				 :length (+ (len (first exp-args))
					    exp-len
					    -1)
				 :freevars exp-freevars))

			  (:def get-really-hairy (fcn)
				 ;; Attempt lambda abstraction
				 (cond ((eq (Qexp-classname fcn) ':qvar)
					;; Abstract exp on app args.
					(values false env))
				       ((eq (Qexp-classname fcn) ':binder)
					;; If fcn is a lambda, do
					;; beta-reduction and match
					;; body to exp
					(values false env))
				       (t
					(values false env)))))))
		(t
		 (values false env))))))			   

;; Returns < success, new-expression, varid, 
;;           env with as many vars bound as possible >
 (:def apply-try-reduce (c-app ca-id env)
    (multi-let (((head head-id)
		 (qexp-normalize (Long-Qexp-head c-app) ca-id env)))
       (cond ((eq (Qexp-classname head) ':binder)
	      (let ((head-args (Long-Qexp-args head))
		    (app-arg (first (Long-Qexp-args c-app))))
		 (let ((rest-param (cond ((is-Symbol (second head-args))
					  (second head-args))
					 (t false)))
		       (reg-parms (nthrest 2 head-args)))
		    (let-fun ()
		       (multi-let (((bound-args bound-parms rest-arg)
				    (flatten-as-far-as-possible
				       app-arg reg-parms rest-param)))
			  (let ((num-bound (len bound-parms))
				(lambda-body (first head-args)))
			     (let ((rem-parms (drop num-bound reg-parms ))
				   (red-env
				      (beta-reduction-env
					  (second head-args)
					  bound-parms bound-args
					  head-id env)))
				(cond ((null rem-parms)
				       (values
					  true
					  lambda-body 
					  head-id
					  red-env))
				      (t
				       (leftover-lambda
					  c-app head head-id
					  rem-parms (second head-args)
					  lambda-body rest-args
					  red-env))))))))))
	     (t
	      (values false nil nil nil)))))

(:def flatten-as-far-as-possible (arglist-qe params rest-param)
   (cond ((null params)
	  (values !() !() (and rest-param arglist-qe)))
	 (t
	  (multi-let (((a1 a1-id)
		       (qexp-normalize arglist head-id env)))
	     (cond ((eq (Qexp-classname a1) ':list)
		    (multi-let (((r-al r-pl r-rst)
				 (flatten-as-far-as-possible
				    (list-qexp-tail arglist-qe)
				    (cdr params)
				    rest-param)))
		       (values
			  (cons (car (Long-Qexp-args arglist-qe))
				r-al)
			  (cons (car params) r-pl)
			  r-rst)))
		   (t
		    (values !() !()
			    (and rest-param arglist-qe))))))))

 (:def leftover-lambda (c-app head head-id num-bound rem-parms
			lambda-body rest-args red-env)
    ;; Can't get all the way to body, so package
    ;; remaining parms into a new lambda --
    (values
       true
       (make-Long-Qexp
	  :handler apply-qexp-class*
	  :type (Qexp-type c-app)
	  :head (make-Long-Qexp
		   :handler binder-qexp-class*
		   :head ':lambda
		   :type (funtype-drop-args num-bound (Qexp-type head))
		   :length (- (Long-Qexp-length head)
			      num-bound)
		   :args (lambda-qexp-drop-args
			    head head-id lambda-body rem-parms odd-parms)
		   :freevars (Qexp-freevars head))
	  :length (Long-Qexp-length c-app)
	  :args (list rest-arg)
	  :freevars (nodupq (nconc (list-copy (Qexp-freevars 
				   (repeat :for ((a :in 



	      (let ((binder-args (Long-Qexp-args head)))
		 (match-let (?binder-body ?k-or-r ?@non-r-params)
			    binder-args
		    (values true
			    binder-body
			    (beta-reduction-env
			       k-or-r non-r-params
			       (Long-Qexp-args c-app) 
			       ca-id env)))))
	     (t
	      (values false nil nil)))))

;;; We already know remaining-params is not ().
(defun lambda-qexp-drop-args (lambda-qexp l-id
			      lambda-body remaining-params odd-params)
   (cons lambda-body
	 (cons (cond ((not (is-list odd-params))
		      ;; a &rest arg
		      odd-params)
		     (t
		      ;; Otherwise, the last k of the remaining-params
		      ;; are &key args, where k = (len odd-params)
		      
	       remaining-params)))
	  



   (let ()
      (make-Long-Qexp
         :handler binder-qexp-class*
	 :type 
	 :head ':lambda
         


				     
(defun qexp-list-type (front-exps tail-exp)
   (let-fun ((build-dots (el)
		(cond ((null el) (Qexp-type tail-exp))
		      (t
		       (make-dot-type
			    'Tup
			    (Qexp-type (car el))
			    (build-dots (cdr el))
			    global-opt-env*)))))
      (build-dots front-exps)))


;;;
(defun funtype-drop-args (num funtype)
   (let ((alspec (type-find-feature funtype 'nity::arglist global-opt-env*)))
      (let ((dropped-alspec
	       (new-Arglistspec

      (cond (alspec
	     (make-funtype
	        0 (type-find-feature
		     funtype 'nity::resulttype global-opt-env*)
		
