;-*- Mode: Common-lisp; Package: opt; Readtable: ytools; -*-
(in-package :opt)
;;; $Id: qassertion.lisp,v 1.8 2005/06/11 21:30:46 dvm Exp $

(depends-on %module/ ytools)

(depends-on %opt/ index internalize)

(end-header :continue-slurping)

(eval-when (:compile-toplevel :load-toplevel :execute :slurp-toplevel)
   (export '(fact-internalize assertion-find-and-erase assertion-deduce
	     assertion-add assertion-erase assertion-find-and-erase
)))

(defmacro changing-fact-index (sit^ &rest body)
   (let ((sitvar (gensym))
	 (indvar (gensym)))
      `(let ((,sitvar ,sit^))
	  (let ((,indvar (Initial-situation-init-index ,sitvar)))
	     (unwind-protect
		(progn (!= (Initial-situation-init-index ,sitvar)
			   (Initial-situation-fact-index ,sitvar))
		       ,@body)
		(!= (Initial-situation-init-index ,sitvar)
		    ,indvar))))))

(defmacro with-thawed-situation (sit^ &rest body)
   (let ((sitvar (gensym))
	 (normalvar (gensym)))
      `(let ((,sitvar ,sit^) (,normalvar false))
	  (unwind-protect
	     (progn (!= (Situation-frozen ,sitvar) false)
		    (!= (Situation-contents ,sitvar) '*uncomputed)
		    (multiple-value-prog1
		       (progn ,@body)
		       (!= ,normalvar true)))
	     (progn
		(!= (Situation-frozen ,sitvar) true)
		(cond ((not ,normalvar)
		       (out (:to *error-output*)
			 "Warning -- abnormal exit while situation "
			 ,sitvar " thawed (I've refrozen it)" :%))))))))

; Initialize timeless index of problem with all the timeless facts
; from domain and parent sit.
(defun problem-initialize (prob)
   (situation-initialize (Problem-sit prob))
   (cond ((not (is-Initialized-problem prob))
          (setq prob (make-inst Initialized-problem
                        :name (Problem-name prob)
                        :sit (Problem-sit prob)
                        :goal (Problem-goal prob)
			:metric (Problem-metric prob)
                        :expansion (Problem-expansion prob)
                        :length (Problem-length prob)))
          (set-global-opt-sym (Problem-name prob) prob problem-type*)))
   (setf (Initialized-problem-expanded-goal prob)
         ;;(out (tr ("expand> " (Initialized-problem-goal prob))
         (internalize (Initialized-problem-goal prob)
		      !() ':antecedent)
	 ;;("expand< " (car out-vals*))))
	 )
   prob)

(defvar copy-fact-sit* false)

;;; If non-false, a function to be used to complete a situation, typically
;;; by doing stuff to its 'more' field.
(defvar sit-init-completer* false)

(defun situation-initialize (sit)
   (let ((idom (initial-situation-domain-indexify sit))
	 (parent-sit (Initial-situation-parent sit)))
      (indexed-domain-make-current idom)
      (cond (parent-sit
	     (situation-initialize parent-sit)))
      (cond ((initial-situation-out-of-date sit true idom)
	     (!= (Situation-query-tab sit) false)
	     (dbg-out domain-current-dbg*
		sit " out of date -- refreshing" :%)
	     (let-fun ((erase-denied-facts ()
			 ;; This is probably wrong but harmless...
			 ;; index still same as fact-index
			 (repeat :for ((d :in (Initial-situation-delta sit)))
			    (!= d (internalize d '() ':consequent))
			    (assertion-erase (cond ((car-eq d 'not)
						    (cadr d))
						   (t `(not ,d)))
					     sit idom)))
		      (index-and-link ()
			 ;; Now index is *not* fact-index
			 (repeat :for ((d :in (Initial-situation-delta sit)))
			    (multi-let (((expanded _)
					 (internalize d '() ':consequent)))
			       (assertion-erase (cond ((car-eq d 'not)
						       (cadr d))
						      (t `(not ,d)))
						sit idom)
			       (aa-tally expanded sit idom))))
		      (initialize-init-index ()
			  (!= (Initial-situation-init-index sit)
			      (cond (parent-sit
				     (exp-index-copy
				        (Initial-situation-init-index
					    parent-sit)))
				    (t
				     (exp-index-init #'Occasion-index-pat
						     qvar-topcoord*))))
			  (!= (Initial-situation-diff-from-init sit)
			      (exp-index-init #'Signed-occasion-index-pat
					      qvar-topcoord*))))
		(setf (Initial-situation-sit-index sit)
		      '())
		(setf (Situation-more sit) false)
		(cond ((and copy-fact-sit*
			    (not (eq (Initial-situation-name sit)
				     '|fact sit|)))
		       (let ((fact-sit
			        (domain-place-fact-sit idom true)))
			  (!= (Initial-situation-fact-index sit)
			      (cond ((null (Initial-situation-delta sit))
				     (Initial-situation-fact-index
				      fact-sit))
				    (t
				     (exp-index-copy
				       (Initial-situation-fact-index
					 fact-sit)))))
			  (initialize-init-index)
			  (with-thawed-situation sit
			     (changing-fact-index sit 
				(erase-denied-facts))
			     (index-and-link))))
		      (t
		       (domain-make-current idom)
		       (let ((fact-ind (exp-index-init #'Occasion-index-pat
						       qvar-topcoord*)))
			  (!= (Initial-situation-fact-index sit)
			      fact-ind)
			  (initialize-init-index)
			  (with-thawed-situation sit
			     (changing-fact-index sit 
				(init-sit-fill sit idom true)
				(erase-denied-facts))
			     (index-and-link)))))
;;;;		(breakpoint situation-initialize
;;;;		   "About to call " sit-init-completer*)
		(cond (sit-init-completer*
		       (funcall sit-init-completer* sit)))
		(!= (Initial-situation-generation sit)
		    (next-generation)))))
	 sit))

;; This can't be defined until deduction.nsp.
(defvar type-indexer* false)

(defun domain-place-fact-sit (idom allow-prelink)
   (let ((fact-sit-bdg (place-local-domain-bdg '|fact sit| idom))
	 fact-sit)
      (cond ((Domain-bdg-unbound fact-sit-bdg)
	     (dbg-out domain-current-dbg*
		"Creating fact sit for " idom :%)
	     (!= fact-sit (new-Initial-situation '|fact sit| idom))
	     (!= (Initial-situation-init-index fact-sit)
		 (exp-index-init #'Occasion-index-pat qvar-topcoord*))
	     (!= (Situation-diff-from-init fact-sit)
		 (exp-index-init #'Signed-occasion-index-pat qvar-topcoord*))
	     (!= (Domain-bdg-val fact-sit-bdg)
		 fact-sit)
	     (initial-situation-fill fact-sit idom true allow-prelink))
	    (t
	     (!= fact-sit (Domain-bdg-val fact-sit-bdg))
	     (cond ((initial-situation-out-of-date fact-sit false idom)
		    (dbg-out domain-current-dbg*
		       fact-sit " out of date -- refreshing" :%)
		    (initial-situation-fill fact-sit idom
					    true allow-prelink)))))
      fact-sit))

;; If finish is false, caller will clean up the index,
;; freeze the situation and set its
;; generation.  (Doesn't seem to be called with 'finish'=false.)
;; The sit in question is always a fact-sit.
(defun initial-situation-fill (sit idom finish allow-prelink)
   (domain-make-current idom)
   (let ((fact-ind (exp-index-init #'Occasion-index-pat qvar-topcoord*)))
      (!= (Initial-situation-fact-index sit)
	  fact-ind)
      (setf (Initial-situation-sit-index sit)
	    nil)
      (setf (Situation-more sit) false)
      (cond (finish
	     (with-thawed-situation sit
		(changing-fact-index sit 
		   (init-sit-fill sit idom allow-prelink)))
	     (!= (Initial-situation-generation sit)
		 (next-generation)))
	    (t
	     ;; If not finish, assume caller did unwind-protect
	     (!= (Initial-situation-init-index sit) fact-ind)
	     (init-sit-fill sit idom allow-prelink)))))

(defun init-sit-fill (initsit idom allow-prelink)
   (let ((linkspots '())
	 (checked-domains '()))
      ;; We do the higher domains first, so that more specific ones
      ;; can delete things.
      (let-fun ((:def fill-from-dom (dom)
		  (let ((already (exists (cdom in checked-domains)
				    (same-domain cdom dom))))
		     (cond ((not already)
			    (!= checked-domains (cons dom *-*))
			    (domain-walk-immed-ancestors #'fill-from-dom dom)
			    (repeat :for  ((bdg :in (domain-get-local-bdgs dom)))
			       (cond ((is-Vartype bdg)
				      (let ((v (Domain-bdg-val bdg)))
					 (cond ((is-Rule-group v)
						(setq linkspots
						  (nconc (rule-group-index
							    v initsit idom)
							 linkspots)))
					       ((is-Type v)
						(cond (type-indexer*
						       (funcall type-indexer*
								v initsit idom))))
					       ((is-Constant v)
						(constant-index
						   (Vartype-var bdg)
						   (Constant-type v)
						   initsit idom))
					       ((is-Domain-var v)
						(constant-index
						   (Vartype-var bdg)
						   (Domain-var-type v)
						   initsit idom))))))))))))
	 (repeat :for ((a :in universal-ancestors*))
	    (fill-from-dom a))
	 (fill-from-dom idom)
;;;;	 (cond ((eq (Initial-situation-name initsit) '|fact sit|)
;;;;		(dbg-save initsit idom)
;;;;		(breakpoint init-sit-fill
;;;;		   "Filled " initsit)))
	 (cond (allow-prelink
		(prelink linkspots idom))))))


;;; Used to return linkspots, which are now obsolete.
(defun rule-group-index (rg initsit idom)
;;;;   (let ((linkspots '()))
      (dolist (def (Rule-group-rules rg))
	 (cond ((is-Fact def)
		(fact-index def initsit idom)
;;;;		(!= linkspots
;;;;		    (nconc (fact-index def initsit idom)
;;;;			   *-*))
		)))
      !())

(defun fact-index (p initsit idom)
   (aa-tally (fact-internalize p) initsit idom))

(defun fact-internalize (p)
   (or (Fact-internalized p)
       (multi-let (((expanded _)
		    (internalize (Fact-statement p) '() ':consequent)))
	  (!= (Fact-internalized p)
	      expanded)
	  expanded)))

(defun exp_index-size (ind) (exptree-size (exp_index-tree ind)))

(defun constant-index (name ty initsit idom)
   (let ((p (type-predify ty name (empty-vartypes idom))))
      (cond ((not (matchq ?(:\| (is Obj ?_)
			       (or . ?_))
			  p))
	     (aa-tally p initsit idom)))))

(defvar trace-deduce* nil)

(defun aa-tally (p initsit idom)
   (match-cond p
      (:? true
	 (out (:to *error-output*) "Adding vacuously true proposition" :%))
      (:? false
	 (signal-problem aa-tally
	    "Inconsistency!"))
      (:? (<- ?c ?a)
	 (let ((d (disjunctive-normal-form a true)))
	    (cond ((null ?d)
		   ;; "If false then c" -- no-op
		   )
		  ((memq !() d)
		   ;; "If true then c" = c
		   (aa-tally c initsit idom))
		  (t
		   (assertion-add p initsit idom)))))
      (t
       (assertion-add p initsit idom))))

;;; Invariant: A signed occasion sC is present in a Subsequent-situation S
;;; if and only if the status of C in S is different from its status
;;; in init(S).  Corollary: Can't have both +C and -C.

(defmacro assertion-add (decls fmla id^ bdgs^ sit^ dom^
			 &key ((:domain compile-time-domain-name)))
   (multi-let (((qexp vtl)
		(compile-time-fmla-analyze
		     fmla decls ':consequent compile-time-domain-name)))
      `(int-assertion-add
	  ',qexp ,id^
	  (verify-types ,bdgs^
			,id^
			,(vartypes-loader vtl))
	  ,sit^ ,dom^)))

(defun vartypes-loader (vtl)
   `(list ,@(<# (\\ (vt)
		  `(new-Vartype ',(Vartype-var vt)
				,(type-loader
				     (Vartype-type vt)
				     !())
				false))
		vtl)))

(defun compile-time-fmla-analyze (fmla decls context compile-time-domain-name)
   (cond ((eq decls ':eval-for-fmla)
	  (cond ((not (null compile-time-domain-name))
		 (err-out "Warning -- :domain supplied when formula "
			  :% " = " fmla 1 decls)))
	  (let ((fmla-var (gen-var 'fmla)))
	     (!= fmla (make-Qvar fmla-var !()))
	     (!= decls '(,fmla-var - Prop)))))
   (let ((cdom (cond (compile-time-domain-name
		      (or (try-domain-with-name
			     compile-time-domain-name false)
			  (signal-problem assertion-add
			     "Undefined domain " compile-time-domain-name)))
		     (t false))))
      (let ((env (cond (cdom
			(domain-place-env cdom))
		       (t global-opt-env*))))
	 (multi-let (((_ vartypes defective-exps)
		      (qvar-list-parse decls univ-type* env)))
	    (cond ((not (null defective-exps))
		   (signal-problem assertion-add
		      "Vars declarations"
		      :% decls
		      :% " for assertion of formula "
		      fmla
		      :% " have syntactic defects: "
		      :% defective-exps)))
	    (multi-let (((typed-exp _)
			 (formula-typecheck fmla true (empty-undo-stack)
					    !()
					    (env-bindings-append
					       true vartypes env)
					    false)))
	       (values
		  (internalize typed-exp
			       (<# Vartype-var vartypes)
			       context)
		  vartypes))))))

(defvar type-verify-id* (new-Varid))

;;; Return 'bdgs' after verifying that none of its bindings
;;; contradict 'declared'.
(defun verify-types (bdgs id declared)
   (repeat :for ((vt :in declared))
    :result bdgs
    :while
      (let ((bdg (uvar-lookup (Vartype-var vt) id bdgs)))
	 (or (not bdg)
	     (type-acceptable
	        false
	        (Qexp-type (Varbdg-val bdg))
		(Vartype-type vt)
		type-verify-id* id bdgs (empty-env) (empty-undo-stack))))
    :result (signal-problem verify-types
	       "Variable " (Vartype-var vt) " is bound to " bdg
	       :% " which is not of type " (Vartype-type vt))))

(defun assertion-clo-add (pat id bdgs sit dom)
   (multiple-value-let (pat _)
		       (safe-varsubst pat id bdgs)
      (assertion-add pat sit dom)))

;;; Returns list of Occasions added
(defun int-assertion-add (qexp id bdgs sit dom)
   (!= qexp (qexp-resolve *-* qid bdgs))
   (multi-let (((pred args bdgs)
		(qexp-main-op qexp qid bdgs)))
      (let-fun ()
 	 (let ((h (assertion-add-handler pred)))
	    (cond (h
		   ;; Use, but don't index
		   (funcall h pat sit dom))
		  ((is-Initial-situation sit)
		   (cond ((not (present-in-init-sit sit))
			  (error-if-frozen)
			  (let ((occ (uniquify-occasion pat dom)))
			     (exp-ob-index occ
					   (Initial-situation-init-index sit)
					   true)
			     (cons occ (forward-chain))))))
		  (t
		   (let ((local-index (Situation-diff-from-init sit))
			 (initsit (Subsequent-situation-init sit)))
		      (let ((occ (present-in-init-sit initsit)))
			 (cond (occ
				(let ((docc (variant-fetch
					        pat ':deleted local-index)))
				   (cond (docc
					  (error-if-frozen)
					  (exp-ob-index docc local-index false)
					  (cons occ (forward-chain))))))
			       (t
				(let ((aocc (variant-fetch
					        pat ':added local-index)))
			           (cond ((not aocc)
					  (error-if-frozen)
					  (let ((occ (uniquify-occasion
						         pat dom)))
					     (exp-ob-index
					        (place-signed-occasion
							      true occ)
						local-index
						true)
					     (cons occ (forward-chain))))
				   )))))))))

       :where

	  (:def present-in-init-sit (initsit)
	     (let ((init-index (Initial-situation-init-index initsit))
		   (fact-index (Initial-situation-fact-index initsit)))
		(or (variant-fetch pat false init-index)
		    (variant-fetch pat false fact-index))))

	  (:def error-if-frozen ()
	     (cond ((Situation-frozen sit)
		    (signal-problem assertion-add :fatal
		       "Adding assertion " pat :%
		       " to frozen situation "
		       sit))))

	  (:def forward-chain ()
	     (cond (trace-deduce*
		    (out (:to *trace-output*) "Adding assertion " pat :%)))
	     (nconc (trigger-forward-rules pat sit dom)
		    (cond ((eq pred '->)
			   (let ((chain-id (new-Varid)))
			      (chain-on-matches
				 (caddr pat) chain-id 
				 (<# car
				     (sit-assertion-fetch
					(cadr pat) chain-id (empty-env)
					true sit))
				 sit dom)))
			  (t !())))))))

(defun assertion-add-handler (sym)
   (and (is-Symbol sym)
	(get sym 'add-handler)))

(datafun attach-datafun add-handler
   (defun :^ (_ sym fname)
      (!= (get sym 'add-handler) (symbol-function fname))))

(datafun add-handler and
   (defun :^ (pat sit dom)
      (repeat :for ((a :in (cdr pat)))
       :nconc
	 (assertion-add a sit dom))))

;;; This should be called only when 'sit' is a Subsequent-situation.
;;; Returns list of Occasions found and flushed.
(defun assertion-find-and-erase (pat id bdgs sit)
   (let ((goners (<# cadr (sit-assertion-fetch pat id bdgs false sit)))
	 (diff-index (Subsequent-situation-diff-from-init sit)))
      (repeat :for ((a :in goners))
	 (cond (trace-deduce*
		(out (:to *trace-output*) "Erasing assertion " (Occasion-prop a) :%)))
	 (let ((delta (variant-fetch (Occasion-prop a) ':neutral diff-index)))
	    (cond (delta
		   (cond ((Signed-occasion-sign delta)
			  ;;; Added since beginning; un-add
			  (exp-ob-index delta diff-index false))))
;;;;			 (t
;;;;			  (dbg-save goners a diff-index id bdgs sit)
;;;;			  (signal-problem assertion-find-and-erase
;;;;			     "Occasion present in spite of deletion: " delta))))
		  (t
		   ;;; Mark as deleted
		   (exp-ob-index (place-signed-occasion false a) diff-index true))))
       :collect a)))

(defun assertion-clo-erase (pat id bdgs sit dom)
   (assertion-erase (safe-varsubst pat id bdgs) sit dom))
	      
... Fix 'assertion-erase' analogously to 'assertion-add' ...

;;; Returns list of Occasions erased.
;;; Apparently pointless 'dom' arg is for parallelism with 'assertion-add', and
;;; because every time I tinker with the damned implementation I keep changing
;;; whether the argument is there or not.
(defun assertion-erase (pat sit dom)
                       (ignore dom)
   (let-fun ()
      (cond ((is-Initial-situation sit)
	     (let ((init-index (Initial-situation-init-index sit)))
		(let ((existing (variant-fetch pat false init-index)))
		   (cond (existing
			  (error-if-frozen)
			  (exp-ob-index existing init-index false)
			  (list existing))
			 (t !())))))
	    (t
	     (let ((local-index (Situation-diff-from-init sit))
		   (init-index (Initial-situation-init-index
				  (Subsequent-situation-init sit))))
		(let ((occ (variant-fetch pat false init-index)))
		   (cond (occ
			  (cond ((not (variant-fetch pat ':deleted local-index))
				 (error-if-frozen)
				 (exp-ob-index (place-signed-occasion
						  false occ)
					       local-index
					       true)
				 (list occ))))
			 (t
			  (let ((aocc (variant-fetch pat ':added local-index)))
			     (cond (aocc
				    (error-if-frozen)
				    (exp-ob-index aocc local-index false)
				    (list (Signed-occasion-occ aocc)))))))))))
				 
    :where
       (error-if-frozen ()
	  (cond ((Situation-frozen sit)
		 (signal-problem assertion-erase :fatal
			     "Erasing assertion " pat " from frozen situation "
			     sit))))))
	  
; Version callable from rule
(defun erase (id bdgs sit dom pat)
   (assertion-clo-erase pat id bdgs sit dom))

(defun assertion-deduce (pat sit)
   (bdgs-assertion-deduce pat dummy-id* (empty-env) sit))

(defun bdgs-assertion-deduce (pat id bdgs sit)
   (<# car (sit-assertion-fetch pat id bdgs true sit)))

;;; Returns a list of triples (Bdgenv Occasion Varid).
;;; The id governs the variables in the Bdgenv from the Occasion.
(defun sit-assertion-fetch (qexp id bdgs include-facts sit)
  (let ((initsit (find-init-situation sit))
	(pat (place-qexp-index-pat qexp)))
      (let ((init-index (Initial-situation-init-index initsit))
	    (diff-index (Situation-diff-from-init sit)))
	 (nconc (cond (include-facts
		       (assertion-fetch
			    pat false id bdgs
			    (Initial-situation-fact-index initsit)))
		      (t !()))
		(repeat :for ((bdgs+occ :in (assertion-fetch pat false id bdgs
							     init-index)))
		 :when (not (variant-fetch (safe-varsubst pat id
							  (car bdgs+occ))
					   ':deleted diff-index))
		 :collect bdgs+occ)
		(repeat :for ((bdgs+occ :in (assertion-fetch
					       pat ':added id bdgs
					       diff-index)))
		 :collect (tuple (first bdgs+occ)
				 (Signed-occasion-occ (second bdgs+occ))
				 (third bdgs+occ)))))))

;;; 'signed' is false if ind contains unsigned Occasions.  Otherwise,
;;; it is either :added, :deleted, or :neutral.  :added means return
;;; just Signed-occasions with positive sign; :deleted, just those
;;; with negative sign.  :neutral means return all of them.
(defun assertion-fetch (pat signed qexp id bdgs ind)
   (mapcan #'(lambda (occ)
		(cond ((occ-agrees-with-sign occ signed)
		       (let ((prop (cond (signed
					  (Signed-occasion-prop occ))
					 (t
					  (Occasion-prop occ))))
			     (ass-id (new-Varid)))
			  (multiple-value-bind (ok e)
					       (qunify qexp prop
						       id ass-id bdgs)

			      (cond (ok (list (lrecord e occ ass-id)))
				    (t
				     (cond ((eq e discrim-bdgs*)
					    (try-rehash force-rehash qexp occ
							prop false
							ind)))
				     !())))))
		      (t !())))
	   (exp-fetch pat ind nil)))

;;; Not currently used, but should work:
;;; Returns a list of Occasions (not Signed-occasions)
(defun sit-variant-fetch (pat sit)
   (let ((initsit (find-init-situation sit))
	 (diff-index (Situation-diff-from-init sit)))
      (let ((initial (variant-fetch pat false (Initial-situation-init-index initsit)))
	    (local (variant-fetch pat ':neutral diff-index))
	    (fact (variant-fetch pat false (Initial-situation-fact-index initsit))))
	 (nconc (cond ((and initial (or (not local)
					(Signed-occasion-sign local)))
		       (list initial))
		      (t !()))
		(cond ((and local (Signed-occasion-sign local))
		       (list (Signed-occasion-occ local)))
		      (t !()))
		(cond (fact (list fact))
		      (t !()))))))

;;; 'signed' has same meaning as for 'assertion-fetch'.
(defun variant-fetch (qexp signed ind)
   (let ((pat (place-qexp-index-pat qexp)))
      (let ((res (<! (\\ (occ)
			(cond ((occ-agrees-with-sign occ signed)
			       (let ((prop 
					(Occasion-prop
					   (cond (signed
						  (Signed-occasion-occ
						     occ))
						 (t occ)))))
				  (multi-let (((ok _ _ e)
					       (qvariants
						  qexp prop
						  variant-id1*
						  variant-id2*
						  (empty-env))))
				     (cond (ok
					    (list occ))
					   ((eq e discrim-bdgs*)
					    (try-rehash force-rehash qexp occ
						     prop true
						     ind)
					    !())))))
			      (t !())))
			 (exp-fetch pat ind true))))
      (cond ((null res) false)
	    ((null (cdr res)) (car res))
	    (t
	     (signal-problem variant-fetch
		"Multiple variants of " pat " found: "
		:% res
		:fatal))))))

(defun occ-agrees-with-sign (occ signed)
   (or (not signed)
       (eq signed ':neutral)
       (eq (eq signed ':added)
	   (Signed-occasion-sign occ))))

(defun trigger-forward-rules (pat sit dom)
   (bind ((optimist-fn* false))
      (let ((pat-id (new-Varid))
	    (rule-id (new-Varid)))
	 (multiple-value-bind (ok e)
			      (qunify '?ante pat rule-id pat-id (empty-env))
	    (cond (ok
		   (multiple-value-bind (rulepat e)
					(safe-varsubst
					   '(-> ?ante ?conse)
					   rule-id e)
		      (let ((rule-bdgs
			       (sit-assertion-fetch
				      rulepat rule-id e true sit)))
			 (chain-on-matches
			    '?conse rule-id rule-bdgs sit dom))))
		  (t
		   (error "Fumbled unification in assertion-add")))))))

(defun chain-on-matches (pat id bdgs-list sit dom)
   (dolist (bdgs bdgs-list)
      (multi-let (((pat env)
		   (safe-varsubst pat id (car bdgs))))
	 (cond ((eq (car pat) 'call)
		(let ((form (car pat)))
		   ;;; Such functions must return list of Occasions added.
		   (apply (symbol-function (car form))
			  id env sit dom (cdr form))))
	       (t
		(assertion-add pat sit dom))))))

;;; Debugging convenience
(defun sit-ini (name dom)
   (let ((sit (find-domain-bdg-val name dom)))
      (cond ((is-Initial-situation sit)
	     (situation-initialize sit))
	    (t false))))

