;-*- Mode: Common-lisp; Package: opt; Readtable: ytools; -*-
(in-package :opt)
;;;$Id: qaxiom.lisp,v 1.4 2005/11/23 18:16:30 dvm Exp $

(depends-on %module/ ytools nity)

(depends-on :at-run-time %opt/ types basics syntax more-syntax
	                 %lisplang/ funcheck typecheck bvarparse flagsource)

(defvar true-te*
    (make-inst Const-typed-exp
       :val 'true
       :type true-type*
       :source 'true
       :env global-opt-env*))

(defvar false-te*
    (make-inst Const-typed-exp
       :val 'false
       :type false-type*
       :source 'false
       :env global-opt-env*))

(defun facts-parse (facts dom rg cxt)
   (multiple-value-bind (literals flg)
                        (list-smooth facts #'consp)
;;;;      (!= literals (expression-symbols-place *-* dom))
      (collecting-defective-exps (ill-formed-exps fact-tes)
				 (<# (\\ (lit)
;;;;					(cond ((matchq (forall ?@_) lit)
;;;;					       (breakpoint facts-parse
;;;;						  "lit = " lit)))
					(formula-typecheck lit true (empty-undo-stack)
							   !() dom))
				     literals)
	 (:if-aborted 
             :restart-report (lambda (srm)
				(out (:to srm)
				     "I will give up on checking the facts in "
				     (car cxt) 1 (cadr cxt)))
	     (list (new-Flagged-subexpression facts ill-formed-exps)))
;;;;	 (repeat :for ((lit :in literals)
;;;;		       (te :in fact-tes))
;;;;	    (cond ((matchq (coerce Boolean ?@_) lit)
;;;;		   (dbg-save te lit dom rg)
;;;;		   (breakpoint facts-parse
;;;;		      "Got coercion fact " lit))))
	 (repeat :for ((te :in fact-tes))
	    (add-to-rule-group (make-Fact te false)
			       rg))
	 `(,@(<# (\\ (te)
		    (flagsource te))
		 fact-tes)
	   ,@flg))))

(defun axioms-parse (axioms dom rg)
   (cond ((null axioms) '())
         (t
	  (multiple-value-bind (axioms flg)
			       (list-smooth axioms #'consp)
	     (let ((flg-all '()))
		(dolist (a axioms)
		   (multiple-value-bind (flg-a defn)
					(axiom-parse a dom)
		      (on-list flg-a flg-all)
                      (cond (rg
		             (add-to-rule-group defn rg)))))
		`(,@(reverse flg-all)
		    ,@flg))))))

; axiom-body  is of form (:context ... :implies ...)
(defun axiom-parse (axiom-body dom)
   (let ()
      (!= scope-time* (+ *-* 1))
      (let-fun ()
	 (collecting-defective-exps (defexps ax-flag ax-te)
				    (parse-it)
	    (:if-aborted 
             :restart-report (lambda (srm)
				(out (:to srm)
				     "I will give up on checking "
				     :% 3 `(:axiom ,@axiom-body)))
	       (new-Flagged-subexpression
			       `(:axiom ,@axiom-body)
			       defexps))
	    (values (new-Flagged-subexpression
		       ax-flag defexps)
                    ax-te))
  :where
  
 (:def parse-it ()
      (multi-let (((items bad-keyword-flg)
		   (keyword-list-smooth axiom-body
					'((:vars :parameters)
					  (:antecedent :context)
					  (:consequent :implies)
					  :procedure)
					'(:consequent))))
	 (let ((conse (get-field ':consequent items))
	       (ante (get-field ':antecedent items))
	       (proc (get-field ':procedure items))
	       (vars (get-field ':vars items))
	       (env (domain-place-env dom)))
	    (multi-let (((low high _)
			 (args-low-high-split
			    (and vars (second vars))
			    true env)))
	       (cond ((null high)
		      (parse-level-0 conse ante proc low true env))
		     (t
		      (multi-let (((hi-con hi-alspec hi-ill-formed)
				   (qvar-list-parse-al high type-type* env)))
			 (let* ((high-bdgs (argspecs-placeholder-params
					      hi-alspec env))
				(low-env (env-bindings-nconc
					    true high-bdgs env)))
			    (multi-let (((ext ax-te)
					 (parse-level-0
					    conse ante proc low
					    hi-con low-env)))
			       (values 
				  (new-Flagged-subexpression
			             (cond ((null bad-keyword-flg)
                                            `(,@ext ,@bad-keyword-flg))
                                           (t ext))
                                     hi-ill-formed)
				  ax-te))))))))))

 (:def parse-level-0 (conse ante proc vars may-constrain env)
    (multi-let (((constraining low-alspec var-ill-formed)
		 (qvar-list-parse-al vars univ-type* env))
                (cxt
                 (opt-syn-context `(axiom ,@axiom-body)
                                  !())))
       (let ((ante-te
		(and ante
		     (term-check
			(second ante)
			prop-type*
			(empty-undo-stack)
			(cons-Syn-context
			   (tuple ':polarity false)
			   (context-expstack-push
			      (second ante) ':antecedent cxt))
			env)))
	     (conse-te
		(term-check
		    (second conse)
		    prop-type*
		    (empty-undo-stack)
                    (cons-Syn-context
                       (tuple ':polarity true)
                       (context-expstack-push
		          (second conse) ':consequent cxt))
		    env))
	     (proc-te
		(and proc
		     (make-inst Unchecked-typed-exp
			:source `(goal-call ,(second proc))))))
	  (let ((final-ante-te
		   (cond ((and ante-te proc-te)
			  (typed-exps-conjoin (list ante-te proc-te) env))
			 (ante-te ante-te)
			 (proc-te proc-te)
			 (t false))))
	     (multi-let (((qte arglist ante-te conse-te)
			  (construct-quant-if-te
			     low-alspec
			     (and may-constrain constraining)
			     final-ante-te conse-te 
			     `(:axiom ,@axiom-body)
			     env)))
		(values `(:axiom
			    ,@(cond ((null (Arglistspec-argspecs arglist))
				     !())
				    (t
				     `(:vars
				       ,(arglistspec-typed-arglist arglist))))
			    :implies ,(flagsource conse-te)
			    ,@(cond (ante-te
				     `(:context ,(flagsource ante-te)))
				    (t !()))
                            ,@var-ill-formed)
			qte)))))))))

(defun derived-parse (clauses dom)
   (let ((dom-env (domain-place-env dom))
         (own-rg (own-rule-group dom))
         (pre-scope-time
            (prog1 scope-time*
                   (!= scope-time* (+ *-* 1)))))
      (let-fun ()
         (control-nest
          ;; :pass0 Decompose clauses
            (repeat :for ((c :in clauses)
                          :collectors preds defs ill-formed)
             :within
               (match-cond c
                  (:? (?pred ?def)
                    (:continue
                     :collect (:into preds pred)
                     :collect (:into defs def)))
                  (t
                   (:continue
                    :collect
                      (:into ill-formed
                         (make-Defective-exp
                                 :target c
                                 :observation
                                    (\\ (targ srm)
                                       (out (:to srm)
                                         targ " must have two fields,"
                                         " pred and defn")))))))
             :result
             :pass1)
          :pass1 ;; Principal pass-- parse bodies, after binding
                    ;; all derived-pred symbols 
             (multi-let (((funrecs trailing-ifes _ _)
                          (fundefs-types clauses false ':no-body
                                         false true prop-type*
                                         (empty-undo-stack)
                                         (opt-syn-context clauses !())
                                         dom-env)))
                (let ((name-flg-list
                         (repeat :for ((fdr :in funrecs))
                          :within
                            (multi-let (((name name-flg)
                                         (symbol-resolve (Fundef-rec-name fdr)
                                                         dom true))) 
                               (cond (name
                                      (!= (Fundef-rec-name fdr) name)))
                               (:continue
                                :collect name-flg)))))
                   (let ((bodies-env
                            (env-bindings-append
                               true 
                               (recursive-funtypes-vartypes funrecs)
                               dom-env)))
                      (repeat :for ((fdr :in funrecs)
                                    (name-flg :in name-flg-list)
                                    (pred :in preds)
                                    (def :in defs)
                                    ;;;; (ustack !())
                                    :collectors fact-tel
                                                flagged-versions)
                       :within
                         (collecting-defective-exps (defexps rule-te ext)
                                                    (parse-as-fact
                                                       fdr pred def name-flg)
                            (:if-aborted
                               :restart-report
                                   (lambda (srm)
                                      (out (:to srm)
                                           "I will give up on checking "
                                           :% 3 `(:derived ,pred ,def)))
                               (:continue
                                :collect (:into fact-tel false)
                                :collect (:into flagged-versions
                                                (flagexp `(:derived ,pred ,def)
                                                         defexps))))
                            (:continue
                             :collect (:into fact-tel rule-te)
                             :collect (:into flagged-versions
                                             (new-Flagged-subexpression
                                                ext defexps))))
                        :result
                        (progn
                           :pass2
                           (cond ((null trailing-ifes)
                                  flagged-versions)
                                 (t
                                  (new-Flagged-subexpression
                                     flagged-versions
                                     trailing-ifes))))))))
          :pass2 ;; Clean up types
             (let ((body-envs
                      (<# (\\ (fdr)
                             (fundef-rec-body-env fdr bodies-env))
                          funrecs)))
                (multi-let (((_ _)
                             (fdrs-tvars-elim funrecs body-envs
                                              pre-scope-time
                                              (empty-undo-stack))))
                   (repeat :for ((fdr :in funrecs))
                      (elim-unks (Fundef-rec-funtype fdr)
                                 pre-scope-time bodies-env))
                    :result
                    :pass3))
          :pass3 ;; Bind predicates
             (repeat :for ((fdr :in funrecs)
                           (fact-te :in fact-tel))
                (cond (fact-te
                       (bind-pred-constant
                          (Fundef-rec-name fdr)
                          true (Fundef-rec-funtype fdr) !() dom-env)))))

          :where

             (:def parse-as-fact (fdr pred def name-flg)
                (let* ((level (Fundef-rec-level fdr))
                       (clause (Fundef-rec-source fdr))
                       (cxt (opt-syn-context
                               `(:derived ,@clause)
                               !())))
                   (cond ((> level 0)
                          (let* ((low-bdgs
                                    (argspecs-placeholder-params
                                       (Fundef-rec-high-args fdr)
                                       dom-env))
                                 (low-env (env-bindings-nconc
                                             true low-bdgs dom-env)))
                             (parse-level-0
                                fdr def clause
                                (Fundef-rec-low-args fdr)
                                cxt low-env name-flg)))
                         (t
                          (parse-level-0 fdr pred def
                                         (Fundef-rec-low-args fdr)
                                         cxt dom-env name-flg)))))

             (:def parse-level-0 (fdr pred def arglist cxt env name-flg)
                (let ((local-bdgs
                         (<# (\\ (as)
                                (new-Vartype
                                   (Argspec-name as)
                                   (Argspec-type as)
                                   false))
                             (Arglistspec-argspecs arglist)))
                      (pred-term
                         `(,(Fundef-rec-name fdr)
                           ,@(<# Argspec-name
                                 (Arglistspec-argspecs arglist)))))
                   (let ((rule-env (env-bindings-append
                                        true local-bdgs env)))
                      (let ((ante-te (term-check
                                        def
                                        prop-type*
                                        (empty-undo-stack)
                                        (cons-Syn-context
                                           (tuple ':polarity false)
                                           (context-expstack-push
                                              def 2 cxt))
                                        rule-env))
                            (conse-te (term-check
                                         pred-term
                                         prop-type*
                                         (empty-undo-stack)
                                         (context-expstack-push
                                            pred-term 1 cxt)
                                         rule-env)))
                         (multi-let (((rule-te arglist ante-te _)
                                      (construct-quant-if-te
                                         arglist true
                                         ante-te conse-te
                                         `(:derived ,pred ,def)
                                         rule-env)))
                            (cond ((= (Typed-exp-totbugs rule-te)
                                      0)
                                   (add-to-rule-group
                                      (make-Fact rule-te false)
                                      own-rg)))
                            `(:derived
                                 (,name-flg
                                  ,@(arglistspec-typed-arglist arglist))
                                 ,(flagsource ante-te))))))))))
				       
;;; Returns < typed-exp, arglist, antecedent (or false), consequent >
(defun construct-quant-if-te (arglist constraining ante-te conse-te
			      qif-source env)
   (multi-let (((if-te ante-te conse-te)
		(cond (ante-te
		       (values 
			  (make-inst If-typed-exp
			     :type prop-type*
			     :env env
			     :test ante-te
			     :prag '<-
			     :iftrue conse-te
			     :iffalse true-te*
			     :subexps (list conse-te ante-te)
			     :tvars (tvars-union (Typed-exp-tvars ante-te)
						 (Typed-exp-tvars conse-te))
			     :ext (if-ext '<- ante-te conse-te false-te*)
			     :source `(<- ,(Typed-exp-source conse-te)
                                          ,(Typed-exp-source ante-te)))
			   ante-te
			   conse-te))
		      (t
		       ;; Degenerate case
		       (values conse-te false conse-te)))))
      (cond ((null (Arglistspec-argspecs arglist))
	     ;; Another degenerate case
	     (!= (Typed-exp-source if-te) qif-source)
	     (values if-te arglist ante-te conse-te))
	    (t
	     (values
		(make-inst Quantified-typed-exp
		   :quantifier 'forall
		   :keep-quantifier false
		   :type prop-type*
		   :use-bindings-as-constraints constraining
		   :universal true
		   :bindings arglist
		   :source qif-source
		   :ext `(forall ,(arglistspec-typed-arglist arglist)
			    (<- ,(Typed-exp-ext conse-te)
				,(Typed-exp-ext ante-te)))
		   :subexps (list if-te)
		   :env env
		   :body if-te)
		arglist ante-te conse-te)))))

(defun bind-pred-constant (predname must-be-new predtype flags dom)
   (bind-constant
      predname must-be-new predtype
      (\\ (predname)
	 (new-Predicate
	    predname predtype
	    :macro false
	    :prechain (memq ':prechain flags)
	    :rigid (memq ':rigid flags)))
      dom))

;;; Returns a list of ill-formed-exps.  'valfn' is function that takes
;;; resolved name and constructs a value.
;;; If 'must-be-new' is false, old binding is okay if of same type.
(defun bind-constant (name must-be-new ctype valfn dom)
   (cond ((not ctype)
	  (signal-problem bind-constant :fatal
	     "Making " name " a constant with null type")))
;;;;   (cond ((memq name '(c1 c2))
;;;;	  (dbg-save dom)
;;;;	  (breakpoint bind-constant
;;;;	     "About to resolve " name " wrt " dom)))
   (multi-let (((name name-flg)
		(symbol-resolve name dom true)))
      (cond (name
	     (let ((cbdg (place-domain-bdg name dom)))
		(cond ((or (Domain-bdg-unbound cbdg)
			   (and (not must-be-new)
				(or (not (Domain-bdg-type cbdg))
				    (types-equal (Domain-bdg-type cbdg)
						 ctype
						 (domain-place-env dom)
						 (domain-place-env dom)))))
		       (!= (Domain-bdg-val cbdg)
			   (funcall valfn name))
		       (!= (Domain-bdg-type cbdg) ctype)
		       '())
		      (t
		       (list 
			  (out-defective-exp
			     "Object " name " already defined to be"
			     " of type " (Domain-bdg-type cbdg)))))))
	    (t
	     (list name-flg)))))

(defvar auxfn-counter* 0)

;;; The name (usually of a thing defined 'define'd) that distinguishes
;;; its auxiliary functions from other things.
(defvar aux-defs-name* false)

(defun proc-compile (procdef)
   (let-fun ()
      (match-cond procdef
	 ((not procdef)
	  false)
	 ((is-Symbol procdef)
	  (eval procdef))
	 (:? (quote ?(:+ ?s is-Symbol))
	    s)
	 (:? (function ?(:+ ?s is-Symbol))
	    (cond ((fboundp s)
		   (symbol-function s))
		  (t s)))
	 (:? (function ?_)
	   (eval procdef))
	 (:? (\\ ?args ?@body)
	   (multi-let (((args body)
			(ytools::ignore-smooth args body)))
	      (compile-or-eval args body)))
	 (:? (function (lambda ?args ?@body))
	   (compile-or-eval args body))
	 (t
	  (note-defective-exp
	     ((procdef) "Illegal as function spec: " procdef)
	     :target procdef)))

      :where

	(compile-or-eval (args body)
;;;;	   (out (:to *query-io*)
;;;;		"Processing " procdef " by ")
	   (cond ((and eval-aux-defs*
		       (eq aux-defs* ':not-allowed))
;;;;		  (out (:to *query-io*) "evaluation" :%)
		  (eval `(function (lambda ,args ,@body))))
		 (t
		  (let ((name-distinguisher
			   (cond ((not aux-defs-name*)
				  (signal-problem proc-compile
				     "aux-defs-name* unbound in definition "
				     args 1 :% 3 body
				     (:continue "The function will have an ambiguous name"))
				  "")
				 (t aux-defs-name*))))
		     (let ((name (build-symbol
				    auxfn- (< name-distinguisher)
				    - (++ auxfn-counter*))))
;;;;		       (cond ((eq aux-defs* ':not-allowed)
;;;;			      (out (:to *query-io*) "previous ")))
;;;;		       (out (:to *query-io*) "compilation to " name :%)
		       (cond ((not (eq aux-defs* ':not-allowed))
			      (note-aux-def ':fun `(,name ,args ,@body))))
		       name)))))))