;-*- Mode: Common-lisp; Package: opt; Readtable: ytools; -*-
(in-package :opt)
;;;$Id: qexp-classes.lisp,v 1.14 2006/02/13 14:48:04 dvm Exp $

(depends-on %module/ ytools nity)

(depends-on (:at :run-time) %opt/ qunify)
;;;;(depends-on (:at :compile-time) %ytools/ multvalhacks)

;;; Unify handlers and priorities --
;;; 
;;; Class                  Priority

;;; qvar           	  100  (highest)
;;; boundvar     	   90
;;; lambda-exp             80  (incl. other binders; head specifies)
;;; apply                  70  (see qapply.lisp)
;;; cons, list     	   60
;;; complex app            50
;;; app of rest or key     30
;;; simple application     20
;;; atomic constant        10 
;;;
;;; All classes are defined in this file except for 'apply', which
;;; is big and hairy, and 'qvar', which was defined in qunify.

(defvar +atomic+ (printable-as-string "<qexp is atomic>"))
(defvar +form+ (printable-as-string "<form in functional position>"))

(let-fun ()
;;; head is var; args are ().
   (def-qexp-class boundvar
      :upriority 90
      :long false
      :unify-handler
	 (\\ (bvar qexp vid qid env)
	    (let ((b (uvar-lookup (Qexp-head bvar) vid env)))
	       (cond (b
		      (cond ((eq (Qexp-classname (Varbdg-skel b))
				 ':boundvar)
			     (values (congruent-boundvar qexp bvar qid vid env)
				     env))
			    (t
			     (unify (Varbdg-skel b) qexp (Varbdg-skelid) qid
				     env))))
		     (t
		      ;; This should not happen, but don't complain
		      (values false env)))))

      :variant-handler
	 (\\ (bvar qexp bvid qid pairings env)
	    (values (congruent-boundvar qexp bvar qid bvid env)
		    pairings
		    env))

      :occur-checker
	 (\\ (qvar bvar qvid bvid env)
	    (let ((bv-val (uvar-lookup (Qexp-head bvar) bvid env)))
	       (cond (bv-val
		      (cond ((and (eq (Qexp-head (Varbdg-skel bv-val))
				      qvar)
				  (Varid= (Varbdg-skelid bv-val) qvid))
			     '*self)
			    (t
			     '*has-boundvars)))
		     (t
		      (signal-problem boundvar-occur-checker
			 "Unexpected boundvar " (Qexp-head bvar))))))

      :index-pat-maker
         (\\ (_) '*dontcare)

      :main-op-extractor
         #'qvar-drill-for-main-op

      :sexp-maker
	 (\\ (qexp)
	    (Qexp-head qexp)))
   :where

 (:def congruent-boundvar (qexp bvar qid bvid env)
    (cond ((eq (Qexp-classname qexp) ':boundvar)
	   (let ((this-vb (uvar-lookup (Qexp-head bvar) bvid
				       env)))
	       (and this-vb
		    (let ((val (Varbdg-skel this-vb))
			  (valid (Varbdg-skelid this-vb)))
		       (and (eq (Qexp-classname val)
				':boundvar)
			    (Varid= valid qid)
			    (eq (Qexp-head val)
				(Qexp-head qexp)))))))
	  (t false))))

;;; When two binders are unified, their boundvars get bound to each other.
;;; When doing occur-check, we bind them to themselves.
;;; So it's okay to find a Boundvar in a value scanned for occur-check,
;;; but only if it's bound to itself.
;;; In other contexts (e.g., beta-reduction), boundvars can get used as
;;; qvar names, and be bound to arbitrary objects.

;;; Internalizer builds these from Binder-typed-exp's.
;;; The Vartypes must give rise to uniquified local Boundvars.
;;; In the case of lambda's, we keep the arglist as well as the
;;; vartypes.  The params get sorted, so we don't need to keep 
;;; track of requireds, optionals, etc.
;;; Header is binder type (:forall, :exists, :lambda, ...).
;;; 'args' has length num-of-params + 2
;;;    first arg = body of binder 
;;;    second arg = Boundvar name if &rest, alphabetized list of keys if &key,
;;;                 else false (always false for :forall and :exists)
;;;    remaining args = param-names (Boundvars), except rest param, if any
;;; 'type' is congruent--
;;;    first elt is type of body of binder
;;;    second is nil unless &rest, when it is type of rest arg
;;;    third is list of types of non-rest params.
;;; Odd case: procedural attachment is handled by having 
;;;    header = :goal-call, 
;;;    first arg = (procedure -args-as-qvars-), 
;;;    second arg false, rest param-names
;;; 
(let-fun ()
   (def-qexp-class binder
       :upriority 80
       :long true
       :unify-handler
	  (\\ (bind-exp exp b-id e-id env)
	     (multi-let (((ok new-env)
			  (binder-match-env exp bind-exp e-id b-id env)))
		(cond (ok
		       (qexp-unify
			  (first (Long-Qexp-args bind-exp))
			  (first (Long-Qexp-args exp))
			  b-id e-id new-env))
		      (t
		       (values false new-env)))))

       :variant-handler
	   (\\ (bind-exp qexp bid qid pairings env)
	      (multi-let (((ok new-env)
			   (binder-match-env qexp bind-exp qid bid env)))
		 (cond (ok
			(qexp-variants (first (Long-Qexp-args bind-exp))
				       (first (Long-Qexp-args qexp))
				       bid qid pairings new-env))
		       (t
			(values false new-env discrim-bdgs*)))))

       :occur-checker
	  (\\ (var b-qexp vid b-id env)
	     (let ((bvars (rest (Long-Qexp-args b-qexp)))
		   (body (first (Long-Qexp-args b-qexp))))
		(let ((augenv
			 (group-bind bvars bvars b-id b-id env)))
		   (list-occur-check var body vid b-id augenv))))

       :index-pat-maker
          (\\ (binder)
	     `(,(Long-Qexp-head binder)
	       ,(let ((k-or-r (second (Long-Qexp-args binder))))
		   (cond ((null k-or-r) 'nil)
			 ((consp k-or-r) k-or-r)
			 (t '*rest-param)))
	       ,(length (rest (rest (Long-Qexp-args binder))))
	       ,(place-qexp-index-pat (first (Long-Qexp-args binder)))))

       :main-op-extractor
          (\\ (binder _ _ env)
	     (values (Long-Qexp-head binder)
		     (Long-Qexp-args binder)
		     env))

       :sexp-maker
	  (\\ (qexp)
	     `(,(Long-Qexp-head qexp)
	       ,(let ((k-or-r (second (Long-Qexp-args qexp)))
		      (non-r-parms (rest (rest (Long-Qexp-args qexp)))))
		   (cond ((not k-or-r)
			  non-r-parms)
			 ((consp k-or-r)
			  (key-args-sexp k-or-r non-r-parms))
			 (t
			  `(,@non-r-parms &rest ,k-or-r))))
	       ,(Qexp-sexp (first (Long-Qexp-args qexp))))))

    :where

 (:def binder-match-env (that-qexp bind-qexp that-id bind-id env)
    (cond ((and (eq (Qexp-classname that-qexp) ':binder)
		(eq (Qexp-head bind-qexp)
		    (Qexp-head that-qexp))
		(= (long-qexps-length-dif that-qexp bind-qexp)
		   0))
	   (match-let (?_ ?this-k-or-r ?@this-vars)
		      (Long-Qexp-args bind-qexp)
	      (match-let (?_ ?that-k-or-r ?@that-vars)
			 (Long-Qexp-args that-qexp)
		 (cond ((cond ((boole-eq (listp this-k-or-r)
					 (listp that-k-or-r))
			       (cond ((listp this-k-or-r)
				      (equal this-k-or-r that-k-or-r))
				     (t
				      (!= this-vars (cons this-k-or-r *-*))
				      (!= that-vars (cons that-k-or-r *-*))
				      true)))
			      (t false))
			(values true
				(group-bind
				   that-vars this-vars
				   bind-id that-id
				   (group-bind
				      this-vars that-vars
				      bind-id that-id env))))
		       (t
			(values false env))))))
	  (t
	   (values false nil))))
)

;;;(defvar list-fcn-qexp* false)

;;; Atomic constant.  The head is the constant.
;;; The word "atom" is somewhat inappropriate, in that the head
;;; can be any quoted datum.  That's why 'equal' is used to
;;; compare two of these things.  
;;; atom-qexp's are used for any atomic expression, including
;;; non-Rigid ones.  Not clear if Rigids should be handled by
;;; having the head just be a Rigid, or whether there should
;;; be a "rigid" flag in the args, so translating back and
;;; forth between the two reps would be necessary.
;;; It depends on whether (e.g.) '3' should unify with '!=3'.  
(def-qexp-class atom
   :upriority 10
   :long false
   :unify-handler
      (\\ (t1 t2 _ _ env)
	 (values (equal (Qexp-head t1)
			(Qexp-head t2))
		 env))
   :variant-handler
      (\\ (t1 t2 _ _ _ pairings _)
	 (cond ((equal (Qexp-head t1)
		       (Qexp-head t2))
		(values true pairings false))
	       (t
		(values false pairings discrim-bdgs*))))

   :occur-checker
      (\\ (_ _ _ _ _)
	 '*const)

   :index-pat-maker
      (\\ (a-qexp)
	 (Qexp-head a-qexp))

   :main-op-extractor
     (\\ (a-qexp _ _ env)
	(values (Qexp-head a-qexp) +atomic+ env))

   :sexp-maker
      (\\ (a-qexp) (Qexp-head a-qexp)))	 

(defvar list-fcn-qexp*
   (let ((ld (global-declaration 'list opt-type-sys* true)))
      (make-Qexp :handler atom-qexp-class*
		 :type (Vartype-type ld)
		 :head 'list)))

(declaim (special list-qexp-class*))

(defvar empty-list-qexp*
    (make-Qexp :handler atom-qexp-class* :head '() :type obj-list-type*))

(defun fun-result-tup-type (fcn)
   (nity::make-tup-type 'Tup 
      (funtype-extract-reslist (Qexp-type fcn) global-opt-env*)
      false global-opt-env*))

;;; The head represents the tail, which is either nil or a variable 
;;;  (that is, the Qexp representing the empty list, or a Qexp of class qvar).
;;; These things must be indexed as though they were 
;;;  (cons x (cons x ...(cons x tail)))
;;; The args represent the elements before the tail.  The arg list
;;; must be _non-empty_.  Anyone who constructs one of these must
;;; ensure this.  Corollary: The empty list is not of class List. 
(def-qexp-class list
   :upriority 60
   :long true
   :unify-handler
      (\\ (l1 l2 id1 id2 env)
	 (case (Qexp-classname l2)
	    (:list
	     (multi-let (((args-ok args-env)
			  (list-unify (Long-Qexp-args l1)
				      (Long-Qexp-args l2)
				      id1 id2 env)))
		(cond (args-ok
		       (let ((dif-len1-len2 (long-qexps-length-dif l1 l2)))
			  (let-fun ()
			     (qexp-unify
				(cond ((> dif-len1-len2 0)
				       (list-remnant l1
						     (Long-Qexp-length l2)
						     dif-len1-len2))
				      (t (Qexp-head l1)))
				(cond ((< dif-len1-len2 0)
				       (list-remnant l2
						     (Long-Qexp-length l1)
						     (- dif-len1-len2)))
				      (t (Qexp-head l2)))
				id1 id2 args-env)
			   :where
			     (:def list-remnant (lx len-y dif)
			       (let ((rem-args (nthcdr len-y lx)))
				  (make-Long-Qexp
				     :handler list-qexp-class*
				     :type (Qexp-type lx)
				     :head (Qexp-head lx)
				     :length dif
				     :args rem-args
				     :freevars (qexps-freevars rem-args)))))))
		      (t
		       (values false args-env)))))
	    ((:complex-app :rest-app)
	     (let ((args2 (Long-Qexp-args l2)))
		(cond ((and (eq (Qexp-classname l2) ':complex-app)
			    (listp (first args2)))
		       (values false env))
		      (t
		       (multi-let (((f-ok f-env)
				    (qexp-unify list-fcn-qexp*
						(Qexp-head l2)
						id1 id2 env)))
			  (cond (f-ok
				 (and (= (long-qexps-length-dif l1 l2)
					 0)
				      (list-unify (Long-Qexp-args l1) args2
						  id1 id2 f-env)))
				(t
				 (values false f-env))))))))
	    (t
	     (values false env))))

   :variant-handler
      (\\ (l-exp qexp l-id q-id pairings env)
	 (cond ((and (eq (Qexp-classname qexp) ':list)
		     (= (long-qexps-length-dif l-exp qexp)
			0))
		(repeat :for ((x1 :in (Long-Qexp-args l-exp))
			      (x2 :in (Long-Qexp-args qexp)))
		 :result (values true pairings false)
		 :within
		    (multi-let (((x-var pl d)
				 (qexp-variants x1 x2 l-id q-id pairings env)))
		       (:continue
			:while x-var
			:result (values x-var pl d)
			   (!= pairings pl)))))
	       (t
		(values false pairings false))))

   :occur-checker
      (\\ (var l-qexp vid l-id env)
	 (let ((a-res (list-occur-check var (Long-Qexp-args l-qexp)
					vid l-id env)))
	    (ecase a-res
	       ((*has-vars *const)
		(let ((d-res (occur-check var (Long-Qexp-head l-qexp)
					  vid l-id env)))
		   (occur-check-res-combine a-res d-res)))
	       ((*self)
		'*circular)
	       ((*circular *has-boundvars)
		a-res))))

   :index-pat-maker
      (\\ (l-qexp)
	 (let-fun ((cons-conses (args)
		      (cond ((null args) (Qexp-sexp (Qexp-head l-qexp)))
			    (t
			     `(cons ,(Qexp-sexp (car args))
				    ,(cons-conses (cdr args)))))))
	    (cons-conses (Long-Qexp-args l-qexp))))

   :main-op-extractor
      (\\ (l-qexp _ _ env)
	 ;; A case could be made that the head should be tossed
	 ;; in at the end of the args --
	 (values 'list (Long-Qexp-args l-qexp) env))

   :sexp-maker
      (\\ (l-qexp)
	 (cond ((eq (Qexp-classname (Qexp-head l-qexp))
		    ':qvar)
		(let-fun ((cons-conses (args)
			     (cond ((null args) (Qexp-sexp (Qexp-head l-qexp)))
				   (t
				    `(cons ,(Qexp-sexp (car args))
					   ,(cons-conses (cdr args)))))))
		   (cons-conses (Long-Qexp-args l-qexp))))
	       (t
		`(list ,@(<# Qexp-sexp (Long-Qexp-args l-qexp)))))))

(defun list-qexp-tail (lqe)
   (let ((atl (tail (Long-Qexp-args lqe))))
      (cond ((null atl)
	     (Long-Qexp-head lqe))
	    (t
	     (make-Long-Qexp
	        :handler list-qexp-class*
		:type (Long-Qexp-type lqe)
		:head (Long-Qexp-head lqe)
		:length (- (Long-Qexp-args lqe) 1)
		:args atl
		:freevars (qexps-freevars atl))))))

;;; Head is the function, an arbitrary Qexp.  First arg is either a
;;; "list Qexp" (if the head is known to take &rest args) or a list of
;;; keys (if the head is known to take &key args) or false (if neither
;;; obtains).  This needs to consider beta reduction.  If head is a
;;; lambda-expression, perhaps we could morph into apply-qexp-class. --

(let-fun ()
   (def-qexp-class complex-app
      :upriority 50
      :long true
      :unify-handler
	 (\\ (app1 app2 id1 id2 env)
	    (multi-let (((reduced body body-id red-env)
			 (complex-try-reduce app1 id1 env)))
	       (cond
		 (reduced
		  (unify body app2 body-id id2 red-env))
		 (t
		  (let ((class2 (Qexp-classname app2)))
		     (cond ((eq class2 ':atom)
			    (values false env))
			   ((eq class2 ':complex-app)
			    ;; Reverse roles
			    (multi-let (((reduced2 body2 body-id2 red-env2)
					 (complex-try-reduce app2 id2 env)))
			       (cond (reduced2
				      (unify app1 body2 id1 body-id2
					     red-env2))
				     (t
				      (complex-try-unify
				         app1 app2 id1 id2 env)))))
			   (t
			    (complex-try-unify app1 app2 id1 id2 env))))))))

      :variant-handler
	 (\\ (cl-app qexp cl-id q-id pairings env)
	    (control-nest 
	       (multi-let (((reduced body b-id r-env)
			    (complex-try-reduce cl-app cl-id env)))
		  (cond (reduced
			 (qexp-variants body qexp b-id q-id pairings r-env))
			(t :or)))
	       :or
	       (cond ((eq (Qexp-classname qexp) ':complex-app)
		      ;; Reverse roles
		      (multi-let (((reduced2 body2 b-id2 r-env2)
				   (complex-try-reduce qexp q-id env)))
			 (cond (reduced2
				(qexp-variants cl-app body2 cl-id b-id2
					       pairings r-env2))
			       (t 
				(complex-app-variants 
				   cl-app qexp cl-id q-id pairings env)))))
		     (t
		      (complex-app-variants
			 cl-app qexp cl-id q-id pairings env)))))

      :occur-checker
	 (\\ (var c-app v-id a-id env)
	    (let ((h-res (occur-check var (Long-Qexp-head c-app)
				      v-id a-id env))
		  (args (Long-Qexp-args c-app)))
	       (case h-res
		  (*self '*circular)
		  ((*circular *has-boundvars) h-res)
		  (t
		   (let ((a-res
			    (list-occur-check
			       var
			       (cond ((listp (first args))
				      (rest args))
				     (t args))
			       v-id a-id env)))
		      (occur-check-res-combine h-res a-res))))))

      :index-pat-maker
         #'convert-to-sexp

      :main-op-extractor
         (\\ (cmplx id targ-id env)
	    (multi-let (((success body r-id env)
			 (complex-try-reduce cmplx id env)))
	       (cond (success
		      (qexp-main-op-with-id body r-id targ-id env))
		     (t
		      (case (Qexp-classname (Qexp-head cmplx))
			 (:qvar
			  (values +qvar+ '() 
				  (cond ((Varid= r-id targ-id)
					 env)
					(t
					 (nth-value
					    1
					    (new-dummy-var
					       (Qexp-head cmplx)
					       r-id targ-id env))))))
			 (:boundvar
			  (values +boundvar+ () env))
			 (:atom
			  (values (Qexp-head (Qexp-head cmplx))
				  (Long-Qexp-args cmplx)
				  env))
			 (t
			  (values +form+ (Long-Qexp-args cmplx) env)))))))

      :sexp-maker
         #'convert-to-sexp)

   :where

 (:def complex-try-reduce (c-app ca-id env)
    (multi-let (((head head-id)
		 (qexp-normalize (Long-Qexp-head c-app) ca-id env)))
       (cond ((eq (Qexp-classname head) ':binder)
	      ;;; Have faith in the type checker --
	      ;;;; (and ... (eq (Long-Qexp-head head) ':lambda))
	      (let ((binder-args (Long-Qexp-args head)))
		 (match-let (?binder-body ?k-or-r ?@non-r-params)
			    binder-args
		    (values true
			    binder-body
			    head-id
			    (beta-reduction-env
			       k-or-r non-r-params
			       (Long-Qexp-args c-app) 
			       ca-id env)))))
	     (t
	      (values false nil +ground-id+ env)))))

(:def complex-try-unify (app1 app2 id1 id2 env)
   ;; app2 must be a complex-app, key-app,
   ;; rest-app, or simple-app
   (multi-let (((f-ok f-env)
		(qexp-unify (Long-Qexp-head app1)
			    (Long-Qexp-head app2)
			    id1 id2 env)))
      (cond (f-ok
	     (app-qexps-args-unify
		app1 app2 id1 id2 f-env))
	    (t
	     (values false f-env)))))

 (:def app-qexps-args-unify (app1 app2 id1 id2 env)
    (let ((args1 (Long-Qexp-args app1))
	  (args2 (Long-Qexp-args app2))
	  (dif-len1-len2 (long-qexps-length-dif app1 app2)))
       (case (Qexp-classname app2)
	  (:simple-app
	   (cond ((and (not (first args1))
		       (= dif-len1-len2 1))
		  (list-unify (rest args1)
			      args2 id1 id2
			      env))
		 (t
		  ;; either length mismatch,
		  ;; or &rest or &key;
		  ;; no good --
		  (values false env))))
	  (:simple-rest-app
	   (cond ((and (= dif-len1-len2 0)
		       (is-Qexp (first args1)))
		  (list-unify args1 args2
			      id1 id2 env))
		 (t
		  (values false env))))
	  (:simple-key-app
	   (cond ((and (= dif-len1-len2 0)
		       (listp args1)
		       (sym-lists-equal args1 args2))
		  (list-unify (rest args1)
			      (rest args2)
			      id1 id2 env))
		 (t
		  (values false env))))
	  ;; They are both complex --
	  ((and (= dif-len1-len2 0)
	        (boole-eq (is-Qexp (first args1))
			  (is-Qexp (first args2))))
	   (cond ((is-Qexp (first args1))
		  (list-unify args1 args2
			      id1 id2 env))
		 ((sym-lists-equal (first args1)
				   (first args2))
		  (list-unify
		     (rest args1)
		     (rest args2)
		     id1 id2 env))
		 (t
		  (values false env))))
	  (t
	   (values false env)))))

 (:def convert-to-sexp (c-app)
	    (let ((args (Long-Qexp-args c-app)))
	       `(,(Qexp-sexp (Long-Qexp-head c-app))
		 ,@(cond ((listp (first args))
			  (key-args-sexp (first args) (rest args)))
			 (t
			  (rest-args-sexp args)))))))

(defun complex-app-variants (cl-app qexp cl-id q-id pairings env) 
   (cond
      ((eq (Qexp-classname qexp) ':complex-app)
       (control-nest 
	  (match-let (?cl-k-or-r ?@cl-non-rs)
		     (Long-Qexp-args cl-app)
	     (match-let (?q-k-or-r ?@q-non-rs)
			(Long-Qexp-args qexp)
		(multi-let (((rest-args-okay ra-pairings ra-d)
			     (arg-expectations-variants
				cl-k-or-r q-k-or-r cl-id q-id pairings env)))
		   (cond (rest-args-okay
			  :and)
			 (t
			  (values false ra-pairings ra-d))))))
	  :and
	  (multi-let (((fcns-okay f-pairings f-d)
		       (qexp-variants
			  (Qexp-head cl-app)
			  (Qexp-head qexp)
			  cl-id q-id ra-pairings
			  env)))
	     (cond (fcns-okay
		    :and)
		   (t
		    (values false f-pairings f-d))))
	  :and
	  (list-variants
	     cl-non-rs q-non-rs cl-id q-id
	     f-pairings env)))
      (t
       (values false pairings discrim-bdgs*))))

(defun simple-app-occur-checker (var a-qexp vid a-id env)
        (cond ((null (Long-Qexp-freevars a-qexp))
	       (values '*const env))
	      (t
	       (list-occur-check var (Long-Qexp-args a-qexp)
				 vid a-id env))))
   
;;; Applications of functions with &rest args.  First arg is a
;;; list-qexp for the &rest args.
;;; The only reason to distinguish this case from 'simple-app' is for 
;;; indexing purposes.  The &rest args are indexed as though they were
;;; a list.  (Actually, we could do away with this class, and use
;;; 'simple-app' in its place, with a little care about those rest args
;;; here and there.) --
(def-qexp-class simple-rest-app
   :upriority 30
   :long true
   :unify-handler
      (\\ (app1 app2 id1 id2 env)
	 (cond ((eq (Qexp-classname app2) ':rest-app)
		;; This will happen to do the right thing for the &rest
		;; args --
		(simple-apps-unify app1 app2 id1 id2 env))
	       (t
		(values false env))))

   :variant-handler
      (\\ (r-app qexp r-id q-id pairings env)
	 (cond ((eq (Qexp-classname qexp) ':rest-app)
		(simple-apps-variants r-app qexp r-id q-id pairings env))
	       (t
		(values false pairings discrim-bdgs*))))

   :occur-checker #'simple-app-occur-checker

   :index-pat-maker
      (\\ (rest-app)
	 `(,(place-qexp-index-pat (Qexp-head rest-app))
	   ,@(<# place-qexp-index-pat (rest (Long-Qexp-args rest-app)))
	   ,(place-qexp-index-pat (first (Long-Qexp-args rest-app)))))


   :main-op-extractor
      (\\ (rest-app _ _ env)
	 (values (Qexp-head (Qexp-head rest-app))
		 (rest (Long-Qexp-args rest-app))
		 env))

   :sexp-maker
      (\\ (rest-app)
	 `(,(Qexp-head (Long-Qexp-head rest-app))
	   ,@(<# Qexp-sexp (rest (Long-Qexp-args rest-app)))
	   ,@(let ((restarg (first (Long-Qexp-args rest-app))))
	        (cond ((and (eq (Qexp-classname restarg) ':list)
			    (eq (Qexp-head restarg) empty-list-qexp*))
		       ;; Safety check; it's always a :list with
		       ;; an empty tail.
		       (<# Qexp-sexp (Long-Qexp-args restarg)))
		      (t
		       ;; In case of gibberish, just dump it
		       (Qexp-sexp restarg)))))))

(defun list-qexps-unify (len1 len2 elts1 tail1 elts2 tail2 type1 type2 id1 id2 env)
   (multi-let (((args-ok args-env)
		(list-unify elts1 elts2 id1 id2 env)))
      (cond (args-ok
	     (let-fun ()
		(qexp-unify
		   (cond ((< len2 len1)
			  (list-remnant elts1 tail1 len1 len2 type1))
			 (t tail1))
		   (cond ((> len1 len2)
			  (list-remnant elts2 tail2 len2 len1 type2))
			 (t tail2))
		   id1 id2 args-env)
	      :where
		(:def list-remnant (lx tailx len-x len-y type-x)
		  (let ((rem-args (nthcdr len-y lx)))
		     (make-Long-Qexp
			:handler list-qexp-class*
			:type type-x
			:head tailx
			:length (- len-x len-y)
			:args rem-args
			:freevars (qexps-freevars rem-args))))))
	    (t
	     (values false args-env)))))

;;; We treat functions with &key args as equivalent to functions with the
;;; same parameters, but permuted so the args are in alphabetical order
;;; by key.
;;; The first arg is a non-empty list of keys.
(def-qexp-class simple-key-app
   :upriority 30
   :long true
   :unify-handler
       (\\ (app1 app2 id1 id2 env)
	  (cond ((and (= (Qexp-classname app2) ':simple-key-app)
		      (eq (Qexp-head (Long-Qexp-head app1))
			  (Qexp-head (Long-Qexp-head app2)))
;;;; Why check this?  There's only one predicate with the name
;;;; we just checked. --		      
;;;;		      (equal (first (Long-Qexp-args app1))
;;;;			     (first (Long-Qexp-args app2)))
		      (= (long-qexps-length-dif app1 app2) 0))
		 (list-unify (rest (Long-Qexp-args app1))
			     (rest (Long-Qexp-args app2))
			     id1 id2 env))
		(t 
		 (values false env))))

   :variant-handler
      (\\ (sk-app qexp sk-id q-id pairings env)
	 (cond ((and (eq (Qexp-classname qexp) ':simple-key-app)
		     (eq (Qexp-head (Long-Qexp-head sk-app))
			 (Qexp-head (Long-Qexp-head qexp)))
		     (= (long-qexps-length-dif sk-app qexp) 0))
		(list-variants (rest (Long-Qexp-args sk-app))
			       (rest (Long-Qexp-args qexp))
			       sk-id q-id pairings env))
	       (t
		(values false pairings env))))

   :occur-checker
       (\\ (var k-app vid k-id env)
	  (list-occur-check var (rest (Long-Qexp-args k-app))
			    vid k-id env))

    :index-pat-maker
       (\\ (key-app)
	  (let ((fcn (Long-Qexp-head key-app))
		(args (Long-Qexp-args key-app)))
	     `(,(Qexp-head fcn)
	       ,(first args)
	       ,@(<# place-qexp-index-pat (rest args)))))

    :sexp-maker
       (\\ (key-app)
	  (let ((fcn (Long-Qexp-head key-app))
		(args (Long-Qexp-args key-app)))
	     `(,(Qexp-head fcn)
	       ,@(key-args-sexp (first args) (rest args)))))

    :main-op-extractor
       (\\ (key-app _ _ env)
	  (values (Qexp-head key-app)
		  (rest (Long-Qexp-args key-app))
		  env)))

(defun rest-args-sexp (args)
   `(,@(<# Qexp-sexp (rest args))
     ,@(let ((restarg (first args)))
	  (cond ((and (eq (Qexp-classname restarg) ':list)
		      (eq (Qexp-head restarg) empty-list-qexp*))
		 ;; Safety check; it's always a :list with
		 ;; an empty tail.
		 (<# Qexp-sexp (Long-Qexp-args restarg)))
		(t
		 ;; In case of gibberish, just dump it
		 (Qexp-sexp restarg))))))

(defun key-args-sexp (keys args)
   `(,@(drop (- (len keys)) args)
     ,@(<! list keys (take (- (len keys)) args))))

(defun simple-app-sexp (app-qexp)
        (let ((args (Long-Qexp-args app-qexp))
	      (fcn (Long-Qexp-head app-qexp)))
	   `(,(Qexp-head fcn) ,@(<# Qexp-sexp args))))

;;; Apps whose functions are constant symbols, represented as Qexps of
;;; class :atom.
(def-qexp-class simple-app
   :upriority 20
   :long true
   :unify-handler
      (\\ (app1 app2 id1 id2 env)
	 (cond ((eq (Qexp-classname app2) ':simple-app)
		(simple-apps-unify app1 app2 id1 id2 env))
	       (t
		(values false env))))

  :variant-handler
     (\\ (app qexp app-id q-id pairings env)
	(cond ((eq (Qexp-classname qexp) ':simple-app)
	       (simple-apps-variants app qexp app-id q-id pairings env))
	      (t
	       (values false pairings false))))

  :occur-checker #'simple-app-occur-checker

  :index-pat-maker #'simple-app-sexp

  :sexp-maker #'simple-app-sexp

  :main-op-extractor
     (\\ (sapp _ _ env)
	(values (Qexp-head sapp) (Long-Qexp-args sapp) env)))

;;; After the class check has already been performed --
;;; The head is an atom Qexp, whose head is a Symbol.
(defun simple-apps-unify (app1 app2 id1 id2 env)
   (cond ((and (eq (Qexp-head (Long-Qexp-head app1))
		   (Qexp-head (Long-Qexp-head app2)))
	       (= (long-qexps-length-dif app1 app2) 0))
	  (list-unify (Long-Qexp-args app1)
		      (Long-Qexp-args app2)
		      id1 id2 env))
	 (t 
	  (values false env))))

(defun simple-apps-variants (app1 app2 id1 id2 pairings env)
   (cond ((and (eq (Qexp-head (Long-Qexp-head app1))
		   (Qexp-head (Long-Qexp-head app2)))
	       (= (long-qexps-length-dif app1 app2) 0))
	  (list-variants (Long-Qexp-args app1)
			 (Long-Qexp-args app2)
			 id1 id2 pairings env))
	 (t
	  (values false pairings discrim-bdgs*))))

;;; Internalization conventions:
;;; Optionals and keywords are always there, keywords in alphabetical order.
;;; &rest turned into a cons-qexp as first arg.
;;;;(defun args-uninternalize (args arglist)
;;;;   (let ()
;;;;      (cond ((not (boole-eq rest (first args)))
;;;;	     (signal-problem args-uninternalize
;;;;		"&rest args out of synch with params")))
;;;;      (let ((spec-arg (first args)))
;;;;	 (cond ((is-Qexp spec-arg)
;;;;	        (let ((rear (Long-Qexp-head spec-arg))
;;;;		      (front (Long-Qexp-args spec-arg)))
;;;;		   `(,@(<# Qexp-sexp (rest args))
;;;;		     ,@(<# Qexp-sexp front)
;;;;		     . ,(cond ((eq (Qexp-classname spec-arg) ':list)
;;;;			       (cond ((eq (Qexp-classname rear) ':qvar)
;;;;				      (Qexp-sexp rear))
;;;;				     (t '())))
;;;;			      (t
;;;;			       (signal-problem args-uninternalize
;;;;				  "Application with &rest params has "
;;;;				  " bogus &rest arg: "
;;;;				  spec-arg
;;;;				  (:proceed "I'll produce something"))
;;;;			       '())))))
;;;;	       (t
;;;;		(let ((numkeys (len spec-arg)))
;;;;		   (cond ((= numkeys 0)
;;;;			  (<# Qexp-sexp (rest args)))
;;;;			 (t
;;;;			  (let-fun ((extract-couples (keys args)
;;;;				       (cond ((null parms) '())
;;;;					     (t
;;;;					      `(,(car keys)
;;;;						,(Qexp-sexp (car args))
;;;;						,@(extract-couples (cdr keys)
;;;;								   (cdr args)))))))
;;;;			     `(,(drop (- numkeys) args)
;;;;			       ,@(extract-couples
;;;;				     spec-arg (take (- numkeys) args))))))))))))


#|
   (cond ((is-Qvar pat1)
	  (var-variant pat1 pat2 id1 id2 m1 m2 e))
	 ((is-Qvar pat2)
	  (var-variant pat2 pat1 id2 id1 m2 m1 e))
	 ((or (atom pat1) (atom pat2))
	  (strip-sym-with-type pat1)
	  (strip-sym-with-type pat2)
	  (cond ((eq pat1 pat2)
		 (values true m1 m2 nil))
		(t
		 (values false m1 m2 discrim-bdgs*))))
	 (t
	  (multi-let (((same _ _)
		       (eq-stripping-sym-with-type (car pat1) (car pat2))))
	     (cond (same
		    (do ((l1 (cdr pat1) (cdr l1))
			 (l2 (cdr pat2) (cdr l2))
			 (okaysofar t) d)
			((or (null l1) (null l2)
			     (not okaysofar))
			 (cond ((and okaysofar (null l1) (null l2))
				(values true m1 m2 nil))
			       (t
				(values false m1 m2
					(cond (okaysofar discrim-bdgs*)
					      (t d))))))
		      (multiple-value-setq (okaysofar m1 m2 d)
					   (pat-variants (car l1) (car l2)
							 id1 id2 m1 m2 e))))
		   (t (values false m1 m2 discrim-bdgs*))))))
|#


#|
CRUCIAL necessity in new regime is that you can quickly tell whether
the function in a term is and, or, not, or whatever.  It would be nice
if there were some version of match-cond or matchq that helped in
this.

Are namespaces relevant here?  Where?

|#

;;; (first args) is a list Qexp if k-or-r is not () or a list of keywords
(defun beta-reduction-env (k-or-r non-r-params args id env)
     (multi-let (((params args)
		(cond ((is-Qexp k-or-r)
		       ;; &rest param
		       (values (cons k-or-r non-r-params)
			       args))
		      (t
		       (values non-r-params args)))))
      (group-bind params args id id env)))

;;; Given a bare qexp (such as the term of an Occasion in the db),
;;; extract the symbol that is its head.
(defun qexp-head-sym (qexp)
   (repeat :for ((h = (Qexp-head qexp) :then (Qexp-head h)))
    :while (is-Qexp h)
    :result h))

(defun arg-expectations-variants (k-or-r-1 k-or-r-2 id1 id2
				  pairings env)
   (cond ((is-Qexp k-or-r-1)
	  (cond ((is-Qexp k-or-r-2)
		 (qexp-variants k-or-r-1 k-or-r-2 id1 id2 pairings env))
		(t
		 (values false pairings discrim-bdgs*))))
	 ((is-Qexp k-or-r-2)
	  (values false pairings discrim-bdgs*))
	 ((sym-lists-equal k-or-r-1 k-or-r-2)
	  (values true pairings false))
	 (t
	  (values false pairings discrim-bdgs*))))

(defun sym-lists-equal (syml1 syml2)
   (repeat :for ((a1 :in syml1 :tail tl1)
		 (a2 :in syml2 :tail tl2))
    :result (and (null tl1) (null tl2))
    :while (eq a1 a2)
    :result false))

