;-*- Mode: Common-lisp; Package: opt; Readtable: ytools; -*-
(in-package :opt)
;;; $Id: qindex.lisp,v 1.5 2005/11/23 18:16:30 dvm Exp $

; This file builds on top of the types in types.lisp to define indexing
; structures for domains.  The idea is that the domain can be defined
; independently of indexing, but whenever it is updated its indexes are
; rebuilt.

(depends-on %module/ ytools)

(depends-on :at-run-time %opt/ expdt setindex varsubst action)

(end-header :continue-slurping)

(eval-when (:compile-toplevel :load-toplevel :execute :slurp-toplevel)
   (export '(all-rule-groups domain-indexify
	     get-situation-contents uniquify-situation
	     disjunctive-normal-form dnf-neg literal-neg)))

;;; Now that index patterns are cached on assertions, we eliminate
;;; variables in advance.  So the only "variable" encountered in 
;;; an index pattern is '*dontcare'.
(defvar qvar-topcoord*
        (topcoord (\\ (_) false)))

;;;; (declaim (special topcoord*))

;;;; (setq topcoord* qvar-topcoord*)

(defvar try-rehash* t)

(defvar break-on-rehash-failure* nil)

(defvar rehash-attempts* 0)
(defvar rehash-failures* 0) 

(defmacro try-rehash (rehasher qexp qavoid as-variants &rest args)
   (let ((seek-pat-var (gen-var 'seek))
         (avoid-pat-var (gen-var 'avoid)))
      `(cond (try-rehash* 
              (let ((,seek-pat-var (place-qexp-index-pat ,qexp))
                    (,avoid-pat-var (place-qexp-index-pat ,qavoid)))
                 (setf rehash-attempts* (+ rehash-attempts* 1))
                 (let ((dif (discrim ,seek-pat-var
                                     ,avoid-pat-var
                                     qvar-topcoord*
                                     ,as-variants)))
                    (cond ((and dif
                                (,rehasher ,seek-pat-var
                                           ,avoid-pat-var
                                           dif ,as-variants ,@args)))
                          (t
                           (cond (break-on-rehash-failure*
                                  (signal-problem 
                                     "Rehash failed after no match of "
                                     ,seek-pat-var
                                     :% " and " ,avoid-pat-var
                                     :proceed)))
                           (setf rehash-failures*
                                 (+ rehash-failures* 1))))))))))

(def-class Indexed-domain 
	      (:options (:kind :object) (:include Domain))
   (fill-time 0)  
   (occasions false)   
   (actions false) ; :type exp-index  ; uniquified action terms
   (query-answer-gens false) ; - Exp-index
   (stratified-backchains false) ; - (~ Htb Boolean)
   (:handler
      (print (id srm)
	 (format srm "#<Indexed domain ~s>"
		 (Domain-name id)))))

(defun indexed-domain-with-name (name create)
   (let ((dom (try-domain-with-name name create)))
      (cond (dom
	     (domain-indexify dom))
	    (t false))))

(defvar idom*)

(def-class Initialized-problem
              (:options (:include Problem))
   expanded-goal
   (:handler
      (print (ip srm)
 	(format srm "#<Initialized problem ~s>"
 		(Problem-name ip)))))

(defun domain-indexify (dom)
   (cond ((is-Indexed-domain dom)
	  dom)
	 (t
	  (multiple-value-bind (dset dget)
			       (domain-name-procs dom)
	     (let ((value-of-name (funcall dget)))
		(cond ((is-Indexed-domain value-of-name)
		       value-of-name)
		      (t
		       (let ((rlocs (Domain-local-bdgs dom)))
			  (let ((idom (make-inst Indexed-domain
					 :fill-time 0
					 :name (Domain-name dom)
					 :uri (Domain-uri dom)
					 :generation (Domain-generation dom)
					 :ancestors nil
					 :parents (<# domain-indexify
						      (Domain-parents dom))
					 :requirements (Domain-requirements dom)
					 :local-bdgs rlocs
					 :inherited-bdgs (Domain-inherited-bdgs
							    dom)
					 :namespace (Domain-namespace dom)
					 :namespace-tab (Domain-namespace-tab dom)
					 :query-answer-gens false
					 ;;:fact-sit false
					 )))
;;;;			     (cond (+namespace-mode+
;;;;				    (!= (Domain-namespace idom)
;;;;					(Domain-namespace dom))))
			     (funcall dset idom)
			     (cond ((not (eq (funcall dget)
					     idom))
				    (signal-problem domain-indexify
				       "Failed to reset domain name for "
				       dom " --> " idom)))
			     (reset-ancestors idom)
			     (domain-mark-current idom)
			     idom)))))))))

(defun domain-initialize (domname)
  (domain-indexify (must-domain-with-name domname)))

(defun indexed-domain-make-current (idom) (domain-make-current idom))

(def-meth domain-make-current ((idom Indexed-domain))
   (call-next-method)
   (let ((ans-gens (Indexed-domain-query-answer-gens idom))
	 (stratified-backchains (Indexed-domain-stratified-backchains idom)))
      (cond ((and ans-gens
		  (exists (a :in (Domain-ancestors idom))
		     (> (Domain-generation a)
			(first ans-gens))))
	     (!= (Indexed-domain-query-answer-gens idom) false)))
      (cond ((and stratified-backchains
		  (exists (a :in (Domain-ancestors idom))
		     (> (Domain-generation a)
			(first stratified-backchains))))
	     (!= (Indexed-domain-stratified-backchains idom) false)))))

(defun Occasion-index-pat (occ)
   (place-qexp-index-pat (Occasion-prop occ)))

(defun Signed-occasion-index-pat (socc)
   (place-qexp-index-pat (Signed-occasion-prop socc)))

;;; 'occ' is a Qexp.
(defun uniquify-occasion (occ context do-variant-check)
  (let ((index (indexed-domain-place-occasion-index context))
	(occ-sexp (place-qexp-index-pat occ)))
     (dolist (cand (exp-fetch occ-sexp index true)
	           (index-new-occasion occ index))
	(cond ((and (equal (Occasion-index-pat cand) occ-sexp)
		    (or (not do-variant-check)
			(variants (Occasion-prop cand) occ
				  variant-id1* variant-id2* (empty-env))))
	       (return cand))))))

(defun place-signed-occasion (sign occ)
   (cond (sign
	  (cond ((not (Occasion-added occ))
		 (!= (Occasion-added occ)
		     (make-Signed-occasion true occ))))
	  (Occasion-added occ))
	 (t
	  (cond ((not (Occasion-deleted occ))
		 (!= (Occasion-deleted occ)
		     (make-Signed-occasion false occ))))
	  (Occasion-deleted occ))))

(defvar variant-id1* (new-Varid))
(defvar variant-id2* (new-Varid))

;;; 'occ' is a Qexp.
(defun index-new-occasion (occ index)
   (let ((newocc
            (cond ((and (eq (Qexp-classname occ) ':simple-app)
			(eq (Qexp-head (Qexp-head occ)) '<-))
		   (let ((args (Long-Qexp-args occ)))
		      (make-Back-chainer
			 :term occ
			 :consequent (car args)
			 :antecedent (cadr args))))
		  (t
		   (make-Occasion occ false false)))))
      (exp-ob-index newocc index true)
      newocc))

(defun indexed-domain-place-occasion-index (idom)
   (let ((oi (Indexed-domain-occasions idom)))
      (cond ((not oi)
	     (setq oi (exp-index-init #'Occasion-index-pat qvar-topcoord*))
	     (setf (Indexed-domain-occasions idom)
		   oi)))
      oi))

;;; This uniquifies 'sit', but it also freezes it (makes Situation-frozen
;;; be true).  Hence all uniquified situations are frozen.  (Not clear 
;;; whether any later code thaws and refreezes them; this would be very
;;; dangerous unless the changes made preserved meaning in some sense.)
(defun uniquify-situation (sit sit-cache)
   (let ((init (find-init-situation sit))
	 (index (Situation-diff-from-init sit)))
      (let ((ind (or sit-cache (Initial-situation-sit-index init)))
	    (conts (exp-index-contents index false)))
	 (cond ((not ind)
		(err-out "Constructing Sit-index for situation space "
			 init :%)
		(setq ind (new-Eq_setindex #'get-situation-contents))
		(eq-index-add init ind)
		(setf (Initial-situation-sit-index init)
		      ind)))
	 (dolist (cs (elts-eq-index-fetch conts ind)
		  (progn
		     (!= (Situation-contents sit) conts)
		     (!= (Situation-frozen sit) true)
		     (eq-index-add sit ind)
		     sit))
	   (cond ((and (exp-index-subconts index (Situation-diff-from-init cs))
		       (exp-index-subconts (Situation-diff-from-init cs)
					   index))
		  (return cs)))))))

(defun initial-situation-domain-indexify (isit)
   (let ((idom (Initial-situation-domain isit)))
     (cond ((not (is-Indexed-domain idom))
	    (setf idom (domain-indexify idom))
	    (setf (Initial-situation-domain isit)
		  idom)))
     (indexed-domain-make-current idom)
     idom))

(defun initial-situation-out-of-date (sit expect-local-index idom)
   (or (not (Initial-situation-fact-index sit))
       (and expect-local-index
	    (not (Initial-situation-init-index sit)))
       (some #'(lambda (a)
		  (> (Domain-generation a)
		     (Initial-situation-generation sit)))
	     (Domain-ancestors idom))))
						
;; This procedure returns only the "local"
;; contents, that is, the contents that distinguish this situation
;; from others in the same space.
(defun get-situation-contents (sit)
    (let ((c (Situation-contents sit)))
       (cond ((eq c '*uncomputed)
	      (let ((conts (exp-index-contents
			      (Situation-diff-from-init sit)
			      nil)))
		 (cond ((Situation-frozen sit)
			(setf (Situation-contents sit)
			      conts)))
		 conts))
	     (t c))))
      
(defun indexify-universal-ancestors ()
   (setf universal-ancestors*
	 (mapcar #'domain-indexify universal-ancestors*))
   (repeat :for ((ud :in universal-ancestors*)
		(g (next-generation)))
      (!= (Indexed-domain-parents ud)
	  (<# domain-indexify *-*))
      ;; We can't use reset-ancestors here; it applies only to
      ;; non-universal domains.
      (!= (Indexed-domain-ancestors ud)
	  (<# domain-indexify *-*))
      (!= (Indexed-domain-generation ud) g)))

(defun all-rule-groups (dom)
   (let ((groups '())
	 (checked-domains '()))
      (labels ((check-next (dom)
		  (cond ((not (member dom checked-domains :test #'eq))
			 (push dom checked-domains)
			 (dolist (bdg (domain-get-local-bdgs dom))
			    (cond ((is-Vartype bdg)
				   (let ((x (Domain-bdg-val bdg)))
				     (cond ((is-Rule-group x)
					    (push x groups)))))))
			 (dolist (sup (Domain-ancestors dom))
			    (cond ((is-Domain sup)
				   (check-next sup))))))))
	  (check-next dom)
	  groups)))


;; If substing all Qvars out of x results in a constant that satisfies
;; pred, return it; otherwise false.  
(defun subst-to-constant (pred x id bdgs)
   (multi-let ((x
		(unsafe-varsubst x id bdgs)))
      (and (not (has-qvars x))
	   (funcall pred x)
	   x)))

;;; Put E in disjunctive normal form (or not-E if 'polarity' = false)
(defun disjunctive-normal-form (e polarity)
   (cond ((atom e)
	  (cond ((memq e '(true false))
		 (cond ((eq (eq e 'true) polarity)
			'(()))
		       (t '())))
		(t
		 `((,(cond (polarity e) (t `(not ,e))))))))
	 ((eq (car e) 'not)
	  (disjunctive-normal-form (cadr e) (not polarity)))
	 ((memq (car e) '(and or))
	  (cond ((eq (eq (car e) 'or) polarity)
		 (repeat :for (x :in (cdr e))
		  :nconc (disjunctive-normal-form x polarity)))
		(t
		 (</ (\\ (r x)
		        (dnf-conjoin r (disjunctive-normal-form x polarity)))
		     `(())
		     (cdr e)))))
	 ((eq (car e) 'if)
	  (cond (polarity
		 (nconc (disjunctive-normal-form (cadr e) false)
			(disjunctive-normal-form (caddr e) true)))
		(t
		 (dnf-conjoin (disjunctive-normal-form (cadr e) true)
			      (disjunctive-normal-form (caddr e) false)))))
	 (t
	  `((,(cond (polarity e) (t `(not ,e))))))))		   

;;; Deletes duplicates that would otherwise be created.
(defun dnf-conjoin (d1 d2)
   (repeat :for (c1 :in d1)
    :nconc (repeat :for (c2 :in d2)
	    :collect
	    `(,@c1 ,@(<? (\\ (x) (not (member x c1 :test #'equalp)))
			 c2)))))

; Given a disjunction of conjunctions, produce its negation also
; as a disjunction of conjunctions
(defun dnf-neg (dl)
   (cond ((null dl)
	  (list '()))
	 (t
	  (let ((rn (dnf-neg (cdr dl))))
	     (repeat :for (c :in (car dl))
	      :nconc
		(let ((nc (literal-neg c)))
		      (repeat :for (n :in rn)
		       :collect 
			 (cons nc n))))))))

(defun literal-neg (l)
   (cond ((car-eq l 'not) (cadr l))
	 (t `(not ,l))))

(defun good (_) true)

;; Conveniences
(defun dom-ind (name)
   (let ((dom (try-domain-with-name name false)))
      (cond (dom
	     (domain-indexify dom))
	    (t '"No such domain"))))

(defun fact-sit-contents (fsit)
   (exp-index-contents (Initial-situation-fact-index fsit)
		       true))

(defun et-see (tr depth signed)
   (exptree-see tr depth 0 nil
		(cond (signed #'Signed-occasion-prop)
		      (t #'Occasion-prop))))

	