;-*- Mode: Common-lisp; Package: opt; Readtable: ytools; -*-
;;;$Id: qinternalize.lisp,v 1.11 2006/03/09 16:12:02 dvm Exp $

(in-package :opt)

(depends-on %module/ ytools)

(depends-on (:at :compile-time :run-time)
            %opt/ qexp-classes)

(depends-on :at-run-time %opt/ more-syntax syntax process axiom
			 %nity/ typeintsect)

(end-header :continue-slurping)

;;; 'goal-position' is either ':consequent', ':antecedent', or false.
;;; 'freevars' describes variables that are expected to occur free in
;;; 'te'.  These are bound in Typed-exps containing the one currently
;;; being internalized, and some will remain bound internally (i.e.,
;;; will be :boundvar's instead of :qvar's).  
;;; Each element of freevars is a Vartype
;;; whose 'val' is the sym's replacement if it is being renamed, and 
;;; whose 'bound' feature is a boolean that is true iff the result should be a
;;; :boundvar.
;;; Returns a Qexp.
(def-op internalize (te freevars goal-position))
   
;;; Principle: Although 'internalize' sometimes builds new Typed-exps,
;;; it never creates any new bugs in them, or pays attention to any that
;;; are created as a byproduct.  If the type checker did its job
;;; correctly, there will not be any bugs (!). 

(def-meth internalize ((vte Var-typed-exp) freevars _)
   (let ((entry (alref. freevars (Var-typed-exp-var vte)
			(signal-problem Var-typed-exp/internalize
			   "Unexpected free variable " vte))))
      ;; Note that 'entry' is the 'rest' of a triple.
      (cond ((second entry)
	     (build-Qexp :boundvar
		(first entry)
		:type (Typed-exp-type vte)))
	    (t
	     (build-Qexp :qvar
		(first entry)
		:type (Typed-exp-type vte))))))

(def-meth internalize ((const-te Const-typed-exp) _ _)
   (build-Qexp :atom
      (let ((val (Const-typed-exp-val const-te)))
	 (cond ((car-eq val 'quote) (cadr val))
	       ((is-Constant val)
		(Constant-name val))
	       ((atom val) val)
	       (t
		(signal-problem internalize
		   "Illegal as val of Const-typed-exp: " val))))
      :type (Typed-exp-type const-te)))

;;;;(defvar nil-qexp* (build-Qexp :atom
;;;;			      '() :type apptype))

(def-meth internalize ((appte App-typed-exp) freevars goal-pos)
   (let ((fcn (App-typed-exp-fcn appte))
	 (args (App-typed-exp-args appte))
	 (apptype (Typed-exp-type appte)))
      ;; Higher-level apps disappear internally --
      (multi-let (((fcn fcntype apptype)
		   (cond ((and (is-App-typed-exp fcn)
			       (> (App-typed-exp-level fcn) 0))
			  (values (App-typed-exp-fcn fcn)
				  (type-bound
				     (App-typed-exp-type fcn)
				     true true ':all empty-env*)
				  (type-bound
				     apptype true true ':all empty-env*)))
			 (t
			  (values fcn
				  (App-typed-exp-type fcn)
				  apptype)))))
	 (cond ((is-Const-typed-exp fcn)
		(let ((cname (Const-typed-exp-ext fcn)))
		   (cond ((eq cname 'list)
			  (cond ((null args)
				 empty-list-qexp*)
				(t
				 (build-Qexp :list
					!()
					:args (list-internalize
						 args freevars false)
					:type apptype))))
			 ((eq cname 'cons)
			  (cons-app-te-internalize args apptype))
			 ((eq cname 'apply)
			  (apply-te-internalize appte apptype freevars))
			 ((eq cname 'iff)
			  (iff-internalize 
			     (App-typed-exp-args appte)
			     freevars goal-pos))
			 (t
			  (normal-app-typed-exp-internalize
			     false 
			     (build-Qexp :atom
				cname :type fcntype)
			     fcntype apptype args freevars goal-pos)))))
	       (t
		(normal-app-typed-exp-internalize
		   true
		   (internalize fcn freevars false)
		   fcntype apptype args freevars))))))

(defun cons-app-te-internalize (args apptype freevars)
   (let-fun ()
      (multi-let (((pre-tail-args tail-arg)
		   (find-tail args)))
	 (build-Qexp :list
	    tail-arg 
	    :args pre-tail-args
	    :type apptype))
    :where

      (:def find-tail (args)
	 (cond ((null args)
		(values !() false))
	       (t
		(let ((a1 (internalize (first args) freevars)))
		   (control-nest
		      (let ((tail-te (second args)))
			 (cond ((is-App-typed-exp tail-te)
				:and)
			       (t
				(values (list a1) tail-te))))
		    :and
		      (let ((tail-fcn (App-typed-exp-fcn
					    tail-te)))
			 (cond ((is-Const-typed-exp tail-fcn)
				:and)
			       (t
				(values (list a1) tail-te))))
		    :and
		      (let ((fcn-name (Const-typed-exp-ext
					  tail-fcn)))
			 (cond ((eq fcn-name 'cons)
				(multi-let (((pre-tl tl)
					     (find-tail (App-typed-exp-args
							    tail-te))))
				   (values (cons a1 pre-tl)
					   tl)))
			       ((eq fcn-name 'list)
				(let ((qexpl (list-internalize
						(App-typed-exp-args
						    tail-te)
						freevars goal-pos)))
				   (values (cons a1 qexpl)
					   false)))
			       (t
				(values (list a1) tail-te)))))))))))

(defun apply-te-internalize (appte apptype freevars)
   (build-Qexp :apply
      (internalize (first (App-typed-exp-args appte))
		   freevars false)
      :args (list (internalize (second (App-typed-exp-args appte))
			       freevars false))
      :type apptype))

(defvar true-qexp*
    (build-Qexp :atom
       'true :type bool-type*))

;;; This is not actually used, because iffs are expanded away during
;;; parsing.  See more-syntax.lisp. -- 
(defun iff-internalize (args freevars goal-pos)
   (let ((p (car args))
	 (q (cadr args)))
      (let ((p-l
	     (internalize p freevars
			  (goal-pos-flip goal-pos)))
	    (p-r
	     (internalize p freevars goal-pos))
	    (q-l
	     (internalize q freevars
			  (goal-pos-flip goal-pos)))
	    (q-r
	     (internalize q freevars goal-pos)))
	 (boolapp-qexp
	    'and
	    (list (if-internalize 'if p-l q-r true-qexp*)
		  (if-internalize 'if q-l p-r true-qexp*))))))

(defun normal-app-typed-exp-internalize (complex fcn-qexp fcntype
					 apptype arg-tel freevars)
   (let ((arglist (type-find-feature
		     fcntype 'arglist global-opt-env*)))
      (let-fun ()
	 (multi-let (((handler args)
		      (cond ((null (Arglistspec-key arglist))
			     (cond ((null (Arglistspec-rest arglist))
				    (simple-handler-and-args))
				   (t
				    (key-handler-and-args))))
			    (t
			     (rest-handler-and-args)))))
	    (make-Long-Qexp
	       :head fcn-qexp
	       :handler handler
	       :args args
	       :type apptype
	       :length (length args)
	       :freevars (cond ((and complex
				     (is-Long-Qexp fcn-qexp))
				(unionq (Long-Qexp-freevars fcn-qexp)
					(qexps-freevars args)))
			       (t (qexps-freevars args)))
	       :index-pat false)
	  :where
	  
 (:def simple-handler-and-args ()
     (cond (complex
	    (values complex-app-qexp-class*
		    (cons false (list-internalize args freevars))))
	   (t
	    (values simple-app-qexp-class*
		    (list-internalize args freevars)))))

 (:def key-handler-and-args ()
    (let* ((key-args
	      (nthcdr (len (Argslistspec-required arglist))
		      arg-tel))
	   (req-args (ldiff arg-tel key-args)))
       ;; This works (I hope) because the type-checker
       ;; fills in _all_ keyword args, using defaults for
       ;; the absent ones.--
       (!= key-args
	   (sort
	      (repeat :for ((kal = key-args :then (rest (rest kal)))
			    :collector key-pairs)
	       :collect (tuple (first kal) (second kal)))
	      (\\ (key-pair1 key-pair2)
		 (string< (Symbol-name (first key-pair1))
			  (Symbol-name (first key-pair2))))))
       (values (cond (complex
		      complex-app-qexp-class*)
		     (t
		      simple-key-app-qexp-class*))
	       (cons (<# first key-args)
		     (nconc
			 (list-internalize req-args freevars)
			 (<# second key-args))))))

 (:def rest-handler-and-args ()
    (let* ((rest-args
	      (nthcdr (len (Arglistspec-required
			      arglist))
		      arg-tel))
	   (req-args
	      (ldiff arg-tel rest-args))
	   (rest-qexps
	      (list-internalize
		 rest-args freevars)))
       (values
	  (cond (complex
		 complex-app-qexp-class*)
		(t
		 simple-rest-app-qexp-class*))
	  (cons (build-Qexp :list
		   false
		   :args rest-qexps
		   :type (make-tup-type
			    'Tup
			    (args->spec
			       (<# Qexp-type
				   rest-qexps))))
		(list-internalize
		   req-args freevars)))))))))

(defun list-internalize (te-list freevars)
   (<# (\\ (te) (internalize te freevars false))
       te-list))

(def-meth internalize ((tte Type-typed-exp) _ _)
   (let ((desig (type-find-designator (Type-typed-exp-which tte)
				      (Typed-exp-env tte))))
      (cond ((atom desig)
	     (build-Qexp :atom desig :type type-type*))
	    (t
	     (signal-problem Type-typed-exp/internalize
		"No way to internalize " tte " implemented")))))

(def-meth internalize ((tte Type-test-typed-exp) freevars goal-pos)
   (let ((which-exp
	    (internalize (Type-test-typed-exp-which tte)
			 freevars goal-pos))
	 (arg-exp
	    (internalize (Type-test-typed-exp-arg tte)
			 freevars goal-pos)))
      (build-Qexp :simple-app
	 (build-Qexp :atom 'is :type false)
	 :args (list which-exp arg-exp)
	 :type bool-type*)))

(defvar bvar-disting* 0)

(defvar =-qexp*
    (build-Qexp :atom
       '= :type (compile-time-designated-type
		   (Fun Boolean (Obj Obj))
		   opt)))

;; bindings slot contains Arglistspec
(def-meth internalize ((qte Quantified-typed-exp) freevars goal-pos)
   (control-nest
      (cond ((> (Quantified-typed-exp-level qte)
		0)
             ;; We really should do something with the bound type variables
             ;; but currently we go with a naive type-erasure algorithm.
             ;; (Because it's not clear what the types are for!)
	     (internalize
                (Quantified-typed-exp-body qte)
                freevars goal-pos))
            (t
             :level-0))
    :level-0
      (let ((qvarbdgs (Quantified-typed-exp-bindings qte))
            (quantifier (Quantified-typed-exp-quantifier qte))
            (universal (Quantified-typed-exp-universal qte)))
         (let* ((nonvacuous-qvarbdgs
                   (cond ((Quantified-typed-exp-use-bindings-as-constraints
                             qte)
                          (<? (\\ (vt)
                                 (not (eq (Vartype-type vt) univ-type*)))
                              qvarbdgs))
                         (t !())))
                (keep-quantifier
                   (Quantified-typed-exp-keep-quantifier qte))
                (qvar-freevars 
                   (<# (\\ (qv)
                          (let ((v (Vartype-var qv)))
                             (tuple v
                                    (cond ((eq quantifier 'freevars)
                                           (make-Qvar v !()))
                                          (t
                                           (build-symbol
                                                 (< v) -
                                                 (++ bvar-disting*))))
                                    keep-quantifier)))
                       qvarbdgs))
                (aug-freevars
                   (append qvar-freevars freevars)))
            (let-fun ()
               (let ((body-te 
                        (cond ((null nonvacuous-qvarbdgs)
                               (Quantified-typed-exp-body qte))
                              ((or (eq quantifier 'forall)
                                   (and universal
                                        (eq quantifier 'freevars)))
                               (add-type-filter-prec
                                         (Quantified-typed-exp-body qte)
                                         nonvacuous-qvarbdgs
                                         (cond (keep-quantifier 'if)
                                               (t '<-))))
                              (t
                               (add-type-filter-conj
                                        (Quantified-typed-exp-body qte)
                                        nonvacuous-qvarbdgs)))))
                  (let ((body-formula
                           (internalize body-te aug-freevars goal-pos)))
                     (build-it body-formula)))
             :where

    (:def build-it (e)
      (cond (keep-quantifier
             (cond ((eq quantifier 'exists!)
                    (let ((paired-vars (<# (\\ (_) (gensym))
                                           qvars)))
                       (build-Qexp :binder
                          'exists
                          :args (cons (boolapp-qexp
                                         'and
                                         (list e
                                               (uniqueness-qexp paired-vars)))
                                      (cons false (<# second qvar-freevars)))
                          :type (Typed-exp-type qte))))
                   (t
                    (build-Qexp :binder
                       quantifier
                       :args (cons e (cons false (<# second qvars)))
                       :type (Typed-exp-type qte)))))
            (t e)))

    (:def uniqueness-qexp (paired-vars)
       (build-Qexp :binder
          'forall
          :args
             (cons (if-internalize
                      'if (internalize body-te
                                       (append (<# (\\ (trip pvar)
                                                      (tuple (first trip)
                                                             pvar
                                                             (third trip)))
                                                   qvar-freevars)
                                               freevars)
                                       (goal-pos-flip goal-pos))
                          (boolapp-qexp
                            'and (<# equality-qexp
                                     qvar-freevars paired-vars qvarbdgs))
                          true-qexp*)
                   (cons false paired-vars))
          :type prop-type*))

    (:def equality-qexp (v pv qv-vt)
       (build-Qexp :simple-app
          =-qexp*
          :args (list (build-Qexp :boundvar
                         (first v)
                         :type (Vartype-type qv-vt))
                      (build-Qexp :boundvar
                         pv
                         :type (Vartype-type qv-vt)))
          :type bool-type*)))))))
				
;;; 'type-filter-vartypes' is known to be non-().
(defun add-type-filter-prec (te type-filter-vartypes prag)
   (cond ((is-If-typed-exp te)
	  (multi-let (((filt-consis useful-filters)
		       (type-filter-conj (If-typed-exp-test te)
					 type-filter-vartypes)))
	     (cond (filt-consis
		    (cond ((null useful-filters)
			   te)
			  (t
			   (let ((prag (If-typed-exp-prag te))
				 (ty (Typed-exp-type te))
				 (env (Typed-exp-env te))
				 (totbugs (Typed-exp-totbugs te))
				 (tvars (Typed-exp-tvars te))
				 (test (If-typed-exp-test te))
				 (iftrue (If-typed-exp-iftrue te))
				 (iffalse (If-typed-exp-iffalse te)))
			      (let-fun ((if-filters (te1 cond1 prag1)
					   (let ((test-te
						    (typed-exp-conjoin-with-filters
						       cond1 useful-filters env)))
					      (make-inst If-typed-exp
						 :type ty
						 :env env
						 :prag prag1
						 :test test-te
						 :iftrue te1
						 :iffalse iffalse
						 :source (if-source
						            prag1 test-te te1 iffalse)
						 :ext (if-ext
						         prag1 test-te te1 iffalse)
					     :totbugs (Typed-exp-totbugs te1)
					     :tvars tvars))))
				 (case prag
				    ((<- >-)
				     (if-filters iftrue test prag))
				    (->
				     (let ((test-te (If-typed-exp-test te))
					   (true-te
					      (if-filters iftrue false '>-)))
					(make-inst If-typed-exp
					   :type ty
					   :env env
					   :prag '->
					   :test test-te
					   :iftrue true-te
					   :iffalse iffalse
					   :source (if-source
						      '-> test-te true-te iffalse)
					   :ext (if-ext
						   '-> test-te true-te iffalse)
					   :totbugs totbugs
					   :tvars tvars)))
				    (t
				     (if-filters te false 'if))))))))
		   (t
		    true-te*))))
	 ((and (is-Boolapp-typed-exp te)
	       (eq (Boolapp-typed-exp-fcn te) 'and))
	  (let ((conjuncts
		   (<# (\\ (c)
			  (add-type-filter-prec c type-filter-vartypes prag))
		       (Boolapp-typed-exp-args te))))
	     (build-and-typed-exp
	        conjuncts (Typed-exp-env te))))
	 (t
	  (typed-exp-conditionalize
	     te
	     (typed-exp-conjoin-with-filters
	        false type-filter-vartypes (Typed-exp-env te))
	     prag))))

(defun build-and-typed-exp (arg-tel env)
   (repeat :for ((arg-te :in arg-tel)
		can-continue can-stop 
		(can-stop-early false)
		continue-bdgs stop-bdgs
		(all-continue-bdgs !(Vartype))
		(stop-alts !((Lst Vartype))))
      (!= < can-continue continue-bdgs >
	  (typed-exp-type-narrow arg-te true true-type*))
      (!= < can-stop stop-bdgs >
	  (typed-exp-type-narrow arg-te true false-type*))
      (cond ((and can-stop (not can-stop-early))
	     (!= can-stop-early true)))
    :while can-continue
      (!= all-continue-bdgs
	  (append continue-bdgs *-*))
      (!= stop-alts (cons stop-bdgs *-*))
    :result (make-inst Boolapp-typed-exp
		 :fcn 'and
		 :args arg-tel
		 :source `(and ,@(<# Typed-exp-source arg-tel))
		 :ext `(and ,@(<# Typed-exp-ext arg-tel))
		 :type-conseqs
		    (tuple (tuple can-continue
				  (vartypes-rem-duplicates all-continue-bdgs))
			   (tuple can-stop-early
				  (vartypes-disjoin stop-alts)))
		 :type prop-type*
		 :env env
		 :bugs '())))

(defun typed-exp-conditionalize (te condition prag)
   (let ((ext (if-ext prag condition te true-te*)))
      (make-inst If-typed-exp
	 :type (Typed-exp-type te)
	 :env (Typed-exp-env te)
	 :prag prag
	 :test condition
	 :iftrue te
	 :iffalse true-te*
	 :source (if-source prag condition te false)
	 :ext ext
	 :totbugs (Typed-exp-totbugs te)
	 :tvars (Typed-exp-tvars te))))

(defun add-type-filter-conj (te type-filter-vartypes)
   (multi-let (((filt-consis useful-filters)
		(type-filter-conj te type-filter-vartypes)))
      (cond (filt-consis
	     (cond ((null useful-filters)
		    te)
		   (t
		    (typed-exp-conjoin-with-filters
		       te useful-filters (Typed-exp-env te)))))
	    (t
	     false-te*))))

(defun type-filter-conj (te type-filter-vartypes)
   (multi-let ((inferred-vartypes
		(typed-exp-argtypes-infer
		   te prop-type* 'true 
		   (<# Vartype-var type-filter-vartypes))))
      (multi-let (((filt-consis useful)
		   (type-filters-cull type-filter-vartypes
				      inferred-vartypes)))
	 (cond (filt-consis
		(values true useful))
	       (t
		(err-out "Type filters " type-filter-vartypes
			 :% " inconsistent with " te)
		(dbg-save te type-filter-vartypes inferred-vartypes)
		(breakpoint type-filter-conj
		   "What now?")
		(values false nil))))))

;;; Returns < consis, non-vacs >
;;; where consis iff all type-filter-vartypes are consistent with
;;; inferred-vartypes; non-vacs are all type-filter-vartypes that do not
;;; follow-from inferred-vartypes.
;;; If consis=false, non-vacs is meaningless and unimportant.
(defun type-filters-cull (type-filter-vartypes inferred-vartypes)
   (repeat :for ((tfvt :in type-filter-vartypes)
		(non-vacs !(Vartype))
		(consis true))
      (let ((inf (vartypes-lookup (Vartype-var tfvt)
				  inferred-vartypes)))
	 (cond (inf
		(let ((inferred-type (Vartype-type inf))
		      (filter-type (Vartype-type tfvt)))
		   (cond ((not (type-acceptable
				  false inferred-type filter-type !()
				  global-opt-env* global-opt-env* !()))
			  ;; Nonvacuous, but is it consistent?
			  (cond ((type-acceptable
				    false filter-type inferred-type !()
				    global-opt-env* global-opt-env* !())
				 ;; Yes
				 (!= non-vacs (cons tfvt *-*)))
				(t
				 ;; Oops
				 (!= consis false)))))))
	       (t
		(!= non-vacs (cons tfvt *-*)))))
    :while consis
    :result (values consis non-vacs)))
	   
;;; te is false if vacuous.  useful-filters is non-()
(defun typed-exp-conjoin-with-filters (te useful-filters env)
   (multi-let (((te-consistent te-true-bdgs)
		(cond (te (typed-exp-type-narrow te true true-type*))
		      (t (values true '()))))
	       ((te-nonvacuous te-false-bdgs)
		(cond (te (typed-exp-type-narrow te true false-type*))
		      (t (values false nil))))
	       (source-conjuncts
		  (qvarbdgs-constraints useful-filters env)))
      (make-inst Boolapp-typed-exp
	 :fcn 'and
	 :args (nconc (cond (te (list te))
			    (t !()))
		      (<# (\\ (vt)
			      (vartype-test-typed-exp vt env))
			  useful-filters))
	 :source `(and ,@(include-if te (Typed-exp-source te))
		       ,@source-conjuncts)
	 :ext `(and ,@(include-if te (Typed-exp-ext te))
		       ,@source-conjuncts)
	 :type-conseqs
	    (tuple (tuple te-consistent
			  (append useful-filters te-true-bdgs))
		   (tuple te-nonvacuous
			  te-false-bdgs))
	 :type prop-type*
	 :env env
	 :bugs '()
	 :totbugs (cond (te (Typed-exp-totbugs te)) (t 0)))))

(defun vartype-test-typed-exp (vt env)
   (let ((var (Vartype-var vt))
	 (type (Vartype-type vt)))
      (let ((type-te
	       (make-inst Type-typed-exp
		  :which type
		  :source (type-find-designator
			     type global-opt-env*)
		  :env global-opt-env*))
	    (var-te
	       (make-inst Var-typed-exp
		  :var var
		  :qvar false
		  :source var)))
	 (make-inst Type-test-typed-exp
	    :which type-te
	    :arg var-te
	    :env env
	    :source `(is ,(Typed-exp-source type-te) ,var)
	    :ext `(is ,(Typed-exp-ext type-te) ,var)
	    :subexps (list type-te var-te)
	    :tvars '()))))

(def-meth internalize ((mte Maker-typed-exp) freevars _)
   (multi-let (((arg-tel linkspots)
		(app-typed-exp-args-internalize mte freevars false)))
      (values `(make (Maker-typed-exp-type mte)
		;; ,(internalize (Maker-typed-exp-fcn mte) freevars false)
		,@arg-tel)
	      linkspots)))

(def-meth internalize ((slte Slot-acc-typed-exp) freevars _)
   (multi-let (((acc ls-slot)
		(internalize (Slot-acc-typed-exp-fcn slte)
			     freevars false))
	       ((args ls-args)
		(app-typed-exp-args-internalize slte freevars false)))
      (values
	 `(,acc ,@args)
	 (nconc ls-slot ls-args))))

(def-meth internalize ((sfte Slot-fun-typed-exp) _ _)
   (values (Slot-fun-typed-exp-fcn-name sfte)
	   !()))

;;;;(defvar +fake-pred-qexp+
;;;;    (build-Qexp :atom 'fake-pred :type univ-type*))

(def-meth internalize ((ute Unchecked-typed-exp) freevars _)
   (match-cond (Unchecked-typed-exp-source ute)
      (:? (goal-call ?pf)
       (build-Qexp :binder
	  (build-Qexp :atom 'goal-call :type (Typed-exp-type ute))
	  :args (list* (build-Qexp :simple-app
                          (build-Qexp :atom pf :type false) 
                          :args (<# (\\ (vt)
                                       (build-Qexp :qvar
                                          (or (Vartype-val vt)
                                              (Vartype-var vt))
                                          :type (Vartype-type vt)))
                                    freevars)
                          :type (Typed-exp-type ute))
                       false
                       (<# (\\ (vt)
			      (or (Vartype-val vt)
                                  (Vartype-var vt)))
                           freevars))
	  :type (list* prop-type*
                       false
                       (<# Vartype-type freevars))))
      (:? ?e
	(qvarify-freevars e freevars))))

(defun build-goal-call (proc) `(goal-call ,proc ,(make-Qvar proc '())))

(def-meth internalize ((ifte If-typed-exp) freevars goal-pos)
   (let ((test-exp (internalize (If-typed-exp-test ifte)
				freevars
				(goal-pos-flip goal-pos)))
	 (iftrue-exp (internalize (If-typed-exp-iftrue ifte)
				  freevars goal-pos))
	 (iffalse-exp (internalize (If-typed-exp-iffalse ifte)
				   freevars goal-pos))
	 (if-prag (If-typed-exp-prag ifte)))
      (if-internalize if-prag test-exp iftrue-exp iffalse-exp)))

(defun if-internalize (if-prag test-exp iftrue-exp iffalse-exp)
      (multi-let (((args argtype)
		   (ecase if-prag
		      ((-> >-)
		       (values (list test-exp iftrue-exp)
			       (compile-time-designated-type
				   (Arg test if-true - Prop)
				   opt)))
		      (<-
		       (values (list iftrue-exp test-exp)
			       (compile-time-designated-type
				  (Arg if-true test - Prop)
				  opt)))
		      (if
		       (values (list test-exp iftrue-exp iffalse-exp)
			       (compile-time-designated-type
				  (Arg test-exp iftrue-exp iffalse-exp)
				  opt))))))
	 (build-Qexp :simple-app
	    (build-Qexp :atom
	       if-prag
	       :type (make-funtype 0 
			prop-type* argtype
			(args->spec (list prop-type*))
			(type-find-feature
			    argtype 'nity::elt-types global-opt-env*)
			false global-opt-env*))
	    :args args)))

(defvar boole-fcn-type*
    (compile-time-designated-type
        (Fun Prop (&rest Prop))
	opt))

(def-meth internalize ((bappte Boolapp-typed-exp) freevars goal-pos)
   (let ((args (list-internalize
		   (Boolapp-typed-exp-args bappte)
		   freevars goal-pos)))
      (boolapp-qexp (Boolapp-typed-exp-fcn bappte)
		    args)))

(defun boolapp-qexp (fcn args)
      (build-Qexp :simple-rest-app
	 (build-Qexp :atom
	    fcn
	    :type boole-fcn-type*)
	:args (list (build-Qexp :list
		       false :args args :type (make-lstype bool-type*)))
	:type bool-type*))

(defvar durham-at-type*
    (compile-time-designated-type
        (Fun Prop ((Con 'start 'end) Prop))
	opt))

(defvar durham-over-type*
    (compile-time-designated-type
        (Fun Prop ((Con 'all) Prop))
	opt))

(def-meth internalize ((dtte Durham-timed-typed-exp) freevars goal-pos)
   (let ((term
	    (internalize (Durham-timed-typed-exp-term dtte)
			 freevars goal-pos)))
      (let ((time-spec (Durham-timed-typed-exp-time-spec dtte)))
	 (build-Qexp :simple-app
	    (build-Qexp :atom
	       (car time-spec)
	       :type (cond ((eq (car time-spec) 'at) durham-at-type*)
			   (t (durham-over-type*))))
	    :args (list (build-Qexp :atom (cadr time-spec) :type false)
			term)
	    :type (Typed-exp-type dtte)))))

(defun goal-pos-flip (goal-pos)
			     (selq goal-pos
				(:consequent ':antecedent)
				(:antecedent ':consequent)
				(t false)))

;;; From the assumption that 'te' has a well-defined value (when
;;; first-orderified), infer what the types of the variables that
;;; occur in it must be.  'targ-type' is the type that we can infer
;;; for 'te' given the context it occurred in.  This is often less
;;; specific than (Typed-exp-type te).
;;; 'val' is a characterization of the value,
;;; either 'true', 'false', or 'def'.  'def' means "a value about which
;;; we can prove something."
;;; 'vars' are the variables that
;;; we are interested in.  
(def-op typed-exp-argtypes-infer (te targ-type val vars)
                                 (ignore val vars targ-type)
   !(Vartype))

(def-meth typed-exp-argtypes-infer ((vte Var-typed-exp) targ _ vars)
   (let ((var (Var-typed-exp-var vte)))
      (cond ((memq var vars)
	     (list (new-Vartype var targ nil)))
	    (t '()))))

(def-meth typed-exp-argtypes-infer ((appte App-typed-exp) targ val vars)
   (let ((fcnval (let ((fcn (App-typed-exp-fcn appte)))
		    (and (is-Const-typed-exp fcn)
			 (Const-typed-exp-val fcn)))))
;;;;      (dbg-save :run-loud appte fcnval)
;;;;      (breakpoint typed-exp-argtypes-infer/app
;;;;	 "Got: " fcnval)
      (cond ((and (eq val 'false)
		  (is-Predicate fcnval))
	     ;; Can't infer anything from the falsehood of a first-order
	     ;; predicate.
	     !(Vartype))
	    ((and fcnval
		  (memq val '(true false))
		  (eq (Constant-name fcnval) 'not))
	     (typed-exp-argtypes-infer
	        (car (App-typed-exp-args appte))
		prop-type*
		(cond ((eq targ 'true) 'false)
		      (t 'true))
		vars))
	    (t
	     (repeat :for ((a :in (App-typed-exp-args appte))
			  (targ :in (App-typed-exp-arg-targ-types appte))
			  (res !(Vartype)))
		(!= res
		    (vartypes-conjoin
		       *-*
		       (typed-exp-argtypes-infer a targ 'def vars)))
	      :result res)))))

(def-meth typed-exp-argtypes-infer ((iste Type-test-typed-exp) _ val vars)
   (let ((arg (Type-test-typed-exp-arg iste)))
      (cond ((and (eq val 'true)
		  (is-Var-typed-exp arg))
	     (list (new-Vartype (Var-typed-exp-var arg)
				(Type-test-typed-exp-extract-which-type
				   iste)
				nil)))
	    (t
	     (typed-exp-argtypes-infer arg univ-type* 'def vars)))))

(def-meth typed-exp-argtypes-infer ((boolte Boolapp-typed-exp) _ val vars)
   (cond ((memq val '(true false))
	  (let ((arg-inferences
		   (<# (\\ (a)
			  (typed-exp-argtypes-infer a prop-type* val vars))
		       (Boolapp-typed-exp-args boolte)))
		(fcn (Boolapp-typed-exp-fcn boolte)))
	     (cond ((eq fcn (cond ((eq val 'true) 'and)
				  (t 'or)))
		    (</ vartypes-conjoin
			!(Vartype) arg-inferences))
		   (t
		    (vartypes-disjoin arg-inferences)))))
	 (t !(Vartype))))

;;; This is not that general!!  It is tailored to the needs of
;;; typed-exp-argtypes-infer.
(defun vartypes-conjoin (vtl1 vtl2)
   (let ((cl !(Vartype))
	 (vtl2c (list-copy vtl2)))
      (repeat :for ((vt1 :in vtl1))
	 (let ((var (Vartype-var vt1)))
	    (!= cl
		(cons (let ((vt2 (vartypes-lookup var vtl2c)))
			 (cond (vt2
				(!= vtl2c (dremove1q vt2 *-*))
				(multi-let (((expressible int12 undo-stack)
					       (types-intersect
						  true
						  true (Vartype-type vt1)
						  true (Vartype-type vt2)
						  !(Undo)
						  global-opt-env*
						  global-opt-env* !())))
				   (cond (expressible
					  (new-Vartype 
					     var int12 nil))
					 (t
					  (undo undo-stack !())
					  vt1))))
			       (t vt1)))
		      *-*)))
       :result (nconc cl vtl2c))))

(def-meth typed-exp-argtypes-infer ((qte Quantified-typed-exp) targ val vars)
   (cond ((eq (Quantified-typed-exp-quantifier qte)
	      'exists)
	  (typed-exp-argtypes-infer
	     (Quantified-typed-exp-body qte)
	     targ
	     val
	     (complementq
	         vars
		 (<# Argspec-name
		     (Arglistspec-argspecs
		        (Quantified-typed-exp-bindings qte))))))
	 (t !(Vartype))))

(defun app-typed-exp-args-internalize (ate freevars goal-pos)
   (list-internalize (App-typed-exp-args ate) freevars goal-pos))

(defun qvarify-freevars (e freevars)
   (cond ((is-Qvar e)
	  (leaf-qvarify (Qvar-sym e) true freevars))
	 ((is-symbolish e)
	  (leaf-qvarify e false freevars))
	 ((atom e)
	  (build-Qexp :atom e (const-type e)))
	 (t
	  (build-Qexp :simple-app
	     (<# (\\ (y) (qvarify-freevars y freevars))
		 e)
	     :type univ-type*))))

(defun leaf-qvarify (sym was-qvar freevars)
   (let ((e (vartypes-lookup sym freevars)))
      (cond (e
	     (build-Qexp :qvar (or (Vartype-val e) sym)
			 :type (Vartype-type vt)))
	    (was-qvar
	     (dbg-save :run-loud freevars)
	     (signal-problem leaf-qvarify
		"Unexpected qvar ?" sym " treating as " sym :%
		:proceed)
	     (build-Qexp :qvar sym :type univ-type*))
	    (t
	     (build-Qexp :atom sym :type univ-type*)))))

(defun qvarbdgs-constraints (qvarbdgs env)
   (mapcan #'(lambda (v)
	        (let ((type (Vartype-type v)))
		   (let ((p (type-predify
				   type
			           (make-Qvar (Vartype-var v) '())
				   env)))
		     (cond ((matchq (is Obj ?_) p)
			    '())
			   (t
			    (list p))))))
	   qvarbdgs))

;;; Change type into predicate
(defun type-predify (n x vartypes)
   (multiple-value-let (fcn found)
		       (type-find-feature n 'predifier vartypes)
      (cond (found
	     (funcall fcn n x vartypes))
	    ((eq n univ-type*)
	     `(is Obj ,x))
	    ((is-symbolish (Type-desig n))
	     `(is ,(Type-desig n) ,x))
	    (t
	     `(is Obj ,x)))))

(class-feature-datafun predifier (alt-class opt)
   (defun (eity arg vartypes)
      (cond ((atom (Type-desig eity))
	     `(is ,(Type-desig eity) ,arg))
            (t
	     (multiple-value-let (alt-types vartypes found)
				 (type-find-feature-spread
				    eity 'nisptype::alt-types vartypes)
		(cond (found
		       (repeat :for ((component :in alt-types)
				    (res '()))
			  (!= res
			      `(,(type-predify component arg vartypes)
				,@*-*))
			:result `(or ,@(dreverse res))))
		      (t
		       (error-break alt-predifier :fatal
			  "Alt with no alt-types: " eity))))))))

(defun multi-reduce (fn inits &rest lists)
   (cond ((<v null lists)
	  (values-list inits))
	 (t
	  (<< multi-reduce fn
	      (cons (multiple-value-list
		       (apply fn (append inits (<# car lists))))
		    (<# cdr lists))))))