;-*- Mode: Common-lisp; Package: opt; Readtable: ytools; -*-
(in-package :opt)
;;; $Id: qsyntax.lisp,v 1.6 2005/11/22 12:27:06 dvm Exp $

;;(depends-on nils)

(depends-on %module/ ytools)

(depends-on %module/ lisplang)

(eval-when (:compile-toplevel :slurp-toplevel :load-toplevel)
   ;; This is to avoid creating a shadowing symbol for 'flagsource' 
   ;; just from reading its file name.
   (import '(lisplang::flagsource))
   (export '(forall exists exists! freevars suppress-syntax-check imply)))

(depends-on :at-run-time %lisplang/ teshow flagsource bvarparse
	                            typecheck
			 %nity/ unkelim tvarelim typebounds slot )

(depends-on :at-run-time %opt/ types basics)

(depends-on %langutils/ synutils)

;;; Slurp to get macro definitions
(end-header :continue-slurping)

;;;;(defmacro do-whats-left (&body b)
;;;;   `(progn ,@b))

(defmacro function-unless-require (req-spec
				   term^ target-type^
				   undo-stack^ context^ mvartypes^
				   &body body)
   `(cond (,(cond ((symbolp req-spec)
		  `(env-declares-requirement ,mvartypes^ ',req-spec))
		  (t
		   `(exists (req :in req-spec)
		       (env-declares-requirement ,mvartypes^ req))))
	   ,@body)
	  (t
	   (functional-term-check ,term^ ,target-type^ ,undo-stack^
				  ,context^ ,mvartypes^))))

(declaim (special opt-type-sys*))

;;(defvar global-opt-env* (empty-vartypes opt-type-sys*))

(defmacro def-opt-form-handler (sym type &rest body)
     (match-cond body
	  (:? (#'?fcn)
	    `(try-enter-in-syntax-table ',sym (tuple ',type #',fcn)))
	  (:? (?(:+ ?base is-Symbol))
	    `(try-enter-in-syntax-table
		 ',sym
		 (find-in-syntax-table ',base ',type)))
	  (t
	   (let ((fun-name (build-symbol (< sym) -handler)))
	      `(progn
		  (defun ,fun-name
		    ,@body)
		  (try-enter-in-syntax-table
		      ',sym (tuple ',type #',fun-name)))))))

(defvar opt-syntax-table* (make-hash-table :test #'eq)
  "Table to store syntax handlers and macros in")

(needed-by-macros

(defun try-enter-in-syntax-table (sym entry)
   (multi-let (((tr _)
		(sym-ns-resolve sym opt-namespace* false)))
      (cond ((or (not tr)
		 (and sym
		      (not (eq tr sym))
		      (signal-problem try-enter-in-syntax-table
			  "Changing canonicalization of " sym
			  " from " tr " to " sym
			  (:prompt-for "Boolean, whether to allow (default: t) " true))))
	     (namespace-associate opt-namespace* (list sym)))))
   (let ((x (gethash sym opt-syntax-table*)))
      (cond ((or (not x)
                 (eq (car entry) (car x))
                 (y-or-n-p "Attempting to change ~s from ~s to ~s.  Allow?"
                           sym (car x) (car entry)))
             (setf (gethash sym opt-syntax-table*)
                   entry)))))

(defun find-in-syntax-table (sym y)
   (let ((entry (gethash sym opt-syntax-table*)))
      (cond (entry
	     (cond ((eq (car entry) y)
		    entry)
		   (t
		    (signal-problem find-in-syntax-table
		       "Syntax-table entry " entry " does not have mode "
		       y))))
	    (t
	     (signal-problem find-in-syntax-table
		"Unknown base for syntax definition: " sym)))))

)

(defun opt-term-checker (form env)
   (multi-let (((h form)
		(opt-form-handler form env)))
      (cond (h
	     (cond ((eq (car h) 'term-checker)
		    (values (cadr h) form))
		   ((eq (car h) 'macro)
		    (values
		       (\\ (term target-type undo-stack context mvartypes)
		          (term-check (funcall (cadr h) term)
				      target-type undo-stack context mvartypes))
		       form))
		   (t (values false form))))
	    (t (values false form)))))

;;; Returns two values: the handler, if any, and the form with first element
;;; canonicalized (if it's a symbol or prefixed symbol).
(defun opt-form-handler (form env &optional (place-op true))
   (let-fun ()
      (cond ((consp form)
	     (multi-let ((a (canonicalize (car form))))
		(values (gethash a opt-syntax-table*)
			(cond ((eq a (car form)) form)
			      (t `(,a ,@(cdr form)))))))
	    (t
	     (multi-let ((a (canonicalize form)))
		(values false a))))
    :where
       (canonicalize (x)
	  (cond ((and +namespace-mode+
		      place-op
		      (or (is-Symbol x)
			  (is-Prefixed-symbol x)))
		 (symbol-env-place x env))
		(t x)))))

;;;;      (cond ((and (consp form) (atom (car form)))
;;;;	     (let ((a (car form)))
;;;;		(cond ((and +namespace-mode+
;;;;			    place-op
;;;;			    (or (is-Symbol a)
;;;;				(is-Prefixed-symbol a)))
;;;;		       (!= a (symbol-env-place *-* env))))
;;;;		(values (gethash a opt-syntax-table*)
;;;;			(cond ((eq a (car form)) form)
;;;;			      (t `(,a ,@(cdr form)))))))
;;;;	    (t
;;;;	     (values false form)))

(declaim (special syntax-handler-finder*))

;;(!= syntax-handler-finder* #'opt-term-checker)

;;; The ':polarity' in a context is used *only* to keep track of
;;; the true nature of a quantifier.  It is *not* used to move 'not's 
;;; inward or anything like that.


;; If dom = false, it's already in the qvarbdgs
(defun formula-typecheck (fmla polarity undo-stack qvarbdgs dom)
   (term-typecheck fmla prop-type* undo-stack
		   (list (tuple ':polarity polarity)) qvarbdgs dom))

(defun term-typecheck (term target-type undo-stack cxt-props qvarbdgs dom)
   (let ((env (cond (dom
		     (make-Env true (append qvarbdgs (list dom))))
		    (t qvarbdgs))))
      (collecting-defective-exps (ill-formed term-te undo-stack)
				 (term-resolve-check-tidy
				    term target-type undo-stack
				    (opt-syn-context term cxt-props)
				    env)
	 (:if-aborted 
	    :restart-report (lambda (srm)
			       (out (:to srm)
				    "I will give up on checking " term))
	    (values (note-bugs (make-inst Unchecked-typed-exp
				  :type target-type
				  :source term
				  :env env)
			       ill-formed)
		    !()))
	 (values term-te undo-stack))))

;;;;(defun term-typecheck (term target-type undo-stack qvarbdgs dom)
;;;;   (term-resolve-check-tidy
;;;;      term target-type undo-stack
;;;;       (opt-syn-context term !()) 
;;;;       (cond (dom
;;;;	      (make-Env true (append qvarbdgs (list dom))))
;;;;	     (t qvarbdgs))))

(defun term-resolve-check-tidy (term target-type undo-stack context env)
   (term-check-and-tidy
      term
;;;;      (exp-env-symbols-place term env)
      target-type undo-stack context env))

;;; The second element is the transer, which will be defined
;;; in the file coerce.nsp .
(defvar opt-dialect-handler*
        (make-Typed-dialect-data
	  #'opt-term-checker false))

(defun opt-syn-context (expression other-props)
   (exp-syn-context
       expression
       opt-dialect-handler*
       other-props))

;; flatten-args is true iff higher-order arglists should be appended
;;    to low-order ones, separated by !&
;; suppress-res is either false, or a type, in which case if the result
;;    type turns out to be that type, it is not included in the value.
(defun fcn-vartypes-list (fvtl special-flags-list flatten-args suppress-res 
			  vartypes)
   (cond ((not (is-Env vartypes))
	  (signal-problem fcn-vartypes-list
	     "Non-env: " vartypes)))
   (cond ((null fvtl) '())
	 (t
	  (let ((fvt (car fvtl))
		(tack-on (car special-flags-list)))
	     (let ((ftype (Vartype-type fvt)))
	        `(,(var-funtype->fundecl
		      (Vartype-var fvt)
		      ftype flatten-args suppress-res tack-on vartypes)
		  ,@(fcn-vartypes-list (cdr fvtl) (cdr special-flags-list)
				       flatten-args suppress-res
				       vartypes)))))))

(defun var-funtype->fundecl (var ftype flatten-args suppress-res tack-on
			     vartypes)
   (cond ((not (is-Env vartypes))
	  (signal-problem var-funtype->fundecl
	     "Non-env: " vartypes)))
   (cond ((is-funtype ftype)
	  (let ((paramlist (type-must-find-feature
			      ftype 'arglist vartypes))
		(level (type-find-feature
			  ftype 'level vartypes)))
	     (let ((res-env
		      (cond ((> level 0)
			     (env-bindings-append
			        true
				(nisptype::funtype-params-declare-unbound
				   ftype vartypes)
				vartypes))
			    (t vartypes))))
		(let ((restype (type-must-find-feature
				  ftype 'resulttype res-env)))
		   (multi-let (((restype res-env)
				(follow-var-ref restype res-env)))
		      `(,var
			,@(funtype->decl
			     level restype 
			     (arglistspec->decl paramlist vartypes)
			     tack-on
			     flatten-args suppress-res
			     res-env)))))))
	 (t
	  (signal-problem fcn-vartypes-list
	     "Non function in function vartypes list: "
	     var 1 ftype))))

;; tack-on is stuff already externalized to be tacked on to the argument
;; list.  
(defun funtype->decl (level restype arg-decl tack-on flatten-args suppress-res
		      res-env)
      (letrec ()
	 (cond ((and flatten-args
		     (is-funtype restype)
		     (= (type-must-find-feature restype 'level res-env)
			(- level 1)))
		(let ((res-lev (- level 1))
		      (res-paramlist
			 (type-must-find-feature restype 'arglist res-env)))
		   (let ((res-res-env
			    (cond ((> res-lev 0)
				   (nisptype::funtype-params-declare-unbound
				      res-paramlist res-env))
				  (t res-env))))
		      (let ((res-restype
			       (type-must-find-feature
				  restype 'resulttype res-res-env)))
			 (multi-let (((res-restype res-res-env)
				      (follow-var-ref
					 res-restype res-res-env)))
			    (funtype->decl res-lev
					   res-restype
					   (arglistspec->decl
					      res-paramlist res-env)
					   `(!& ,@arg-decl ,@tack-on)
					   true suppress-res
					   res-res-env))))))
	       ((eq restype suppress-res)
		`(,@arg-decl ,@tack-on))
	       (t
		`(- ,(Type-desig restype) ,@arg-decl ,@tack-on)))))

(defun arglistspec->decl (paramlist vartypes)
   (nisptype::desig-subst
      (arglistspec-typed-arglist paramlist)
      '() vartypes))

;;; Produce rel fcn from pos-list.  (i j ...) means "... of jth element 
;;; of i'th element".
(defun nth-of-nth (pos-list)
   (\\ (e)
      (letrec ((find-sub (l piece)
		  (cond ((null l)
			 (values true (make-Noted-piece `(,piece))))
			(t
			 (let ((rel (car l)))
			    (cond ((and (>= rel 0)
					(is-list-of piece (\\ (_) true))
					(> (length e) rel))
				   (multi-let (((okay noted-sub)
						(find-sub (cdr l)
							  (nth rel piece))))
				      (cond (okay
					     (values
					        true
						`(,@(take rel piece)
						  ,noted-sub
						  ,@(drop (+ rel 1) piece))))
					    (t
					     (values false nil)))))
				  (t
				   (values false nil))))))))
	 (find-sub pos-list e))))

(defun simple-fun-typed-exp (sym res-type arg-type env)
   (build-Var-typed-exp
      sym sym
      (make-funtype 0 res-type arg-type
		    (type-arglistspec res-type env)
		    (type-arglistspec arg-type env)
		    false env)
      env))

(defun declare-fun-args (funtype vartypes)
   (argspecs-declare
      (type-must-find-feature funtype 'arglist vartypes)
      (nisptype::create-params-for-metas vartypes)
      vartypes))

(def-meth var-val-typed-exp ((val Constant) vt _ _ env)
   (let ((const (Vartype-val vt)))
      (make-inst Const-typed-exp
	 :val const
	 :source (Vartype-var vt)
	 :ext (Constant-name const)
	 :type (Vartype-type vt)
	 :env env)))
;;;;   (const-vt-typed-exp vt env)

(def-opt-form-handler !& term-checker (term target-type
				       undo-stack context mvartypes)
   (cond ((null (cdr term))
	  (ill-formed-typed-exp term target-type mvartypes))
	 (t
	  (let ((res (simple-functional-term-check 1 (cadr term) (cddr term)
						   target-type
						   undo-stack
						   (context-push-for-function-pos
						      (cadr term) 1 context)
						   context mvartypes)))
;;;;	     (dbg-save res)
;;;;	     (breakpoint \!&-form-handler
;;;;		"Got !& res = " res)
	     res))))

;;; 'bindings' slot is (Lst Vartype)
(def-class Let-var-typed-exp
    (:options (:include Binder-typed-exp))
    (:handler
       (initialize :before ((tc Let-var-typed-exp))
	  (slot-defaults tc flag 'let-var))))

(def-meth show-header ((lte Let-var-typed-exp))
   (out "Let-var"))

(def-meth show ((lte Let-var-typed-exp))
   (out "Bindings: ")
   (let ((bindings (Let-var-typed-exp-bindings lte)))
      (cond ((null bindings)
	     (out "None" :%))
	    (t
	     (out (:i> 3)
		(:e (repeat :for ((vt :in bindings))
		      (let ((val (Vartype-val vt)))
		         (:o :% (Vartype-var vt)
			    (:q ((eq val '*noinit)
			        (:e (type-show (Vartype-type vt)))
			        :%)
			       (t
				" = " (:e (show val)))))))))))
      (out "Body:" :%
	   (:e (show (Let-var-typed-exp-body lte)))
	   :%)))

(def-meth flagsource ((lvte Let-var-typed-exp))
   `(let-var ,(var-bindings-flagsource (Let-var-typed-exp-bindings lvte))
     ,(flagsource (Let-var-typed-exp-body lvte))))

(defun var-bindings-flagsource (vtl)
   (letrec ((extrude (vtl)
	       (cond ((null vtl)
		      (values '() 'Obj))
		     (t
		      (let ((vt (car vtl)))
			 (let ((var (Vartype-var vt))
			       (vtydesig (type-find-designator
					    (Vartype-type vt)
					    empty-env*))
			       (vv (Vartype-val vt)))
			    (multi-let (((r rtydesig)
					 (extrude (cdr vtl))))
			       (values
				  `(,(cond ((is-Typed-exp vv)
					    `(,var ,(flagsource vv)))
					   (t var))
				    ,@(cond ((equal vtydesig rtydesig)
					     '())
					    (t `(- ,vtydesig)))
				    ,@r)
				  vtydesig))))))))
      (extrude vtl)))

(def-opt-form-handler let-var term-checker (term target-type undo-stack
					    context mvartypes)
   (match-cond term
      (:? (let-var ?bdgs ?@body)
	(multi-let (((bdgs body-list rels _)
		     (extract-where bdgs body)))
	   (let ((body-bugs
		  (cond ((= (len body-list) 1)
			 !())
			(t
			 (list (make-Defective-exp
				  :observation
				     (\\ (targ srm)
					(out (:to srm)
					   "Illegal 'let-var' body: " body-list
					   :% "   in " targ))
				  :context context)))))
		 (body (cond ((null body-list) 'nil)
			     (t (car body-list)))))
	      (multi-let (((bdgs-vartypes _)
			   (bvar-list-parse bdgs false true ':tvar mvartypes))
			  (ustack undo-stack)
			  bod-te
			  (binding-tel '())
			  (binding-bugs 0)
			  (binding-tvars '()))
		 (repeat :for ((b :in bdgs-vartypes)
			      (rel :in rels)
			      val-te)
		    (cond ((not (eq (Vartype-val b) '*noinit))
			   (!= < val-te ustack >
			       (term-check (Vartype-val b)
					   (Vartype-type b)
					   ustack
					   (context-expstack-push-n
						   `(,@rel 1) context)
					   mvartypes))
			   (!= (Vartype-val b) val-te)
			   (!= binding-tel (cons val-te *-*))
			   (!= binding-bugs
			       (+ *-* (Typed-exp-totbugs val-te)))
			   (!= binding-tvars
			       (append (Typed-exp-tvars val-te)
				       *-*)))))
		 (let ((let-var-te
			  (make-inst Let-var-typed-exp
			     :flag 'let-var
			     :source term
			     :bindings bdgs-vartypes
			     :env mvartypes)))
		    (repeat :for ((vt :in bdgs-vartypes))
		       (!= (vartype-feat vt ':binder) let-var-te))
		    (!= < bod-te ustack >
			(term-check body target-type
				    ustack
				    (context-expstack-push
				       body 2 context)
				    (env-bindings-append
				       true
				       bdgs-vartypes mvartypes)))
		    (note-bugs let-var-te body-bugs)
		    (values 
		       (set-fields Let-var-typed-exp let-var-te
			  :body bod-te
			  :type (Typed-exp-type bod-te)
			  :ext `(let-var ,(var-bindings-sexp bdgs-vartypes
							     mvartypes)
				   ,(Typed-exp-source bod-te))
			  :totbugs (+ binding-bugs (Typed-exp-totbugs bod-te))
			  :tvars (nodupq (nconc binding-tvars
						(Typed-exp-tvars bod-te)))
			  :subexps (nconc (dreverse binding-tel)
					  (list bod-te)))
		       ustack))))))
      (t
       (values (ill-formed-typed-exp term target-type mvartypes)
	       undo-stack))))
				 

(defun var-bindings-sexp (vtl env)
   (letrec ((extrude (vtl)
	       (cond ((null vtl)
		      (values '() 'Obj))
		     (t
		      (let ((vt (car vtl)))
			 (let ((var (Vartype-var vt))
			       (vtydesig
				  (type-find-designator
				     (type-bound
					(Vartype-type vt)
					true false ':all env)
				     env))
			       (vv (Vartype-val vt)))
			    (multi-let (((r rtydesig)
					 (extrude (cdr vtl))))
			       (values
				  `(,(cond ((is-Typed-exp vv)
					    `(,var ,(Typed-exp-source vv)))
					   (t var))
				    ,@(cond ((equal vtydesig rtydesig)
					     '())
					    (t `(- ,vtydesig)))
				    ,@r)
				  vtydesig))))))))
      (extrude vtl)))

(defun context-expstack-push-n (rel-list context)
   (letrec ((expstack-push-n (rel-list expstack)
	       (cond ((null rel-list)
		      expstack)
		     (t
		      (expstack-push-n
			 (cdr rel-list)
			 (let ((exp (car (Expstack-expressions expstack))))
			    (expstack-push (nth (car rel-list) exp)
					   (car rel-list)
					   expstack)))))))
      (multi-let (((expstack props)
		   (nisptype::context-find-expstack context false)))
	 (context-expstack-aug
	    context
	    (expstack-push-n rel-list expstack)
	    props))))

;;;;(try-enter-in-syntax-table 'lambda
;;;;			   (tuple '#'lambda-term-check))

(def-class Quantified-typed-exp (:options (:include Binder-typed-exp))
   quantifier  ;; forall, exists, freevar
;;;;   level    ;;  -- moved to Binder-typed-exp (typedexp.lisp)
   keep-quantifier  ;; true if this quantifier should still exist after
                    ;; internalization
   use-bindings-as-constraints  ;; Boolean
   universal  ;; forall in positive context, exists in negative, freevar
              ;; in either
   ;; -- really mean "represent bound vars as free vars when internalizing"

;    (:handler
;        (print (qte srm)
; 	  (out (to srm) "#<Quantified-typed-exp " (Typed-exp-type qte) "/"
; 	       (Typed-exp-sexp qte true))))
   )

(def-meth initialize :before ((tc Quantified-typed-exp))
   (slot-defaults tc flag 'quantified))

(def-meth show-header ((qte Quantified-typed-exp))
  (out (Quantified-typed-exp-quantifier qte)
       (:q ((> (Quantified-typed-exp-level qte) 0)
	    1 (Quantified-typed-exp-level qte) 1))
       (Quantified-typed-exp-bindings qte)
       (:q ((Quantified-typed-exp-keep-quantifier qte)
	    " [keep]"))))

(def-meth show ((qte Quantified-typed-exp))
   (out (:e (show (Quantified-typed-exp-body qte)))
	:%))

(def-meth flagsource ((qte Quantified-typed-exp))
   `(,(Quantified-typed-exp-quantifier qte)
     ,@(include-if (> (Quantified-typed-exp-level qte) 0)
	     (Quantified-typed-exp-level qte))
     ,(nisptype::arglistspec-typed-arglist
	 (Quantified-typed-exp-bindings qte))
     ,(flagsource (Quantified-typed-exp-body qte))))

(defun quantified-formula-check (qgoal target-type undo-stack
				 context mvartypes)
   (control-nest
      (multi-let (((quant level qvars body junk)
		   (match-cond qgoal
		      (:? (?quant ?(:+ ?lev is-Number) ?qvars ?body ?@junk)
			 (values quant lev qvars body))
		      (:? (?quant ?qvars ?body ?@junk)
			 (values quant 0 qvars body junk))
		      (t
		       (values false nil nil nil nil)))))
	 (cond ((not quant)
		(ill-formed-typed-exp qgoal target-type mvartypes))
	       (t
		:well-formed)))
    :well-formed
      (let ((initial-scope-time scope-time*))
	 (!= scope-time* (+ *-* 1))
	 (multi-let (((univ requirements)
		      (quantifier-analyze quant context))
		     (keep (syn-context-lookup context
					       'keep-quantifiers))
		     ((low high _)
		      (cond ((= level 0)
			     (args-low-high-split qvars true mvartypes))
			    (t
			     (values !() qvars false)))))
            :high-or-low))
    :high-or-low
      (let-fun ()
	 (cond ((null high)
                (low-quantified-te context undo-stack mvartypes))
               (t
                (multi-let (((hqte qv-alspec)
                             (initialize-quantified-te
                                 high type-type* level mvartypes)))
                   (multi-let (((high-te undo-stack-1)
                                (cond (univ	
                                       (univ-high-quantified-te
                                          hqte qv-alspec))
                                      (t
                                       (exis-high-quantified-te
                                          hqte qv-alspec)))))
                      (values high-te undo-stack-1)))))

   :where

 (:def univ-high-quantified-te (hqte qv-alspec)
    (let* ((high-bdgs (argspecs-placeholder-params
			 qv-alspec mvartypes))
	   (low-env (env-bindings-nconc
		        true high-bdgs mvartypes)))
	(multi-let (((zqte undo-stack-1)
		     (low-quantified-te
			context undo-stack low-env)))
	   (multi-let (((ltype _ undo-stack-2)
			(tvar-elim
			   (Typed-exp-type zqte)
			   true
			   (list false ':max-if-constrained)
			   initial-scope-time
			   undo-stack-1 low-env)))
	      (!= ltype 
		  (high-bdgs-elim-unks
		      *-* high-bdgs initial-scope-time mvartypes))
	      (!= (Typed-exp-type zqte) ltype)
	      (quantified-te-finish
		 hqte zqte high-bdgs
		 1 undo-stack-2)))))

 (:def exis-high-quantified-te (hqte qv-alspec)
     (let* ((high-bdgs (argspecs-tvar-types qv-alspec mvartypes))
	    (low-env (env-bindings-nconc
		         true high-bdgs mvartypes)))
        (multi-let (((zqte undo-stack-1)
		     (low-quantified-te
			(cond ((not keep)
			       (cons-Syn-context
				  (tuple 'keep-quantifiers true)
				  context))
			      (t context))
		        undo-stack low-env)))
	   (quantified-te-finish hqte zqte high-bdgs 1 undo-stack-1))))

 (:def low-quantified-te (context undo-stack env)
    (let* ((zqte (initialize-quantified-te low ':tvar 0 env))
	   (qte-bindings (<# (\\ (as)
				(new-Vartype
				   (Argspec-name as)
				   (Argspec-type as)
				   false))
			     (Arglistspec-argspecs 
				(Binder-typed-exp-bindings zqte)))))
       (multi-let (((bte undo-stack-1)
		    (term-check
			  body
			  prop-type*
			  undo-stack
			  (context-expstack-push
			     body 2 context)
			  (env-bindings-append
			     true qte-bindings env))))
	  (multi-let (((bindings)
		       (bdgs-tvar-elim
			  qte-bindings initial-scope-time undo-stack-1)))
	     (multi-let (((fqte undo-stack-3)
			  (quantified-te-finish
			     zqte bte bindings 0 undo-stack-1)))
		(repeat :for ((req :in requirements))
		   (cond ((eq req ':existential-effects)
			  ;; Pseudo-requirement, never satisfied
			  (note-existential-in-effect-bug fqte))
			 (t
			  (verify-requirement req mvartypes fqte))))
		(cond ((not (null junk))
		       (note-bugs fqte
				  (list (simple-ill-formed-exp
					   "Too much stuff in goal body"
					   qgoal)))))
		(let ((eff-con (syn-context-lookup context 'action-context)))
		   (cond (eff-con
			  (cond ((eq (second eff-con) 'condition)
				 (verify-requirement
				    (cond (univ
					   ':universal-preconditions)
					  (t
					   ':existential-preconditions))
				    mvartypes fqte))
				((not univ)
				 (note-bugs
				     fqte
				     (list (simple-ill-formed-exp
					      !"Existentials are not allowed ~
						in action effects"
					      qgoal))))))))
                (values fqte undo-stack-3))))))

 (:def initialize-quantified-te (qvars default level env)
;;;;    (trace-around initialize-quantified-te
;;;;       (:> "(initialize-quantified-te: " qvars 1 default 1 level 1 env ")")
    (multi-let (((constraining alspec var-ill-formed)
		 (qvar-list-parse-al qvars default env)))
       (let ((te (make-inst Quantified-typed-exp
		    :quantifier quant
		    :type bool-type*
		    :level level
		    :keep-quantifier (or (not univ) keep)
		    :use-bindings-as-constraints constraining
		    :universal univ
		    ;;;; :bindings new-qvarbdgs
		    :body '()
		    :source qgoal
		    :env mvartypes)))
	  (repeat :for ((as :in (Arglistspec-argspecs alspec)))
	     (!= (argspec-feat as ':binder) te))
;;;;	  (repeat :for ((vt :in new-qvarbdgs))
;;;;	     (!= (vartype-feat vt ':binder) te))
	  (note-bugs te var-ill-formed)
	  (values te alspec)))
;;;;       (:< (val &rest _) "initialize-quantified-te: " val))
    )

 (:def quantified-te-finish (qte body-te bindings level undo-stack)
    (let ()   ;;;; (bindings (arglistspec->vartypes qv-alspec))
       (set-fields Quantified-typed-exp qte
	  :body body-te
	  :ext `(,(Quantified-typed-exp-quantifier qte)
		 ,@(include-if (> level 0 level))
		 ,(arglistspec-typed-arglist bindings)
		 ,(Typed-exp-ext body-te))
	  :totbugs (+ *-* (Typed-exp-totbugs body-te))
	  :tvars (Typed-exp-tvars body-te)
	  :type (Typed-exp-type body-te)
	  :subexps (list body-te)
	  :bindings bindings)
       (values qte undo-stack))))))

(defun qvar-list-parse (vardecls default-type env)
   (multi-let (((con alspec defexps)
		(qvar-list-parse-al vardecls default-type env)))
      (values con
	      (arglistspec->vartypes alspec)
	      defexps)))

;;; Returns < constraining, arglistspec, defective-exps >
;;; 'constraining' means that declarations are to be used as
;;; explicit constraints when they can't be proved vacuous, as in
;;; (forall (p - Person) (if (> (weight p) 300) (obese p))),
;;; where (is Person p) must be added to the antecedent.
(defun qvar-list-parse-al (vardecls default-type env)
   (cond ((listp vardecls)
	  ;;;;(!= vardecls (parms-symbols-place *-* env))
	  (let ((unconstraining (memq ':unconstraining vardecls)))
	     (cond (unconstraining
		    (!= vardecls
			(remove ':unconstraining *-* :test #'eq))))
	     (multi-let (((alspec _ _ synerrs)
			  (params-parse vardecls true default-type ;;;;univ-type*
					false false env)))
		   (values (not unconstraining)
			   alspec    ;;;; (arglistspec->vartypes alspec)
			   (<# (\\ (p)
				  (make-Defective-exp
				     :target false
				     :observation (\\ (_ srm)
						     (synerr-out p srm))
				     :signaler (\\ (this-exp)
						  (signal-problem :place qvar-list-parse
						     "Syntactic error in quantified"
						     " vars list: " this-exp
						     (:continue "I'll ignore it")))))
			       synerrs)))))
	 (t
	  (values false !()
		  (list (make-Defective-exp
			   :target false
			   :observation (\\ (_ srm)
					   (out (:to srm)
						"Illegal quantified variable list: "
						vardecls))
			   :signaler (\\ (this-exp)
					(signal-problem :place qvar-list-parse
					   "Illegal quantified variable list in: "
					   this-exp
					   (:continue "I'll proceed with variables undeclared")))))))))

(defun bdgs-tvar-elim (bdgs after undo-stack)
;;;;   (dbg-save bdgs after undo-stack)
;;;;   (breakpoint bdgs-tvar-elim
;;;;      "after = " after)
   (repeat :for ((vt :in bdgs) (ustack undo-stack) ty
		 :collector res)
      (!= < ty _ ustack >
	  (tvar-elim (Vartype-type vt)
		     false (list false ':maximize)
		     after ustack empty-env*))
;;;;      (cond ((and (null ustack)
;;;;		  (not (null undo-stack)))
;;;;	     (dbg-save vt ty undo-stack)
;;;;	     (breakpoint bdgs-tvar-elim
;;;;		"ustack screwed up; vt = " vt " ty = " ty)))
    :within
      (let ((new-vt (new-Vartype (Vartype-var vt)
				 ty
				 (Vartype-val vt))))
;;;;	 (out "Elim " vt " --> " new-vt :%)
	 (repeat :for ((p :in (nisptype::Vartype-props vt)))
	    (!= (vartype-feat new-vt (car p)) (cadr p)))
	 (:continue
	  :collect new-vt))
    :result
      (progn (undo ustack undo-stack)
	     ;; The bound found by 'tvar-elim' will survive
	     res)))


(try-enter-in-syntax-table 'forall
			   (tuple 'term-checker #'quantified-formula-check))
(try-enter-in-syntax-table 'exists
			   (tuple 'term-checker #'quantified-formula-check))
(try-enter-in-syntax-table 'exists!
			   (tuple 'term-checker #'quantified-formula-check))
(try-enter-in-syntax-table 'freevars
			   (tuple 'term-checker 'quantified-formula-check))

;;; Returns < whether-universal, domain-requirements >
(defun quantifier-analyze (quant con)
   (let (;;;;(quant (car qgoal))
	 (polarity (context-polarity con))
	 (action-cxt (syn-context-lookup con 'action-context)))
      (let ((univ
	       (cond ((eq quant 'freevars)
		      true)
		     (t
		      (memq quant
			    (cond (polarity '(forall))
				  (t '(exists exists!))))))))
	 (values
	    univ
	    (cond (action-cxt
		   (cond ((eq (cadr action-cxt) 'condition)
			  ;; Paradoxical-looking, but a universal
			  ;; in a condition will just be Skolemized.
			  (list (cond (univ ':existential-preconditions)
				      (t ':universal-preconditions))))
			 (univ !())
			 (t
			  ;; This requirement doesn't exist,
			  ;; because we never allow
			  ;; existentials in effects.  The caller
			  ;; must realize this and treat it as always
			  ;; violated.
			  ':existential-effects)))
		  (t !()))))))

;; "No polarity" is the same as "polarity true."
(defun context-polarity (c)
   (let ((p (syn-context-lookup c ':polarity)))
      (or (not p) (cadr p))))

(defun note-existential-in-effect-bug (te)
   (note-bugs te
	      (list (make-Defective-exp
		       :target te
		       :observation
			  (\\ (targ srm)
			     (out (:to srm)
			       (:pp-block
				"Existential quantifiers may not appear in"
				" action effects: "
				 (:pp-nl :fill)
				 targ)))
		       :signaler
			  (\\ (this-exp)
			     (signal-problem existential-bug
				this-exp
				(:continue "I'll overlook it")))))))

(defun synerr-out (p srm)
   (out (:to srm)
      "("
	 (:e (repeat :for ((pl p (cdr pl)) x)
	     :until (null pl)
	       (!= x (car pl))
	       (:o (:q ((is-String x) (:a x))
		     (t x))
		  (:q ((not (null (cdr pl)))
		      1)))))
       ")"))

(def-class Maker-typed-exp (:options (:include App-typed-exp))
   (:handler
      (initialize :before ((tc Maker-typed-exp))
	 (slot-defaults tc
			flag 'make level 0
			hidden false
			fcn (maybe-type-slot-fun
			       false (Maker-typed-exp-type tc)
			       'conser 'acc '()
			       (Typed-exp-env tc))
			subexps (App-typed-exp-args tc)))))
      
(def-meth show-header ((mte Maker-typed-exp))
  (out "Make " (Type-desig (Typed-exp-type mte))))

;; show method inherited from App-typed-exp

(def-meth flagsource ((mte Maker-typed-exp))
   `(make ,(Type-desig (Typed-exp-type mte))
	  ,@(app-typed-exp-args-flagsource mte)))

(def-opt-form-handler make term-checker (term target-type undo-stack
					 context mvartypes)
   (match-cond term
      (:? (make ?td ?@_)
	(let ((d (and (is-symbolish td)
		      (var-place-and-lookup td mvartypes))))
	   (cond ((and (is-Tyfun d)
		       (is-Constructor-spec (Tyfun-defn d)))
		  (elided-make-checker d term undo-stack context mvartypes))
		 (t
		  (let ((made-type (designated-type td true mvartypes)))
		     (multi-let (((con _)
				  (type-find-feature
				     made-type 'nity::constructor mvartypes)))
			(cond (con
			       (make-constructed-checker made-type con term
							 undo-stack context mvartypes))
			      (t
			       (make-ordinary-checker
				  made-type term undo-stack context mvartypes)))))))))
      (t 
       (values (ill-formed-typed-exp term target-type mvartypes)
	       undo-stack))))

;;; (make con ...) where con is just a constructor (i.e. a tyfun)
;;; Fills in missing args with tvars, like 'high-fcn-hide'.
(defun elided-make-checker (tyfun term undo-stack context mvartypes)
   (let ((cspec (Tyfun-defn tyfun))
	 (tyf-env (Tyfun-env tyfun)))
      (let ((highparms (Constructor-spec-type-params cspec)))
	 (multi-let (((arg-bdgs _)
		      (arglistspec-bind-to-tvars highparms tyf-env)))
	    (make-constructed-checker
	       (finish-constructed-type 
		  cspec arg-bdgs tyf-env)
	       cspec term undo-stack context mvartypes)))))

(defun make-constructed-checker (made-type con term undo-stack context
				 mvartypes)
   (multi-let (((argvts okay)
		(type-find-feature made-type 'nity::arg-vartypes mvartypes)))
      (cond (okay
	     (multi-let (((arg-tel arg-prefs targ-types _ bugs undo-stack-1)
			  (args-check (cddr term)
				      (<# (\\ (vt)
					     (new-Argspec
					        (Vartype-var vt)
						':required
						(Vartype-type vt)))
					  argvts)
				      mvartypes
				      undo-stack context mvartypes)))
		(values
		   (make-inst Maker-typed-exp
		      :type made-type
		      :fcn con
		      :args arg-tel
		      :arg-positions arg-prefs
		      :arg-targ-types targ-types
		      :env mvartypes
		      :source term
		      :ext `(make ,(Type-desig made-type) ,@(<# Typed-exp-ext arg-tel))
		      :totbugs (len bugs)
		      :bugs bugs)
		   undo-stack-1)))
	    (t
	     (signal-problem make-constructed-checker
		"Constructor type with no argtypes: " made-type)))))

(defun make-ordinary-checker (made-type term undo-stack context
			      mvartypes)
	(let ((args (cdr term)))
	   (multi-let (((conser-te _ undo-stack-1)
			(fcn-te-from-slot made-type 'conser undo-stack mvartypes)))
	      (cond (conser-te
		     (let ((funtype (Typed-exp-type conser-te)))
		       (let ((atypes (type-find-feature
				        funtype 'argtype mvartypes)))
			  (multi-let (((arg-tel posl arg-targs
					_ pathology undo-stack-2)
				       (args-check args atypes mvartypes
						   undo-stack-1
						   context mvartypes)))
			     (let ((subexps (cons conser-te arg-tel)))
				(let ((cte (make-inst Maker-typed-exp
					      :type made-type
					      :fcn conser-te
					      :args arg-tel
					      :arg-positions posl
					      :arg-targ-types arg-targs
					      :env mvartypes
					      :source term
					      :ext `(make ,(Type-desig made-type)
							  ,@(<# Typed-exp-ext arg-tel))
					      :totbugs
					         (te-list-totbugs
						    subexps))))
				   (cond ((not (null pathology))
					  (note-defective-exp
						((targ)
						 "Parsing errors: "
						 (:pp-nl :linear) pathology
						 (:pp-nl :linear) "in "
						 targ)
					     :target cte
					     :place make-opt-form-handler
					     (:novalue
					      "I'll try to keep going"))))
				   (values cte undo-stack-2)))))))
		   (t
;;;;		    (dbg-save made-type)
;;;;		    (breakpoint make-ordinary-checker
;;;;		       "No conser: " made-type)
		    (values
		       (note-defective-exp ((_) made-type " has no conser")
			  :place make-opt-form-handler
			  :fatal)
		       undo-stack))))))

(def-class Slot-acc-typed-exp (:options (:include App-typed-exp))
   slotname
   type-invert
   (:handler
      (initialize :before ((tc Slot-acc-typed-exp))
	 (slot-defaults tc
			flag 'slot-acc level 0
			hidden false ))))

(def-meth flagsource ((slte Slot-acc-typed-exp))
   `(!_ ,(Slot-acc-typed-exp-slotname slte)
	,@(app-typed-exp-args-flagsource slte)))

;;;;(defvar any-args
;;;;        (new-Arglistspec '()
;;;;	   :rest (list (new-Argspec '_ '*rest univ-type*))))

(def-opt-form-handler !_ term-checker (term target-type undo-stack
				       context mvartypes)
   ;;(out (tr slot-handler ("!_ > " term)
   (match-cond term
      (:? (!_ ?(:\| (?td ?slot) ?slot)
	     ?arg ?@other-args)
	 ;;(out "td = " td :%)
	(let ((ty (cond ((not td) univ-type*)
			(t (designated-type td true mvartypes)))))
;;;;	   (dbg-save arg ty undo-stack
;;;;		     (cxt (context-expstack-push arg 1 context))
;;;;		     mvartypes)
;;;;	   (breakpoint \!\_-term-checker
;;;;	      "Ready to call term-check")
	   (multi-let (((arg-te undo-stack-1)
			(term-check arg ty undo-stack
				     (context-expstack-push
				        arg 1 context)
				     mvartypes)))
 	      (multi-let (((slot-te slot-invert undo-stack-2)
			   (fcn-te-from-slot 
			       (Typed-exp-type arg-te)
			       slot undo-stack-1 mvartypes)))
		 (cond ((not slot-te)
			(dbg-save :run-loud arg-te slot mvartypes)
			(breakpoint slot-term-checker
			   "Can't find slot " slot " in type of "
			   arg-te)
			(note-defective-exp 
			   ((_) "Can't find slot " slot " in type "
			    (Typed-exp-type arg-te))
			   :place \!_-term-checker))
		       (t
			(let ((slotfn-type (Typed-exp-type slot-te)))
			   (multi-let (((args-tel arg-prefs arg-targs _
					 arg-bugs undo-stack-3)
					(args-check
					   (cons `(already-checked
						     ,true ,arg-te)
						 other-args)
					   (type-find-feature
					         slotfn-type
						 'nisptype::arglist
						 empty-env*)
					   mvartypes
					   undo-stack-2 context mvartypes)))
			      (let ((subexps
				       (cons slot-te args-tel)))
				 (let ((slot-te 
					  (make-inst Slot-acc-typed-exp
					     :slotname slot
					     :type-invert slot-invert
					     :fcn slot-te
					     :args args-tel
					     :arg-positions arg-prefs
					     :arg-targ-types arg-targs
					     :hidden false
					     :type (type-find-feature
						      slotfn-type
						      'nisptype::resulttype
						      empty-env*)
					     :source term
					     :ext `(!_(,(Type-desig ty)
						       ,slot)
						      ,@(<# Typed-exp-ext args-tel))
					     :env mvartypes
					     :totbugs (te-list-totbugs subexps)
					     :subexps subexps)))
				    (cond ((not (null arg-bugs))
					   (note-defective-exp
					       ((targ)
						"Parsing errors: "
						(:pp-nl :linear) arg-bugs
						(:pp-nl :linear) " in "
						targ)
					       :target slot-te
					       :place !\_-handler
					       (:novalue
						"I will try to ignore them"))))
				    (values slot-te undo-stack-3)))))))))))
      (t
       (values
	  (ill-formed-typed-exp term target-type mvartypes)
	  undo-stack)))
   ;;("!_ < " (car out-vals*))))
   ) 

(def-meth type-infer-conseqs ((ste Slot-acc-typed-exp) ty)
   (let ((main-arg (car (Slot-acc-typed-exp-args ste)))
	 (env (Typed-exp-env ste)))
      (let ((main-arg-type (Typed-exp-type main-arg)))
	 (multi-let (((slot _ _)
		      (maybe-type-slot-fun
			 false main-arg-type
			 (Slot-acc-typed-exp-slotname ste)
			 false '() env)))
	    (cond (slot
		   (!= < slot env >
		       (follow-var-ref slot env))
		   (let ((type-invert
			    (nisptype::coerce-to-fun (Slot-invert slot))))
		      (cond (type-invert
			     (funcall type-invert
				      ;;;;(Slot-name slot)
				      ty (Slot-acc-typed-exp-args ste)))
			    (t
			     (values true '())))))
		  (t
		   (signal-problem Slot-acc-typed-exp/type-infer-conseqs
		      "Fumbled slot " (Slot-acc-typed-exp-slotname ste))))))))

;;; The type of functions implied by make and !_.
(def-class Slot-fun-typed-exp (:options (:include Typed-exp))
   slotname
   fcn-name
   (:handler
      (initialize :before ((te Slot-fun-typed-exp))
	 (slot-defaults te
			flag 'slot-fun))))

(def-meth flagsource ((sfte Slot-fun-typed-exp))
   (Slot-fun-typed-exp-slotname sfte))

(def-meth show-header ((sfte Slot-fun-typed-exp))
   (let ((fn (Slot-fun-typed-exp-fcn-name sfte)))
      (out "Slot " (Slot-fun-typed-exp-slotname sfte) ", function "
	   (:q (fn 1 (condense fn))))))

(def-meth show ((sfte Slot-fun-typed-exp))
   (values))

(defun fcn-te-from-slot (type slname undo-stack env)
   (multi-let (((slot truetype undo-stack-1)
		(maybe-type-slot-fun
		   true type slname false undo-stack env)))
      (multi-let (((slot env)
		   (follow-var-ref slot env)))
	 (cond (slot
		(values
		      (make-slot-fcn-te slot truetype env)
		      (Slot-invert slot)
		      undo-stack-1))
	       (t (values false nil (undo undo-stack-1 undo-stack)))))))

(defun make-slot-fcn-te (slot truetype env)
   (let ((slname (Slot-name slot)))
      (multi-let (((augmented-atypes atypes-env)
		   (nisptype::slot-atypes-add-type-arg
		      (Slot-atypes slot) slname truetype env)))
	 (make-inst Slot-fun-typed-exp
	       :source slname
	       :ext slname
	       :slotname slname
	       :fcn-name (nisptype::Slot-access-fcn slot)
	       :type (make-funtype
			    0
			    (Slot-type slot)
			    (arglistspec-argtype
			       augmented-atypes atypes-env)
			    (args->spec (list (Slot-type slot)))
			    augmented-atypes
			    false env)))))

;;; Internal rep of (is type a).
;;; We can't call this "Is-typed-exp," because that name looks too much like
;;; something else.
(def-class Type-test-typed-exp (:options (:include Typed-exp))
   which
   arg)

(def-meth initialize :before ((tc Type-test-typed-exp))
;;;;   (dbg-save tc)
;;;;   (breakpoint Type-test-typed-exp-initialize
;;;;      "tc = " tc)
   (slot-defaults tc
		  flag 'is
		  type bool-type*
		  subexps
		  (list (Type-test-typed-exp-arg tc))))

(def-meth show-header ((tte Type-test-typed-exp))
  (let ((which-ty (Type-test-typed-exp-which tte)))
     (out "Type judgment "
	  (:q ((is-Type which-ty) (Type-desig which-ty))
	      (t which-ty)))))

(def-meth show ((tte Type-test-typed-exp))
   (out "Arg: "
	(:e (show (Type-test-typed-exp-arg tte)))
	:%))

(def-meth flagsource ((tte Type-test-typed-exp))
  `(is ,(flagsource (Type-test-typed-exp-which tte))
       ,(flagsource (Type-test-typed-exp-arg tte))))

(def-opt-form-handler is term-checker (term target-type undo-stack
				       context mvartypes)
   (cond ((= (len term) 3)
	  (multi-let (((type-te undo-stack-1)
		       (term-check (cadr term) type-type* undo-stack
				   (context-expstack-push
				      (cadr term) 1 context)
				   mvartypes)))
	     (multi-let (((arg-te undo-stack-2)
			  (term-check (caddr term) univ-type* undo-stack-1
				      (context-expstack-push
				         (caddr term) 2 context)
				      mvartypes)))
;;;;		(cond ((not (is-Type-typed-exp type-te))
;;;;		       (dbg-save :run-loud type-te)
;;;;		       (signal-problem is-checker
;;;;			  "Not a Type-typed-exp: " type-te)))
		(values
		   (make-inst Type-test-typed-exp
		      :which type-te
		      :arg arg-te
		      :env mvartypes
		      :source term
		      :ext `(is ,(Typed-exp-source type-te)
				,(Typed-exp-source arg-te))
		      :subexps (list type-te arg-te)
		      :tvars '())
		   undo-stack-2))))
	 (t
	  (values (ill-formed-typed-exp term target-type mvartypes)
		  undo-stack))))

(def-meth type-infer-conseqs ((is-te Type-test-typed-exp) ty)
;;;;   (trace-around Type-test/type-infer
;;;;      (:> "(Type-test/type-infer: " is-te 1 ty")")
   (let ((b (type-as-boolean ty empty-env*)))
      (values
         true
	 (cond (b
		(list (new-Vartype
		         (Type-test-typed-exp-arg is-te)
			 (let ((test-ty
				  (Type-test-typed-exp-extract-which-type
				     is-te)))
			    (cond ((eq b 'true) test-ty)
				  (t `(not ,test-ty))))
			 nil)))
	       (t '()))))
;;;;      (:< (consis bdgs) "Type-test/type-infer: " consis 1 bdgs))
   )

(defun Type-test-typed-exp-extract-which-type (is-te)
   (let ((wh (Type-test-typed-exp-which is-te)))
      (let ((test-ty
	       (cond ((is-Type-typed-exp wh)
		      (Type-typed-exp-which wh))
		     ((is-Type wh)
		      wh)
		     (t
		      (signal-problem
			 Type-test-typed-exp-extract-type
			 "Can't extract type from "
			 wh)))))
	 test-ty)))

(def-opt-form-handler suppress-syntax-check term-checker
		      (term target-type undo-stack _ _)
   (values
      (make-inst Unchecked-typed-exp
	 :source (cadr term)
	 :type target-type
	 :env empty-env*)
      undo-stack))

;; Useful for building new expressions out of existing Typed-exps,
;; by creating s-expressions and parsing them.
;; (already-checked <ta> <typed-exp>) just turns into <typed-exp>.
;; If <ta>=true, acceptability has already been checked.
(def-opt-form-handler already-checked term-checker
		      (term target-type undo-stack context mvartypes)
		      (ignore mvartypes target-type context)
   (match-cond term
      (:? (already-checked ?ta ?ans-te)
        (cond (ta
	       (!= (Typed-exp-already-transed ans-te) true)))
	(values ans-te undo-stack))
      (t
       (note-defective-exp
	  ((_) "Ill-formed 'already-checked' expression: " term)
	  :place already-checked-handler))))
	
(defun verify-requirement (reqname vartypes te)
   (let ((dom (find-domain-in-vartypes vartypes)))
      (cond ((not (domain-declares-requirement dom reqname))
	     (note-bugs te
			(list (make-Defective-exp
			         :target te
				 :observation
				    (\\ (targ srm)
				       (out (:to srm)
					 (:pp-block
					  "Illegal for domain"
					  " not declaring requirement "
					   (:pp-nl :fill)
					  reqname ": " 
					   (:pp-nl :fill) targ)))
				 :signaler
				    (\\ (this-exp)
				       (signal-problem verify-requirement
					  this-exp
					  (:continue "I'll overlook it"))))))))
      te))

(defun verify-one-of-requirements (reql vartypes te)
   (let ((dom (find-domain-in-vartypes vartypes)))
      (cond ((or (not dom)
		 (not (exists (r :in reql)
			 (domain-declares-requirement dom r))))
	     (note-bugs te
			(list (simple-ill-formed-exp 
				 "Illegal for domain not declaring one of requirements "
				 reql))))
	    (t te))))

(defun env-declares-requirement (vartypes reqname)
   (let ((dom (find-domain-in-vartypes vartypes)))
      (cond (dom
	     (domain-declares-requirement dom reqname))
	    (t
	     (signal-problem env-declares-requirement
		"Can't find domain in " vartypes
		:% " while testing for requirement " reqname
		(:novalue "I will assume env does declare the requirement"))))))

;;; Returns < keyword-value pairs, flagged-subexpressions >
(defun keyword-list-smooth (l keywords required)
   (multiple-value-let (l flg)
                        (list-smooth l #'any)
      (let ((items '()))
	 (do ((xl l (cddr xl)))
	     ((or (null xl)
		  (null (cdr xl)))
	      (values items
		      `(,@(reverse flg)
			,@(mapcan #'(lambda (r)
				       (cond ((get-field r items)
					      '())
					     (t
					      `(,(flagexp
						    "Missing keyword"
						    r)))))
				  required)
			,@(cond ((null xl) '())
				((consp xl)
				 `(,(flagexp
				       "Odd element of keyword list"
				       (car xl))))
				(t
				 `(,(flagexp
				       "Junk at end of list . "
				       xl)))))))
	   (let ((k1 (car xl))
		 (v1 (cadr xl)))
	      (cond ((symbolp k1)
		     (dolist (kk keywords
			      (setq flg `(,(flagexp 
					      "Illegal keyword" k1)
					  ,@flg)))
			(cond ((eq k1 kk)
			       (push (list k1 v1) items)
			       (return))
			      ((and (consp kk)
				    (member k1 kk))
			       (push (list (car kk) v1) items)
			       (return)))))
		    (t
		     (setq flg `(,(flagexp
				     "Nonsymbolic keyword" k1)
				 ,@flg)))))))))

(defun list-smooth (l element-okay)
   (labels ((collect (l)
               (cond ((consp l)
                      (let ((a (car l)))
                        (multi-let (((mh _) (opt-form-handler a global-opt-env* false)))
                          (cond ((and mh (eq (car mh) 'macro))
                                 (multiple-value-let (here there)
				                      (funcall (cadr mh)
                                                               a)
				                      (declare (ignore there))
                                   (multiple-value-let
                                          (r flg)
					  (collect (append here (cdr l)))
                                      (values r flg))))
                                (t
				 (multiple-value-let (r flg)
				                      (collect (cdr l))
				   (cond ((funcall element-okay a)
					  (values (cons a r)
						  flg))
					 (t
					  (values
                                             r
                                             (cons (simple-ill-formed-exp
                                                      "Illegal in this context"
						      a)
                                                   flg))))))))))
                     ((null l)
                      (values '() '()))
                     (t
                      (values '() (list (simple-ill-formed-exp
					   "Junk at end of list"
					   l)))))))
     (collect l)))

(defun get-field-or-empty (kw keyword-tab)
   (let ((p (assoc kw keyword-tab :test #'eq)))
      (cond (p (cadr p)) (t !()))))

(defun get-field (kw keyword-tab)
   (assoc kw keyword-tab :test #'eq))

(defun set-field (kw keyword-tab newval)
  (cons (list kw newval)
        (let ((p (get-field kw keyword-tab))) 
          (cond (p
		 (remove p keyword-tab :test #'eq :count 1))
                (t keyword-tab)))))

(defun ill-formed-typed-exp (source target-type env)
;;;;   (breakpoint ill-formed-typed-exp
;;;;      "source = " source)
       (make-inst Unchecked-typed-exp
	  :flag 'ill-formed
	  :type target-type
	  :source source
	  :env env
	  :bugs (list (simple-ill-formed-exp "Ill-formed expression" source))
	  :totbugs 1))



