;-*- Mode: Common-lisp; Package: opt; Readtable: ytools; -*-
(in-package :opt)
;;; $Id: reduction.lisp,v 1.9 2004/03/29 15:17:27 dvm Exp $

(depends-on :at-run-time %opt/ deduction)

(eval-when (:compile-toplevel :load-toplevel :execute :slurp-toplevel)
   (export '(find-reductions bad-reduction-preds*)))

;; Does one step of deduction, returning a list of pairs.
;; Each pair consists of a list of subgoals and Bdgenv 
;; summarizing constraints on goal that these subgoals entail.
(defun find-reductions (query vid bdgs sit th)
   (multi-let (((qa qd bdgs)
		(e-car-cdr query vid bdgs)))
      (case qa
	 (prelinked
            (mapcan #'(lambda (r)
                         (rule-reductions (car qd) vid r bdgs))
                    (Prelink-list-rules (cadr qd))))
	 (and
	  (signal-problem find-reductions
	     "Attempt to find reductions of " query
	     (:novalue "I'll assume it has no reductions"))
	  '())
	 (or
	  (mapcan #'(lambda (d)
		      (find-reductions d vid bdgs sit th))
		  qd))
	 (goal-call
	  ;;;;(call-reductions qd vid bdgs sit th)
	  !())
	 (t
	  (let ((bcl (backchain-fetch query vid bdgs
				      (\\ (bcocc _)
					 (back-chainer-is-stratified
					    bcocc th))
				      sit)))
	     (repeat :for (bc :in bcl)
	      :nconc
		   (multi-let (((bcpat env)
				(safe-varsubst '?ante (car bc) (cadr bc))))
		      (antecedent-reductions bcpat env (car bc) vid))))))))

;;;;(defun call-reductions (args vid bdgs sit th)
;;;;   (multi-let (((proc proc-id bdgs)
;;;;		(call-decipher args vid bdgs)))
;;;;      ;; Note that we call the procedure and discard the
;;;;      ;; actual answers we get; we only want the subgoals.
;;;;      (let ((pal (funcall proc proc-id bdgs sit th)))
;;;;	 (<! (\\ (e)
;;;;		(multi-let (((subgoal e)
;;;;			     (call-result-subgoal e proc-id)))
;;;;		   (cond (subgoal
;;;;			  (antecedent-reductions subgoal e proc-id vid))
;;;;			 ((eq e many-bdgs*)
;;;;			  (list (tuple 'false bdgs)))
;;;;			 (t
;;;;			  (list (tuple 'true e))))))
;;;;	     pal))))

(defun rule-reductions (query qid rule bdgs)
   (let ((rule-id (new-Varid))
	 (ant (Back-chainer-antecedent rule)))
      (multiple-value-bind (ok e)
			   (unify (Back-chainer-consequent rule)
				  query rule-id qid bdgs)
	 (cond (ok
		(antecedent-reductions ant e rule-id qid))
	       (t
                '())))))

(defvar bad-reduction-preds* '(goal-call eval eval-test))


(defun antecedent-reductions (ante env ante-id target-id)
   (multi-let (((ante env)
		(varid-convert
		   (disjunctive-normal-form ante true)
		   ante-id target-id env)))
      ;;(!= env (bdgenv-contract *-* ante-id))
      (<! (\\ (subconj)
	     (cond ((forall (sc :in subconj)
		       (and (consp sc)
			    (memq (car sc) bad-reduction-preds*)))
		    !())
		   (t
		    (list (tuple subconj env)))))
	  ante)))







